/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityCaveSpider
extends EntitySpider {
    public EntityCaveSpider(EntityTypes<? extends EntityCaveSpider> type, World level) {
        super((EntityTypes<? extends EntitySpider>)type, level);
    }

    public static AttributeProvider.Builder k() {
        return EntitySpider.m().a(GenericAttributes.t, 12.0);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.caveSpiderRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.caveSpiderRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.caveSpiderControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.caveSpiderMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.caveSpiderScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.caveSpiderTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.caveSpiderAlwaysDropExp;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        if (super.c(level, target)) {
            if (target instanceof EntityLiving) {
                int i2 = 0;
                if (this.an().aq() == EnumDifficulty.c) {
                    i2 = 7;
                } else if (this.an().aq() == EnumDifficulty.d) {
                    i2 = 15;
                }
                if (i2 > 0) {
                    ((EntityLiving)target).addEffect(new MobEffect(MobEffects.s, i2 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        return spawnGroupData;
    }

    @Override
    public Vec3D m(Entity entity) {
        return entity.dA() <= this.dA() ? new Vec3D(0.0, 0.21875 * (double)this.eA(), 0.0) : super.m(entity);
    }
}

