/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityCreeper
extends EntityMonster {
    private static final DataWatcherObject<Integer> a = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final boolean d = false;
    private static final boolean e = false;
    private static final short f = 30;
    private static final byte ct = 3;
    private int cu;
    public int cv;
    public int cw = 30;
    public int cx = 3;
    public boolean cy;
    @Nullable
    public Entity entityIgniter;
    private boolean exploding = false;
    private int spacebarCharge = 0;
    private int prevSpacebarCharge = 0;
    private int powerToggleDelay = 0;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.creeperRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.creeperRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.creeperControllable;
    }

    @Override
    protected void a(WorldServer world) {
        if (this.powerToggleDelay > 0) {
            --this.powerToggleDelay;
        }
        if (this.getRider() != null && this.isControllable()) {
            if (this.getRider().getForwardMot() != 0.0f || this.getRider().getStrafeMot() != 0.0f) {
                this.spacebarCharge = 0;
                this.setIgnited(false);
                this.b(-1);
            }
            if (this.spacebarCharge == this.prevSpacebarCharge) {
                this.spacebarCharge = 0;
            }
            this.prevSpacebarCharge = this.spacebarCharge;
        }
        super.a(world);
    }

    @Override
    public void onMount(EntityHuman rider) {
        super.onMount(rider);
        this.setIgnited(false);
        this.b(-1);
    }

    @Override
    public boolean onSpacebar() {
        if (this.powerToggleDelay > 0) {
            return true;
        }
        ++this.spacebarCharge;
        if (this.spacebarCharge > this.cw - 2) {
            this.spacebarCharge = 0;
            if (this.getRider() != null && this.getRider().getBukkitEntity().hasPermission("allow.powered.creeper")) {
                this.powerToggleDelay = 20;
                this.setPowered(!this.m());
                this.setIgnited(false);
                this.b(-1);
                return true;
            }
        }
        if (!this.s() && this.getRider() != null && this.getRider().getForwardMot() == 0.0f && this.getRider().getStrafeMot() == 0.0f && this.getRider().getBukkitEntity().hasPermission("allow.special.creeper")) {
            this.setIgnited(true);
            this.b(1);
            return true;
        }
        return this.getForwardMot() == 0.0f && this.getStrafeMot() == 0.0f;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.creeperMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.creeperScale);
    }

    @Override
    protected void H() {
        this.cq.a(1, new PathfinderGoalFloat(this));
        this.cq.a(2, new PathfinderGoalSwell(this));
        this.cq.a(3, new HasRider(this));
        this.cq.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.cq.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.cq.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cq.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.cq.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(6, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.cr.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.w, 0.25);
    }

    @Override
    public int cR() {
        return this.e() == null ? this.y(0.0f) : this.y(this.eU() - 1.0f);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        this.cv += (int)(fallDistance * 1.5);
        if (this.cv > this.cw - 5) {
            this.cv = this.cw - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, -1);
        builder.a(b, false);
        builder.a(c, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("powered", this.m());
        output.a("Fuse", (short)this.cw);
        output.a("ExplosionRadius", (byte)this.cx);
        output.a("ignited", this.s());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.az.a(b, input.a("powered", false));
        this.cw = input.a("Fuse", (short)30);
        this.cx = input.a("ExplosionRadius", (byte)3);
        if (input.a("ignited", false)) {
            this.az.a(c, true);
        }
    }

    @Override
    public void g() {
        if (this.bX()) {
            int swellDir;
            this.cu = this.cv;
            if (this.s()) {
                this.b(1);
            }
            if ((swellDir = this.n()) > 0 && this.cv == 0) {
                this.a(SoundEffects.hm, 1.0f, 0.5f);
                this.c(GameEvent.I);
            }
            this.cv += swellDir;
            if (this.cv < 0) {
                this.cv = 0;
            }
            if (this.cv >= this.cw) {
                this.cv = this.cw;
                this.gJ();
            }
        }
        super.g();
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving target, @Nullable EntityTargetEvent.TargetReason reason) {
        if (!(target instanceof Goat)) {
            return super.setTarget(target, reason);
        }
        return false;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        double chance = world.a().purpurConfig.creeperChargedChance;
        if (chance > 0.0 && this.as.j() <= chance) {
            this.setPowered(true);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(WorldServer world, DamageSource damageSource) {
        if (!this.exploding && this.an().purpurConfig.creeperExplodeWhenKilled && damageSource.d() instanceof EntityPlayer) {
            this.gJ();
        }
        return super.dropAllDeathLoot(world, damageSource);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.creeperTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.creeperAlwaysDropExp;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.hl;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.hk;
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        if (this.e(level) && this.m() && !this.cy) {
            entity.a(level, damageSource, false, LootTables.bd, (ItemStack itemStack) -> {
                entity.a(level, (ItemStack)itemStack);
                this.cy = true;
            });
        }
        return super.a(level, entity, damageSource);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        return true;
    }

    public boolean m() {
        return this.az.a(b);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cu, this.cv) / (float)(this.cw - 2);
    }

    public int n() {
        return this.az.a(a);
    }

    public void b(int state) {
        this.az.a(a, state);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        super.a(level, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.az.a(b, true);
    }

    public void setPowered(boolean powered) {
        this.az.a(b, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(TagsItem.bK)) {
            SoundEffect soundEvent = itemInHand.a(Items.we) ? SoundEffects.kb : SoundEffects.kr;
            this.an().a((Entity)player, this.dK(), this.dM(), this.dQ(), soundEvent, this.dw(), 1.0f, this.as.i() * 0.4f + 0.8f);
            if (!this.an().D_()) {
                this.entityIgniter = player;
                this.gI();
                if (itemInHand.p() == 0) {
                    itemInHand.h(1);
                } else {
                    itemInHand.a(1, (EntityLiving)player, hand.a());
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    public void gJ() {
        this.exploding = true;
        World world = this.an();
        if (world instanceof WorldServer) {
            float multiplier;
            WorldServer serverLevel = (WorldServer)world;
            float f2 = this.m() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.cx * f2 * (multiplier = serverLevel.purpurConfig.creeperHealthRadius ? this.eU() / this.fj() : 1.0f), false);
            if (!event.isCancelled()) {
                this.bI = true;
                serverLevel.a((Entity)this, this.dK(), this.dM(), this.dQ(), event.getRadius(), event.getFire(), serverLevel.S().c(GameRules.d) && this.an().purpurConfig.creeperAllowGriefing ? World.a.c : World.a.a);
                this.gK();
                this.a(serverLevel, Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.cv = 0;
                this.az.a(c, false);
            }
        }
        this.exploding = false;
    }

    private void gK() {
        Collection<MobEffect> activeEffects = this.eR();
        if (!activeEffects.isEmpty() && !this.an().paperConfig().entities.behavior.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(this.an(), this.dK(), this.dM(), this.dQ());
            areaEffectCloud.a(this);
            areaEffectCloud.a(2.5f);
            areaEffectCloud.c(-0.5f);
            areaEffectCloud.c(10);
            areaEffectCloud.a(300);
            areaEffectCloud.b(0.25f);
            areaEffectCloud.d(-areaEffectCloud.c() / (float)areaEffectCloud.h());
            for (MobEffect mobEffectInstance : activeEffects) {
                areaEffectCloud.a(new MobEffect(mobEffectInstance));
            }
            this.an().addFreshEntity(areaEffectCloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.s() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.az.a(c, event.isIgnited());
            if (!event.isIgnited()) {
                this.b(-1);
            }
        }
    }

    public boolean s() {
        return this.az.a(c);
    }

    public void gI() {
        this.setIgnited(true);
    }
}

