/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.purpurmc.purpur.controller.MoveControllerWASD;

public class EntityDrowned
extends EntityZombie
implements IRangedEntity {
    public static final float a = 0.03f;
    boolean f;

    public EntityDrowned(EntityTypes<? extends EntityDrowned> type, World level) {
        super((EntityTypes<? extends EntityZombie>)type, level);
        this.cn = new d(this);
        this.a(PathType.j, 0.0f);
    }

    public static AttributeProvider.Builder k() {
        return EntityZombie.gK().a(GenericAttributes.C, 1.0);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.drownedRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.drownedRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.drownedControllable;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new AmphibiousPathNavigation(this, level);
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.drownedMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.drownedScale);
    }

    @Override
    protected void gP() {
        this.h(GenericAttributes.B).a(this.as.j() * this.an().purpurConfig.drownedSpawnReinforcements);
    }

    @Override
    public boolean jockeyOnlyBaby() {
        return this.an().purpurConfig.drownedJockeyOnlyBaby;
    }

    @Override
    public double jockeyChance() {
        return this.an().purpurConfig.drownedJockeyChance;
    }

    @Override
    public boolean jockeyTryExistingChickens() {
        return this.an().purpurConfig.drownedJockeyTryExistingChickens;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.drownedTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.drownedAlwaysDropExp;
    }

    @Override
    protected void m() {
        this.cq.a(1, new c(this, 1.0));
        this.cq.a(2, new f(this, 1.0, 40, 10.0f));
        this.cq.a(2, new a(this, 1.0, false));
        this.cq.a(5, new b(this, 1.0));
        this.cq.a(6, new e(this, 1.0, this.an().T()));
        if (this.an().purpurConfig.drownedBreakDoors) {
            this.cq.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gO));
        }
        this.cq.a(7, new PathfinderGoalRandomStroll(this, 1.0));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, EntityDrowned.class).a(EntityPigZombie.class));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entity, level) -> this.i(entity)));
        if (this.an().spigotConfig.zombieAggressiveTowardsVillager) {
            this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false){

                @Override
                public boolean b() {
                    return (EntityDrowned.this.an().purpurConfig.zombieAggressiveTowardsVillagerWhenLagging || !EntityDrowned.this.an().q().server.isLagging()) && super.b();
                }

                @Override
                public boolean c() {
                    return (EntityDrowned.this.an().purpurConfig.zombieAggressiveTowardsVillagerWhenLagging || !EntityDrowned.this.an().q().server.isLagging()) && super.c();
                }
            });
        }
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<Axolotl>((EntityInsentient)this, Axolotl.class, true, false));
        this.cr.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.ct));
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        if (this.a(EnumItemSlot.b).f() && level.I_().i() < 0.03f) {
            this.a(EnumItemSlot.b, new ItemStack(Items.yg));
            this.g(EnumItemSlot.b);
        }
        return spawnGroupData;
    }

    public static boolean a(EntityTypes<EntityDrowned> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        boolean flag;
        if (!level.b_(pos.e()).a(TagsFluid.a) && !EntitySpawnReason.a(spawnReason)) {
            return false;
        }
        Holder<BiomeBase> biome = level.v(pos);
        boolean bl = flag = !(level.aq() == EnumDifficulty.a || !EntitySpawnReason.b(spawnReason) && !EntityDrowned.a(level, pos, random) || !EntitySpawnReason.a(spawnReason) && !level.b_(pos).a(TagsFluid.a));
        if (!flag || !EntitySpawnReason.a(spawnReason) && spawnReason != EntitySpawnReason.j) {
            return biome.a(BiomeTags.ar) ? random.a(15) == 0 && flag : random.a(40) == 0 && EntityDrowned.a(level, pos) && flag;
        }
        return true;
    }

    private static boolean a(GeneratorAccess level, BlockPosition pos) {
        return pos.v() < level.T() - 5;
    }

    @Override
    public SoundEffect p() {
        return this.bu() ? SoundEffects.iQ : SoundEffects.iP;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.bu() ? SoundEffects.iU : SoundEffects.iT;
    }

    @Override
    public SoundEffect f_() {
        return this.bu() ? SoundEffects.iS : SoundEffects.iR;
    }

    @Override
    protected SoundEffect n() {
        return SoundEffects.iW;
    }

    @Override
    public SoundEffect bg() {
        return SoundEffects.iX;
    }

    @Override
    protected boolean s() {
        return true;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if ((double)random.i() > 0.9) {
            int randomInt = random.a(16);
            if (randomInt < 10) {
                this.a(EnumItemSlot.a, new ItemStack(Items.yf));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.sZ));
            }
        }
    }

    @Override
    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        return !currentItem.a(Items.yg) && super.a(newItem, currentItem, slot);
    }

    @Override
    protected boolean gI() {
        return false;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    public boolean i(@Nullable EntityLiving target) {
        return target != null && (!this.an().aa() || target.bu());
    }

    @Override
    public boolean cW() {
        return !this.cw();
    }

    boolean gQ() {
        if (this.f) {
            return true;
        }
        EntityLiving target = this.e();
        return target != null && target.bu();
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.by() && this.gQ()) {
            this.a(0.01f, travelVector);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.9));
        } else {
            super.m(travelVector);
        }
    }

    @Override
    public void bB() {
        if (!this.an().D_()) {
            this.j(this.dt() && this.by() && this.gQ());
        }
    }

    @Override
    public boolean cx() {
        return this.cw();
    }

    protected boolean gJ() {
        double d2;
        BlockPosition target;
        PathEntity path = this.S().j();
        return path != null && (target = path.l()) != null && (d2 = this.h(target.u(), target.v(), target.w())) < 4.0;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        ItemStack mainHandItem = this.fq();
        ItemStack itemStack = mainHandItem.a(Items.yf) ? mainHandItem : new ItemStack(Items.yf);
        EntityThrownTrident thrownTrident = new EntityThrownTrident(this.an(), this, itemStack);
        double d2 = target.dK() - this.dK();
        double d1 = target.f(0.3333333333333333) - thrownTrident.dM();
        double d22 = target.dQ() - this.dQ();
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            IProjectile.a(thrownTrident, serverLevel, itemStack, d2, d1 + squareRoot * (double)0.2f, d22, 1.6f, 14 - this.an().aq().a() * 4);
        }
        this.a(SoundEffects.iV, 1.0f, 1.0f / (this.ek().i() * 0.4f + 0.8f));
    }

    @Override
    public TagKey<Item> ac() {
        return TagsItem.ci;
    }

    public void x(boolean searchingForLand) {
        this.f = searchingForLand;
    }

    static class d
    extends MoveControllerWASD {
        private final EntityDrowned l;

        public d(EntityDrowned mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void vanillaTick() {
            EntityLiving target = this.l.e();
            if (this.l.gQ() && this.l.bu()) {
                if (target != null && target.dM() > this.l.dM() || this.l.f) {
                    this.l.k(this.l.dI().b(0.0, 0.002, 0.0));
                }
                if (this.k != ControllerMove.Operation.b || this.l.S().l()) {
                    this.l.B(0.0f);
                    return;
                }
                double d2 = this.e - this.l.dK();
                double d1 = this.f - this.l.dM();
                double d22 = this.g - this.l.dQ();
                double squareRoot = Math.sqrt(d2 * d2 + d1 * d1 + d22 * d22);
                d1 /= squareRoot;
                float f2 = (float)(MathHelper.d(d22, d2) * 180.0 / 3.1415927410125732) - 90.0f;
                this.l.v(this.b(this.l.dX(), f2, 90.0f));
                this.l.bB = this.l.dX();
                float f1 = (float)(this.c() * this.l.i(GenericAttributes.w));
                float f22 = MathHelper.h(0.125f, this.l.fD(), f1);
                this.l.B(f22);
                this.l.k(this.l.dI().b((double)f22 * d2 * 0.005, (double)f22 * d1 * 0.1, (double)f22 * d22 * 0.005));
            } else {
                if (!this.l.aS()) {
                    this.l.k(this.l.dI().b(0.0, -0.008, 0.0));
                }
                super.vanillaTick();
            }
        }
    }

    static class c
    extends PathfinderGoal {
        private final EntityCreature a;
        private double b;
        private double c;
        private double d;
        private final double e;
        private final World f;

        public c(EntityCreature mob, double speedModifier) {
            this.a = mob;
            this.e = speedModifier;
            this.f = mob.an();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!this.f.aa()) {
                return false;
            }
            if (this.a.bu()) {
                return false;
            }
            Vec3D waterPos = this.h();
            if (waterPos == null) {
                return false;
            }
            this.b = waterPos.g;
            this.c = waterPos.h;
            this.d = waterPos.i;
            return true;
        }

        @Override
        public boolean c() {
            return !this.a.S().l();
        }

        @Override
        public void d() {
            this.a.S().a(this.b, this.c, this.d, this.e);
        }

        @Nullable
        private Vec3D h() {
            RandomSource random = this.a.ek();
            BlockPosition blockPos = this.a.dF();
            for (int i2 = 0; i2 < 10; ++i2) {
                BlockPosition blockPos1 = blockPos.b(random.a(20) - 10, 2 - random.a(8), random.a(20) - 10);
                if (!this.f.a_(blockPos1).a(Blocks.J)) continue;
                return Vec3D.c(blockPos1);
            }
            return null;
        }
    }

    static class f
    extends PathfinderGoalArrowAttack {
        private final EntityDrowned a;

        public f(IRangedEntity rangedAttackMob, double speedModifier, int attackInterval, float attackRadius) {
            super(rangedAttackMob, speedModifier, attackInterval, attackRadius);
            this.a = (EntityDrowned)rangedAttackMob;
        }

        @Override
        public boolean b() {
            return super.b() && this.a.fq().a(Items.yf);
        }

        @Override
        public void d() {
            super.d();
            this.a.w(true);
            this.a.c(EnumHand.a);
        }

        @Override
        public void e() {
            super.e();
            this.a.fU();
            this.a.w(false);
        }
    }

    static class a
    extends PathfinderGoalZombieAttack {
        private final EntityDrowned b;

        public a(EntityDrowned drowned, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(drowned, speedModifier, followingTargetEvenIfNotSeen);
            this.b = drowned;
        }

        @Override
        public boolean b() {
            return super.b() && this.b.i(this.b.e());
        }

        @Override
        public boolean c() {
            return super.c() && this.b.i(this.b.e());
        }
    }

    static class b
    extends PathfinderGoalGotoTarget {
        private final EntityDrowned g;

        public b(EntityDrowned drowned, double speedModifier) {
            super(drowned, speedModifier, 8, 2);
            this.g = drowned;
        }

        @Override
        public boolean b() {
            return super.b() && !this.g.an().aa() && this.g.bu() && this.g.dM() >= (double)(this.g.an().T() - 3);
        }

        @Override
        public boolean c() {
            return super.c();
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            BlockPosition blockPos = pos.d();
            return level.w(blockPos) && level.w(blockPos.d()) && level.a_(pos).b((IBlockAccess)level, pos, this.g);
        }

        @Override
        public void d() {
            this.g.x(false);
            super.d();
        }

        @Override
        public void e() {
            super.e();
        }
    }

    static class e
    extends PathfinderGoal {
        private final EntityDrowned a;
        private final double b;
        private final int c;
        private boolean d;

        public e(EntityDrowned drowned, double speedModifier, int seaLevel) {
            this.a = drowned;
            this.b = speedModifier;
            this.c = seaLevel;
        }

        @Override
        public boolean b() {
            return !this.a.an().aa() && this.a.bu() && this.a.dM() < (double)(this.c - 2);
        }

        @Override
        public boolean c() {
            return this.b() && !this.d;
        }

        @Override
        public void a() {
            if (this.a.dM() < (double)(this.c - 1) && (this.a.S().l() || this.a.gJ())) {
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 4, 8, new Vec3D(this.a.dK(), this.c - 1, this.a.dQ()), 1.5707963705062866);
                if (posTowards == null) {
                    this.d = true;
                    return;
                }
                this.a.S().a(posTowards.g, posTowards.h, posTowards.i, this.b);
            }
        }

        @Override
        public void d() {
            this.a.x(true);
            this.d = false;
        }

        @Override
        public void e() {
            this.a.x(false);
        }
    }
}

