/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EndermanAttackPlayerEvent;
import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final MinecraftKey c = MinecraftKey.b("attacking");
    private static final AttributeModifier d = new AttributeModifier(c, 0.15f, AttributeModifier.Operation.a);
    private static final int e = 400;
    private static final int f = 600;
    private static final DataWatcherObject<Optional<IBlockData>> ct = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> cu = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cv = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int cw = Integer.MIN_VALUE;
    private int cx;
    private static final UniformInt cy = TimeRange.a(20, 39);
    private int cz;
    @Nullable
    private UUID cA;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        if (this.fG()) {
            this.a(PathType.j, -1.0f);
        }
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.endermanRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.endermanRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.endermanControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.endermanMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.endermanScale);
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.endermanAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new a(this));
        this.cq.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cq.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.cq.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.cq.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a));
        this.cr.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>(this, EntityEndermite.class, 10, true, false, (entityliving, ignored) -> {
            if (!entityliving.an().purpurConfig.endermanAggroEndermites) return false;
            if (!(entityliving instanceof EntityEndermite)) return false;
            EntityEndermite endermite = (EntityEndermite)entityliving;
            if (!entityliving.an().purpurConfig.endermanAggroEndermitesOnlyIfPlayerSpawned) return true;
            if (!endermite.isPlayerSpawned()) return false;
            return true;
        }));
        this.cr.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 40.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.c, 7.0).a(GenericAttributes.n, 64.0).a(GenericAttributes.C, 1.0);
    }

    private boolean tryEscape(EndermanEscapeEvent.Reason reason) {
        return new EndermanEscapeEvent((Enderman)((CraftEnderman)this.getBukkitEntity()), reason).callEvent();
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving target, @Nullable EntityTargetEvent.TargetReason reason) {
        if (!super.setTarget(target, reason)) {
            return false;
        }
        target = this.e();
        AttributeModifiable attribute = this.h(GenericAttributes.w);
        if (target == null) {
            this.cx = 0;
            this.az.a(cu, false);
            this.az.a(cv, false);
            attribute.c(c);
        } else {
            this.cx = this.at;
            this.az.a(cu, true);
            if (!attribute.b(c)) {
                attribute.b(d);
            }
        }
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ct, Optional.empty());
        builder.a(cu, false);
        builder.a(cv, false);
    }

    @Override
    public void c() {
        this.a(cy.a(this.as));
    }

    @Override
    public void a(int time) {
        this.cz = time;
    }

    @Override
    public int a() {
        return this.cz;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.cA = target;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cA;
    }

    public void m() {
        if (this.at >= this.cw + 400) {
            this.cw = this.at;
            if (!this.bm()) {
                this.an().a(this.dK(), this.dO(), this.dQ(), SoundEffects.jz, this.dw(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cu.equals(key) && this.gJ() && this.an().D_()) {
            this.m();
        }
        super.a(key);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        IBlockData carriedBlock = this.s();
        if (carriedBlock != null) {
            output.a("carriedBlockState", IBlockData.a, carriedBlock);
        }
        this.a_(output);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.c((IBlockData)input.a("carriedBlockState", IBlockData.a).filter(blockState -> !blockState.l()).orElse(null));
        this.a(this.an(), input);
    }

    boolean g(EntityHuman player) {
        boolean shouldAttack = !this.an().purpurConfig.endermanDisableStareAggro && this.isBeingStaredBy0(player);
        EndermanAttackPlayerEvent event = new EndermanAttackPlayerEvent((Enderman)this.getBukkitEntity(), (Player)player.getBukkitEntity());
        event.setCancelled(!shouldAttack);
        return event.callEvent();
    }

    boolean isBeingStaredBy0(EntityHuman player) {
        return EntityLiving.bn.test(player) && this.a(player, 0.025, true, false, this.dO());
    }

    @Override
    public void e_() {
        if (this.an().D_()) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.an().a(Particles.ag, this.e(0.5), this.dN() - 0.25, this.h(0.5), (this.as.j() - 0.5) * 2.0, -this.as.j(), (this.as.j() - 0.5) * 2.0);
            }
        }
        this.bL = false;
        if (!this.an().D_()) {
            this.a((WorldServer)this.an(), true);
        }
        super.e_();
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.endermanTakeDamageFromWater;
    }

    @Override
    protected void a(WorldServer level) {
        float lightLevelDependentMagicValue;
        if ((this.getRider() == null || !this.isControllable()) && level.aa() && this.at >= this.cx + 600 && (lightLevelDependentMagicValue = this.bK()) > 0.5f && level.h(this.dF()) && this.as.i() * 30.0f < (lightLevelDependentMagicValue - 0.4f) * 2.0f && this.tryEscape(EndermanEscapeEvent.Reason.RUNAWAY)) {
            this.g((EntityLiving)null);
            this.n();
        }
        super.a(level);
    }

    public boolean n() {
        if (!this.an().D_() && this.bX()) {
            double d2 = this.dK() + (this.as.j() - 0.5) * 64.0;
            double d1 = this.dM() + (double)(this.as.a(64) - 32);
            double d22 = this.dQ() + (this.as.j() - 0.5) * 64.0;
            return this.p(d2, d1, d22);
        }
        return false;
    }

    public boolean G(Entity target) {
        Vec3D vec3 = new Vec3D(this.dK() - target.dK(), this.f(0.5) - target.dO(), this.dQ() - target.dQ());
        vec3 = vec3.d();
        double d2 = 16.0;
        double d1 = this.dK() + (this.as.j() - 0.5) * 8.0 - vec3.g * 16.0;
        double d22 = this.dM() + (double)(this.as.a(16) - 8) - vec3.h * 16.0;
        double d3 = this.dQ() + (this.as.j() - 0.5) * 8.0 - vec3.i * 16.0;
        return this.p(d1, d22, d3);
    }

    private boolean p(double x2, double y2, double z2) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, y2, z2);
        while (mutableBlockPos.v() > this.an().M_() && !this.an().a_(mutableBlockPos).d()) {
            mutableBlockPos.c(EnumDirection.a);
        }
        IBlockData blockState = this.an().a_(mutableBlockPos);
        boolean flag = blockState.d();
        boolean isWater = blockState.y().a(TagsFluid.a);
        if (flag && !isWater) {
            Vec3D vec3 = this.dD();
            boolean flag1 = this.b(x2, y2, z2, true);
            if (flag1) {
                this.an().a(GameEvent.R, vec3, GameEvent.a.a(this));
                if (!this.bm()) {
                    this.an().a(null, this.Y, this.Z, this.aa, SoundEffects.jA, this.dw(), 1.0f, 1.0f);
                    this.a(SoundEffects.jA, 1.0f, 1.0f);
                }
            }
            return flag1;
        }
        return false;
    }

    @Override
    public SoundEffect p() {
        return this.gI() ? SoundEffects.jy : SoundEffects.jv;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.jx;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.jw;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        IBlockData carriedBlock = this.s();
        if (carriedBlock != null) {
            ItemStack itemStack = new ItemStack(Items.qP);
            EnchantmentManager.a(itemStack, level.L_(), VanillaEnchantmentProviders.g, level.d_(this.dF()), this.ek());
            LootParams.a builder = new LootParams.a((WorldServer)this.an()).a(LootContextParameters.h, this.dD()).a(LootContextParameters.k, itemStack).b(LootContextParameters.a, this);
            for (ItemStack itemStack1 : carriedBlock.a(builder)) {
                this.a(level, itemStack1);
            }
        }
    }

    public void c(@Nullable IBlockData state) {
        this.az.a(ct, Optional.ofNullable(state));
    }

    @Nullable
    public IBlockData s() {
        return this.az.a(ct).orElse(null);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag;
        EntityPotion abstractThrownPotion;
        EntityPotion abstractThrownPotion1;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.getRider() != null && this.isControllable()) {
            return super.a(level, damageSource, amount);
        }
        if (PurpurConfig.endermanShortHeight && damageSource.a(DamageTypes.g)) {
            return false;
        }
        Entity entity = damageSource.c();
        EntityPotion entityPotion = abstractThrownPotion1 = entity instanceof EntityPotion ? (abstractThrownPotion = (EntityPotion)entity) : null;
        if (!damageSource.a(DamageTypeTags.j) && abstractThrownPotion1 == null) {
            boolean flag2 = super.a(level, damageSource, amount);
            if (!(damageSource.d() instanceof EntityLiving) && this.as.a(10) != 0 && this.tryEscape(damageSource.a(DamageTypeTags.n) ? EndermanEscapeEvent.Reason.DROWN : EndermanEscapeEvent.Reason.CRITICAL_HIT)) {
                this.n();
            }
            return flag2;
        }
        boolean bl = flag = abstractThrownPotion1 != null && this.a(level, damageSource, abstractThrownPotion1, amount);
        if (!flag && level.purpurConfig.endermanIgnoreProjectiles) {
            return super.a(level, damageSource, amount);
        }
        if (this.tryEscape(EndermanEscapeEvent.Reason.INDIRECT)) {
            for (int i2 = 0; i2 < 64; ++i2) {
                if (!this.n()) continue;
                return true;
            }
        }
        return flag;
    }

    private boolean a(WorldServer level, DamageSource damageSource, EntityPotion potion, float damageAmount) {
        ItemStack item = potion.e();
        PotionContents potionContents = item.a(DataComponents.R, PotionContents.a);
        return potionContents.a(Potions.a) && super.a(level, damageSource, damageAmount);
    }

    public boolean gI() {
        return this.az.a(cu);
    }

    public boolean gJ() {
        return this.az.a(cv);
    }

    public void gK() {
        this.az.a(cv, true);
    }

    public void setCreepy(boolean creepy) {
        this.az.a(cu, creepy);
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.az.a(cv, hasBeenStaredAt);
    }

    @Override
    public boolean ae() {
        return super.ae() || !this.an().purpurConfig.endermanDespawnEvenWithBlock && this.s() != null;
    }

    static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman enderman) {
            this.a = enderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.b = this.a.e();
            EntityLiving entityLiving = this.b;
            if (entityLiving instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entityLiving;
                double d2 = this.b.g(this.a);
                return !(d2 > 256.0) && this.a.g(player);
            }
            return false;
        }

        @Override
        public void d() {
            this.a.S().n();
        }

        @Override
        public void a() {
            this.a.P().a(this.b.dK(), this.b.dO(), this.b.dQ());
        }
    }

    static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean b() {
            if (!this.a.an().purpurConfig.endermanAllowGriefing) {
                return false;
            }
            return this.a.s() != null && PathfinderGoalEndermanPlaceBlock.a(this.a).S().getBoolean(GameRules.d, this.a.an().purpurConfig.endermanMobGriefingOverride) && this.a.ek().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0;
        }

        @Override
        public void a() {
            int floor2;
            int floor1;
            int floor;
            BlockPosition blockPos;
            RandomSource random = this.a.ek();
            World level = this.a.an();
            IBlockData blockState = level.getBlockStateIfLoaded(blockPos = new BlockPosition(floor = MathHelper.a(this.a.dK() - 1.0 + random.j() * 2.0), floor1 = MathHelper.a(this.a.dM() + random.j() * 2.0), floor2 = MathHelper.a(this.a.dQ() - 1.0 + random.j() * 2.0)));
            if (blockState == null) {
                return;
            }
            BlockPosition blockPos1 = blockPos.e();
            IBlockData blockState1 = level.a_(blockPos1);
            IBlockData carriedBlock = this.a.s();
            if (carriedBlock != null && this.a(level, blockPos, carriedBlock = Block.b(carriedBlock, (GeneratorAccess)this.a.an(), blockPos), blockState, blockState1, blockPos1) && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos, carriedBlock)) {
                level.a(blockPos, carriedBlock, 3);
                level.a(GameEvent.i, blockPos, GameEvent.a.a(this.a, carriedBlock));
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World level, BlockPosition destinationPos, IBlockData carriedState, IBlockData destinationState, IBlockData belowDestinationState, BlockPosition belowDestinationPos) {
            return destinationState.l() && !belowDestinationState.l() && !belowDestinationState.a(Blocks.I) && belowDestinationState.m(level, belowDestinationPos) && carriedState.a((IWorldReader)level, destinationPos) && level.a_(this.a, AxisAlignedBB.a(Vec3D.a(destinationPos))).isEmpty();
        }
    }

    static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean b() {
            if (!this.a.an().purpurConfig.endermanAllowGriefing) {
                return false;
            }
            return this.a.s() == null && PathfinderGoalEndermanPickupBlock.a(this.a).S().getBoolean(GameRules.d, this.a.an().purpurConfig.endermanMobGriefingOverride) && this.a.ek().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0;
        }

        @Override
        public void a() {
            int floor2;
            int floor1;
            int floor;
            BlockPosition blockPos;
            RandomSource random = this.a.ek();
            World level = this.a.an();
            IBlockData blockState = level.getBlockStateIfLoaded(blockPos = new BlockPosition(floor = MathHelper.a(this.a.dK() - 2.0 + random.j() * 4.0), floor1 = MathHelper.a(this.a.dM() + random.j() * 3.0), floor2 = MathHelper.a(this.a.dQ() - 2.0 + random.j() * 4.0)));
            if (blockState == null) {
                return;
            }
            Vec3D vec3 = new Vec3D((double)this.a.dJ() + 0.5, (double)floor1 + 0.5, (double)this.a.dP() + 0.5);
            Vec3D vec31 = new Vec3D((double)floor + 0.5, (double)floor1 + 0.5, (double)floor2 + 0.5);
            MovingObjectPositionBlock blockHitResult = level.a(new RayTrace(vec3, vec31, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = blockHitResult.b().equals(blockPos);
            if (blockState.a(TagsBlock.aB) && flag && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos, blockState.y().g())) {
                level.a(blockPos, false);
                level.a(GameEvent.f, blockPos, GameEvent.a.a(this.a, blockState));
                this.a.c(blockState.b().m());
            }
        }
    }

    static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final PathfinderTargetCondition.a o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman enderman, @Nullable PathfinderTargetCondition.a selector) {
            super(enderman, EntityHuman.class, 10, false, false, selector);
            this.i = enderman;
            this.o = (entity, level) -> (enderman.g((EntityHuman)entity) || enderman.a(entity, level)) && !enderman.B(entity);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean b() {
            this.j = PathfinderGoalPlayerWhoLookedAtTarget.a(this.i).a(this.m.a(this.l()), this.i);
            return this.j != null;
        }

        @Override
        public void d() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gK();
        }

        @Override
        public void e() {
            this.j = null;
            super.e();
        }

        @Override
        public boolean c() {
            if (this.j != null) {
                if (!this.o.test(this.j, PathfinderGoalPlayerWhoLookedAtTarget.a(this.i))) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.B(this.c)) {
                    return false;
                }
                if (this.n.a(PathfinderGoalPlayerWhoLookedAtTarget.a(this.i), this.i, this.c)) {
                    return true;
                }
            }
            return super.c();
        }

        @Override
        public void a() {
            if (this.i.e() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.d();
                }
            } else {
                if (this.c != null && !this.i.cl()) {
                    if (this.i.g((EntityHuman)this.c)) {
                        if (this.c.g(this.i) < 16.0 && this.i.tryEscape(EndermanEscapeEvent.Reason.STARE)) {
                            this.i.n();
                        }
                        this.l = 0;
                    } else if (this.c.g(this.i) > 256.0 && this.l++ >= this.a(30) && this.i.G(this.c)) {
                        this.l = 0;
                    }
                }
                super.a();
            }
        }
    }
}

