/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityEndermite
extends EntityMonster {
    private static final int a = 2400;
    private static final int b = 0;
    public int c = 0;
    private boolean isPlayerSpawned;

    public EntityEndermite(EntityTypes<? extends EntityEndermite> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cl = 3;
    }

    public boolean isPlayerSpawned() {
        return this.isPlayerSpawned;
    }

    public void setPlayerSpawned(boolean playerSpawned) {
        this.isPlayerSpawned = playerSpawned;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.endermiteRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.endermiteRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.endermiteControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.endermiteMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.endermiteScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.endermiteTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.endermiteAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(1, new PathfinderGoalFloat(this));
        this.cq.a(1, new HasRider(this));
        this.cq.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.an()));
        this.cq.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cq.a(3, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 8.0).a(GenericAttributes.w, 0.25).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.c;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.jB;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.jD;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.jC;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.jE, 0.15f, 1.0f);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.c = input.a("Lifetime", 0);
        this.isPlayerSpawned = input.a("PlayerSpawned", false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Lifetime", this.c);
        output.a("PlayerSpawned", this.isPlayerSpawned);
    }

    @Override
    public void g() {
        this.bB = this.dX();
        super.g();
    }

    @Override
    public void s(float offset) {
        this.v(offset);
        super.s(offset);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.an().D_()) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.an().a(Particles.ag, this.e(0.5), this.dN(), this.h(0.5), (this.as.j() - 0.5) * 2.0, -this.as.j(), (this.as.j() - 0.5) * 2.0);
            }
        } else {
            if (!this.gr()) {
                ++this.c;
            }
            if (this.c >= 2400) {
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    public static boolean b(EntityTypes<EntityEndermite> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (!EntityEndermite.c(entityType, level, spawnReason, pos, random)) {
            return false;
        }
        if (EntitySpawnReason.a(spawnReason)) {
            return true;
        }
        EntityHuman nearestPlayer = level.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, 5.0, true);
        return nearestPlayer == null;
    }
}

