/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep a;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> type, World level) {
        super((EntityTypes<? extends EntityIllagerWizard>)type, level);
        this.cl = 10;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.evokerRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.evokerRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.evokerControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.evokerMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.evokerScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.evokerTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.evokerAlwaysDropExp;
    }

    @Override
    protected void H() {
        super.H();
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new b());
        this.cq.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.cq.a(3, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 0.6, 1.0));
        this.cq.a(4, new c());
        this.cq.a(5, new a());
        this.cq.a(6, new d());
        this.cq.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.cq.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.cq.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gN().a(GenericAttributes.w, 0.5).a(GenericAttributes.n, 12.0).a(GenericAttributes.t, 24.0);
    }

    @Override
    public SoundEffect ah_() {
        return SoundEffects.jL;
    }

    @Override
    protected boolean u(Entity entity) {
        EntityVex vex;
        return entity == this || super.u(entity) || entity instanceof EntityVex && (vex = (EntityVex)entity).m() != null && this.u(vex.m());
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.jJ;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.jM;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.jO;
    }

    public void a(@Nullable EntitySheep wololoTarget) {
        this.a = wololoTarget;
    }

    @Nullable
    public EntitySheep hc() {
        return this.a;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.jK;
    }

    @Override
    public void a(WorldServer level, int wave, boolean flag) {
    }

    class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        public void a() {
            if (EntityEvoker.this.e() != null) {
                EntityEvoker.this.P().a(EntityEvoker.this.e(), (float)EntityEvoker.this.ah(), (float)EntityEvoker.this.af());
            } else if (EntityEvoker.this.hc() != null) {
                EntityEvoker.this.P().a(EntityEvoker.this.hc(), (float)EntityEvoker.this.ah(), (float)EntityEvoker.this.af());
            }
        }
    }

    class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        c() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).d().e();
        }

        @Override
        public boolean b() {
            if (!super.b()) {
                return false;
            }
            int size = net.minecraft.world.entity.monster.EntityEvoker$c.a(EntityEvoker.this.an()).a(EntityVex.class, this.e, EntityEvoker.this, EntityEvoker.this.de().g(16.0)).size();
            return EntityEvoker.this.as.a(8) + 1 > size;
        }

        @Override
        protected int h() {
            return 100;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            WorldServer serverLevel = (WorldServer)EntityEvoker.this.an();
            ScoreboardTeam team = EntityEvoker.this.cD();
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockPos = EntityEvoker.this.dF().b(-2 + EntityEvoker.this.as.a(5), 1, -2 + EntityEvoker.this.as.a(5));
                EntityVex vex = EntityTypes.bH.a(EntityEvoker.this.an(), EntitySpawnReason.f);
                if (vex == null) continue;
                vex.a(blockPos, 0.0f, 0.0f);
                vex.a((WorldAccess)serverLevel, EntityEvoker.this.an().d_(blockPos), EntitySpawnReason.f, null);
                vex.a(EntityEvoker.this);
                vex.h(blockPos);
                vex.b(20 * (30 + EntityEvoker.this.as.a(90)));
                if (team != null) {
                    serverLevel.g().a(vex.cV(), team);
                }
                serverLevel.addFreshEntityWithPassengers(vex, CreatureSpawnEvent.SpawnReason.SPELL);
                serverLevel.a(GameEvent.t, blockPos, GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.jQ;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.b;
        }
    }

    class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        protected int h() {
            return 40;
        }

        @Override
        protected int i() {
            return 100;
        }

        @Override
        protected void k() {
            EntityLiving target = EntityEvoker.this.e();
            double min = Math.min(target.dM(), EntityEvoker.this.dM());
            double d2 = Math.max(target.dM(), EntityEvoker.this.dM()) + 1.0;
            float f2 = (float)MathHelper.d(target.dQ() - EntityEvoker.this.dQ(), target.dK() - EntityEvoker.this.dK());
            if (EntityEvoker.this.g((Entity)target) < 9.0) {
                float f1;
                int i2;
                for (i2 = 0; i2 < 5; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.a(EntityEvoker.this.dK() + (double)MathHelper.b(f1) * 1.5, EntityEvoker.this.dQ() + (double)MathHelper.a(f1) * 1.5, min, d2, f1, 0);
                }
                for (i2 = 0; i2 < 8; ++i2) {
                    f1 = f2 + (float)i2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.a(EntityEvoker.this.dK() + (double)MathHelper.b(f1) * 2.5, EntityEvoker.this.dQ() + (double)MathHelper.a(f1) * 2.5, min, d2, f1, 3);
                }
            } else {
                for (int i3 = 0; i3 < 16; ++i3) {
                    double d1 = 1.25 * (double)(i3 + 1);
                    int i1 = 1 * i3;
                    this.a(EntityEvoker.this.dK() + (double)MathHelper.b(f2) * d1, EntityEvoker.this.dQ() + (double)MathHelper.a(f2) * d1, min, d2, f2, i1);
                }
            }
        }

        private void a(double x2, double z2, double minY, double maxY, float yRot, int warmupDelay) {
            BlockPosition blockPos = BlockPosition.a(x2, maxY, z2);
            boolean flag = false;
            double d2 = 0.0;
            do {
                IBlockData blockState1;
                VoxelShape collisionShape;
                BlockPosition blockPos1 = blockPos.e();
                IBlockData blockState = EntityEvoker.this.an().a_(blockPos1);
                if (!blockState.c((IBlockAccess)EntityEvoker.this.an(), blockPos1, EnumDirection.b)) continue;
                if (!EntityEvoker.this.an().w(blockPos) && !(collisionShape = (blockState1 = EntityEvoker.this.an().a_(blockPos)).g(EntityEvoker.this.an(), blockPos)).c()) {
                    d2 = collisionShape.c(EnumDirection.EnumAxis.b);
                }
                flag = true;
                break;
            } while ((blockPos = blockPos.e()).v() >= MathHelper.a(minY) - 1);
            if (flag) {
                EntityEvoker.this.an().b(new EntityEvokerFangs(EntityEvoker.this.an(), x2, (double)blockPos.v() + d2, z2, yRot, warmupDelay, EntityEvoker.this));
                EntityEvoker.this.an().a(GameEvent.t, new Vec3D(x2, (double)blockPos.v() + d2, z2), GameEvent.a.a(EntityEvoker.this));
            }
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.jP;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.c;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        public d() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).a((EntityLiving entity, WorldServer level) -> ((EntitySheep)entity).n() == EnumColor.l);
        }

        @Override
        public boolean b() {
            if (EntityEvoker.this.e() != null) {
                return false;
            }
            if (EntityEvoker.this.gR()) {
                return false;
            }
            if (EntityEvoker.this.at < this.c) {
                return false;
            }
            WorldServer serverLevel = net.minecraft.world.entity.monster.EntityEvoker$d.a(EntityEvoker.this.an());
            if (!serverLevel.S().getBoolean(GameRules.d, serverLevel.purpurConfig.evokerMobGriefingOverride)) {
                return false;
            }
            List<EntitySheep> nearbyEntities = serverLevel.a(EntitySheep.class, this.e, EntityEvoker.this, EntityEvoker.this.de().c(16.0, 4.0, 16.0));
            if (nearbyEntities.isEmpty()) {
                return false;
            }
            EntityEvoker.this.a(nearbyEntities.get(EntityEvoker.this.as.a(nearbyEntities.size())));
            return true;
        }

        @Override
        public boolean c() {
            return EntityEvoker.this.hc() != null && this.b > 0;
        }

        @Override
        public void e() {
            super.e();
            EntityEvoker.this.a((EntitySheep)null);
        }

        @Override
        protected void k() {
            EntitySheep wololoTarget = EntityEvoker.this.hc();
            if (wololoTarget != null && wololoTarget.bX()) {
                wololoTarget.a(EnumColor.o);
            }
        }

        @Override
        protected int n() {
            return 40;
        }

        @Override
        protected int h() {
            return 60;
        }

        @Override
        protected int i() {
            return 140;
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.jR;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.d;
        }
    }
}

