/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.purpurmc.purpur.controller.FlyingMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityGhast
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGhast.class, DataWatcherRegistry.k);
    private static final byte b = 1;
    private int c = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> type, World level) {
        super((EntityTypes<? extends EntityInsentient>)type, level);
        this.cl = 5;
        this.cn = new ControllerGhast((EntityInsentient)this, false, () -> false);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.ghastRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.ghastRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.ghastControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.ghastMaxY;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.ghastMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.ghastScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.ghastTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.ghastAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cq.a(5, new PathfinderGoalGhastIdleMove(this));
        this.cq.a(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.cq.a(7, new PathfinderGoalGhastAttackTarget(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entity, level) -> Math.abs(entity.dM() - this.dM()) <= 4.0));
    }

    public boolean k() {
        return this.az.a(a);
    }

    public void x(boolean charging) {
        this.az.a(a, charging);
    }

    public int m() {
        return this.c;
    }

    public void setExplosionPower(int explosionPower) {
        this.c = explosionPower;
    }

    private static boolean i(DamageSource damageSource) {
        return damageSource.c() instanceof EntityLargeFireball && damageSource.d() instanceof EntityHuman;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.cP() && !damageSource.a(DamageTypeTags.d) || !EntityGhast.i(damageSource) && super.a(level, damageSource);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean fe() {
        return false;
    }

    @Override
    public void m(Vec3D travelVector) {
        this.a(travelVector, 0.02f);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).bc) {
            float speed = (float)this.i(GenericAttributes.m);
            this.B(speed);
            Vec3D mot = this.dI();
            this.a(EnumMoveType.a, mot.d(speed, 1.0, speed));
            this.k(mot.c(0.9));
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (EntityGhast.i(damageSource)) {
            super.a(level, damageSource, 1000.0f);
            return true;
        }
        return !this.a(level, damageSource) && super.a(level, damageSource, amount);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
    }

    public static AttributeProvider.Builder n() {
        return EntityInsentient.I().a(GenericAttributes.t, 10.0).a(GenericAttributes.n, 100.0).a(GenericAttributes.i, 8.0).a(GenericAttributes.m, 0.06);
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.lC;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.lE;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.lD;
    }

    @Override
    public float ft() {
        return 5.0f;
    }

    public static boolean b(EntityTypes<EntityGhast> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (EntityMonster.canSpawnInBlueAndPackedIce(level, pos)) {
            return false;
        }
        return level.aq() != EnumDifficulty.a && random.a(20) == 0 && EntityGhast.a(entityType, level, spawnReason, pos, random);
    }

    @Override
    public int ak() {
        return 1;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("ExplosionPower", (byte)this.c);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.c = input.a("ExplosionPower", (byte)1);
    }

    @Override
    public boolean dT() {
        return true;
    }

    @Override
    public double B() {
        return 10.0;
    }

    @Override
    public double A() {
        return 16.0;
    }

    public static void a(EntityInsentient mob) {
        if (mob.e() == null) {
            Vec3D deltaMovement = mob.dI();
            mob.v(-((float)MathHelper.d(deltaMovement.g, deltaMovement.i)) * 57.295776f);
            mob.bB = mob.dX();
        } else {
            EntityLiving target = mob.e();
            double d2 = 64.0;
            if (target.g(mob) < 4096.0) {
                double d1 = target.dK() - mob.dK();
                double d22 = target.dQ() - mob.dQ();
                mob.v(-((float)MathHelper.d(d1, d22)) * 57.295776f);
                mob.bB = mob.dX();
            }
        }
    }

    public static class ControllerGhast
    extends FlyingMoveControllerWASD {
        private final EntityInsentient l;
        private int m;
        private final boolean n;
        private final BooleanSupplier o;

        public ControllerGhast(EntityInsentient mob, boolean careful, BooleanSupplier shouldBeStopped) {
            super(mob);
            this.l = mob;
            this.n = careful;
            this.o = shouldBeStopped;
        }

        @Override
        public void vanillaTick() {
            if (this.o.getAsBoolean()) {
                this.k = ControllerMove.Operation.a;
                this.l.aa();
            }
            if (this.k == ControllerMove.Operation.b && this.m-- <= 0) {
                this.m = this.m + this.l.ek().a(5) + 2;
                Vec3D vec3 = new Vec3D(this.e - this.l.dK(), this.f - this.l.dM(), this.g - this.l.dQ());
                if (this.a(vec3)) {
                    this.l.k(this.l.dI().e(vec3.d().c(this.l.i(GenericAttributes.m) * 5.0 / 3.0)));
                } else {
                    this.k = ControllerMove.Operation.a;
                }
            }
        }

        private boolean a(Vec3D delta) {
            AxisAlignedBB boundingBox = this.l.de();
            AxisAlignedBB aabb = boundingBox.c(delta);
            if (this.n) {
                for (BlockPosition blockPos : BlockPosition.a(aabb.g(1.0))) {
                    if (this.a(this.l.an(), null, null, blockPos, false, false)) continue;
                    return false;
                }
            }
            boolean isInWater = this.l.bu();
            boolean isInLava = this.l.bJ();
            Vec3D vec3 = this.l.dD();
            Vec3D vec31 = vec3.e(delta);
            return IBlockAccess.a(vec3, vec31, aabb, (pos, index) -> boundingBox.b(pos) || this.a(this.l.an(), vec3, vec31, pos, isInWater, isInLava));
        }

        private boolean a(IBlockAccess level, @Nullable Vec3D from, @Nullable Vec3D to, BlockPosition pos, boolean isInLava, boolean isInWater) {
            boolean flag1;
            boolean flag;
            IBlockData blockState = level.a_(pos);
            if (blockState.l()) {
                return true;
            }
            boolean bl = flag = from != null && to != null;
            boolean bl2 = flag ? !this.l.a(from, to, blockState.g(level, pos).a(new Vec3D(pos)).e()) : (flag1 = blockState.g(level, pos).c());
            if (!this.n) {
                return flag1;
            }
            if (blockState.a(TagsBlock.bC)) {
                return false;
            }
            Fluid fluidState = level.b_(pos);
            if (!(fluidState.c() || flag && !this.l.a(fluidState, pos, from, to))) {
                if (fluidState.a(TagsFluid.a)) {
                    return isInLava;
                }
                if (fluidState.a(TagsFluid.b)) {
                    return isInWater;
                }
            }
            return flag1;
        }
    }

    public static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private static final int a = 64;
        private final EntityInsentient b;
        private final int c;

        public PathfinderGoalGhastIdleMove(EntityInsentient ghast) {
            this(ghast, 0);
        }

        public PathfinderGoalGhastIdleMove(EntityInsentient ghast, int distanceToBlocks) {
            this.b = ghast;
            this.c = distanceToBlocks;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            double d2;
            double d1;
            ControllerMove moveControl = this.b.Q();
            if (!moveControl.b()) {
                return true;
            }
            double d3 = moveControl.d() - this.b.dK();
            double d32 = d3 * d3 + (d1 = moveControl.e() - this.b.dM()) * d1 + (d2 = moveControl.f() - this.b.dQ()) * d2;
            return d32 < 1.0 || d32 > 3600.0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void d() {
            Vec3D suitableFlyToPosition = PathfinderGoalGhastIdleMove.a(this.b, this.c);
            this.b.Q().a(suitableFlyToPosition.a(), suitableFlyToPosition.b(), suitableFlyToPosition.c(), 1.0);
        }

        public static Vec3D a(EntityInsentient mob, int distanceToBlocks) {
            BlockPosition blockPos;
            int height;
            World level = mob.an();
            RandomSource random = mob.ek();
            Vec3D vec3 = mob.dD();
            Vec3D vec31 = null;
            for (int i2 = 0; i2 < 64; ++i2) {
                vec31 = PathfinderGoalGhastIdleMove.a(mob, vec3, random);
                if (vec31 == null || !PathfinderGoalGhastIdleMove.a(level, vec31, distanceToBlocks)) continue;
                return vec31;
            }
            if (vec31 == null) {
                vec31 = PathfinderGoalGhastIdleMove.a(vec3, random);
            }
            if ((height = level.a(HeightMap.Type.e, (blockPos = BlockPosition.a(vec31)).u(), blockPos.w())) < blockPos.v() && height > level.M_()) {
                vec31 = new Vec3D(vec31.a(), mob.dM() - Math.abs(mob.dM() - vec31.b()), vec31.c());
            }
            return vec31;
        }

        private static boolean a(World level, Vec3D pos, int distanceToBlocks) {
            if (distanceToBlocks <= 0) {
                return true;
            }
            BlockPosition blockPos = BlockPosition.a(pos);
            if (!level.a_(blockPos).l()) {
                return false;
            }
            for (EnumDirection direction : EnumDirection.values()) {
                for (int i2 = 1; i2 < distanceToBlocks; ++i2) {
                    BlockPosition blockPos1 = blockPos.a(direction, i2);
                    if (level.a_(blockPos1).l()) continue;
                    return true;
                }
            }
            return false;
        }

        private static Vec3D a(Vec3D pos, RandomSource random) {
            double d2 = pos.a() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            double d1 = pos.b() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            double d22 = pos.c() + (double)((random.i() * 2.0f - 1.0f) * 16.0f);
            return new Vec3D(d2, d1, d22);
        }

        @Nullable
        private static Vec3D a(EntityInsentient mob, Vec3D pos, RandomSource random) {
            Vec3D vec3 = PathfinderGoalGhastIdleMove.a(pos, random);
            return mob.gw() && !mob.a(vec3) ? null : vec3;
        }
    }

    public static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityInsentient a;

        public PathfinderGoalGhastMoveTowardsTarget(EntityInsentient ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            EntityGhast.a(this.a);
        }
    }

    static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast b;
        public int a;

        public PathfinderGoalGhastAttackTarget(EntityGhast ghast) {
            this.b = ghast;
        }

        @Override
        public boolean b() {
            return this.b.e() != null;
        }

        @Override
        public void d() {
            this.a = 0;
        }

        @Override
        public void e() {
            this.b.x(false);
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.b.e();
            if (target != null) {
                double d2 = 64.0;
                if (target.g(this.b) < 4096.0 && this.b.F(target)) {
                    World level = this.b.an();
                    ++this.a;
                    if (this.a == 10 && !this.b.bm()) {
                        level.a(null, 1015, this.b.dF(), 0);
                    }
                    if (this.a == 20) {
                        double d1 = 4.0;
                        Vec3D viewVector = this.b.h(1.0f);
                        double d22 = target.dK() - (this.b.dK() + viewVector.g * 4.0);
                        double d3 = target.f(0.5) - (0.5 + this.b.f(0.5));
                        double d4 = target.dQ() - (this.b.dQ() + viewVector.i * 4.0);
                        Vec3D vec3 = new Vec3D(d22, d3, d4);
                        if (!this.b.bm()) {
                            level.a(null, 1016, this.b.dF(), 0);
                        }
                        EntityLargeFireball largeFireball = new EntityLargeFireball(level, (EntityLiving)this.b, vec3.d(), this.b.m());
                        largeFireball.f = this.b.m();
                        largeFireball.bukkitYield = largeFireball.f;
                        largeFireball.a_(this.b.dK() + viewVector.g * 4.0, this.b.f(0.5) + 0.5, largeFireball.dQ() + viewVector.i * 4.0);
                        level.b(largeFireball);
                        this.a = -40;
                    }
                } else if (this.a > 0) {
                    --this.a;
                }
                this.b.x(this.a > 10);
            }
        }
    }
}

