/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.jetbrains.annotations.Nullable;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityGiantZombie
extends EntityMonster {
    public EntityGiantZombie(EntityTypes<? extends EntityGiantZombie> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.giantRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.giantRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.giantControllable;
    }

    @Override
    protected void H() {
        if (this.an().purpurConfig.giantHaveAI) {
            this.cq.a(0, new PathfinderGoalFloat(this));
            this.cq.a(0, new HasRider(this));
            this.cq.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
            this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 16.0f));
            this.cq.a(8, new PathfinderGoalRandomLookaround(this));
            this.cq.a(5, new PathfinderGoalMoveTowardsRestriction(this, 1.0));
            if (this.an().purpurConfig.giantHaveHostileAI) {
                this.cq.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
                this.cr.a(0, new HasRider(this));
                this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
                this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
                this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillager>((EntityInsentient)this, EntityVillager.class, false));
                this.cr.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
                this.cr.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>((EntityInsentient)this, EntityTurtle.class, true));
            }
        }
    }

    @Override
    protected void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.giantMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.giantScale);
        this.h(GenericAttributes.w).a(this.an().purpurConfig.giantMovementSpeed);
        this.h(GenericAttributes.c).a(this.an().purpurConfig.giantAttackDamage);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.giantTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.giantAlwaysDropExp;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 100.0).a(GenericAttributes.w, 0.5).a(GenericAttributes.c, 50.0).a(GenericAttributes.i, 16.0);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity entityData) {
        GroupDataEntity groupData = super.a(world, difficulty, spawnReason, entityData);
        if (groupData == null) {
            this.a(this.as, difficulty);
            this.a(world, this.as, difficulty);
        }
        return groupData;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(this.as, difficulty);
        float f2 = random.i();
        float f3 = this.an().aq() == EnumDifficulty.d ? 0.1f : 0.05f;
        if (f2 < f3) {
            this.a(EnumItemSlot.a, new ItemStack(Items.qH));
        }
    }

    @Override
    public float fw() {
        return this.an().purpurConfig.giantJumpHeight;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return super.a(pos, level);
    }
}

