/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.controller.WaterMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityGuardian
extends EntityMonster {
    protected static final int b = 80;
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityGuardian.class, DataWatcherRegistry.b);
    private float e;
    private float f;
    private float ct;
    private float cu;
    private float cv;
    @Nullable
    private EntityLiving cw;
    private int cx;
    private boolean cy;
    @Nullable
    public PathfinderGoalRandomStroll c;
    public PathfinderGoalGuardianAttack guardianAttackGoal;

    public EntityGuardian(EntityTypes<? extends EntityGuardian> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cl = 10;
        this.a(PathType.j, 0.0f);
        this.cn = new ControllerMoveGuardian(this);
        this.cm = new LookControllerWASD(this, this){

            @Override
            public void setYawPitch(float yaw, float pitch) {
                super.setYawPitch(yaw, pitch * 0.35f);
            }
        };
        this.f = this.e = this.as.i();
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.guardianRidable;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.guardianControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.guardianMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.guardianScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.guardianTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.guardianAlwaysDropExp;
    }

    @Override
    protected void H() {
        PathfinderGoalMoveTowardsRestriction moveTowardsRestrictionGoal = new PathfinderGoalMoveTowardsRestriction(this, 1.0);
        this.c = new PathfinderGoalRandomStroll(this, 1.0, 80);
        this.cq.a(0, new HasRider(this));
        this.guardianAttackGoal = new PathfinderGoalGuardianAttack(this);
        this.cq.a(4, this.guardianAttackGoal);
        this.cq.a(5, moveTowardsRestrictionGoal);
        this.cq.a(7, this.c);
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityGuardian.class, 12.0f, 0.01f));
        this.cq.a(9, new PathfinderGoalRandomLookaround(this));
        this.c.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        moveTowardsRestrictionGoal.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 10, true, false, new EntitySelectorGuardianTargetHumanSquid(this)));
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gN().a(GenericAttributes.c, 6.0).a(GenericAttributes.w, 0.5).a(GenericAttributes.t, 30.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new NavigationGuardian(this, level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
        builder.a(d, 0);
    }

    public boolean gI() {
        return this.az.a(a);
    }

    void x(boolean moving) {
        this.az.a(a, moving);
    }

    public int m() {
        return 80;
    }

    public void b(int activeAttackTargetId) {
        this.az.a(d, activeAttackTargetId);
    }

    public boolean gJ() {
        return this.az.a(d) != 0;
    }

    @Nullable
    public EntityLiving gK() {
        if (!this.gJ()) {
            return null;
        }
        if (this.an().D_()) {
            if (this.cw != null) {
                return this.cw;
            }
            Entity entity = this.an().a(this.az.a(d));
            if (entity instanceof EntityLiving) {
                this.cw = (EntityLiving)entity;
                return this.cw;
            }
            return null;
        }
        return this.e();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (d.equals(key)) {
            this.cx = 0;
            this.cw = null;
        }
    }

    @Override
    public int W() {
        return 160;
    }

    @Override
    public SoundEffect p() {
        return this.bu() ? SoundEffects.mK : SoundEffects.mL;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.bu() ? SoundEffects.mQ : SoundEffects.mR;
    }

    @Override
    public SoundEffect f_() {
        return this.bu() ? SoundEffects.mN : SoundEffects.mO;
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.c;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.b_(pos).a(TagsFluid.a) ? 10.0f + level.y(pos) : super.a(pos, level);
    }

    @Override
    public void e_() {
        if (this.bX()) {
            if (this.an().D_()) {
                Vec3D deltaMovement;
                this.f = this.e;
                if (!this.bu()) {
                    this.ct = 2.0f;
                    deltaMovement = this.dI();
                    if (deltaMovement.h > 0.0 && this.cy && !this.bm()) {
                        this.an().a(this.dK(), this.dM(), this.dQ(), this.n(), this.dw(), 1.0f, 1.0f, false);
                    }
                    this.cy = deltaMovement.h < 0.0 && this.an().a(this.dF().e(), this);
                } else {
                    this.ct = this.gI() ? (this.ct < 0.5f ? 4.0f : (this.ct += (0.5f - this.ct) * 0.1f)) : (this.ct += (0.125f - this.ct) * 0.2f);
                }
                this.e += this.ct;
                this.cv = this.cu;
                this.cu = !this.bu() ? this.as.i() : (this.gI() ? (this.cu += (0.0f - this.cu) * 0.25f) : (this.cu += (1.0f - this.cu) * 0.06f));
                if (this.gI() && this.bu()) {
                    deltaMovement = this.h(0.0f);
                    for (int i2 = 0; i2 < 2; ++i2) {
                        this.an().a(Particles.d, this.e(0.5) - deltaMovement.g * 1.5, this.dN() - deltaMovement.h * 1.5, this.h(0.5) - deltaMovement.i * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.gJ()) {
                    EntityLiving activeAttackTarget;
                    if (this.cx < this.m()) {
                        ++this.cx;
                    }
                    if ((activeAttackTarget = this.gK()) != null) {
                        this.P().a(activeAttackTarget, 90.0f, 90.0f);
                        this.P().a();
                        double d2 = this.L(0.0f);
                        double d1 = activeAttackTarget.dK() - this.dK();
                        double d22 = activeAttackTarget.f(0.5) - this.dO();
                        double d3 = activeAttackTarget.dQ() - this.dQ();
                        double squareRoot = Math.sqrt(d1 * d1 + d22 * d22 + d3 * d3);
                        d1 /= squareRoot;
                        d22 /= squareRoot;
                        d3 /= squareRoot;
                        double randomDouble = this.as.j();
                        while (randomDouble < squareRoot) {
                            this.an().a(Particles.d, this.dK() + d1 * (randomDouble += 1.8 - d2 + this.as.j() * (1.7 - d2)), this.dO() + d22 * randomDouble, this.dQ() + d3 * randomDouble, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.bu()) {
                this.j(300);
            } else if (this.aS()) {
                this.k(this.dI().b((this.as.i() * 2.0f - 1.0f) * 0.4f, 0.5, (this.as.i() * 2.0f - 1.0f) * 0.4f));
                this.v(this.as.i() * 360.0f);
                this.e(false);
                this.aF = true;
            }
            if (this.gJ()) {
                this.v(this.bD);
            }
        }
        super.e_();
    }

    protected SoundEffect n() {
        return SoundEffects.mP;
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.f, this.e);
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cv, this.cu);
    }

    public float L(float partialTick) {
        return ((float)this.cx + partialTick) / (float)this.m();
    }

    public float gL() {
        return this.cx;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    public static boolean b(EntityTypes<? extends EntityGuardian> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (EntityGuardian.canSpawnInBlueAndPackedIce(level, pos)) {
            return false;
        }
        return !(random.a(20) != 0 && level.x(pos) || level.aq() == EnumDifficulty.a || !EntitySpawnReason.a(spawnReason) && !level.b_(pos).a(TagsFluid.a) || !level.b_(pos.e()).a(TagsFluid.a));
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        if (!this.gI() && !damageSource.a(DamageTypeTags.w) && !damageSource.a(DamageTypes.P) && (entity = damageSource.c()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            livingEntity.a(level, this.ei().d(this), 2.0f);
        }
        if (this.c != null) {
            this.c.i();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public int af() {
        return 180;
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.bu()) {
            this.a(this.getRider() != null && this.isControllable() ? this.fD() : 0.1f, travelVector);
            this.a(EnumMoveType.a, this.dI());
            this.k(this.dI().c(0.9));
            if (!this.gI() && this.e() == null) {
                this.k(this.dI().b(0.0, -0.005, 0.0));
            }
        } else {
            super.m(travelVector);
        }
    }

    static class ControllerMoveGuardian
    extends WaterMoveControllerWASD {
        private final EntityGuardian l;

        public ControllerMoveGuardian(EntityGuardian mob) {
            super(mob);
            this.l = mob;
        }

        @Override
        public void purpurTick(EntityHuman rider) {
            super.purpurTick(rider);
            this.l.k(this.l.dI().b(0.0, 0.005, 0.0));
            this.l.x(this.l.getForwardMot() > 0.0f);
        }

        @Override
        public void vanillaTick() {
            if (this.k == ControllerMove.Operation.b && !this.l.S().l()) {
                Vec3D vec3 = new Vec3D(this.e - this.l.dK(), this.f - this.l.dM(), this.g - this.l.dQ());
                double len = vec3.g();
                double d2 = vec3.g / len;
                double d1 = vec3.h / len;
                double d22 = vec3.i / len;
                float f2 = (float)(MathHelper.d(vec3.i, vec3.g) * 180.0 / 3.1415927410125732) - 90.0f;
                this.l.v(this.b(this.l.dX(), f2, 90.0f));
                this.l.bB = this.l.dX();
                float f1 = (float)(this.c() * this.l.i(GenericAttributes.w));
                float f22 = MathHelper.h(0.125f, this.l.fD(), f1);
                this.l.B(f22);
                double d3 = Math.sin((double)(this.l.at + this.l.az()) * 0.5) * 0.05;
                double cos = Math.cos(this.l.dX() * ((float)Math.PI / 180));
                double sin = Math.sin(this.l.dX() * ((float)Math.PI / 180));
                double d4 = Math.sin((double)(this.l.at + this.l.az()) * 0.75) * 0.05;
                this.l.k(this.l.dI().b(d3 * cos, d4 * (sin + cos) * 0.25 + (double)f22 * d1 * 0.1, d3 * sin));
                ControllerLook lookControl = this.l.P();
                double d5 = this.l.dK() + d2 * 2.0;
                double d6 = this.l.dO() + d1 / len;
                double d7 = this.l.dQ() + d22 * 2.0;
                double wantedX = lookControl.e();
                double wantedY = lookControl.f();
                double wantedZ = lookControl.g();
                if (!lookControl.d()) {
                    wantedX = d5;
                    wantedY = d6;
                    wantedZ = d7;
                }
                this.l.P().a(MathHelper.d(0.125, wantedX, d5), MathHelper.d(0.125, wantedY, d6), MathHelper.d(0.125, wantedZ, d7), 10.0f, 40.0f);
                this.l.x(true);
            } else {
                this.l.B(0.0f);
                this.l.x(false);
            }
        }
    }

    public static class PathfinderGoalGuardianAttack
    extends PathfinderGoal {
        private final EntityGuardian a;
        public int b;
        private final boolean c;

        public PathfinderGoalGuardianAttack(EntityGuardian guardian) {
            this.a = guardian;
            this.c = guardian instanceof EntityGuardianElder;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = this.a.e();
            return target != null && target.bX();
        }

        @Override
        public boolean c() {
            return super.c() && (this.c || this.a.e() != null && this.a.g((Entity)this.a.e()) > 9.0);
        }

        @Override
        public void d() {
            this.b = -10;
            this.a.S().n();
            EntityLiving target = this.a.e();
            if (target != null) {
                this.a.P().a(target, 90.0f, 90.0f);
            }
            this.a.aF = true;
        }

        @Override
        public void e() {
            this.a.b(0);
            this.a.g((EntityLiving)null);
            this.a.c.i();
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.a.e();
            if (target != null) {
                this.a.S().n();
                this.a.P().a(target, 90.0f, 90.0f);
                if (!this.a.F(target)) {
                    this.a.g((EntityLiving)null);
                } else {
                    ++this.b;
                    if (this.b == 0) {
                        this.a.b(target.az());
                        if (!this.a.bm()) {
                            this.a.an().a((Entity)this.a, (byte)21);
                        }
                    } else if (this.b >= this.a.m()) {
                        float f2 = 1.0f;
                        if (this.a.an().aq() == EnumDifficulty.d) {
                            f2 += 2.0f;
                        }
                        if (this.c) {
                            f2 += 2.0f;
                        }
                        WorldServer serverLevel = PathfinderGoalGuardianAttack.a(this.a);
                        target.a(serverLevel, this.a.ei().c((Entity)this.a, (Entity)this.a), f2);
                        this.a.c(serverLevel, (Entity)target);
                        this.a.g((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    static class EntitySelectorGuardianTargetHumanSquid
    implements PathfinderTargetCondition.a {
        private final EntityGuardian a;

        public EntitySelectorGuardianTargetHumanSquid(EntityGuardian guardian) {
            this.a = guardian;
        }

        @Override
        public boolean test(@Nullable EntityLiving entity, WorldServer level) {
            return (entity instanceof EntityHuman || entity instanceof EntitySquid || entity instanceof Axolotl) && entity.g(this.a) > 9.0;
        }
    }
}

