/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;

public class EntityMagmaCube
extends EntitySlime {
    public EntityMagmaCube(EntityTypes<? extends EntityMagmaCube> type, World level) {
        super((EntityTypes<? extends EntitySlime>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.magmaCubeRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.magmaCubeRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.magmaCubeControllable;
    }

    @Override
    public float fw() {
        return 0.42f * this.bd();
    }

    @Override
    protected String getMaxHealthEquation() {
        return this.an().purpurConfig.magmaCubeMaxHealth;
    }

    @Override
    protected String getAttackDamageEquation() {
        return this.an().purpurConfig.magmaCubeAttackDamage;
    }

    @Override
    protected Map<Integer, Double> getMaxHealthCache() {
        return this.an().purpurConfig.magmaCubeMaxHealthCache;
    }

    @Override
    protected Map<Integer, Double> getAttackDamageCache() {
        return this.an().purpurConfig.magmaCubeAttackDamageCache;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.magmaCubeTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.magmaCubeAlwaysDropExp;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.w, 0.2f);
    }

    public static boolean b(EntityTypes<EntityMagmaCube> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (EntityMonster.canSpawnInBlueAndPackedIce(level, pos)) {
            return false;
        }
        return level.aq() != EnumDifficulty.a;
    }

    @Override
    public void a(int size, boolean resetHealth) {
        super.a(size, resetHealth);
        this.h(GenericAttributes.a).a(size * 3);
    }

    @Override
    public float bK() {
        return 1.0f;
    }

    @Override
    protected ParticleParam m() {
        return Particles.G;
    }

    @Override
    public boolean ck() {
        return false;
    }

    @Override
    protected int n() {
        return super.n() * 4;
    }

    @Override
    protected void s() {
        this.d *= 0.9f;
    }

    @Override
    public void u() {
        Vec3D deltaMovement = this.dI();
        float f2 = (float)this.gI() * 0.1f;
        this.m(deltaMovement.g, this.fw() + f2, deltaMovement.i);
        this.aF = true;
        this.actualJump = false;
    }

    @Override
    protected void c(TagKey<FluidType> fluidTag) {
        if (fluidTag == TagsFluid.b) {
            Vec3D deltaMovement = this.dI();
            this.m(deltaMovement.g, 0.22f + (float)this.gI() * 0.05f, deltaMovement.i);
            this.aF = true;
        } else {
            super.c(fluidTag);
        }
    }

    @Override
    protected boolean gE() {
        return this.dt();
    }

    @Override
    protected float gF() {
        return super.gF() + 2.0f;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.gJ() ? SoundEffects.qi : SoundEffects.qh;
    }

    @Override
    public SoundEffect f_() {
        return this.gJ() ? SoundEffects.pW : SoundEffects.qg;
    }

    @Override
    protected SoundEffect gG() {
        return this.gJ() ? SoundEffects.ql : SoundEffects.qk;
    }

    @Override
    protected SoundEffect gH() {
        return SoundEffects.qj;
    }
}

