/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.util.Vector;
import org.purpurmc.purpur.controller.FlyingMoveControllerWASD;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;
import org.purpurmc.purpur.entity.projectile.PhantomFlames;

public class EntityPhantom
extends EntityInsentient
implements IMonster {
    public static final float a = 7.448451f;
    public static final int b = MathHelper.f(24.166098f);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityPhantom.class, DataWatcherRegistry.b);
    Vec3D d = Vec3D.c;
    @Nullable
    public BlockPosition e;
    AttackPhase f = AttackPhase.a;
    Vec3D crystalPosition;
    @Nullable
    public UUID spawningEntity;
    private static final RecipeItemStack TORCH = RecipeItemStack.a(Items.fk, Items.gb);

    public EntityPhantom(EntityTypes<? extends EntityPhantom> type, World level) {
        super((EntityTypes<? extends EntityInsentient>)type, level);
        this.cl = 5;
        this.cn = new g(this);
        this.cm = new f(this);
        this.setShouldBurnInDay(true);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.phantomRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.phantomRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.phantomControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.phantomMaxY;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.gN().a(GenericAttributes.m, 3.0);
    }

    @Override
    public boolean onSpacebar() {
        if (this.getRider() != null && this.getRider().getBukkitEntity().hasPermission("allow.special.phantom")) {
            this.shoot();
        }
        return false;
    }

    public boolean shoot() {
        Location loc = ((LivingEntity)this.getBukkitEntity()).getEyeLocation();
        loc.setPitch(-loc.getPitch());
        Vector target = loc.getDirection().normalize().multiply(100).add(loc.toVector());
        PhantomFlames flames = new PhantomFlames(this.an(), this);
        flames.canGrief = this.an().purpurConfig.phantomAllowGriefing;
        flames.c(target.getX() - this.dK(), target.getY() - this.dM(), target.getZ() - this.dQ(), 1.0f, 5.0f);
        this.an().b(flames);
        return true;
    }

    @Override
    protected void b(WorldServer world, DamageSource damageSource, boolean causedByPlayer) {
        boolean dropped = false;
        if (this.bG == null && damageSource.d() instanceof EntityEnderCrystal && this.as.a(5) < 1) {
            boolean bl = dropped = this.a(world, new ItemStack(Items.pp)) != null;
        }
        if (!dropped) {
            super.b(world, damageSource, causedByPlayer);
        }
    }

    public boolean isCirclingCrystal() {
        return this.crystalPosition != null;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.phantomTakeDamageFromWater;
    }

    @Override
    public boolean shouldBurnInDay() {
        boolean burnFromDaylight = this.shouldBurnInDay && this.an().purpurConfig.phantomBurnInDaylight;
        boolean burnFromLightSource = this.an().purpurConfig.phantomBurnInLight > 0 && this.an().C(this.dF()) >= this.an().purpurConfig.phantomBurnInLight;
        return burnFromDaylight || burnFromLightSource;
    }

    @Override
    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.phantomAlwaysDropExp;
    }

    @Override
    public boolean bl() {
        return (this.m() + this.at) % b == 0;
    }

    @Override
    protected EntityAIBodyControl N() {
        return new d(this);
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        if (this.an().purpurConfig.phantomOrbitCrystalRadius > 0.0) {
            this.cq.a(1, new PhantomFindCrystalGoal(this));
            this.cq.a(2, new PhantomOrbitCrystalGoal(this, this));
        }
        this.cq.a(3, new c());
        this.cq.a(4, new i());
        this.cq.a(5, new e());
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new b());
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, 0);
    }

    public void b(int phantomSize) {
        this.az.a(c, MathHelper.a(phantomSize, 0, 64));
    }

    private void n() {
        this.l_();
        if (this.an().purpurConfig.phantomFlamesOnSwoop && this.f == AttackPhase.b) {
            this.shoot();
        }
        this.h(GenericAttributes.t).a(this.getFromCache(() -> this.an().purpurConfig.phantomMaxHealth, () -> this.an().purpurConfig.phantomMaxHealthCache, () -> 20.0));
        this.h(GenericAttributes.c).a(this.getFromCache(() -> this.an().purpurConfig.phantomAttackDamage, () -> this.an().purpurConfig.phantomAttackDamageCache, () -> 6 + this.k()));
    }

    public int k() {
        return this.az.a(c);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (c.equals(key)) {
            this.n();
        }
        super.a(key);
    }

    public int m() {
        return this.az() * 3;
    }

    private double getFromCache(Supplier<String> equation, Supplier<Map<Integer, Double>> cache, Supplier<Double> defaultValue) {
        int size = this.k();
        Double value = cache.get().get(size);
        if (value == null) {
            try {
                value = ((Number)Entity.scriptEngine.eval("let size = " + size + "; " + equation.get())).doubleValue();
            }
            catch (ScriptException e2) {
                e2.printStackTrace();
                value = defaultValue.get();
            }
            cache.get().put(size, value);
        }
        return value;
    }

    @Override
    public void g() {
        super.g();
        if (this.an().D_()) {
            float cos = MathHelper.b((float)(this.m() + this.at) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            float cos1 = MathHelper.b((float)(this.m() + this.at + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI);
            if (cos > 0.0f && cos1 <= 0.0f) {
                this.an().a(this.dK(), this.dM(), this.dQ(), SoundEffects.vq, this.dw(), 0.95f + this.as.i() * 0.05f, 0.95f + this.as.i() * 0.05f, false);
            }
            float f2 = this.dA() * 1.48f;
            float f1 = MathHelper.b(this.dX() * ((float)Math.PI / 180)) * f2;
            float f22 = MathHelper.a(this.dX() * ((float)Math.PI / 180)) * f2;
            float f3 = (0.3f + cos * 0.45f) * this.dB() * 2.5f;
            this.an().a(Particles.ad, this.dK() + (double)f1, this.dM() + (double)f3, this.dQ() + (double)f22, 0.0, 0.0, 0.0);
            this.an().a(Particles.ad, this.dK() - (double)f1, this.dM() + (double)f3, this.dQ() - (double)f22, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void e_() {
        super.e_();
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean fe() {
        return false;
    }

    @Override
    public void m(Vec3D travelVector) {
        this.a(travelVector, 0.2f);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).bc) {
            float speed = (float)this.i(GenericAttributes.m);
            this.B(speed);
            Vec3D mot = this.dI();
            this.a(EnumMoveType.a, mot.d(speed, speed, speed));
            this.k(mot.c(0.9));
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.e = this.dF().b(5);
        int min = level.a().purpurConfig.phantomMinSize;
        int max = level.a().purpurConfig.phantomMaxSize;
        this.b(min == max ? min : level.I_().a(max + 1 - min) + min);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.e = input.a("anchor_pos", BlockPosition.a).orElse(null);
        this.b(input.a("size", 0));
        this.spawningEntity = input.a("Paper.SpawningEntity", UUIDUtil.a).orElse(null);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.b("anchor_pos", BlockPosition.a, this.e);
        output.a("size", this.k());
        output.b("Paper.SpawningEntity", UUIDUtil.a, this.spawningEntity);
    }

    @Override
    public boolean a(double distance) {
        return true;
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.vn;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vr;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.vp;
    }

    @Override
    public float ft() {
        return 1.0f;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return true;
    }

    @Override
    public EntitySize b(EntityPose pose) {
        int phantomSize = this.k();
        EntitySize entityDimensions = super.b(pose);
        return entityDimensions.a(1.0f + 0.15f * (float)phantomSize);
    }

    boolean a(WorldServer level, EntityLiving entity, PathfinderTargetCondition targetingConditions) {
        return targetingConditions.a(level, this, entity);
    }

    static final class AttackPhase
    extends Enum<AttackPhase> {
        public static final /* enum */ AttackPhase a = new AttackPhase();
        public static final /* enum */ AttackPhase b = new AttackPhase();
        private static final /* synthetic */ AttackPhase[] c;

        public static AttackPhase[] values() {
            return (AttackPhase[])c.clone();
        }

        public static AttackPhase valueOf(String name) {
            return Enum.valueOf(AttackPhase.class, name);
        }

        private static /* synthetic */ AttackPhase[] a() {
            return new AttackPhase[]{a, b};
        }

        static {
            c = AttackPhase.a();
        }
    }

    class g
    extends FlyingMoveControllerWASD {
        private float m;

        public g(EntityInsentient mob) {
            super(mob);
            this.m = 0.1f;
        }

        @Override
        public void purpurTick(EntityHuman rider) {
            if (!((Entity)EntityPhantom.this).bc) {
                // empty if block
            }
            super.purpurTick(rider);
        }

        @Override
        public void vanillaTick() {
            if (EntityPhantom.this.ad) {
                EntityPhantom.this.v(EntityPhantom.this.dX() + 180.0f);
                this.m = 0.1f;
            }
            double d2 = EntityPhantom.this.d.g - EntityPhantom.this.dK();
            double d1 = EntityPhantom.this.d.h - EntityPhantom.this.dM();
            double d22 = EntityPhantom.this.d.i - EntityPhantom.this.dQ();
            double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
            if (Math.abs(squareRoot) > (double)1.0E-5f) {
                double d3 = 1.0 - Math.abs(d1 * (double)0.7f) / squareRoot;
                squareRoot = Math.sqrt((d2 *= d3) * d2 + (d22 *= d3) * d22);
                double squareRoot1 = Math.sqrt(d2 * d2 + d22 * d22 + d1 * d1);
                float yRot = EntityPhantom.this.dX();
                float f2 = (float)MathHelper.d(d22, d2);
                float f1 = MathHelper.h(EntityPhantom.this.dX() + 90.0f);
                float f22 = MathHelper.h(f2 * 57.295776f);
                EntityPhantom.this.v(MathHelper.e(f1, f22, 4.0f) - 90.0f);
                EntityPhantom.this.bB = EntityPhantom.this.dX();
                this.m = MathHelper.d(yRot, EntityPhantom.this.dX()) < 3.0f ? MathHelper.d(this.m, 1.8f, 0.005f * (1.8f / this.m)) : MathHelper.d(this.m, 0.2f, 0.025f);
                float f3 = (float)(-(MathHelper.d(-d1, squareRoot) * 180.0 / 3.1415927410125732));
                EntityPhantom.this.w(f3);
                float f4 = EntityPhantom.this.dX() + 90.0f;
                double d4 = (double)(this.m * MathHelper.b(f4 * ((float)Math.PI / 180))) * Math.abs(d2 / squareRoot1);
                double d5 = (double)(this.m * MathHelper.a(f4 * ((float)Math.PI / 180))) * Math.abs(d22 / squareRoot1);
                double d6 = (double)(this.m * MathHelper.a(f3 * ((float)Math.PI / 180))) * Math.abs(d1 / squareRoot1);
                Vec3D deltaMovement = EntityPhantom.this.dI();
                EntityPhantom.this.k(deltaMovement.e(new Vec3D(d4, d6, d5).d(deltaMovement).c(0.2)));
            }
        }
    }

    static class f
    extends LookControllerWASD {
        public f(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void purpurTick(EntityHuman rider) {
            this.setYawPitch(rider.dX(), -rider.ac * 0.75f);
        }

        @Override
        public void vanillaTick() {
        }
    }

    class d
    extends EntityAIBodyControl {
        public d(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void a() {
            EntityPhantom.this.bD = EntityPhantom.this.bB;
            EntityPhantom.this.bB = EntityPhantom.this.dX();
        }
    }

    class PhantomFindCrystalGoal
    extends PathfinderGoal {
        private final EntityPhantom phantom;
        private EntityEnderCrystal crystal;
        private Comparator<EntityEnderCrystal> comparator;

        PhantomFindCrystalGoal(EntityPhantom phantom) {
            this.phantom = phantom;
            this.comparator = Comparator.comparingDouble(phantom::g);
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            double range = this.maxTargetRange();
            List<EntityEnderCrystal> crystals = EntityPhantom.this.an().a(EntityEnderCrystal.class, this.phantom.de().g(range));
            if (crystals.isEmpty()) {
                return false;
            }
            crystals.sort(this.comparator);
            this.crystal = crystals.get(0);
            if (this.phantom.g(this.crystal) > range * range) {
                this.crystal = null;
                return false;
            }
            return true;
        }

        @Override
        public boolean c() {
            if (this.crystal == null || !this.crystal.bX()) {
                return false;
            }
            double range = this.maxTargetRange();
            return this.phantom.g(this.crystal) <= range * range * 2.0;
        }

        @Override
        public void d() {
            this.phantom.crystalPosition = new Vec3D(this.crystal.dK(), this.crystal.dM() + (double)(this.phantom.as.a(10) + 10), this.crystal.dQ());
        }

        @Override
        public void e() {
            this.crystal = null;
            this.phantom.crystalPosition = null;
            super.e();
        }

        private double maxTargetRange() {
            return this.phantom.an().purpurConfig.phantomOrbitCrystalRadius;
        }
    }

    class PhantomOrbitCrystalGoal
    extends PathfinderGoal {
        private final EntityPhantom phantom;
        private float offset;
        private float radius;
        private float verticalChange;
        private float direction;

        PhantomOrbitCrystalGoal(EntityPhantom this$0, EntityPhantom phantom) {
            this.phantom = phantom;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return this.phantom.isCirclingCrystal();
        }

        @Override
        public void d() {
            this.radius = 5.0f + this.phantom.as.i() * 10.0f;
            this.verticalChange = -4.0f + this.phantom.as.i() * 9.0f;
            this.direction = this.phantom.as.h() ? 1.0f : -1.0f;
            this.updateOffset();
        }

        @Override
        public void a() {
            if (this.phantom.as.a(350) == 0) {
                this.verticalChange = -4.0f + this.phantom.as.i() * 9.0f;
            }
            if (this.phantom.as.a(250) == 0) {
                this.radius += 1.0f;
                if (this.radius > 15.0f) {
                    this.radius = 5.0f;
                    this.direction = -this.direction;
                }
            }
            if (this.phantom.as.a(450) == 0) {
                this.offset = this.phantom.as.i() * 2.0f * (float)Math.PI;
                this.updateOffset();
            }
            if (this.phantom.d.c(this.phantom.dK(), this.phantom.dM(), this.phantom.dQ()) < 4.0) {
                this.updateOffset();
            }
            if (this.phantom.d.h < this.phantom.dM() && !this.phantom.an().w(new BlockPosition(this.phantom).c(1))) {
                this.verticalChange = Math.max(1.0f, this.verticalChange);
                this.updateOffset();
            }
            if (this.phantom.d.h > this.phantom.dM() && !this.phantom.an().w(new BlockPosition(this.phantom).b(1))) {
                this.verticalChange = Math.min(-1.0f, this.verticalChange);
                this.updateOffset();
            }
        }

        private void updateOffset() {
            this.offset += this.direction * 15.0f * ((float)Math.PI / 180);
            this.phantom.d = this.phantom.crystalPosition.b(this.radius * MathHelper.b(this.offset), -4.0f + this.verticalChange, this.radius * MathHelper.a(this.offset));
        }
    }

    class c
    extends PathfinderGoal {
        private int b;

        c() {
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityPhantom.this.e();
            return target != null && EntityPhantom.this.a(net.minecraft.world.entity.monster.EntityPhantom$c.a(EntityPhantom.this.an()), target, PathfinderTargetCondition.a);
        }

        @Override
        public void d() {
            this.b = this.a(10);
            EntityPhantom.this.f = AttackPhase.a;
            this.h();
        }

        @Override
        public void e() {
            if (EntityPhantom.this.e != null) {
                EntityPhantom.this.e = EntityPhantom.this.an().a(HeightMap.Type.e, EntityPhantom.this.e).b(10 + EntityPhantom.this.as.a(20));
            }
        }

        @Override
        public void a() {
            if (EntityPhantom.this.f == AttackPhase.a) {
                --this.b;
                if (this.b <= 0) {
                    EntityPhantom.this.f = AttackPhase.b;
                    this.h();
                    this.b = this.a((8 + EntityPhantom.this.as.a(4)) * 20);
                    EntityPhantom.this.a(SoundEffects.vs, 10.0f, 0.95f + EntityPhantom.this.as.i() * 0.1f);
                }
            }
        }

        private void h() {
            if (EntityPhantom.this.e != null) {
                EntityPhantom.this.e = EntityPhantom.this.e().dF().b(20 + EntityPhantom.this.as.a(20));
                if (EntityPhantom.this.e.v() < EntityPhantom.this.an().T()) {
                    EntityPhantom.this.e = new BlockPosition(EntityPhantom.this.e.u(), EntityPhantom.this.an().T() + 1, EntityPhantom.this.e.w());
                }
            }
        }
    }

    class i
    extends h {
        private static final int c = 20;
        private boolean d;
        private int e;

        i() {
        }

        @Override
        public boolean b() {
            return EntityPhantom.this.e() != null && EntityPhantom.this.f == AttackPhase.b;
        }

        @Override
        public boolean c() {
            EntityLiving target = EntityPhantom.this.e();
            if (target == null) {
                return false;
            }
            if (!target.bX()) {
                return false;
            }
            if (EntityPhantom.this.an().purpurConfig.phantomBurnInLight > 0 && EntityPhantom.this.an().i(new BlockPosition(EntityPhantom.this)) >= EntityPhantom.this.an().purpurConfig.phantomBurnInLight) {
                return false;
            }
            if (EntityPhantom.this.an().purpurConfig.phantomIgnorePlayersWithTorch && (TORCH.a(target.b(EnumHand.a)) || TORCH.a(target.b(EnumHand.b)))) {
                return false;
            }
            if (target instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)target;
                if (target.at() || player.gQ()) {
                    return false;
                }
            }
            if (!this.b()) {
                return false;
            }
            if (EntityPhantom.this.at > this.e) {
                this.e = EntityPhantom.this.at + 20;
                List<Entity> entitiesOfClass = EntityPhantom.this.an().a(EntityCat.class, EntityPhantom.this.de().g(16.0), IEntitySelector.a);
                for (EntityCat entityCat : entitiesOfClass) {
                    entityCat.gX();
                }
                this.d = !entitiesOfClass.isEmpty();
            }
            return !this.d;
        }

        @Override
        public void d() {
        }

        @Override
        public void e() {
            EntityPhantom.this.g((EntityLiving)null);
            EntityPhantom.this.f = AttackPhase.a;
        }

        @Override
        public void a() {
            EntityLiving target = EntityPhantom.this.e();
            if (target != null) {
                EntityPhantom.this.d = new Vec3D(target.dK(), target.f(0.5), target.dQ());
                if (EntityPhantom.this.de().g(0.2f).c(target.de())) {
                    EntityPhantom.this.c(i.a(EntityPhantom.this.an()), (Entity)target);
                    EntityPhantom.this.f = AttackPhase.a;
                    if (!EntityPhantom.this.bm()) {
                        EntityPhantom.this.an().c(1039, EntityPhantom.this.dF(), 0);
                    }
                } else if (EntityPhantom.this.ad || EntityPhantom.this.bt > 0) {
                    EntityPhantom.this.f = AttackPhase.a;
                }
            }
        }
    }

    class e
    extends h {
        private float c;
        private float d;
        private float e;
        private float f;

        e() {
        }

        @Override
        public boolean b() {
            return EntityPhantom.this.e() == null || EntityPhantom.this.f == AttackPhase.a;
        }

        @Override
        public void d() {
            this.d = 5.0f + EntityPhantom.this.as.i() * 10.0f;
            this.e = -4.0f + EntityPhantom.this.as.i() * 9.0f;
            this.f = EntityPhantom.this.as.h() ? 1.0f : -1.0f;
            this.i();
        }

        @Override
        public void a() {
            if (EntityPhantom.this.as.a(this.a(350)) == 0) {
                this.e = -4.0f + EntityPhantom.this.as.i() * 9.0f;
            }
            if (EntityPhantom.this.as.a(this.a(250)) == 0) {
                this.d += 1.0f;
                if (this.d > 15.0f) {
                    this.d = 5.0f;
                    this.f = -this.f;
                }
            }
            if (EntityPhantom.this.as.a(this.a(450)) == 0) {
                this.c = EntityPhantom.this.as.i() * 2.0f * (float)Math.PI;
                this.i();
            }
            if (this.h()) {
                this.i();
            }
            if (EntityPhantom.this.d.h < EntityPhantom.this.dM() && !EntityPhantom.this.an().w(EntityPhantom.this.dF().c(1))) {
                this.e = Math.max(1.0f, this.e);
                this.i();
            }
            if (EntityPhantom.this.d.h > EntityPhantom.this.dM() && !EntityPhantom.this.an().w(EntityPhantom.this.dF().b(1))) {
                this.e = Math.min(-1.0f, this.e);
                this.i();
            }
        }

        private void i() {
            if (EntityPhantom.this.e == null) {
                EntityPhantom.this.e = EntityPhantom.this.dF();
            }
            this.c += this.f * 15.0f * ((float)Math.PI / 180);
            EntityPhantom.this.d = Vec3D.a(EntityPhantom.this.e).b(this.d * MathHelper.b(this.c), -4.0f + this.e, this.d * MathHelper.a(this.c));
        }
    }

    class b
    extends PathfinderGoal {
        private final PathfinderTargetCondition b = PathfinderTargetCondition.a().a(64.0);
        private int c = net.minecraft.world.entity.monster.EntityPhantom$b.b(20);

        b() {
        }

        @Override
        public boolean b() {
            if (this.c > 0) {
                --this.c;
                return false;
            }
            this.c = net.minecraft.world.entity.monster.EntityPhantom$b.b(60);
            WorldServer serverLevel = net.minecraft.world.entity.monster.EntityPhantom$b.a(EntityPhantom.this.an());
            List<EntityHuman> nearbyPlayers = serverLevel.a(this.b, EntityPhantom.this, EntityPhantom.this.de().c(16.0, 64.0, 16.0));
            if (EntityPhantom.this.an().purpurConfig.phantomIgnorePlayersWithTorch) {
                nearbyPlayers.removeIf(human -> TORCH.a(human.b(EnumHand.a)) || TORCH.a(human.b(EnumHand.b)));
            }
            if (!nearbyPlayers.isEmpty()) {
                nearbyPlayers.sort(Comparator.comparing(Entity::dM).reversed());
                for (EntityHuman player : nearbyPlayers) {
                    if (!EntityPhantom.this.a(serverLevel, (EntityLiving)player, PathfinderTargetCondition.a) || EntityPhantom.this.an().paperConfig().entities.behavior.phantomsOnlyAttackInsomniacs && !IEntitySelector.IS_INSOMNIAC.test(player)) continue;
                    EntityPhantom.this.setTarget(player, EntityTargetEvent.TargetReason.CLOSEST_PLAYER);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving target = EntityPhantom.this.e();
            return target != null && EntityPhantom.this.a(net.minecraft.world.entity.monster.EntityPhantom$b.a(EntityPhantom.this.an()), target, PathfinderTargetCondition.a);
        }
    }

    abstract class h
    extends PathfinderGoal {
        public h() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        protected boolean h() {
            return EntityPhantom.this.d.c(EntityPhantom.this.dK(), EntityPhantom.this.dM(), EntityPhantom.this.dQ()) < 4.0;
        }
    }
}

