/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.entity.PigZombie;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PigZombieAngerEvent;

public class EntityPigZombie
extends EntityZombie
implements IEntityAngerable {
    private static final EntitySize f = EntityTypes.bW.n().a(0.5f).b(0.97f);
    private static final MinecraftKey ct = MinecraftKey.b("attacking");
    private static final AttributeModifier cu = new AttributeModifier(ct, 0.05, AttributeModifier.Operation.a);
    private static final UniformInt cv = TimeRange.a(0, 1);
    private int cw;
    private static final UniformInt cx = TimeRange.a(20, 39);
    private int cy;
    @Nullable
    private UUID cz;
    private static final int cA = 10;
    private static final UniformInt cB = TimeRange.a(4, 6);
    private int cC;
    private PathfinderGoalHurtByTarget hurtByTargetGoal;

    public EntityPigZombie(EntityTypes<? extends EntityPigZombie> type, World level) {
        super((EntityTypes<? extends EntityZombie>)type, level);
        this.a(PathType.i, 8.0f);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.zombifiedPiglinRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.zombifiedPiglinRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.zombifiedPiglinControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.zombifiedPiglinMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.zombifiedPiglinScale);
    }

    @Override
    public boolean jockeyOnlyBaby() {
        return this.an().purpurConfig.zombifiedPiglinJockeyOnlyBaby;
    }

    @Override
    public double jockeyChance() {
        return this.an().purpurConfig.zombifiedPiglinJockeyChance;
    }

    @Override
    public boolean jockeyTryExistingChickens() {
        return this.an().purpurConfig.zombifiedPiglinJockeyTryExistingChickens;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.zombifiedPiglinTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.zombifiedPiglinAlwaysDropExp;
    }

    @Override
    public void a(@Nullable UUID target) {
        this.cz = target;
    }

    @Override
    protected void m() {
        this.cq.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.cq.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.hurtByTargetGoal = new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]);
        this.cr.a(1, this.hurtByTargetGoal);
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.cr.a(3, new PathfinderGoalUniversalAngerReset<EntityPigZombie>(this, true));
    }

    public static AttributeProvider.Builder gQ() {
        return EntityZombie.gK().a(GenericAttributes.B, 0.0).a(GenericAttributes.w, 0.23f).a(GenericAttributes.c, 5.0);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? f : super.b(pose);
    }

    @Override
    protected boolean gI() {
        return false;
    }

    @Override
    protected void a(WorldServer level) {
        AttributeModifiable attribute = this.h(GenericAttributes.w);
        if (this.ae_()) {
            if (!this.g_() && !attribute.b(ct)) {
                attribute.b(cu);
            }
            this.gR();
        } else if (attribute.b(ct)) {
            attribute.c(ct);
        }
        this.a(level, true);
        if (this.e() != null) {
            this.gS();
        }
        if (this.ae_() && this.an().purpurConfig.zombifiedPiglinCountAsPlayerKillWhenAngry) {
            this.bH = this.at;
        }
        super.a(level);
    }

    private void gR() {
        if (this.cw > 0) {
            --this.cw;
            if (this.cw == 0) {
                this.gU();
            }
        }
    }

    private void gS() {
        if (this.cC > 0) {
            --this.cC;
        } else {
            if (this.T().a(this.e())) {
                this.gT();
            }
            this.cC = cB.a(this.as);
        }
    }

    private void gT() {
        double attributeValue = this.i(GenericAttributes.n);
        AxisAlignedBB aabb = AxisAlignedBB.a(this.dD()).c(attributeValue, 10.0, attributeValue);
        this.an().a(EntityPigZombie.class, aabb, IEntitySelector.f).stream().filter(zombifiedPiglin -> zombifiedPiglin != this).filter(zombifiedPiglin -> zombifiedPiglin.e() == null).filter(zombifiedPiglin -> !zombifiedPiglin.t(this.e())).forEach(zombifiedPiglin -> zombifiedPiglin.setTarget(this.e(), EntityTargetEvent.TargetReason.TARGET_ATTACKED_NEARBY_ENTITY));
    }

    private void gU() {
        this.a(SoundEffects.FU, this.ft() * 2.0f, this.fu() * 1.8f);
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving target, @Nullable EntityTargetEvent.TargetReason reason) {
        if (this.e() == null && target != null) {
            this.cw = cv.a(this.as);
            this.cC = cB.a(this.as);
        }
        if (target instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)target;
            if (this.an().purpurConfig.zombifiedPiglinCountAsPlayerKillWhenAngry) {
                this.a(player, this.at);
            }
        }
        return super.setTarget(target, reason);
    }

    @Override
    public void c() {
        Entity entity = this.an().d(this.b());
        PigZombieAngerEvent event = new PigZombieAngerEvent((PigZombie)this.getBukkitEntity(), (org.bukkit.entity.Entity)(entity == null ? null : entity.getBukkitEntity()), cx.a(this.as));
        if (!event.callEvent()) {
            this.a((UUID)null);
            this.hurtByTargetGoal.e();
            return;
        }
        this.a(event.getNewAnger());
    }

    public static boolean b(EntityTypes<EntityPigZombie> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (EntityPigZombie.canSpawnInBlueAndPackedIce(level, pos)) {
            return false;
        }
        return level.aq() != EnumDifficulty.a && !level.a_(pos.e()).a(Blocks.lG);
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this) && !level.d(this.de());
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        this.a_(output);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(this.an(), input);
    }

    @Override
    public void a(int time) {
        this.cy = time;
    }

    @Override
    public int a() {
        return this.cy;
    }

    @Override
    public SoundEffect p() {
        return this.ae_() ? SoundEffects.FU : SoundEffects.FT;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.FW;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.FV;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.qC));
    }

    @Override
    protected void gP() {
        this.h(GenericAttributes.B).a(this.as.j() * this.an().purpurConfig.zombifiedPiglinSpawnReinforcements);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cz;
    }

    @Override
    public boolean a(WorldServer level, EntityHuman player) {
        return this.a((EntityLiving)player, level);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return this.g(stack);
    }
}

