/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCrossbowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityPillager
extends EntityIllagerAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityPillager.class, DataWatcherRegistry.k);
    private static final int b = 5;
    private static final int e = 300;
    public final InventorySubcontainer ct = new InventorySubcontainer(5);

    public EntityPillager(EntityTypes<? extends EntityPillager> type, World level) {
        super((EntityTypes<? extends EntityIllagerAbstract>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.pillagerRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.pillagerRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.pillagerControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.pillagerMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.pillagerScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.pillagerTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.pillagerAlwaysDropExp;
    }

    @Override
    protected void H() {
        super.H();
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new PathfinderGoalAvoidTarget<Creaking>(this, Creaking.class, 8.0f, 1.0, 1.2));
        this.cq.a(2, new EntityRaider.a(this, 10.0f));
        this.cq.a(3, new PathfinderGoalCrossbowAttack<EntityPillager>(this, 1.0, 8.0f));
        this.cq.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.cq.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 15.0f, 1.0f));
        this.cq.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 15.0f));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gN().a(GenericAttributes.w, 0.35f).a(GenericAttributes.t, 24.0).a(GenericAttributes.c, 5.0).a(GenericAttributes.n, 32.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
    }

    @Override
    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return projectileWeapon == Items.yi;
    }

    public boolean s() {
        return this.az.a(a);
    }

    @Override
    public void b(boolean isCharging) {
        this.az.a(a, isCharging);
    }

    @Override
    public void a() {
        this.bJ = 0;
    }

    @Override
    public TagKey<Item> ac() {
        return TagsItem.ck;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        this.b_(output);
    }

    @Override
    public EntityIllagerAbstract.a k() {
        if (this.s()) {
            return EntityIllagerAbstract.a.f;
        }
        if (this.b(Items.yi)) {
            return EntityIllagerAbstract.a.e;
        }
        return this.gz() ? EntityIllagerAbstract.a.b : EntityIllagerAbstract.a.h;
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a_(input);
        this.a_(true);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    public int ak() {
        return 1;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.I_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.yi));
    }

    @Override
    protected void b(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        ItemStack mainHandItem;
        super.b(level, random, difficulty);
        if (random.a(300) == 0 && (mainHandItem = this.fq()).a(Items.yi)) {
            EnchantmentManager.a(mainHandItem, level.L_(), VanillaEnchantmentProviders.b, difficulty, random);
        }
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.vO;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.vQ;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vR;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.b(this, 1.6f);
    }

    @Override
    public InventorySubcontainer n() {
        return this.ct;
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.e();
        if (item.h() instanceof ItemBanner) {
            super.a(level, entity);
        } else if (this.i(item)) {
            this.a(entity);
            ItemStack itemStack = this.ct.b(item);
            if (itemStack.f()) {
                entity.discard(EntityRemoveEvent.Cause.PICKUP);
            } else {
                item.e(itemStack.M());
            }
        }
    }

    private boolean i(ItemStack item) {
        return this.gY() && item.a(Items.wZ);
    }

    @Override
    public SlotAccess a_(int slot) {
        int i2 = slot - 300;
        return i2 >= 0 && i2 < this.ct.b() ? SlotAccess.a(this.ct, i2) : super.a_(slot);
    }

    @Override
    public void a(WorldServer level, int wave, boolean flag) {
        boolean flag1;
        Raid currentRaid = this.gV();
        boolean bl = flag1 = this.as.i() <= currentRaid.s();
        if (flag1) {
            ItemStack itemStack = new ItemStack(Items.yi);
            ResourceKey<EnchantmentProvider> resourceKey = wave > currentRaid.a(EnumDifficulty.c) ? VanillaEnchantmentProviders.d : (wave > currentRaid.a(EnumDifficulty.b) ? VanillaEnchantmentProviders.c : null);
            if (resourceKey != null) {
                EnchantmentManager.a(itemStack, level.L_(), resourceKey, level.d_(this.dF()), this.ek());
                this.a(EnumItemSlot.a, itemStack);
            }
        }
    }

    @Override
    public SoundEffect ah_() {
        return SoundEffects.vP;
    }
}

