/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> e = entity -> !(entity instanceof EntityRavager) && entity.bX();
    private static final Predicate<Entity> f = entity -> e.test((Entity)entity) && !entity.ax().equals(EntityTypes.h);
    private static final Predicate<EntityLiving> ct = livingEntity -> !(livingEntity instanceof EntityRavager) && livingEntity.bX() && livingEntity.dq();
    private static final double cu = 0.3;
    private static final double cv = 0.35;
    private static final int cw = 8356754;
    private static final float cx = 0.57254905f;
    private static final float cy = 0.5137255f;
    private static final float cz = 0.49803922f;
    public static final int a = 10;
    public static final int b = 40;
    private static final int cA = 0;
    private static final int cB = 0;
    private static final int cC = 0;
    public int cD = 0;
    public int cE = 0;
    public int cF = 0;

    public EntityRavager(EntityTypes<? extends EntityRavager> type, World level) {
        super((EntityTypes<? extends EntityRaider>)type, level);
        this.cl = 20;
        this.a(PathType.v, 0.0f);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.ravagerRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.ravagerRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.ravagerControllable;
    }

    @Override
    public void onMount(EntityHuman rider) {
        super.onMount(rider);
        this.S().n();
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.ravagerMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.ravagerScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.ravagerTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.ravagerAlwaysDropExp;
    }

    @Override
    protected void H() {
        super.H();
        this.cq.a(0, new PathfinderGoalFloat(this));
        if (this.an().purpurConfig.ravagerAvoidRabbits) {
            this.cq.a(3, new PathfinderGoalAvoidTarget<EntityRabbit>(this, EntityRabbit.class, 6.0f, 1.0, 1.2));
        }
        this.cq.a(0, new HasRider(this));
        this.cq.a(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.cq.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.cq.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cq.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.cr.a(0, new HasRider(this));
        this.cr.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.cr.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, (entity, level) -> !entity.g_()));
        this.cr.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void Z() {
        boolean flag = !(this.dg() instanceof EntityInsentient) || this.dg().ax().a(TagsEntity.c);
        boolean flag1 = !(this.du() instanceof AbstractBoat);
        this.cq.a(PathfinderGoal.Type.a, flag);
        this.cq.a(PathfinderGoal.Type.c, flag && flag1);
        this.cq.a(PathfinderGoal.Type.b, flag);
        this.cq.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 100.0).a(GenericAttributes.w, 0.3).a(GenericAttributes.q, 0.75).a(GenericAttributes.c, 12.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.n, 32.0).a(GenericAttributes.C, 1.0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("AttackTick", this.cD);
        output.a("StunTick", this.cE);
        output.a("RoarTick", this.cF);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cD = input.a("AttackTick", 0);
        this.cE = input.a("StunTick", 0);
        this.cF = input.a("RoarTick", 0);
    }

    @Override
    public SoundEffect ah_() {
        return SoundEffects.wX;
    }

    @Override
    public int ah() {
        return 45;
    }

    @Override
    public void e_() {
        super.e_();
        if (this.bX() && (this.getRider() == null || !this.isControllable())) {
            if (this.fv()) {
                this.h(GenericAttributes.w).a(0.0);
            } else {
                double d2 = this.e() != null ? 0.35 : 0.3;
                double baseValue = this.h(GenericAttributes.w).b();
                this.h(GenericAttributes.w).a(MathHelper.d(0.1, baseValue, d2));
            }
            World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.ad && serverLevel.S().getBoolean(GameRules.d, serverLevel.purpurConfig.ravagerMobGriefingOverride)) {
                    boolean flag = false;
                    AxisAlignedBB aabb = this.de().g(0.2);
                    for (BlockPosition blockPos : BlockPosition.b(MathHelper.a(aabb.a), MathHelper.a(aabb.b), MathHelper.a(aabb.c), MathHelper.a(aabb.d), MathHelper.a(aabb.e), MathHelper.a(aabb.f))) {
                        IBlockData blockState = serverLevel.a_(blockPos);
                        Block block = blockState.b();
                        if (!this.an().purpurConfig.ravagerGriefableBlocks.contains(block) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, blockState.y().g())) continue;
                        flag = serverLevel.a(blockPos, true, this) || flag;
                    }
                    if (!flag && this.aS()) {
                        if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.u();
                        } else {
                            this.t(false);
                        }
                    }
                }
            }
            if (this.cF > 0) {
                --this.cF;
                if (this.cF == 10) {
                    this.gT();
                }
            }
            if (this.cD > 0) {
                --this.cD;
            }
            if (this.cE > 0) {
                --this.cE;
                this.gS();
                if (this.cE == 0) {
                    this.a(SoundEffects.xc, 1.0f, 1.0f);
                    this.cF = 20;
                }
            }
        }
    }

    private void gS() {
        if (this.as.a(6) == 0) {
            double d2 = this.dK() - (double)this.dA() * Math.sin(this.bB * ((float)Math.PI / 180)) + (this.as.j() * 0.6 - 0.3);
            double d1 = this.dM() + (double)this.dB() - 0.3;
            double d22 = this.dQ() + (double)this.dA() * Math.cos(this.bB * ((float)Math.PI / 180)) + (this.as.j() * 0.6 - 0.3);
            this.an().a(ColorParticleOption.a(Particles.v, 0.49803922f, 0.5137255f, 0.57254905f), d2, d1, d22, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean fv() {
        return super.fv() || this.cD > 0 || this.cE > 0 || this.cF > 0;
    }

    @Override
    public boolean F(Entity entity) {
        return this.cE <= 0 && this.cF <= 0 && super.F(entity);
    }

    @Override
    protected void d(EntityLiving entity) {
        if (this.cF == 0) {
            if (this.as.j() < 0.5) {
                this.cE = 40;
                this.a(SoundEffects.xb, 1.0f, 1.0f);
                this.an().a((Entity)this, (byte)39);
                entity.h(this);
            } else {
                this.G(entity);
            }
            entity.ah = true;
        }
    }

    private void gT() {
        World world;
        if (this.bX() && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Predicate<Entity> predicate = serverLevel.S().c(GameRules.d) ? e : f;
            for (EntityLiving entityLiving : this.an().a(EntityLiving.class, this.de().g(4.0), predicate)) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.a(serverLevel, this.ei().b(this), 6.0f);
                }
                if (entityLiving instanceof EntityHuman) continue;
                this.G(entityLiving);
            }
            this.c(GameEvent.u);
            serverLevel.a((Entity)this, (byte)69);
        }
    }

    private void hc() {
        for (EntityLiving livingEntity : this.an().a(EntityLiving.class, this.de().g(4.0), ct)) {
            this.G(livingEntity);
        }
    }

    private void G(Entity entity) {
        double d2 = entity.dK() - this.dK();
        double d1 = entity.dQ() - this.dQ();
        double max = Math.max(d2 * d2 + d1 * d1, 0.001);
        entity.push(d2 / max * 4.0, 0.2, d1 / max * 4.0, this);
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.cD = 10;
            this.a(SoundEffects.wW, 1.0f, 1.0f);
        } else if (id == 39) {
            this.cE = 40;
        } else if (id == 69) {
            this.hd();
            this.hc();
        }
        super.b(id);
    }

    private void hd() {
        Vec3D center = this.de().f();
        for (int i2 = 0; i2 < 40; ++i2) {
            double d2 = this.as.k() * 0.2;
            double d1 = this.as.k() * 0.2;
            double d22 = this.as.k() * 0.2;
            this.an().a(Particles.af, center.g, center.h, center.i, d2, d1, d22);
        }
    }

    public int m() {
        return this.cD;
    }

    public int s() {
        return this.cE;
    }

    public int gR() {
        return this.cF;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        this.cD = 10;
        level.a((Entity)this, (byte)4);
        this.a(SoundEffects.wW, 1.0f, 1.0f);
        return super.c(level, target);
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return SoundEffects.wV;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.wZ;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.wY;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.xa, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader level) {
        return !level.d(this.de());
    }

    @Override
    public void a(WorldServer level, int wave, boolean flag) {
    }

    @Override
    public boolean gI() {
        return false;
    }

    @Override
    protected AxisAlignedBB gA() {
        AxisAlignedBB aabb = super.gA();
        return aabb.f(0.05, 0.0, 0.05);
    }
}

