/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import io.papermc.paper.event.entity.ShulkerDuplicateEvent;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Shulker;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityShulker
extends EntityGolem
implements IMonster {
    private static final MinecraftKey d = MinecraftKey.b("covered");
    private static final AttributeModifier e = new AttributeModifier(d, 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> a = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.q);
    protected static final DataWatcherObject<Byte> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int f = 6;
    private static final byte ct = 16;
    private static final byte cu = 16;
    private static final int cv = 8;
    private static final int cw = 8;
    private static final int cx = 5;
    private static final float cy = 0.05f;
    private static final byte cz = 0;
    private static final EnumDirection cA = EnumDirection.a;
    static final Vector3f cB = SystemUtils.a(() -> {
        BaseBlockPosition unitVec3i = EnumDirection.d.q();
        return new Vector3f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w());
    });
    public static final float cC = 3.0f;
    private float cD;
    private float cE;
    @Nullable
    private BlockPosition cF;
    private int cG;
    private static final float cH = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> type, World level) {
        super((EntityTypes<? extends EntityGolem>)type, level);
        this.cl = 5;
        this.cm = new d(this);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemDye dye;
        Item item;
        ItemStack itemstack = player.b(hand);
        if (player.an().purpurConfig.shulkerChangeColorWithDye && (item = itemstack.h()) instanceof ItemDye && (dye = (ItemDye)item).a() != this.gI()) {
            this.a(Optional.of(dye.a()));
            if (!player.gC().d) {
                itemstack.h(1);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.shulkerRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.shulkerRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.shulkerControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.shulkerMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.shulkerScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.shulkerTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.shulkerAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.cq.a(4, new a());
        this.cq.a(7, new f());
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.cr.a(2, new e(this));
        this.cr.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.yQ;
    }

    @Override
    public void X() {
        if (!this.gM()) {
            super.X();
        }
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.yW;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.gM() ? SoundEffects.yY : SoundEffects.yX;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, cA);
        builder.a(b, (byte)0);
        builder.a(c, (byte)16);
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.I().a(GenericAttributes.t, 30.0);
    }

    @Override
    protected EntityAIBodyControl N() {
        return new b(this);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("AttachFace", EnumDirection.k).orElse(cA));
        this.az.a(b, input.a("Peek", (byte)0));
        this.az.a(c, input.a("Color", (byte)16));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("AttachFace", EnumDirection.k, this.n());
        output.a("Peek", this.az.a(b));
        output.a("Color", this.az.a(c));
    }

    @Override
    public void g() {
        super.g();
        if (!(this.an().D_() || this.cl() || this.a(this.dF(), this.n()))) {
            this.gJ();
        }
        if (this.gK()) {
            this.gL();
        }
        if (this.an().D_()) {
            if (this.cG > 0) {
                --this.cG;
            } else {
                this.cF = null;
            }
        }
    }

    private void gJ() {
        EnumDirection direction = this.h(this.dF());
        if (direction != null) {
            this.a(direction);
        } else {
            this.m();
        }
    }

    @Override
    protected AxisAlignedBB c(Vec3D position) {
        float physicalPeek = EntityShulker.L(this.cE);
        EnumDirection opposite = this.n().g();
        return EntityShulker.a(this.eA(), opposite, physicalPeek, position);
    }

    private static float L(float peek) {
        return 0.5f - MathHelper.a((0.5f + peek) * (float)Math.PI) * 0.5f;
    }

    private boolean gK() {
        this.cD = this.cE;
        float f2 = (float)this.gO() * 0.01f;
        if (this.cE == f2) {
            return false;
        }
        this.cE = this.cE > f2 ? MathHelper.a(this.cE - 0.05f, f2, 1.0f) : MathHelper.a(this.cE + 0.05f, 0.0f, f2);
        return true;
    }

    private void gL() {
        this.aG();
        float physicalPeek = EntityShulker.L(this.cE);
        float physicalPeek1 = EntityShulker.L(this.cD);
        EnumDirection opposite = this.n().g();
        float f2 = (physicalPeek - physicalPeek1) * this.eA();
        if (!(f2 <= 0.0f)) {
            for (Entity entity : this.an().a((Entity)this, EntityShulker.a(this.eA(), opposite, physicalPeek1, physicalPeek, this.dD()), IEntitySelector.f.and(entity1 -> !entity1.A(this)))) {
                if (entity instanceof EntityShulker || entity.ar) continue;
                entity.a(EnumMoveType.e, new Vec3D(f2 * (float)opposite.j(), f2 * (float)opposite.k(), f2 * (float)opposite.l()));
            }
        }
    }

    public static AxisAlignedBB a(float scale, EnumDirection expansionDirection, float peek, Vec3D position) {
        return EntityShulker.a(scale, expansionDirection, -1.0f, peek, position);
    }

    public static AxisAlignedBB a(float scale, EnumDirection expansionDirection, float currentPeek, float oldPeek, Vec3D position) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(-scale) * 0.5, 0.0, (double)(-scale) * 0.5, (double)scale * 0.5, scale, (double)scale * 0.5);
        double d2 = Math.max(currentPeek, oldPeek);
        double d1 = Math.min(currentPeek, oldPeek);
        AxisAlignedBB aabb1 = aabb.b((double)expansionDirection.j() * d2 * (double)scale, (double)expansionDirection.k() * d2 * (double)scale, (double)expansionDirection.l() * d2 * (double)scale).a((double)(-expansionDirection.j()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.k()) * (1.0 + d1) * (double)scale, (double)(-expansionDirection.l()) * (1.0 + d1) * (double)scale);
        return aabb1.d(position.g, position.h, position.i);
    }

    @Override
    public boolean a(Entity entity, boolean force, boolean triggerEvents) {
        if (this.an().D_()) {
            this.cF = null;
            this.cG = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, force, triggerEvents);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        if (this.an().D_()) {
            this.cF = this.dF();
        }
        this.bC = 0.0f;
        this.bB = 0.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.v(0.0f);
        this.bD = this.dX();
        this.bL();
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (type == EnumMoveType.d) {
            this.m();
        } else {
            super.a(type, movement);
        }
    }

    @Override
    public Vec3D dI() {
        return Vec3D.c;
    }

    @Override
    public void k(Vec3D deltaMovement) {
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        BlockPosition blockPos1;
        BlockPosition blockPos = this.dF();
        if (this.cl()) {
            super.a_(x2, y2, z2);
        } else {
            super.a_((double)MathHelper.a(x2) + 0.5, MathHelper.a(y2 + 0.5), (double)MathHelper.a(z2) + 0.5);
        }
        if (this.at != 0 && !(blockPos1 = this.dF()).equals(blockPos)) {
            this.az.a(b, (byte)0);
            this.aF = true;
            if (this.an().D_() && !this.cl() && !blockPos1.equals(this.cF)) {
                this.cF = blockPos;
                this.cG = 6;
                this.ao = this.dK();
                this.ap = this.dM();
                this.aq = this.dQ();
            }
        }
    }

    @Nullable
    protected EnumDirection h(BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.values()) {
            if (!this.a(pos, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean a(BlockPosition pos, EnumDirection facing) {
        if (this.i(pos)) {
            return false;
        }
        EnumDirection opposite = facing.g();
        if (!this.an().a(pos.a(facing), this, opposite)) {
            return false;
        }
        AxisAlignedBB aabb = EntityShulker.a(this.eA(), opposite, 1.0f, pos.c()).h(1.0E-6);
        return this.an().a((Entity)this, aabb);
    }

    private boolean i(BlockPosition pos) {
        IBlockData blockState = this.an().a_(pos);
        if (blockState.l()) {
            return false;
        }
        boolean flag = blockState.a(Blocks.ca) && pos.equals(this.dF());
        return !flag;
    }

    protected boolean m() {
        if (!this.gx() && this.bX()) {
            BlockPosition blockPos = this.dF();
            for (int i2 = 0; i2 < 5; ++i2) {
                BlockPosition blockPos1 = blockPos.b(MathHelper.b(this.as, -8, 8), MathHelper.b(this.as, -8, 8), MathHelper.b(this.as, -8, 8));
                if (blockPos1.v() <= this.an().M_() || !this.an().w(blockPos1) || !this.an().u().a(blockPos1) || !this.an().a((Entity)this, new AxisAlignedBB(blockPos1).h(1.0E-6))) continue;
                EnumDirection direction = this.h(blockPos1);
                EntityTeleportEvent teleportEvent = CraftEventFactory.callEntityTeleportEvent(this, blockPos1.u(), blockPos1.v(), blockPos1.w());
                if (teleportEvent.isCancelled() || teleportEvent.getTo() == null) {
                    return false;
                }
                blockPos1 = CraftLocation.toBlockPosition(teleportEvent.getTo());
                if (direction == null) continue;
                this.av();
                this.a(direction);
                this.a(SoundEffects.zb, 1.0f, 1.0f);
                this.a_((double)blockPos1.u() + 0.5, blockPos1.v(), (double)blockPos1.w() + 0.5);
                this.an().a(GameEvent.R, blockPos, GameEvent.a.a(this));
                this.az.a(b, (byte)0);
                this.g((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public InterpolationHandler n_() {
        return null;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity directEntity;
        if (this.gM() && (directEntity = damageSource.c()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        if ((double)this.eU() < (double)this.fj() * 0.5 && this.as.a(4) == 0) {
            this.m();
        } else if (damageSource.a(DamageTypeTags.j) && (directEntity = damageSource.c()) != null && directEntity.ax() == EntityTypes.bi) {
            this.gN();
        }
        return true;
    }

    private boolean gM() {
        return this.gO() == 0;
    }

    private void gN() {
        Vec3D vec3 = this.dD();
        AxisAlignedBB boundingBox = this.de();
        if (!(this.an().purpurConfig.shulkerSpawnFromBulletRequireOpenLid && this.gM() || !this.m())) {
            EntityShulker shulker;
            float chance = this.an().purpurConfig.shulkerSpawnFromBulletBaseChance;
            if (!this.an().purpurConfig.shulkerSpawnFromBulletNearbyEquation.isBlank()) {
                int nearby = this.an().a(EntityTypes.bh, boundingBox.g(this.an().purpurConfig.shulkerSpawnFromBulletNearbyRange), Entity::bX).size();
                try {
                    chance -= ((Number)Entity.scriptEngine.eval("let nearby = " + nearby + "; " + this.an().purpurConfig.shulkerSpawnFromBulletNearbyEquation)).floatValue();
                }
                catch (ScriptException e2) {
                    e2.printStackTrace();
                    chance -= (float)(nearby - 1) / 5.0f;
                }
            }
            if (this.an().z.i() <= chance && (shulker = EntityTypes.bh.a(this.an(), EntitySpawnReason.e)) != null) {
                shulker.a(this.s());
                shulker.f(vec3);
                if (!new ShulkerDuplicateEvent((Shulker)shulker.getBukkitEntity(), (Shulker)this.getBukkitEntity()).callEvent()) {
                    return;
                }
                this.an().addFreshEntity(shulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean j(@Nullable Entity entity) {
        return this.bX();
    }

    public EnumDirection n() {
        return this.az.a(a);
    }

    public void a(EnumDirection attachFace) {
        this.az.a(a, attachFace);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (a.equals(key)) {
            this.a(this.aF());
        }
        super.a(key);
    }

    public int gO() {
        return this.az.a(b).byteValue();
    }

    public void b(int peekAmount) {
        if (!this.an().D_()) {
            this.h(GenericAttributes.a).c(d);
            if (peekAmount == 0) {
                this.h(GenericAttributes.a).d(e);
                this.a(SoundEffects.yV, 1.0f, 1.0f);
                this.c(GameEvent.j);
            } else {
                this.a(SoundEffects.yZ, 1.0f, 1.0f);
                this.c(GameEvent.k);
            }
        }
        this.az.a(b, (byte)peekAmount);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cD, this.cE);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.bB = 0.0f;
        this.bC = 0.0f;
    }

    @Override
    public int af() {
        return 180;
    }

    @Override
    public int ah() {
        return 180;
    }

    @Override
    public void h(Entity entity) {
    }

    @Nullable
    public Vec3D K(float partialTick) {
        if (this.cF != null && this.cG > 0) {
            double d2 = (double)((float)this.cG - partialTick) / 6.0;
            d2 *= d2;
            BlockPosition blockPos = this.dF();
            double d1 = (double)(blockPos.u() - this.cF.u()) * (d2 *= (double)this.eA());
            double d22 = (double)(blockPos.v() - this.cF.v()) * d2;
            double d3 = (double)(blockPos.w() - this.cF.w()) * d2;
            return new Vec3D(-d1, -d22, -d3);
        }
        return null;
    }

    @Override
    protected float c(float scale) {
        return Math.min(scale, 3.0f);
    }

    private void a(Optional<EnumColor> variant) {
        this.az.a(c, variant.map(color -> (byte)color.a()).orElse((byte)16));
    }

    public Optional<EnumColor> s() {
        return Optional.ofNullable(this.an().purpurConfig.shulkerSpawnFromBulletRandomColor ? EnumColor.random(this.an().z) : this.gI());
    }

    @Nullable
    public EnumColor gI() {
        byte b2 = this.az.a(c);
        return b2 != 16 && b2 <= 15 ? EnumColor.a(b2) : null;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aS ? EntityShulker.c(component, this.gI()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aS);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aS) {
            this.a(Optional.of(EntityShulker.c(DataComponents.aS, value)));
            return true;
        }
        return super.b(component, value);
    }

    class d
    extends LookControllerWASD {
        public d(EntityInsentient mob) {
            super(mob);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection opposite = EntityShulker.this.n().g();
            Vector3f vector3f = opposite.b().transform(new Vector3f((Vector3fc)cB));
            BaseBlockPosition unitVec3i = opposite.q();
            Vector3f vector3f1 = new Vector3f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w());
            vector3f1.cross((Vector3fc)vector3f);
            double d2 = this.e - this.a.dK();
            double d1 = this.f - this.a.dO();
            double d22 = this.g - this.a.dQ();
            Vector3f vector3f2 = new Vector3f((float)d2, (float)d1, (float)d22);
            float f2 = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return !(Math.abs(f2) > 1.0E-5f) && !(Math.abs(f1) > 1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 180.0 / 3.1415927410125732)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityShulker.this.e();
            return target != null && target.bX() && EntityShulker.this.an().aq() != EnumDifficulty.a;
        }

        @Override
        public void d() {
            this.b = 20;
            EntityShulker.this.b(100);
        }

        @Override
        public void e() {
            EntityShulker.this.b(0);
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityShulker.this.an().aq() != EnumDifficulty.a) {
                --this.b;
                EntityLiving target = EntityShulker.this.e();
                if (target != null) {
                    EntityShulker.this.P().a(target, 180.0f, 180.0f);
                    double d2 = EntityShulker.this.g((Entity)target);
                    if (d2 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.as.a(10) * 20 / 2;
                            EntityShulker.this.an().b(new EntityShulkerBullet(EntityShulker.this.an(), EntityShulker.this, target, EntityShulker.this.n().o()));
                            EntityShulker.this.a(SoundEffects.za, 2.0f, (EntityShulker.this.as.i() - EntityShulker.this.as.i()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.g((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean b() {
            return EntityShulker.this.e() == null && EntityShulker.this.as.a(net.minecraft.world.entity.monster.EntityShulker$f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.dF(), EntityShulker.this.n());
        }

        @Override
        public boolean c() {
            return EntityShulker.this.e() == null && this.b > 0;
        }

        @Override
        public void d() {
            this.b = this.a(20 * (1 + EntityShulker.this.as.a(3)));
            EntityShulker.this.b(30);
        }

        @Override
        public void e() {
            if (EntityShulker.this.e() == null) {
                EntityShulker.this.b(0);
            }
        }

        @Override
        public void a() {
            --this.b;
        }
    }

    class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker shulker) {
            super((EntityInsentient)shulker, EntityHuman.class, true);
        }

        @Override
        public boolean b() {
            return EntityShulker.this.an().aq() != EnumDifficulty.a && super.b();
        }

        @Override
        protected AxisAlignedBB a(double targetDistance) {
            EnumDirection attachFace = ((EntityShulker)this.e).n();
            if (attachFace.o() == EnumDirection.EnumAxis.a) {
                return this.e.de().c(4.0, targetDistance, targetDistance);
            }
            return attachFace.o() == EnumDirection.EnumAxis.c ? this.e.de().c(targetDistance, targetDistance, 4.0) : this.e.de().c(targetDistance, 4.0, targetDistance);
        }
    }

    static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker shulker) {
            super(shulker, EntityLiving.class, 10, true, false, (entity, level) -> entity instanceof IMonster);
        }

        @Override
        public boolean b() {
            return this.e.cD() != null && super.b();
        }

        @Override
        protected AxisAlignedBB a(double targetDistance) {
            EnumDirection attachFace = ((EntityShulker)this.e).n();
            if (attachFace.o() == EnumDirection.EnumAxis.a) {
                return this.e.de().c(4.0, targetDistance, targetDistance);
            }
            return attachFace.o() == EnumDirection.EnumAxis.c ? this.e.de().c(targetDistance, targetDistance, 4.0) : this.e.de().c(targetDistance, 4.0, targetDistance);
        }
    }

    static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient mob) {
            super(mob);
        }

        @Override
        public void a() {
        }
    }
}

