/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntitySilverfish
extends EntityMonster {
    @Nullable
    private PathfinderGoalSilverfishWakeOthers a;

    public EntitySilverfish(EntityTypes<? extends EntitySilverfish> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.silverfishRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.silverfishRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.silverfishControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.silverfishMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.silverfishScale);
        this.h(GenericAttributes.w).a(this.an().purpurConfig.silverfishMovementSpeed);
        this.h(GenericAttributes.c).a(this.an().purpurConfig.silverfishAttackDamage);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.silverfishTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.silverfishAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.a = new PathfinderGoalSilverfishWakeOthers(this);
        this.cq.a(1, new PathfinderGoalFloat(this));
        this.cq.a(1, new HasRider(this));
        this.cq.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.an()));
        this.cq.a(3, this.a);
        this.cq.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cq.a(5, new PathfinderGoalSilverfishHideInBlock(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 8.0).a(GenericAttributes.w, 0.25).a(GenericAttributes.c, 1.0);
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.c;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.zc;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.ze;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.zd;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.zf, 0.15f, 1.0f);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.a(level, damageSource)) {
            return false;
        }
        if ((damageSource.d() != null || damageSource.a(DamageTypeTags.x)) && this.a != null) {
            this.a.h();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public void g() {
        this.bB = this.dX();
        super.g();
    }

    @Override
    public void s(float offset) {
        this.v(offset);
        super.s(offset);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return BlockMonsterEggs.p(level.a_(pos.e())) ? 10.0f : super.a(pos, level);
    }

    public static boolean b(EntityTypes<EntitySilverfish> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (!EntitySilverfish.c(entityType, level, spawnReason, pos, random)) {
            return false;
        }
        if (EntitySpawnReason.a(spawnReason)) {
            return true;
        }
        EntityHuman nearestPlayer = level.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, 5.0, true);
        return (nearestPlayer == null || nearestPlayer.affectsSpawning) && nearestPlayer == null;
    }

    static class PathfinderGoalSilverfishWakeOthers
    extends PathfinderGoal {
        private final EntitySilverfish a;
        private int b;

        public PathfinderGoalSilverfishWakeOthers(EntitySilverfish silverfish) {
            this.a = silverfish;
        }

        public void h() {
            if (this.b == 0) {
                this.b = this.a(20);
            }
        }

        @Override
        public boolean b() {
            return this.b > 0;
        }

        @Override
        public void a() {
            --this.b;
            if (this.b <= 0) {
                World level = this.a.an();
                RandomSource random = this.a.ek();
                BlockPosition blockPos = this.a.dF();
                int i2 = 0;
                while (i2 <= 5 && i2 >= -5) {
                    int i1 = 0;
                    while (i1 <= 10 && i1 >= -10) {
                        int i22 = 0;
                        while (i22 <= 10 && i22 >= -10) {
                            BlockPosition blockPos1 = blockPos.b(i1, i2, i22);
                            IBlockData blockState = level.a_(blockPos1);
                            Block block = blockState.b();
                            if (block instanceof BlockMonsterEggs) {
                                IBlockData afterState;
                                IBlockData iBlockData = afterState = PathfinderGoalSilverfishWakeOthers.a(level).S().getBoolean(GameRules.d, PathfinderGoalSilverfishWakeOthers.a((World)level).purpurConfig.silverfishMobGriefingOverride) ? blockState.y().g() : ((BlockMonsterEggs)block).r(level.a_(blockPos1));
                                if (CraftEventFactory.callEntityChangeBlockEvent(this.a, blockPos1, afterState)) {
                                    if (PathfinderGoalSilverfishWakeOthers.a(level).S().c(GameRules.d)) {
                                        level.a(blockPos1, true, this.a);
                                    } else {
                                        level.a(blockPos1, ((BlockMonsterEggs)block).r(level.a_(blockPos1)), 3);
                                    }
                                    if (random.h()) {
                                        return;
                                    }
                                }
                            }
                            i22 = (i22 <= 0 ? 1 : 0) - i22;
                        }
                        i1 = (i1 <= 0 ? 1 : 0) - i1;
                    }
                    i2 = (i2 <= 0 ? 1 : 0) - i2;
                }
            }
        }
    }

    static class PathfinderGoalSilverfishHideInBlock
    extends PathfinderGoalRandomStroll {
        @Nullable
        private EnumDirection i;
        private boolean j;

        public PathfinderGoalSilverfishHideInBlock(EntitySilverfish silverfish) {
            super(silverfish, 1.0, 10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (this.b.e() != null) {
                return false;
            }
            if (!this.b.S().l()) {
                return false;
            }
            RandomSource random = this.b.ek();
            if (PathfinderGoalSilverfishHideInBlock.a(this.b).S().getBoolean(GameRules.d, PathfinderGoalSilverfishHideInBlock.a((Entity)this.b).purpurConfig.silverfishMobGriefingOverride) && random.a(PathfinderGoalSilverfishHideInBlock.b(10)) == 0) {
                this.i = EnumDirection.b(random);
                BlockPosition blockPos = BlockPosition.a(this.b.dK(), this.b.dM() + 0.5, this.b.dQ()).a(this.i);
                IBlockData blockState = this.b.an().a_(blockPos);
                if (BlockMonsterEggs.p(blockState)) {
                    this.j = true;
                    return true;
                }
            }
            this.j = false;
            return super.b();
        }

        @Override
        public boolean c() {
            return !this.j && super.c();
        }

        @Override
        public void d() {
            if (!this.j) {
                super.d();
            } else {
                BlockPosition blockPos;
                World levelAccessor = this.b.an();
                IBlockData blockState = levelAccessor.a_(blockPos = BlockPosition.a(this.b.dK(), this.b.dM() + 0.5, this.b.dQ()).a(this.i));
                if (BlockMonsterEggs.p(blockState)) {
                    if (!CraftEventFactory.callEntityChangeBlockEvent(this.b, blockPos, BlockMonsterEggs.q(blockState))) {
                        return;
                    }
                    levelAccessor.a(blockPos, BlockMonsterEggs.q(blockState), 3);
                    this.b.Y();
                    this.b.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
                }
            }
        }
    }
}

