/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntitySkeleton
extends EntitySkeletonAbstract {
    private static final int b = 300;
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntitySkeleton.class, DataWatcherRegistry.k);
    public static final String a = "StrayConversionTime";
    private static final int d = -1;
    public int e;
    public int f;
    private int witherRosesFed = 0;

    public EntitySkeleton(EntityTypes<? extends EntitySkeleton> type, World level) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.skeletonRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.skeletonRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.skeletonControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.skeletonMaxHealth);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.skeletonTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.skeletonAlwaysDropExp;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, false);
    }

    public boolean gK() {
        return this.aC().a(c);
    }

    public void x(boolean isFrozen) {
        this.az.a(c, isFrozen);
    }

    @Override
    public boolean gJ() {
        return this.gK();
    }

    @Override
    public void g() {
        if (!this.an().D_() && this.bX() && !this.gx()) {
            if (this.aJ) {
                if (this.gK()) {
                    --this.f;
                    if (this.f < 0) {
                        this.gL();
                    }
                } else {
                    ++this.e;
                    if (this.e >= 140) {
                        this.b(300);
                    }
                }
            } else {
                this.e = -1;
                this.x(false);
            }
        }
        super.g();
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(a, this.gK() ? this.f : -1);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        int intOr = input.a(a, -1);
        if (intOr != -1) {
            this.b(intOr);
        } else {
            this.x(false);
        }
    }

    @VisibleForTesting
    public void b(int conversionTime) {
        this.f = conversionTime;
        this.x(true);
    }

    protected void gL() {
        EntitySkeletonStray stray = this.convertTo(EntityTypes.bx, ConversionParams.a(this, true, true), (T mob) -> {
            if (!this.bm()) {
                this.an().a(null, 1048, this.dF(), 0);
            }
        }, EntityTransformEvent.TransformReason.FROZEN, CreatureSpawnEvent.SpawnReason.FROZEN);
        if (stray == null) {
            this.f = 300;
        }
    }

    @Override
    public boolean dV() {
        return false;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.zg;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.zr;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.zi;
    }

    @Override
    SoundEffect m() {
        return SoundEffects.zt;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack stack = player.b(hand);
        if (this.an().purpurConfig.skeletonFeedWitherRoses > 0 && this.ax() != EntityTypes.bP && stack.h() == Blocks.cn.h()) {
            return this.feedWitherRose(player, stack);
        }
        return super.b(player, hand);
    }

    private EnumInteractionResult feedWitherRose(EntityHuman player, ItemStack stack) {
        if (++this.witherRosesFed < this.an().purpurConfig.skeletonFeedWitherRoses) {
            if (!player.gC().d) {
                stack.h(1);
            }
            return EnumInteractionResult.c;
        }
        EntitySkeletonWither skeleton = EntityTypes.bP.a(this.an(), EntitySpawnReason.i);
        if (skeleton == null) {
            return EnumInteractionResult.e;
        }
        skeleton.b(this.dK(), this.dM(), this.dQ(), this.dX(), this.dZ());
        skeleton.x(this.eU());
        skeleton.w(this.gz());
        skeleton.x(this);
        skeleton.s(this.bB);
        skeleton.r(this.cN());
        skeleton.ab = this.ab;
        skeleton.ac = this.ac;
        if (this.k_()) {
            skeleton.b(this.ar());
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, skeleton, EntityTransformEvent.TransformReason.INFECTION).isCancelled()) {
            return EnumInteractionResult.e;
        }
        this.an().b(skeleton);
        this.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DISCARD);
        if (!player.gC().d) {
            stack.h(1);
        }
        for (int i2 = 0; i2 < 15; ++i2) {
            ((WorldServer)this.an()).sendParticlesSource(((WorldServer)this.an()).C(), null, Particles.R, false, true, this.dK() + (double)this.as.i(), this.dM() + (double)(this.as.i() * 2.0f), this.dQ() + (double)this.as.i(), 1, this.as.k() * 0.05, this.as.k() * 0.05, this.as.k() * 0.05, 0.0);
        }
        return EnumInteractionResult.a;
    }
}

