/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private static final int a = 20;
    private static final int b = 40;
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> c = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack d = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void e() {
            super.e();
            EntitySkeletonAbstract.this.w(false);
        }

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.w(true);
        }
    };

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.n();
        this.setShouldBurnInDay(true);
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cq.a(2, new PathfinderGoalRestrictSun(this));
        this.cq.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.cq.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.cq.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(6, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.ct));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.w, 0.25);
    }

    @Override
    public boolean shouldBurnInDay() {
        return this.shouldBurnInDay;
    }

    @Override
    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.m(), 0.15f, 1.0f);
    }

    abstract SoundEffect m();

    @Override
    public void e_() {
        super.e_();
    }

    @Override
    public void t() {
        super.t();
        Entity entity = this.dv();
        if (entity instanceof EntityCreature) {
            EntityCreature pathfinderMob = (EntityCreature)entity;
            this.bB = pathfinderMob.bB;
        }
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(random, difficulty);
        this.a(EnumItemSlot.a, new ItemStack(Items.pW));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        RandomSource random = level.I_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        this.n();
        this.a_(this.an().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.skeletons || random.i() < 0.55f * difficulty.d());
        if (this.a(EnumItemSlot.f).f() && EntityBat.isHalloweenSeason(level.getMinecraftWorld()) && this.as.i() < this.an().purpurConfig.chanceHeadHalloweenOnEntity) {
            this.a(EnumItemSlot.f, new ItemStack(random.i() < 0.1f ? Blocks.eK : Blocks.eJ));
            this.a(EnumItemSlot.f, 0.0f);
        }
        return spawnGroupData;
    }

    public void n() {
        if (this.an() != null && !this.an().D_()) {
            this.cq.a(this.d);
            this.cq.a(this.c);
            ItemStack itemInHand = this.b(ProjectileHelper.a(this, Items.pW));
            if (itemInHand.a(Items.pW)) {
                int hardAttackInterval = this.s();
                if (this.an().aq() != EnumDifficulty.d) {
                    hardAttackInterval = this.gI();
                }
                this.c.c(hardAttackInterval);
                this.cq.a(4, this.c);
            } else {
                this.cq.a(4, this.d);
            }
        }
    }

    protected int s() {
        return 20;
    }

    protected int gI() {
        return 40;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        EnumHand hand = ProjectileHelper.a(this, Items.pW);
        ItemStack itemInHand = this.b(hand);
        ItemStack projectile = this.d(itemInHand);
        EntityArrow arrow = this.a(projectile, distanceFactor, itemInHand);
        double d2 = target.dK() - this.dK();
        double d1 = target.f(0.3333333333333333) - arrow.dM();
        double d22 = target.dQ() - this.dQ();
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            IProjectile.Delayed<EntityArrow> delayedEntity = IProjectile.spawnProjectileUsingShootDelayed(arrow, serverLevel, projectile, d2, d1 + squareRoot * (double)0.2f, d22, 1.6f, serverLevel.purpurConfig.skeletonBowAccuracyMap.getOrDefault(serverLevel.aq().a(), Float.valueOf(14 - serverLevel.aq().a() * 4)).floatValue());
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, itemInHand, arrow.m(), arrow, hand, distanceFactor, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == arrow.getBukkitEntity()) {
                delayedEntity.spawn();
            }
        }
        this.a(SoundEffects.zs, 1.0f, 1.0f / (this.ek().i() * 0.4f + 0.8f));
    }

    protected EntityArrow a(ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        return ProjectileHelper.a(this, arrow, velocity, weapon);
    }

    @Override
    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return projectileWeapon == Items.pW;
    }

    @Override
    public TagKey<Item> ac() {
        return TagsItem.ch;
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.n();
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
    }

    @Override
    public void onEquipItem(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem, boolean silent) {
        super.onEquipItem(slot, oldItem, newItem, silent);
        if (!this.an().D_()) {
            this.n();
        }
    }

    public boolean gJ() {
        return this.cJ();
    }
}

