/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> cs = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int a = 1;
    public static final int b = 127;
    public static final int c = 4;
    private static final boolean ct = false;
    public float d;
    public float e;
    public float f;
    private boolean cu = false;
    private boolean canWander = true;
    protected boolean actualJump;

    public EntitySlime(EntityTypes<? extends EntitySlime> type, World level) {
        super((EntityTypes<? extends EntityInsentient>)type, level);
        this.da();
        this.cn = new ControllerMoveSlime(this);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.slimeRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.slimeRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.slimeControllable;
    }

    @Override
    public float fw() {
        float height = super.fw();
        return this.getRider() != null && this.isControllable() && this.actualJump ? height * 1.5f : height;
    }

    @Override
    public boolean onSpacebar() {
        if (((Entity)this).bc && this.getRider() != null && this.isControllable()) {
            this.actualJump = true;
            if (this.getRider().getForwardMot() == 0.0f || this.getRider().getStrafeMot() == 0.0f) {
                this.u();
            }
        }
        return true;
    }

    protected String getMaxHealthEquation() {
        return this.an().purpurConfig.slimeMaxHealth;
    }

    protected String getAttackDamageEquation() {
        return this.an().purpurConfig.slimeAttackDamage;
    }

    protected Map<Integer, Double> getMaxHealthCache() {
        return this.an().purpurConfig.slimeMaxHealthCache;
    }

    protected Map<Integer, Double> getAttackDamageCache() {
        return this.an().purpurConfig.slimeAttackDamageCache;
    }

    protected double getFromCache(Supplier<String> equation, Supplier<Map<Integer, Double>> cache, Supplier<Double> defaultValue) {
        int size = this.gI();
        Double value = cache.get().get(size);
        if (value == null) {
            try {
                value = ((Number)Entity.scriptEngine.eval("let size = " + size + "; " + equation.get())).doubleValue();
            }
            catch (ScriptException e2) {
                e2.printStackTrace();
                value = defaultValue.get();
            }
            cache.get().put(size, value);
        }
        return value;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.slimeTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.slimeAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cq.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.cq.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.cq.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.cq.a(5, new PathfinderGoalSlimeIdle(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entity, level) -> Math.abs(entity.dM() - this.dM()) <= 4.0));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cs, 1);
    }

    @VisibleForTesting
    public void a(int size, boolean resetHealth) {
        int i2 = MathHelper.a(size, 1, 127);
        this.az.a(cs, i2);
        this.aG();
        this.l_();
        this.h(GenericAttributes.t).a(this.getFromCache(this::getMaxHealthEquation, this::getMaxHealthCache, () -> size * size));
        this.h(GenericAttributes.w).a(0.2f + 0.1f * (float)i2);
        this.h(GenericAttributes.c).a(this.getFromCache(this::getAttackDamageEquation, this::getAttackDamageCache, () -> i2));
        if (resetHealth) {
            this.x(this.fj());
        }
        this.cl = i2;
    }

    public int gI() {
        return this.az.a(cs);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Size", this.gI() - 1);
        output.a("wasOnGround", this.cu);
        output.a("Paper.canWander", this.canWander);
    }

    @Override
    protected void a(ValueInput input) {
        this.a(input.a("Size", 0) + 1, false);
        super.a(input);
        this.cu = input.a("wasOnGround", false);
        this.canWander = input.a("Paper.canWander", true);
    }

    public boolean gJ() {
        return this.gI() <= 1;
    }

    protected ParticleParam m() {
        return Particles.Y;
    }

    @Override
    public void g() {
        this.f = this.e;
        this.e += (this.d - this.e) * 0.5f;
        super.g();
        if (this.aS() && !this.cu) {
            float f2 = this.a(this.aE()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.as.i() * ((float)Math.PI * 2);
                float f3 = this.as.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a(f22) * f1 * f3;
                float f5 = MathHelper.b(f22) * f1 * f3;
                this.an().a(this.m(), this.dK() + (double)f4, this.dM(), this.dQ() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gG(), this.ft(), ((this.as.i() - this.as.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aS() && this.cu) {
            this.d = 1.0f;
        }
        this.cu = this.aS();
        this.s();
    }

    protected void s() {
        this.d *= 0.6f;
    }

    protected int n() {
        return this.as.a(20) + 10;
    }

    @Override
    public void l_() {
        double x2 = this.dK();
        double y2 = this.dM();
        double z2 = this.dQ();
        super.l_();
        this.a_(x2, y2, z2);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cs.equals(key)) {
            this.l_();
            this.v(this.bD);
            this.bB = this.bD;
            if (this.bu() && this.as.a(20) == 0) {
                this.bE();
            }
        }
        super.a(key);
    }

    public EntityTypes<? extends EntitySlime> ax() {
        return super.ax();
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        int size = this.gI();
        if (!this.an().D_() && size > 1 && this.eV()) {
            float width = this.a(this.aE()).a();
            float f2 = width / 2.0f;
            int i2 = size / 2;
            int i1 = 2 + this.as.a(3);
            ScoreboardTeam team = this.cD();
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), i1);
            if (!event.callEvent() || event.getCount() <= 0) {
                super.remove(reason, eventCause);
                return;
            }
            i1 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(i1);
            for (int i22 = 0; i22 < i1; ++i22) {
                float f1 = ((float)(i22 % 2) - 0.5f) * f2;
                float f22 = ((float)(i22 / 2) - 0.5f) * f2;
                EntitySlime converted = this.convertTo(this.ax(), new ConversionParams(ConversionType.b, false, false, team), EntitySpawnReason.k, (T mob) -> {
                    mob.a(i2, true);
                    mob.b(this.dK() + (double)f1, this.dM() + 0.5, this.dQ() + (double)f22, this.as.i() * 360.0f, 0.0f);
                }, null, null);
                if (converted == null) continue;
                slimes.add(converted);
            }
            if (!slimes.isEmpty() && CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(reason, eventCause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.an().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(reason, eventCause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gE()) {
            this.i((EntityLiving)entity);
        }
    }

    @Override
    public void a_(EntityHuman entity) {
        if (this.gE()) {
            this.i(entity);
        }
    }

    protected void i(EntityLiving livingEntity) {
        World world = this.an();
        if (world instanceof WorldServer) {
            DamageSource damageSource;
            WorldServer serverLevel = (WorldServer)world;
            if (this.bX() && this.h(livingEntity) && this.F(livingEntity) && livingEntity.a(serverLevel, damageSource = this.ei().b(this), this.gF())) {
                this.a(SoundEffects.zu, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                EnchantmentManager.a(serverLevel, (Entity)livingEntity, damageSource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return new Vec3D(0.0, (double)dimensions.b() - 0.015625 * (double)this.gI() * (double)partialTick, 0.0);
    }

    protected boolean gE() {
        return !this.gJ() && this.dt();
    }

    protected float gF() {
        return (float)this.i(GenericAttributes.c);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.gJ() ? SoundEffects.Az : SoundEffects.zw;
    }

    @Override
    public SoundEffect f_() {
        return this.gJ() ? SoundEffects.Ay : SoundEffects.zv;
    }

    protected SoundEffect gG() {
        return this.gJ() ? SoundEffects.AB : SoundEffects.zy;
    }

    public static boolean c(EntityTypes<EntitySlime> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (EntityMonster.canSpawnInBlueAndPackedIce(level, pos)) {
            return false;
        }
        if (level.aq() != EnumDifficulty.a) {
            if (EntitySpawnReason.a(spawnReason)) {
                return EntitySlime.a(entityType, level, spawnReason, pos, random);
            }
            double maxHeightSwamp = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.maximum;
            double minHeightSwamp = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.minimum;
            if (level.v(pos).a(BiomeTags.as) && (double)pos.v() > minHeightSwamp && (double)pos.v() < maxHeightSwamp && random.i() < 0.5f && random.i() < level.av() && level.C(pos) <= random.a(8)) {
                return EntitySlime.a(entityType, level, spawnReason, pos, random);
            }
            if (!(level instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
            boolean flag = level.getMinecraftWorld().paperConfig().entities.spawning.allChunksAreSlimeChunks || SeededRandom.a(chunkPos.h, chunkPos.i, ((GeneratorAccessSeed)level).H(), level.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            double maxHeightSlimeChunk = level.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.slimeChunk.maximum;
            if (random.a(10) == 0 && flag && (double)pos.v() < maxHeightSlimeChunk) {
                return EntitySlime.a(entityType, level, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float ft() {
        return 0.4f * (float)this.gI();
    }

    @Override
    public int af() {
        return 0;
    }

    protected boolean gK() {
        return this.gI() > 0;
    }

    @Override
    public void u() {
        Vec3D deltaMovement = this.dI();
        this.m(deltaMovement.g, this.fw(), deltaMovement.i);
        this.aF = true;
        this.actualJump = false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.I_();
        int randomInt = random.a(3);
        if (randomInt < 2 && random.i() < 0.5f * difficulty.d()) {
            ++randomInt;
        }
        int i2 = 1 << randomInt;
        this.a(i2, true);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    float k() {
        float f2 = this.gJ() ? 1.4f : 0.8f;
        return ((this.as.i() - this.as.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gH() {
        return this.gJ() ? SoundEffects.AA : SoundEffects.zx;
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return super.b(pose).a(this.gI());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    static class ControllerMoveSlime
    extends MoveControllerWASD {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime mob) {
            super(mob);
            this.n = mob;
            this.l = 180.0f * mob.dX() / (float)Math.PI;
        }

        public void a(float yRot, boolean aggressive) {
            this.l = yRot;
            this.o = aggressive;
        }

        public void a(double speedModifier) {
            this.setSpeedModifier(speedModifier);
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            if (this.n.getRider() != null && this.n.isControllable()) {
                this.purpurTick(this.n.getRider());
                if (this.n.getForwardMot() != 0.0f || this.n.getStrafeMot() != 0.0f) {
                    if (this.m > 10) {
                        this.m = 6;
                    }
                } else {
                    this.m = 20;
                }
            } else {
                this.d.v(this.b(this.d.dX(), this.l, 90.0f));
                this.d.bD = this.d.dX();
                this.d.bB = this.d.dX();
            }
            if (!(this.n.getRider() != null && this.n.isControllable() || this.k == ControllerMove.Operation.b)) {
                this.d.G(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aS()) {
                    this.d.B((float)(this.c() * this.d.i(GenericAttributes.w) * (this.n.getRider() != null && this.n.isControllable() && (this.n.getRider().getForwardMot() != 0.0f || this.n.getRider().getStrafeMot() != 0.0f) ? 2.0 : 1.0)));
                    if (this.m-- <= 0) {
                        this.m = this.n.n();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.R().a();
                        if (this.n.gK()) {
                            this.n.a(this.n.gH(), this.n.ft(), this.n.k());
                        }
                    } else {
                        this.n.bM = 0.0f;
                        this.n.bO = 0.0f;
                        this.d.B(0.0f);
                    }
                } else {
                    this.d.B((float)(this.c() * this.d.i(GenericAttributes.w) * (this.n.getRider() != null && this.n.isControllable() && (this.n.getRider().getForwardMot() != 0.0f || this.n.getRider().getStrafeMot() != 0.0f) ? 2.0 : 1.0)));
                }
            }
        }
    }

    static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            slime.S().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.bu() || this.a.bJ()) && this.a.Q() instanceof ControllerMoveSlime && this.a.canWander && new SlimeSwimEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            if (this.a.ek().i() < 0.8f) {
                this.a.R().a();
            }
            if ((controllerMove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(1.2);
            }
        }
    }

    static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving target = this.a.e();
            if (target == null || !target.bX()) {
                return false;
            }
            if (!this.a.c(target)) {
                return false;
            }
            return this.a.Q() instanceof ControllerMoveSlime && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)target.getBukkitEntity()).callEvent();
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving target = this.a.e();
            if (target == null || !target.bX()) {
                return false;
            }
            if (!this.a.c(target)) {
                return false;
            }
            return --this.b > 0 && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)target.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            EntityLiving target = this.a.e();
            if (target != null) {
                this.a.a((Entity)target, 10.0f, 10.0f);
            }
            if ((controllerMove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(this.a.dX(), this.a.gE());
            }
        }

        @Override
        public void e() {
            this.b = 0;
            this.a.g((EntityLiving)null);
        }
    }

    static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.e() == null && this.a.canWander && (this.a.aS() || this.a.bu() || this.a.bJ() || this.a.d(MobEffects.y)) && this.a.Q() instanceof ControllerMoveSlime;
        }

        @Override
        public void a() {
            ControllerMove controllerMove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.ek().a(60));
                this.b = this.a.ek().a(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((Slime)this.a.getBukkitEntity(), this.b);
                if (!this.a.canWander || !event.callEvent()) {
                    return;
                }
                this.b = event.getNewYaw();
            }
            if ((controllerMove = this.a.Q()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(this.b, false);
            }
        }
    }

    static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.cl() && this.a.canWander && new SlimeWanderEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void a() {
            ControllerMove controllerMove = this.a.Q();
            if (controllerMove instanceof ControllerMoveSlime) {
                ControllerMoveSlime slimeMoveControl = (ControllerMoveSlime)controllerMove;
                slimeMoveControl.a(1.0);
            }
        }
    }
}

