/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityStrider
extends EntityAnimal
implements ISteerable {
    private static final MinecraftKey ct = MinecraftKey.b("suffocating");
    private static final AttributeModifier cu = new AttributeModifier(ct, -0.34f, AttributeModifier.Operation.b);
    private static final float cv = 0.35f;
    private static final float cx = 0.55f;
    private static final DataWatcherObject<Integer> cy = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage cA;
    @Nullable
    private PathfinderGoalTempt cB;

    public EntityStrider(EntityTypes<? extends EntityStrider> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cA = new SaddleStorage(this.az, cy);
        this.W = true;
        if (this.fG()) {
            this.a(PathType.j, -1.0f);
        }
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.striderRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.striderRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.striderControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.striderMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.striderScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.striderBreedingTicks;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.striderAlwaysDropExp;
    }

    public static boolean c(EntityTypes<EntityStrider> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        do {
            mutableBlockPos.c(EnumDirection.b);
        } while (level.b_(mutableBlockPos).a(TagsFluid.b));
        return level.a_(mutableBlockPos).l();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cy.equals(key) && this.an().D_()) {
            this.cA.a();
        }
        super.a(key);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cy, 0);
        builder.a(cz, false);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.bX() && !this.g_();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.h || super.f(slot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.Ax : super.a(slot, stack, equippable);
    }

    @Override
    protected void H() {
        this.cq.a(1, new PathfinderGoalPanic(this, 1.65));
        this.cq.a(0, new HasRider(this));
        this.cq.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cB = new PathfinderGoalTempt(this, 1.4, itemStack -> itemStack.a(TagsItem.bb), false);
        this.cq.a(3, this.cB);
        this.cq.a(4, new a(this, 1.0));
        this.cq.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.cq.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.cq.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void x(boolean suffocating) {
        this.az.a(cz, suffocating);
        AttributeModifiable attribute = this.h(GenericAttributes.w);
        if (attribute != null) {
            if (suffocating) {
                attribute.a(cu);
            } else {
                attribute.c(ct);
            }
        }
    }

    public boolean m() {
        return this.az.a(cz);
    }

    @Override
    public boolean a(Fluid fluidState) {
        return fluidState.a(TagsFluid.b);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        if (!this.an().D_()) {
            return super.a(entity, dimensions, partialTick);
        }
        float min = Math.min(0.25f, this.bz.b());
        float f2 = this.bz.c();
        float f1 = 0.12f * MathHelper.b(f2 * 1.5f) * 2.0f * min;
        return super.a(entity, dimensions, partialTick).b(0.0, f1 * partialTick, 0.0);
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    @Override
    @Nullable
    public EntityLiving dg() {
        EntityHuman player;
        Entity entity;
        return this.am() && (entity = this.dj()) instanceof EntityHuman && (player = (EntityHuman)entity).b(Items.po) ? player : super.dg();
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        Vec3D[] vec3s = new Vec3D[]{EntityStrider.a(this.dA(), (double)livingEntity.dA(), livingEntity.dX()), EntityStrider.a(this.dA(), (double)livingEntity.dA(), livingEntity.dX() - 22.5f), EntityStrider.a(this.dA(), (double)livingEntity.dA(), livingEntity.dX() + 22.5f), EntityStrider.a(this.dA(), (double)livingEntity.dA(), livingEntity.dX() - 45.0f), EntityStrider.a(this.dA(), (double)livingEntity.dA(), livingEntity.dX() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d2 = this.de().e;
        double d1 = this.de().b - 0.5;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (Vec3D vec3 : vec3s) {
            mutableBlockPos.b(this.dK() + vec3.g, d2, this.dQ() + vec3.i);
            for (double d22 = d2; d22 > d1; d22 -= 1.0) {
                set.add(mutableBlockPos.j());
                mutableBlockPos.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockPos : set) {
            double blockFloorHeight;
            if (this.an().b_(blockPos).a(TagsFluid.b) || !DismountUtil.a(blockFloorHeight = this.an().j(blockPos))) continue;
            Vec3D vec31 = Vec3D.a(blockPos, blockFloorHeight);
            for (EntityPose pose : livingEntity.gd()) {
                AxisAlignedBB localBoundsForPose = livingEntity.f(pose);
                if (!DismountUtil.a(this.an(), livingEntity, localBoundsForPose.c(vec31))) continue;
                livingEntity.c(pose);
                return vec31;
            }
        }
        return new Vec3D(this.dK(), this.de().e, this.dQ());
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        this.a(player.dX(), player.dZ() * 0.5f);
        this.bB = this.bD = this.dX();
        this.ab = this.bD;
        this.cA.b();
        super.a(player, travelVector);
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float f(EntityHuman player) {
        return (float)(this.i(GenericAttributes.w) * (double)(this.m() ? 0.35f : 0.55f) * (double)this.cA.c());
    }

    @Override
    protected float bf() {
        return this.al + 0.6f;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.bJ() ? SoundEffects.Av : SoundEffects.Au, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.cA.a(this.ek());
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        if (this.bJ()) {
            this.l();
        } else {
            super.a(y2, onGround, state, pos);
        }
    }

    @Override
    public void g() {
        if (this.s() && this.as.a(140) == 0) {
            this.b(SoundEffects.Aq);
        } else if (this.gF() && this.as.a(60) == 0) {
            this.b(SoundEffects.Ar);
        }
        if (!this.gx()) {
            boolean suffocating;
            EntityStrider strider;
            IBlockData blockState = this.an().a_(this.dF());
            IBlockData blockStateOnLegacy = this.bF();
            boolean flag = blockState.a(TagsBlock.bg) || blockStateOnLegacy.a(TagsBlock.bg) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.du();
            boolean flag1 = entity instanceof EntityStrider && (strider = (EntityStrider)entity).m();
            boolean bl = suffocating = !flag || flag1;
            if (suffocating ^ this.m() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.x(suffocating);
            }
        }
        super.g();
        this.gI();
    }

    private boolean s() {
        return this.cB != null && this.cB.k();
    }

    @Override
    protected boolean J() {
        return true;
    }

    private void gI() {
        if (this.bJ()) {
            VoxelShapeCollision collisionContext = VoxelShapeCollision.a(this);
            if (collisionContext.a(BlockFluids.d, this.dF(), true) && !this.an().b_(this.dF().d()).a(TagsFluid.b)) {
                this.e(true);
            } else {
                this.k(this.dI().c(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder n() {
        return EntityAnimal.gN().a(GenericAttributes.w, 0.175f);
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return !this.gF() && !this.s() ? SoundEffects.Ap : null;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.At;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.As;
    }

    @Override
    protected boolean s(Entity passenger) {
        return !this.cm() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.striderTakeDamageFromWater;
    }

    @Override
    public boolean ck() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new b(this, level);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (level.a_(pos).y().a(TagsFluid.b)) {
            return 10.0f;
        }
        return this.bJ() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    @Nullable
    public EntityStrider b(WorldServer level, EntityAgeable partner) {
        return EntityTypes.by.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.ba);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean isFood = this.i(player.b(hand));
        if (this.an().purpurConfig.striderGiveSaddleBack && player.gp() && !isFood && this.am() && !this.cm()) {
            this.a(EnumItemSlot.h, ItemStack.l);
            if (!player.gC().d) {
                ItemStack saddle = new ItemStack(Items.oR);
                if (!player.gB().g(saddle)) {
                    player.a(saddle, false);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!isFood && this.am() && !this.cm() && !player.gp()) {
            if (!this.an().D_()) {
                player.o(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (!interactionResult.a()) {
            ItemStack itemInHand = player.b(hand);
            return this.a(itemInHand, EnumItemSlot.h) ? itemInHand.a(player, (EntityLiving)this, hand) : this.tryRide(player, hand);
        }
        if (isFood && !this.bm()) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.Aw, this.dw(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
        return interactionResult;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.6f * this.df(), this.dA() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (this.g_()) {
            return super.a(level, difficulty, spawnReason, spawnGroupData);
        }
        RandomSource random = level.I_();
        if (random.a(30) == 0) {
            EntityInsentient mob = EntityTypes.bW.a(level.a(), EntitySpawnReason.g);
            if (mob != null) {
                spawnGroupData = this.a(level, difficulty, mob, (GroupDataEntity)new EntityZombie.GroupDataZombie(EntityZombie.a(random), false));
                mob.a(EnumItemSlot.a, new ItemStack(Items.po));
                this.a(EnumItemSlot.h, new ItemStack(Items.oR));
                this.g(EnumItemSlot.h);
            }
        } else if (random.a(10) == 0) {
            EntityAgeable ageableMob = EntityTypes.by.a(level.a(), EntitySpawnReason.g);
            if (ageableMob != null) {
                ageableMob.c_(-24000);
                spawnGroupData = this.a(level, difficulty, ageableMob, null);
            }
        } else {
            spawnGroupData = new EntityAgeable.a(0.5f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntityInsentient jockey, @Nullable GroupDataEntity spawnData) {
        jockey.b(this.dK(), this.dM(), this.dQ(), this.dX(), 0.0f);
        jockey.a(level, difficulty, EntitySpawnReason.g, spawnData);
        jockey.a((Entity)this, true, false);
        return new EntityAgeable.a(0.0f);
    }

    static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider strider, double speedModifier) {
            super(strider, speedModifier, 8, 2);
            this.g = strider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean c() {
            return !this.g.bJ() && this.a(this.g.an(), this.e);
        }

        @Override
        public boolean b() {
            return !this.g.bJ() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            return level.a_(pos).a(Blocks.K) && level.a_(pos.d()).a(PathMode.a);
        }
    }

    static class b
    extends Navigation {
        b(EntityStrider strider, World level) {
            super(strider, level);
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new PathfinderNormal();
            return new Pathfinder(this.o, maxVisitedNodes);
        }

        @Override
        protected boolean a(PathType pathType) {
            return pathType == PathType.i || pathType == PathType.o || pathType == PathType.n || super.a(pathType);
        }

        @Override
        public boolean a(BlockPosition pos) {
            return this.b.a_(pos).a(Blocks.K) || super.a(pos);
        }
    }
}

