/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.controller.FlyingMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityVex
extends EntityMonster
implements TraceableEntity {
    public static final float a = 45.836624f;
    public static final int b = MathHelper.f(3.9269907f);
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityVex.class, DataWatcherRegistry.a);
    private static final int d = 1;
    @Nullable
    public EntityReference<EntityInsentient> e;
    @Nullable
    private BlockPosition f;
    public boolean ct;
    public int cu;

    public EntityVex(EntityTypes<? extends EntityVex> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cn = new c(this);
        this.cl = 3;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.vexRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.vexRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.vexControllable;
    }

    @Override
    public double getMaxY() {
        return this.an().purpurConfig.vexMaxY;
    }

    @Override
    public void m(Vec3D vec3) {
        super.m(vec3);
        if (this.getRider() != null && this.isControllable()) {
            float speed = ((Entity)this).bc ? (float)this.i(GenericAttributes.w) * 0.1f : (float)this.i(GenericAttributes.m);
            this.B(speed);
            Vec3D mot = this.dI();
            this.a(EnumMoveType.a, mot.d(speed, 1.0, speed));
            this.k(mot.c(0.9));
        }
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.vexMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.vexScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.vexTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.vexAlwaysDropExp;
    }

    @Override
    public boolean bl() {
        return this.at % b == 0;
    }

    @Override
    public boolean aW() {
        return !this.ec();
    }

    @Override
    public void g() {
        this.ar = this.getRider() == null || !this.isControllable();
        super.g();
        this.ar = false;
        this.g(true);
        if (this.ct && --this.cu <= 0) {
            this.cu = 20;
            this.a(this.ei().j(), 1.0f);
        }
    }

    @Override
    protected void H() {
        super.H();
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new HasRider(this));
        this.cq.a(4, new a());
        this.cq.a(8, new d());
        this.cq.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.cq.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.cr.a(2, new b(this));
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 14.0).a(GenericAttributes.c, 4.0).a(GenericAttributes.m, 0.6);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, (byte)0);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.f = input.a("bound_pos", BlockPosition.a).orElse(null);
        input.e("life_ticks").ifPresentOrElse(this::b, () -> {
            this.ct = false;
        });
        this.e = EntityReference.a(input, "owner");
    }

    @Override
    public void y(Entity entity) {
        super.y(entity);
        if (entity instanceof EntityVex) {
            EntityVex vex = (EntityVex)entity;
            this.e = vex.e;
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.b("bound_pos", BlockPosition.a, this.f);
        if (this.ct) {
            output.a("life_ticks", this.cu);
        }
        EntityReference.a(this.e, output, "owner");
    }

    @Nullable
    public EntityInsentient m() {
        return EntityReference.a(this.e, this.an(), EntityInsentient.class);
    }

    @Nullable
    public BlockPosition n() {
        return this.f;
    }

    public void h(@Nullable BlockPosition boundOrigin) {
        this.f = boundOrigin;
    }

    private boolean c(int mask) {
        byte i2 = this.az.a(c);
        return (i2 & mask) != 0;
    }

    private void a(int mask, boolean value) {
        int i2 = this.az.a(c).byteValue();
        i2 = value ? (i2 |= mask) : (i2 &= ~mask);
        this.az.a(c, (byte)(i2 & 0xFF));
    }

    public boolean s() {
        return this.c(1);
    }

    public void x(boolean charging) {
        this.a(1, charging);
    }

    public void a(EntityInsentient owner) {
        this.e = EntityReference.a(owner);
    }

    public void b(int limitedLifeTicks) {
        this.ct = true;
        this.cu = limitedLifeTicks;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.Dh;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.Dj;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.Dk;
    }

    @Override
    public float bK() {
        return 1.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.I_();
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(EnumItemSlot.a, new ItemStack(Items.qH));
        this.a(EnumItemSlot.a, 0.0f);
    }

    class c
    extends FlyingMoveControllerWASD {
        public c(EntityVex mob) {
            super(mob);
        }

        @Override
        public void vanillaTick() {
            if (this.k == ControllerMove.Operation.b) {
                Vec3D vec3 = new Vec3D(this.e - EntityVex.this.dK(), this.f - EntityVex.this.dM(), this.g - EntityVex.this.dQ());
                double len = vec3.g();
                if (len < EntityVex.this.de().a()) {
                    this.k = ControllerMove.Operation.a;
                    EntityVex.this.k(EntityVex.this.dI().c(0.5));
                } else {
                    EntityVex.this.k(EntityVex.this.dI().e(vec3.c(this.c() * 0.05 / len)));
                    if (EntityVex.this.e() == null) {
                        Vec3D deltaMovement = EntityVex.this.dI();
                        EntityVex.this.v(-((float)MathHelper.d(deltaMovement.g, deltaMovement.i)) * 57.295776f);
                        EntityVex.this.bB = EntityVex.this.dX();
                    } else {
                        double d2 = EntityVex.this.e().dK() - EntityVex.this.dK();
                        double d1 = EntityVex.this.e().dQ() - EntityVex.this.dQ();
                        EntityVex.this.v(-((float)MathHelper.d(d2, d1)) * 57.295776f);
                        EntityVex.this.bB = EntityVex.this.dX();
                    }
                }
            }
        }
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            EntityLiving target = EntityVex.this.e();
            return target != null && target.bX() && !EntityVex.this.Q().b() && EntityVex.this.as.a(net.minecraft.world.entity.monster.EntityVex$a.b(7)) == 0 && EntityVex.this.g((Entity)target) > 4.0;
        }

        @Override
        public boolean c() {
            return EntityVex.this.Q().b() && EntityVex.this.s() && EntityVex.this.e() != null && EntityVex.this.e().bX();
        }

        @Override
        public void d() {
            EntityLiving target = EntityVex.this.e();
            if (target != null) {
                Vec3D eyePosition = target.bR();
                EntityVex.this.cn.a(eyePosition.g, eyePosition.h, eyePosition.i, 1.0);
            }
            EntityVex.this.x(true);
            EntityVex.this.a(SoundEffects.Di, 1.0f, 1.0f);
        }

        @Override
        public void e() {
            EntityVex.this.x(false);
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = EntityVex.this.e();
            if (target != null) {
                if (EntityVex.this.de().c(target.de())) {
                    EntityVex.this.c(net.minecraft.world.entity.monster.EntityVex$a.a(EntityVex.this.an()), (Entity)target);
                    EntityVex.this.x(false);
                } else {
                    double d2 = EntityVex.this.g((Entity)target);
                    if (d2 < 9.0) {
                        Vec3D eyePosition = target.bR();
                        EntityVex.this.cn.a(eyePosition.g, eyePosition.h, eyePosition.i, 1.0);
                    }
                }
            }
        }
    }

    class d
    extends PathfinderGoal {
        public d() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !EntityVex.this.Q().b() && EntityVex.this.as.a(net.minecraft.world.entity.monster.EntityVex$d.b(7)) == 0;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public void a() {
            BlockPosition boundOrigin = EntityVex.this.n();
            if (boundOrigin == null) {
                boundOrigin = EntityVex.this.dF();
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockPos = boundOrigin.b(EntityVex.this.as.a(15) - 7, EntityVex.this.as.a(11) - 5, EntityVex.this.as.a(15) - 7);
                IBlockData blockState = EntityVex.this.an().getBlockStateIfLoaded(blockPos);
                if (blockState == null || !blockState.l()) continue;
                EntityVex.this.cn.a((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5, 0.25);
                if (EntityVex.this.e() != null) break;
                EntityVex.this.P().a((double)blockPos.u() + 0.5, (double)blockPos.v() + 0.5, (double)blockPos.w() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class b
    extends PathfinderGoalTarget {
        private final PathfinderTargetCondition b;

        public b(EntityCreature mob) {
            super(mob, false);
            this.b = PathfinderTargetCondition.b().d().e();
        }

        @Override
        public boolean b() {
            EntityInsentient owner = EntityVex.this.m();
            return owner != null && owner.e() != null && this.a(owner.e(), this.b);
        }

        @Override
        public void d() {
            EntityInsentient owner = EntityVex.this.m();
            EntityVex.this.setTarget(owner != null ? owner.e() : null, EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET);
            super.d();
        }
    }
}

