/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.ItemStack;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final MinecraftKey a = MinecraftKey.b("drinking");
    private static final AttributeModifier b = new AttributeModifier(a, -0.25, AttributeModifier.Operation.a);
    private static final DataWatcherObject<Boolean> e = DataWatcher.a(EntityWitch.class, DataWatcherRegistry.k);
    public int f;
    private PathfinderGoalNearestHealableRaider<EntityRaider> ct;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> cu;

    public EntityWitch(EntityTypes<? extends EntityWitch> type, World level) {
        super((EntityTypes<? extends EntityRaider>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.witchRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.witchRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.witchControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.witchMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.witchScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.witchTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.witchAlwaysDropExp;
    }

    @Override
    protected void H() {
        super.H();
        this.ct = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, (entity, level) -> this.gY() && entity.ax() != EntityTypes.bN);
        this.cu = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, null);
        this.cq.a(1, new PathfinderGoalFloat(this));
        this.cq.a(1, new HasRider(this));
        this.cq.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.cq.a(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(3, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.cr.a(2, this.ct);
        this.cr.a(3, this.cu);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(e, false);
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.EM;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.EQ;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.EO;
    }

    public void z(boolean usingItem) {
        this.aC().a(e, usingItem);
    }

    public boolean k() {
        return this.aC().a(e);
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gN().a(GenericAttributes.t, 26.0).a(GenericAttributes.w, 0.25);
    }

    @Override
    public void e_() {
        if (!this.an().D_() && this.bX()) {
            this.ct.k();
            if (this.ct.i() <= 0) {
                this.cu.a(true);
            } else {
                this.cu.a(false);
            }
            if (this.k()) {
                if (this.f-- <= 0) {
                    this.z(false);
                    net.minecraft.world.item.ItemStack mainHandItem = this.fq();
                    this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.l);
                    PotionContents potionContents = mainHandItem.a(DataComponents.R);
                    if (mainHandItem.a(Items.up)) {
                        WitchConsumePotionEvent event = new WitchConsumePotionEvent((Witch)this.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(mainHandItem));
                        PotionContents potionContents2 = potionContents = event.callEvent() ? CraftItemStack.unwrap(event.getPotion()).a(DataComponents.R) : null;
                    }
                    if (mainHandItem.a(Items.up) && potionContents != null) {
                        potionContents.a((MobEffect effect) -> this.addEffect((MobEffect)effect, EntityPotionEffectEvent.Cause.ATTACK), mainHandItem.a(DataComponents.S, Float.valueOf(1.0f)).floatValue());
                    }
                    this.c(GameEvent.l);
                    this.h(GenericAttributes.w).c(b.a());
                }
            } else {
                Holder<PotionRegistry> holder = null;
                if (this.as.i() < 0.15f && ((Entity)this).a(TagsFluid.a) && !this.d(MobEffects.m)) {
                    holder = Potions.w;
                } else if (this.as.i() < 0.15f && (this.ck() || this.eW() != null && this.eW().a(DamageTypeTags.i)) && !this.d(MobEffects.l)) {
                    holder = Potions.l;
                } else if (this.as.i() < 0.05f && this.eU() < this.fj()) {
                    holder = Potions.y;
                } else if (this.as.i() < 0.5f && this.e() != null && !this.d(MobEffects.a) && this.e().g(this) > 121.0) {
                    holder = Potions.n;
                }
                if (holder != null) {
                    this.setDrinkingPotion(PotionContents.a(Items.up, holder));
                }
            }
            if (this.as.i() < 7.5E-4f) {
                this.an().a((Entity)this, (byte)15);
            }
        }
        super.e_();
    }

    public void setDrinkingPotion(net.minecraft.world.item.ItemStack potion) {
        potion = CraftEventFactory.handleWitchReadyPotionEvent(this, potion);
        this.a(EnumItemSlot.a, potion);
        this.f = this.fq().a(this);
        this.z(true);
        if (!this.bm()) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.EP, this.dw(), 1.0f, 0.8f + this.as.i() * 0.4f);
        }
        AttributeModifiable attribute = this.h(GenericAttributes.w);
        attribute.c(a);
        attribute.b(b);
    }

    @Override
    public SoundEffect ah_() {
        return SoundEffects.EN;
    }

    @Override
    public void b(byte id) {
        if (id == 15) {
            for (int i2 = 0; i2 < this.as.a(35) + 10; ++i2) {
                this.an().a(Particles.ar, this.dK() + this.as.k() * (double)0.13f, this.de().e + 0.5 + this.as.k() * (double)0.13f, this.dQ() + this.as.k() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.b(id);
        }
    }

    @Override
    protected float f(DamageSource damageSource, float damageAmount) {
        damageAmount = super.f(damageSource, damageAmount);
        if (damageSource.d() == this) {
            damageAmount = 0.0f;
        }
        if (damageSource.a(DamageTypeTags.k)) {
            damageAmount *= 0.15f;
        }
        return damageAmount;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        if (!this.k()) {
            Vec3D deltaMovement = target.dI();
            double d2 = target.dK() + deltaMovement.g - this.dK();
            double d1 = target.dO() - (double)1.1f - this.dM();
            double d22 = target.dQ() + deltaMovement.i - this.dQ();
            double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
            Holder<PotionRegistry> holder = Potions.A;
            if (target instanceof EntityRaider) {
                holder = target.eU() <= 4.0f ? Potions.y : Potions.F;
                this.g((EntityLiving)null);
            } else if (squareRoot >= 8.0 && !target.d(MobEffects.b)) {
                holder = Potions.q;
            } else if (target.eU() >= 8.0f && !target.d(MobEffects.s)) {
                holder = Potions.C;
            } else if (squareRoot <= 3.0 && !target.d(MobEffects.r) && this.as.i() < 0.25f) {
                holder = Potions.L;
            }
            World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                net.minecraft.world.item.ItemStack itemStack = PotionContents.a(Items.xy, holder);
                WitchThrowPotionEvent event = new WitchThrowPotionEvent((Witch)this.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemStack));
                if (!event.callEvent()) {
                    return;
                }
                itemStack = CraftItemStack.asNMSCopy(event.getPotion());
                IProjectile.a(ThrownSplashPotion::new, serverLevel, itemStack, this, d2, d1 + squareRoot * 0.2, d22, 0.75f, 8.0f);
            }
            if (!this.bm()) {
                this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.ER, this.dw(), 1.0f, 0.8f + this.as.i() * 0.4f);
            }
        }
    }

    @Override
    public void a(WorldServer level, int wave, boolean flag) {
    }

    @Override
    public boolean gI() {
        return false;
    }
}

