/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityZoglin
extends EntityMonster
implements IOglin {
    private static final DataWatcherObject<Boolean> e = DataWatcher.a(EntityZoglin.class, DataWatcherRegistry.k);
    private static final int f = 40;
    private static final int ct = 1;
    private static final float cu = 0.6f;
    private static final int cv = 6;
    private static final float cw = 0.5f;
    private static final int cx = 40;
    private static final int cy = 15;
    private static final int cz = 200;
    private static final float cA = 0.3f;
    private static final float cB = 0.4f;
    private static final boolean cC = false;
    private int cD;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityZoglin>>> a = ImmutableList.of(SensorType.c, SensorType.d);
    protected static final ImmutableList<? extends MemoryModuleType<?>> b = ImmutableList.of(MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q);

    public EntityZoglin(EntityTypes<? extends EntityZoglin> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cl = 5;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.zoglinRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.zoglinRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.zoglinControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.zoglinMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.zoglinScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.zoglinTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.zoglinAlwaysDropExp;
    }

    protected BehaviorController.b<EntityZoglin> er() {
        return BehaviorController.a(b, a);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityZoglin> brain = this.er().a(dynamic);
        EntityZoglin.a(brain);
        EntityZoglin.b(brain);
        EntityZoglin.c(brain);
        brain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        brain.b(Activity.b);
        brain.f();
        return brain;
    }

    private static void a(BehaviorController<EntityZoglin> brain) {
        brain.a(Activity.a, 0, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of((Object)new BehaviorLook(45, 90), (Object)new BehavorMove()));
    }

    private static void b(BehaviorController<EntityZoglin> brain) {
        brain.a(Activity.b, 10, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of(BehaviorAttackTargetSet.a((WorldServer level, E zoglin) -> zoglin.h(level)), SetEntityLookTargetSometimes.a(8.0f, UniformInt.a(30, 60)), new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.a(0.4f), (Object)2), (Object)Pair.of(BehaviorLookWalk.a(0.4f, 3), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)))));
    }

    private static void c(BehaviorController<EntityZoglin> brain) {
        brain.a(Activity.k, 10, (ImmutableList<BehaviorControl<EntityZoglin>>)ImmutableList.of(BehaviorWalkAwayOutOfRange.a(1.0f), BehaviorBuilder.a(EntityZoglin::m, BehaviorAttack.a(40)), BehaviorBuilder.a(EntityZoglin::g_, BehaviorAttack.a(15)), BehaviorAttackTargetForget.a()), MemoryModuleType.p);
    }

    private Optional<? extends EntityLiving> h(WorldServer level) {
        return this.eq().c(MemoryModuleType.h).orElse(NearestVisibleLivingEntities.a()).a((EntityLiving entity) -> this.b(level, (EntityLiving)entity));
    }

    private boolean b(WorldServer level, EntityLiving entity) {
        EntityTypes<?> type = entity.ax();
        return type != EntityTypes.bS && type != EntityTypes.H && Sensor.c(level, this, entity);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(e, false);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (e.equals(key)) {
            this.l_();
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (level.I_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 40.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.q, 0.6f).a(GenericAttributes.d, 1.0).a(GenericAttributes.c, 6.0);
    }

    public boolean m() {
        return !this.g_();
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        if (target instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)target;
            this.cD = 10;
            level.a((Entity)this, (byte)4);
            this.b(SoundEffects.FD);
            return IOglin.a(level, this, livingEntity);
        }
        return false;
    }

    @Override
    public boolean v() {
        return true;
    }

    @Override
    protected void d(EntityLiving entity) {
        if (!this.g_()) {
            IOglin.a(this, entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            if (this.c(livingEntity) && !BehaviorUtil.a((EntityLiving)this, livingEntity, 4.0)) {
                this.i(livingEntity);
            }
            return true;
        }
        return flag;
    }

    private void i(EntityLiving target) {
        this.bY.b(MemoryModuleType.F);
        this.bY.a(MemoryModuleType.p, target, 200L);
    }

    public BehaviorController<EntityZoglin> eq() {
        return super.eq();
    }

    protected void n() {
        Activity activity = this.bY.g().orElse(null);
        this.bY.a((List<Activity>)ImmutableList.of((Object)Activity.k, (Object)Activity.b));
        Activity activity1 = this.bY.g().orElse(null);
        if (activity1 == Activity.k && activity != Activity.k) {
            this.gI();
        }
        this.w(this.bY.a(MemoryModuleType.p));
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("zoglinBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        this.n();
    }

    @Override
    public void a(boolean childZombie) {
        this.aC().a(e, childZombie);
        if (!this.an().D_() && childZombie) {
            this.h(GenericAttributes.c).a(0.5);
        }
    }

    @Override
    public boolean g_() {
        return this.aC().a(e);
    }

    @Override
    public void e_() {
        if (this.cD > 0) {
            --this.cD;
        }
        super.e_();
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.cD = 10;
            this.b(SoundEffects.FD);
        } else {
            super.b(id);
        }
    }

    @Override
    public int s() {
        return this.cD;
    }

    @Override
    public SoundEffect p() {
        if (this.an().D_()) {
            return null;
        }
        return this.bY.a(MemoryModuleType.p) ? SoundEffects.FC : SoundEffects.FB;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.FF;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.FE;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.FG, 0.15f, 1.0f);
    }

    protected void gI() {
        this.b(SoundEffects.FC);
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.U();
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsBaby", this.g_());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("IsBaby", false));
    }
}

