/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private final AttributeModifier babyModifier;
    private static final MinecraftKey ct = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier cu = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey cv = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey cw = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cy = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float b = 0.05f;
    public static final int c = 50;
    public static final int d = 40;
    public static final int e = 7;
    private static final int cA = -1;
    private static final EntitySize cB = EntityTypes.bT.n().a(0.5f).b(0.93f);
    private static final float cC = 0.1f;
    public static final Predicate<EnumDifficulty> cD = difficulty -> difficulty == EnumDifficulty.d;
    private static final boolean cE = false;
    private static final boolean cF = false;
    private static final int cG = 0;
    private final PathfinderGoalBreakDoor cH;
    private boolean cI;
    private int cJ;
    public int cK;

    public EntityZombie(EntityTypes<? extends EntityZombie> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.babyModifier = new AttributeModifier(a, this.an().paperConfig().entities.behavior.babyZombieMovementModifier, AttributeModifier.Operation.b);
        this.cI = false;
        this.cJ = 0;
        this.cH = new PathfinderGoalBreakDoor(this, (Predicate<EnumDifficulty>)Predicates.in((Collection)level.paperConfig().entities.behavior.doorBreakingDifficulty.getOrDefault(type, level.paperConfig().entities.behavior.doorBreakingDifficulty.get(EntityTypes.bT))));
        this.setShouldBurnInDay(true);
    }

    public EntityZombie(World level) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bT, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.zombieRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.zombieRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.zombieControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.zombieMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.zombieScale);
    }

    public boolean jockeyOnlyBaby() {
        return this.an().purpurConfig.zombieJockeyOnlyBaby;
    }

    public double jockeyChance() {
        return this.an().purpurConfig.zombieJockeyChance;
    }

    public boolean jockeyTryExistingChickens() {
        return this.an().purpurConfig.zombieJockeyTryExistingChickens;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.zombieTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.zombieAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        if (this.an().paperConfig().entities.behavior.zombiesTargetTurtleEggs) {
            this.cq.a(4, new a((EntityCreature)this, 1.0, 3));
        }
        this.cq.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(8, new PathfinderGoalRandomLookaround(this));
        this.cr.a(0, new HasRider(this));
        this.m();
    }

    protected void m() {
        this.cq.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.cq.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gO));
        this.cq.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cr.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.cr.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.an().spigotConfig.zombieAggressiveTowardsVillager) {
            this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false){

                @Override
                public boolean b() {
                    return (EntityZombie.this.an().purpurConfig.zombieAggressiveTowardsVillagerWhenLagging || !EntityZombie.this.an().q().server.isLagging()) && super.b();
                }

                @Override
                public boolean c() {
                    return (EntityZombie.this.an().purpurConfig.zombieAggressiveTowardsVillagerWhenLagging || !EntityZombie.this.an().q().server.isLagging()) && super.c();
                }
            });
        }
        this.cr.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.cr.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.ct));
    }

    public static AttributeProvider.Builder gK() {
        return EntityMonster.gN().a(GenericAttributes.n, 35.0).a(GenericAttributes.w, 0.23f).a(GenericAttributes.c, 3.0).a(GenericAttributes.a, 2.0).a(GenericAttributes.B);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cx, false);
        builder.a(cy, 0);
        builder.a(cz, false);
    }

    public boolean gL() {
        return this.aC().a(cz);
    }

    public boolean gO() {
        return this.cI;
    }

    public void y(boolean canBreakDoors) {
        if (this.cp.c()) {
            if (this.cI != canBreakDoors) {
                this.cI = canBreakDoors;
                this.cp.e(canBreakDoors);
                if (canBreakDoors) {
                    this.cq.a(1, this.cH);
                } else {
                    this.cq.a(this.cH);
                }
            }
        } else if (this.cI) {
            this.cq.a(this.cH);
            this.cI = false;
        }
    }

    @Override
    public boolean g_() {
        return this.aC().a(cx);
    }

    @Override
    protected int f(WorldServer level) {
        int previousReward = this.cl;
        if (this.g_()) {
            this.cl = (int)((double)this.cl * 2.5);
        }
        int reward = super.f(level);
        this.cl = previousReward;
        return reward;
    }

    @Override
    public void a(boolean childZombie) {
        this.aC().a(cx, childZombie);
        if (this.an() != null && !this.an().D_()) {
            AttributeModifiable attribute = this.h(GenericAttributes.w);
            attribute.c(this.babyModifier.a());
            if (childZombie) {
                attribute.b(this.babyModifier);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cx.equals(key)) {
            this.l_();
        }
        super.a(key);
    }

    protected boolean gI() {
        return true;
    }

    @Override
    public void g() {
        if (!this.an().D_() && this.bX() && !this.gx()) {
            if (this.gL()) {
                --this.cK;
                if (this.cK < 0) {
                    this.af_();
                }
            } else if (this.gI()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cJ;
                    if (this.cJ >= 600) {
                        this.r(300);
                    }
                } else {
                    this.cJ = -1;
                }
            }
        }
        super.g();
    }

    @Override
    public void e_() {
        super.e_();
    }

    public void stopDrowning() {
        this.cK = -1;
        this.aC().a(cz, false);
    }

    public void r(int conversionTime) {
        this.cK = conversionTime;
        this.aC().a(cz, true);
    }

    protected void af_() {
        this.b(EntityTypes.N);
        if (!this.bm()) {
            this.an().a(null, 1040, this.dF(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entityType) {
        EntityZombie converted = this.convertTo(entityType, ConversionParams.a(this, true, true), (T zombie) -> zombie.J(zombie.an().d_(zombie.dF()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer level, EntityVillager villager) {
        return EntityZombie.convertVillagerToZombieVillager(level, villager, this.dF(), this.bm(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    @Nullable
    public static EntityZombieVillager convertVillagerToZombieVillager(WorldServer level, EntityVillager villager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        EntityZombieVillager zombieVillager = villager.convertTo(EntityTypes.bV, ConversionParams.a(villager, true, true), (T mob) -> {
            mob.a((WorldAccess)level, level.d_(mob.dF()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            mob.a(villager.gR());
            mob.a(villager.hd().d());
            mob.a(villager.gK().a());
            mob.s(villager.s());
            if (!silent) {
                level.a(null, 1026, blockPosition, 0);
            }
        }, transformReason, creatureSpawnReason);
        return zombieVillager;
    }

    @Override
    public boolean shouldBurnInDay() {
        return this.ag_();
    }

    public boolean ag_() {
        return this.shouldBurnInDay;
    }

    @Override
    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!super.a(level, damageSource, amount)) {
            return false;
        }
        EntityLiving target = this.e();
        if (target == null && damageSource.d() instanceof EntityLiving) {
            target = (EntityLiving)damageSource.d();
        }
        if (target != null && level.aq() == EnumDifficulty.d && (double)this.as.i() < this.i(GenericAttributes.B) && level.M()) {
            int floor = MathHelper.a(this.dK());
            int floor1 = MathHelper.a(this.dM());
            int floor2 = MathHelper.a(this.dQ());
            EntityTypes<? extends EntityZombie> type = this.ax();
            EntityZombie zombie = type.a(level, EntitySpawnReason.j);
            if (zombie == null) {
                return true;
            }
            for (int i2 = 0; i2 < 50; ++i2) {
                int i3;
                int i22;
                int i1 = floor + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1);
                BlockPosition blockPos = new BlockPosition(i1, i22 = floor1 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1), i3 = floor2 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1));
                if (!EntityPositionTypes.a(type, level, blockPos) || !EntityPositionTypes.a(type, level, EntitySpawnReason.j, blockPos, level.z)) continue;
                zombie.a_(i1, i22, i3);
                if (level.hasNearbyAlivePlayerThatAffectsSpawning(i1, i22, i3, 7.0) || !level.f(zombie) || !level.g(zombie) || !zombie.s() && level.d(zombie.de())) continue;
                zombie.setTarget(target, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET);
                zombie.a((WorldAccess)level, level.d_(zombie.dF()), EntitySpawnReason.j, null);
                level.addFreshEntityWithPassengers(zombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attribute = this.h(GenericAttributes.B);
                AttributeModifier modifier = attribute.a(ct);
                double d2 = modifier != null ? modifier.b() : 0.0;
                attribute.c(ct);
                attribute.d(new AttributeModifier(ct, d2 - 0.05, AttributeModifier.Operation.a));
                zombie.h(GenericAttributes.B).d(cu);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        boolean flag = super.c(level, target);
        if (flag) {
            EntityCombustByEntityEvent event;
            float effectiveDifficulty = this.an().d_(this.dF()).b();
            if (this.fq().f() && this.ck() && this.as.i() < effectiveDifficulty * 0.3f && (event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), (float)(2 * (int)effectiveDifficulty))).callEvent()) {
                target.igniteForSeconds(event.getDuration(), false);
            }
        }
        return flag;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.FH;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.FR;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.FM;
    }

    protected SoundEffect n() {
        return SoundEffects.FX;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(this.n(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> ax() {
        return super.ax();
    }

    protected boolean s() {
        return false;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        super.a(random, difficulty);
        float f2 = random.i();
        float f3 = this.an().aq() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int randomInt = random.a(3);
            if (randomInt == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.qH));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.qI));
            }
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsBaby", this.g_());
        output.a("CanBreakDoors", this.gO());
        output.a("InWaterTime", this.bu() ? this.cJ : -1);
        output.a("DrownedConversionTime", this.gL() ? this.cK : -1);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("IsBaby", false));
        this.y(input.a("CanBreakDoors", false));
        this.cJ = input.a("InWaterTime", 0);
        int intOr = input.a("DrownedConversionTime", -1);
        if (intOr != -1) {
            this.r(intOr);
        } else {
            this.aC().a(cz, false);
        }
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        EntityVillager villager;
        double fallbackChance;
        boolean flag = super.a(level, entity, damageSource);
        double d2 = level.aq() == EnumDifficulty.d ? 100.0 : (fallbackChance = level.aq() == EnumDifficulty.c ? 50.0 : 0.0);
        if (this.as.j() * 100.0 < level.paperConfig().entities.behavior.zombieVillagerInfectionChance.or(fallbackChance) && entity instanceof EntityVillager && this.a(level, villager = (EntityVillager)entity)) {
            flag = false;
        }
        return flag;
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? cB : super.b(pose);
    }

    @Override
    public boolean g(ItemStack stack) {
        return (!stack.a(TagsItem.az) || !this.g_() || !this.cl()) && super.g(stack);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return !stack.a(Items.tk) && super.c(level, stack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.I_();
        spawnGroupData = super.a(level, difficulty, spawnReason, spawnGroupData);
        float specialMultiplier = difficulty.d();
        if (spawnReason != EntitySpawnReason.i) {
            this.a_(this.an().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.zombies || random.i() < 0.55f * specialMultiplier);
        }
        if (spawnGroupData == null) {
            spawnGroupData = new GroupDataZombie(EntityZombie.a(random), true);
        }
        if (spawnGroupData instanceof GroupDataZombie) {
            GroupDataZombie zombieGroupData = (GroupDataZombie)spawnGroupData;
            if (!this.jockeyOnlyBaby() || zombieGroupData.a) {
                this.a(zombieGroupData.a);
                if (zombieGroupData.b && (double)random.i() < this.jockeyChance()) {
                    List entitiesOfClass;
                    List<Object> list = entitiesOfClass = this.jockeyTryExistingChickens() ? level.a(EntityChicken.class, this.de().c(5.0, 3.0, 5.0), IEntitySelector.c) : Collections.emptyList();
                    if (!entitiesOfClass.isEmpty()) {
                        EntityChicken chicken = (EntityChicken)entitiesOfClass.get(0);
                        chicken.x(true);
                        this.a((Entity)chicken, false, false);
                    } else {
                        EntityChicken chicken1 = EntityTypes.B.a(this.an(), EntitySpawnReason.g);
                        if (chicken1 != null) {
                            chicken1.b(this.dK(), this.dM(), this.dQ(), this.dX(), 0.0f);
                            chicken1.a(level, difficulty, EntitySpawnReason.g, null);
                            chicken1.x(true);
                            this.a((Entity)chicken1, false, false);
                            level.addFreshEntity(chicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                        }
                    }
                }
            }
            this.y(random.i() < specialMultiplier * 0.1f);
            if (spawnReason != EntitySpawnReason.i) {
                this.a(random, difficulty);
                this.a(level, random, difficulty);
            }
        }
        if (this.a(EnumItemSlot.f).f() && EntityBat.isHalloweenSeason(level.getMinecraftWorld()) && this.as.i() < this.an().purpurConfig.chanceHeadHalloweenOnEntity) {
            this.a(EnumItemSlot.f, new ItemStack(random.i() < 0.1f ? Blocks.eK : Blocks.eJ));
            this.a(EnumItemSlot.f, 0.0f);
        }
        this.J(specialMultiplier);
        return spawnGroupData;
    }

    @VisibleForTesting
    public void b(int inWaterTime) {
        this.cJ = inWaterTime;
    }

    @VisibleForTesting
    public void c(int conversionTime) {
        this.cK = conversionTime;
    }

    public static boolean a(RandomSource random) {
        return random.i() < 0.05f;
    }

    protected void J(float difficulty) {
        this.gP();
        this.h(GenericAttributes.q).c(new AttributeModifier(EntityInsentient.cf, this.as.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d2 = this.as.j() * 1.5 * (double)difficulty;
        if (d2 > 1.0) {
            this.h(GenericAttributes.n).c(new AttributeModifier(cw, d2, AttributeModifier.Operation.c));
        }
        if (this.as.i() < difficulty * 0.05f) {
            this.h(GenericAttributes.B).c(new AttributeModifier(cv, this.as.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.h(GenericAttributes.t).c(new AttributeModifier(cv, this.as.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.y(true);
        }
    }

    protected void gP() {
        this.h(GenericAttributes.B).a(this.as.j() * this.an().purpurConfig.zombieSpawnReinforcements);
    }

    class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature mob, double speedModifier, int verticalSearchRange) {
            super(Blocks.nb, mob, speedModifier, verticalSearchRange);
        }

        @Override
        public void a(GeneratorAccess level, BlockPosition pos) {
            level.a(null, pos, SoundEffects.FN, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.as.i() * 0.2f);
        }

        @Override
        public void a(World level, BlockPosition pos) {
            level.a(null, pos, SoundEffects.CB, SoundCategory.e, 0.7f, 0.9f + level.z.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean isBaby, boolean canSpawnJockey) {
            this.a = isBaby;
            this.b = canSpawnJockey;
        }
    }
}

