/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityZombieHusk
extends EntityZombie {
    public EntityZombieHusk(EntityTypes<? extends EntityZombieHusk> type, World level) {
        super((EntityTypes<? extends EntityZombie>)type, level);
        this.setShouldBurnInDay(false);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.huskRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.huskRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.huskControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.huskMaxHealth);
    }

    @Override
    protected void gP() {
        this.h(GenericAttributes.B).a(this.as.j() * this.an().purpurConfig.huskSpawnReinforcements);
    }

    @Override
    public boolean jockeyOnlyBaby() {
        return this.an().purpurConfig.huskJockeyOnlyBaby;
    }

    @Override
    public double jockeyChance() {
        return this.an().purpurConfig.huskJockeyChance;
    }

    @Override
    public boolean jockeyTryExistingChickens() {
        return this.an().purpurConfig.huskJockeyTryExistingChickens;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.huskTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.huskAlwaysDropExp;
    }

    public static boolean a(EntityTypes<EntityZombieHusk> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return EntityZombieHusk.b(entityType, level, spawnReason, pos, random) && (EntitySpawnReason.a(spawnReason) || level.h(pos));
    }

    @Override
    public boolean ag_() {
        return this.shouldBurnInDay;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.oC;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.oF;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.oE;
    }

    @Override
    protected SoundEffect n() {
        return SoundEffects.oG;
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        boolean flag = super.c(level, target);
        if (flag && this.fq().f() && target instanceof EntityLiving) {
            float effectiveDifficulty = this.an().d_(this.dF()).b();
            ((EntityLiving)target).addEffect(new MobEffect(MobEffects.q, 140 * (int)effectiveDifficulty), this, EntityPotionEffectEvent.Cause.ATTACK);
        }
        return flag;
    }

    @Override
    protected boolean gI() {
        return true;
    }

    @Override
    protected void af_() {
        this.b(EntityTypes.bT);
        if (!this.bm()) {
            this.an().a(null, 1041, this.dF(), 0);
        }
    }
}

