/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    public static final DataWatcherObject<Boolean> a = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> f = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.t);
    private static final int ct = 3600;
    private static final int cu = 6000;
    private static final int cv = 14;
    private static final int cw = 4;
    private static final int cx = -1;
    private static final int cy = 0;
    public int cz;
    @Nullable
    public UUID cA;
    @Nullable
    private Reputation cB;
    @Nullable
    private MerchantRecipeList cC;
    private int cD = 0;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> type, World level) {
        super((EntityTypes<? extends EntityZombie>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.zombieVillagerRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.zombieVillagerRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.zombieVillagerControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.zombieVillagerMaxHealth);
    }

    @Override
    protected void gP() {
        this.h(GenericAttributes.B).a(this.as.j() * this.an().purpurConfig.zombieVillagerSpawnReinforcements);
    }

    @Override
    public boolean jockeyOnlyBaby() {
        return this.an().purpurConfig.zombieVillagerJockeyOnlyBaby;
    }

    @Override
    public double jockeyChance() {
        return this.an().purpurConfig.zombieVillagerJockeyChance;
    }

    @Override
    public boolean jockeyTryExistingChickens() {
        return this.an().purpurConfig.zombieVillagerJockeyTryExistingChickens;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.zombieVillagerTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.zombieVillagerAlwaysDropExp;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, false);
        builder.a(f, this.gT());
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("VillagerData", VillagerData.c, this.gR());
        output.b("Offers", MerchantRecipeList.a, this.cC);
        output.b("Gossips", Reputation.a, this.cB);
        output.a("ConversionTime", this.gQ() ? this.cz : -1);
        output.b("ConversionPlayer", UUIDUtil.a, this.cA);
        output.a("Xp", this.cD);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.az.a(f, input.a("VillagerData", VillagerData.c).orElseGet(this::gT));
        this.cC = input.a("Offers", MerchantRecipeList.a).orElse(null);
        this.cB = input.a("Gossips", Reputation.a).orElse(null);
        int intOr = input.a("ConversionTime", -1);
        if (intOr != -1) {
            UUID uuid = input.a("ConversionPlayer", UUIDUtil.a).orElse(null);
            this.b(uuid, intOr);
        } else {
            this.aC().a(a, false);
            this.cz = -1;
        }
        this.cD = input.a("Xp", 0);
    }

    private VillagerData gT() {
        World level = this.an();
        Optional random = BuiltInRegistries.y.a(this.as);
        VillagerData villagerData = EntityVillager.gX().a(level.L_(), VillagerType.a(level.v(this.dF())));
        if (random.isPresent()) {
            villagerData = villagerData.b(random.get());
        }
        return villagerData;
    }

    @Override
    public void g() {
        if (!this.an().D_() && this.bX() && this.gQ()) {
            int conversionProgress = this.gU();
            this.cz -= conversionProgress;
            if (this.cz <= 0) {
                this.h((WorldServer)this.an());
            }
        }
        super.g();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.rK)) {
            if (this.d(MobEffects.r) && this.an().purpurConfig.zombieVillagerCureEnabled) {
                itemInHand.a(1, (EntityLiving)player);
                if (!this.an().D_()) {
                    this.b(player.cT(), this.as.a(this.an().purpurConfig.zombieVillagerCuringTimeMax - this.an().purpurConfig.zombieVillagerCuringTimeMin + 1) + this.an().purpurConfig.zombieVillagerCuringTimeMin);
                }
                return EnumInteractionResult.b;
            }
            return EnumInteractionResult.c;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean gI() {
        return false;
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.gQ() && this.cD == 0;
    }

    public boolean gQ() {
        return this.aC().a(a);
    }

    public void b(@Nullable UUID conversionStarter, int villagerConversionTime) {
        this.startConverting(conversionStarter, villagerConversionTime, true);
    }

    public void startConverting(@Nullable UUID conversionStarter, int villagerConversionTime, boolean broadcastEntityEvent) {
        this.cA = conversionStarter;
        this.cz = villagerConversionTime;
        this.aC().a(a, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, villagerConversionTime, Math.min(this.an().aq().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        if (broadcastEntityEvent) {
            this.an().a((Entity)this, (byte)16);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 16) {
            if (!this.bm()) {
                this.an().a(this.dK(), this.dO(), this.dQ(), SoundEffects.Ga, this.dw(), 1.0f + this.as.i(), this.as.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(id);
        }
    }

    private void h(WorldServer level) {
        EntityVillager converted = this.convertTo(EntityTypes.bI, ConversionParams.a(this, false, false), (T mob) -> {
            EntityHuman playerByUuid;
            for (EnumItemSlot equipmentSlot : this.a(level, (ItemStack itemStack) -> !EnchantmentManager.a(itemStack, EnchantmentEffectComponents.E))) {
                SlotAccess slot = mob.a_(equipmentSlot.b() + 300);
                slot.a(this.a(equipmentSlot));
            }
            mob.a(this.gR());
            if (this.cB != null) {
                mob.a(this.cB);
            }
            if (this.cC != null) {
                mob.b(this.cC.a());
            }
            mob.t(this.cD);
            mob.a((WorldAccess)level, level.d_(mob.dF()), EntitySpawnReason.i, null);
            mob.h(level);
            if (this.cA != null && (playerByUuid = level.getGlobalPlayerByUUID(this.cA)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)playerByUuid, this, (EntityVillager)mob);
                level.a(ReputationEvent.a, (Entity)playerByUuid, (ReputationHandler)((Object)mob));
            }
            mob.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.bm()) {
                level.a(null, 1027, this.dF(), 0);
            }
        }, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (converted == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @Override
    @VisibleForTesting
    public void r(int villagerConversionTime) {
        this.cz = villagerConversionTime;
    }

    private int gU() {
        int i2 = 1;
        if (this.as.i() < 0.01f) {
            int i1 = 0;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i22 = (int)this.dK() - 4; i22 < (int)this.dK() + 4 && i1 < 14; ++i22) {
                for (int i3 = (int)this.dM() - 4; i3 < (int)this.dM() + 4 && i1 < 14; ++i3) {
                    for (int i4 = (int)this.dQ() - 4; i4 < (int)this.dQ() + 4 && i1 < 14; ++i4) {
                        IBlockData blockState = this.an().a_(mutableBlockPos.d(i22, i3, i4));
                        if (!blockState.a(Blocks.fC) && !(blockState.b() instanceof BlockBed)) continue;
                        if (this.as.i() < 0.3f) {
                            ++i2;
                        }
                        ++i1;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float fu() {
        return this.g_() ? (this.as.i() - this.as.i()) * 0.2f + 2.0f : (this.as.i() - this.as.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect p() {
        return SoundEffects.FY;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.Gc;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.Gb;
    }

    @Override
    public SoundEffect n() {
        return SoundEffects.Gd;
    }

    public void a(MerchantRecipeList tradeOffers) {
        this.cC = tradeOffers;
    }

    public void a(Reputation gossips) {
        this.cB = gossips;
    }

    @Override
    public void a(VillagerData data) {
        VillagerData villagerData = this.gR();
        if (!villagerData.b().equals(data.b())) {
            this.cC = null;
        }
        this.az.a(f, data);
    }

    @Override
    public VillagerData gR() {
        return this.az.a(f);
    }

    public int gS() {
        return this.cD;
    }

    public void s(int villagerXp) {
        this.cD = villagerXp;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.av ? EntityZombieVillager.c(component, this.gR().a()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.av);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.av) {
            Holder<VillagerType> holder = EntityZombieVillager.c(DataComponents.av, value);
            this.a(this.gR().a(holder));
            return true;
        }
        return super.b(component, value);
    }
}

