/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.creaking.CreakingAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Creaking
extends EntityMonster {
    private static final DataWatcherObject<Boolean> cw = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cy = DataWatcher.a(Creaking.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Optional<BlockPosition>> cz = DataWatcher.a(Creaking.class, DataWatcherRegistry.p);
    private static final int cA = 15;
    private static final int cB = 1;
    private static final float cC = 3.0f;
    private static final float cD = 32.0f;
    private static final float cE = 144.0f;
    public static final int a = 40;
    private static final float cF = 0.4f;
    public static final float b = 0.3f;
    public static final int c = 16545810;
    public static final int d = 0x5F5F5F;
    public static final int e = 8;
    public static final int f = 45;
    private static final int cG = 4;
    private int cH;
    public final AnimationState ct = new AnimationState();
    public final AnimationState cu = new AnimationState();
    public final AnimationState cv = new AnimationState();
    private int cI;
    private boolean cJ;
    private int cK;
    private int cL;

    public Creaking(EntityTypes<? extends Creaking> type, World level) {
        super((EntityTypes<? extends EntityMonster>)type, level);
        this.cm = new c(this);
        this.cn = new d(this);
        this.co = new b(this);
        Navigation groundPathNavigation = (Navigation)this.S();
        groundPathNavigation.a(true);
        this.cl = 0;
    }

    public void h(BlockPosition homePos) {
        this.i(homePos);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    public boolean k() {
        return this.gJ() != null;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.creakingRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.creakingRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.creakingControllable;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cr.a(0, new HasRider(this));
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.creakingMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.creakingScale);
    }

    @Override
    protected EntityAIBodyControl N() {
        return new a(this);
    }

    protected BehaviorController.b<Creaking> er() {
        return CreakingAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CreakingAi.b(this, this.er().a(dynamic));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cw, true);
        builder.a(cx, false);
        builder.a(cy, false);
        builder.a(cz, Optional.empty());
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gN().a(GenericAttributes.t, 1.0).a(GenericAttributes.w, 0.4f).a(GenericAttributes.c, 3.0).a(GenericAttributes.n, 32.0).a(GenericAttributes.C, 1.0625);
    }

    public boolean n() {
        return this.az.a(cw);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        if (!(target instanceof EntityLiving)) {
            return false;
        }
        this.cH = 15;
        this.an().a((Entity)this, (byte)4);
        return super.c(level, target);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        BlockPosition homePos = this.gJ();
        if (homePos == null || damageSource.a(DamageTypeTags.d)) {
            return super.a(level, damageSource, amount);
        }
        if (!this.a(level, damageSource) && this.cI <= 0 && !this.eV()) {
            CreakingHeartBlockEntity creakingHeartBlockEntity;
            EntityHuman player = this.i(damageSource);
            Entity directEntity = damageSource.c();
            if (!(directEntity instanceof EntityLiving) && !(directEntity instanceof IProjectile) && player == null) {
                return false;
            }
            this.cI = 8;
            this.an().a((Entity)this, (byte)66);
            this.c(GameEvent.u);
            TileEntity tileEntity = this.an().c_(homePos);
            if (tileEntity instanceof CreakingHeartBlockEntity && (creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity).b(this)) {
                if (player != null) {
                    creakingHeartBlockEntity.c();
                }
                this.h(damageSource);
            }
            return true;
        }
        return false;
    }

    public EntityHuman i(DamageSource damageSource) {
        this.f(damageSource);
        return this.g(damageSource);
    }

    @Override
    public boolean bU() {
        return super.bU() && this.n();
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (this.n()) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    public BehaviorController<Creaking> eq() {
        return super.eq();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("creakingBrain");
        this.eq().a((WorldServer)this.an(), this);
        profilerFiller.c();
        CreakingAi.a(this);
    }

    @Override
    public void e_() {
        if (this.cI > 0) {
            --this.cI;
        }
        if (this.cH > 0) {
            --this.cH;
        }
        if (!this.an().D_()) {
            boolean flag = this.az.a(cw);
            boolean flag1 = this.gQ();
            if (flag1 != flag) {
                this.c(GameEvent.u);
                if (flag1) {
                    this.b(SoundEffects.gY);
                } else {
                    this.aa();
                    this.b(SoundEffects.gX);
                }
            }
            this.az.a(cw, flag1);
        }
        super.e_();
    }

    @Override
    public void g() {
        BlockPosition homePos;
        if (!this.an().D_() && (homePos = this.gJ()) != null) {
            CreakingHeartBlockEntity creakingHeartBlockEntity;
            boolean flag;
            TileEntity tileEntity = this.an().c_(homePos);
            boolean bl = flag = tileEntity instanceof CreakingHeartBlockEntity && (creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity).b(this);
            if (!flag) {
                this.x(0.0f);
            }
        }
        super.g();
        if (this.an().D_()) {
            this.gT();
            this.gP();
        }
    }

    @Override
    protected void eC() {
        if (this.k() && this.gL()) {
            ++this.bv;
            if (!this.an().D_() && this.bv > 45 && !this.ec()) {
                this.s();
            }
        } else {
            super.eC();
        }
    }

    @Override
    protected void A(float partialTick) {
        float min = Math.min(partialTick * 25.0f, 3.0f);
        this.bz.a(min, 0.4f, 1.0f);
    }

    private void gT() {
        this.ct.a(this.cH > 0, this.at);
        this.cu.a(this.cI > 0, this.at);
        this.cv.a(this.gL(), this.at);
    }

    public void s() {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            AxisAlignedBB boundingBox = this.de();
            Vec3D center = boundingBox.f();
            double d2 = boundingBox.b() * 0.3;
            double d1 = boundingBox.c() * 0.3;
            double d22 = boundingBox.d() * 0.3;
            serverLevel.a(new ParticleParamBlock(Particles.bj, Blocks.u.m()), center.g, center.h, center.i, 100, d2, d1, d22, 0.0);
            serverLevel.a(new ParticleParamBlock(Particles.bj, (IBlockData)Blocks.cQ.m().b(CreakingHeartBlock.c, CreakingHeartState.c)), center.g, center.h, center.i, 10, d2, d1, d22, 0.0);
        }
        this.b(this.f_());
        this.remove(Entity.RemovalReason.b, null);
    }

    public void j(DamageSource damageSource) {
        this.i(damageSource);
        this.a(damageSource);
        this.b(SoundEffects.hb);
    }

    @Override
    public void b(byte id) {
        if (id == 66) {
            this.cI = 8;
            this.h(this.ei().p());
        } else if (id == 4) {
            this.cH = 15;
            this.gB();
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean bt() {
        return this.k() || super.bt();
    }

    @Override
    protected boolean s(Entity passenger) {
        return !this.k() && super.s(passenger);
    }

    @Override
    protected boolean cc() {
        return !this.k() && super.cc();
    }

    @Override
    protected void q(Entity passenger) {
        if (this.k()) {
            throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
        }
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return !this.k() && super.o(allowPassengers);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new e(this, level);
    }

    public boolean gI() {
        List list = this.bY.c(MemoryModuleType.j).orElse(List.of());
        if (list.isEmpty()) {
            this.cL = 0;
            return false;
        }
        AxisAlignedBB boundingBox = this.de();
        for (EntityHuman player : list) {
            if (!boundingBox.d(player.bR())) continue;
            ++this.cL;
            return this.cL > 4;
        }
        this.cL = 0;
        return false;
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        input.a("home_pos", BlockPosition.a).ifPresent(this::h);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.b("home_pos", BlockPosition.a, this.gJ());
    }

    public void i(BlockPosition homePos) {
        this.az.a(cz, Optional.of(homePos));
    }

    @Nullable
    public BlockPosition gJ() {
        return this.az.a(cz).orElse(null);
    }

    public void gK() {
        this.az.a(cy, true);
    }

    public boolean gL() {
        return this.az.a(cy);
    }

    public boolean gO() {
        return this.cJ;
    }

    public void gP() {
        if (this.bv > this.cK) {
            this.cK = this.bv + this.ek().a(this.cJ ? 2 : this.bv / 4, this.cJ ? 8 : this.bv / 2);
            this.cJ = !this.cJ;
        }
    }

    @Override
    public void gB() {
        this.b(SoundEffects.gU);
    }

    @Override
    public SoundEffect p() {
        return this.gS() ? null : SoundEffects.gR;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return this.k() ? SoundEffects.ha : super.e(damageSource);
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.gV;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.gW, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.U();
    }

    @Override
    public void knockback(double strength, double x2, double z2, @Nullable Entity attacker, EntityKnockbackEvent.Cause cause) {
        if (this.n()) {
            super.knockback(strength, x2, z2, attacker, cause);
        }
    }

    public boolean gQ() {
        List list = this.bY.c(MemoryModuleType.j).orElse(List.of());
        boolean isActive = this.gS();
        if (list.isEmpty()) {
            if (isActive) {
                this.gR();
            }
            return true;
        }
        boolean flag = false;
        for (EntityHuman player : list) {
            if (!this.c((EntityLiving)player) || this.t(player)) continue;
            flag = true;
            if (isActive && !EntityLiving.bn.test(player) || !this.a(player, 0.5, false, true, this.dO(), this.dM() + 0.5 * (double)this.eA(), (this.dO() + this.dM()) / 2.0)) continue;
            if (isActive) {
                return false;
            }
            if (!(player.g(this) < 144.0)) continue;
            this.g(player);
            return false;
        }
        if (!flag && isActive) {
            this.gR();
        }
        return true;
    }

    public void g(EntityHuman player) {
        this.eq().a(MemoryModuleType.p, player);
        this.c(GameEvent.u);
        this.b(SoundEffects.gS);
        this.x(true);
    }

    public void gR() {
        this.eq().b(MemoryModuleType.p);
        this.c(GameEvent.u);
        this.b(SoundEffects.gT);
        this.x(false);
    }

    public void x(boolean isActive) {
        this.az.a(cx, isActive);
    }

    public boolean gS() {
        return this.az.a(cx);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    class c
    extends LookControllerWASD {
        public c(Creaking mob) {
            super(mob);
        }

        @Override
        public void vanillaTick() {
            if (Creaking.this.n()) {
                super.vanillaTick();
            }
        }
    }

    class d
    extends MoveControllerWASD {
        public d(Creaking mob) {
            super(mob);
        }

        @Override
        public void vanillaTick() {
            if (Creaking.this.n()) {
                super.vanillaTick();
            }
        }
    }

    class b
    extends ControllerJump {
        public b(Creaking mob) {
            super(mob);
        }

        @Override
        public void b() {
            if (Creaking.this.n()) {
                super.b();
            } else {
                Creaking.this.t(false);
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Creaking mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (Creaking.this.n()) {
                super.a();
            }
        }
    }

    class e
    extends Navigation {
        e(Creaking mob, World level) {
            super(mob, level);
        }

        @Override
        public void d() {
            if (Creaking.this.n()) {
                super.d();
            }
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new f();
            this.o.a(true);
            return new Pathfinder(this.o, maxVisitedNodes);
        }
    }

    class f
    extends PathfinderNormal {
        private static final int m = 1024;

        f() {
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            BlockPosition homePos = Creaking.this.gJ();
            if (homePos == null) {
                return super.a(context, x2, y2, z2);
            }
            double d2 = homePos.j(new BaseBlockPosition(x2, y2, z2));
            return d2 > 1024.0 && d2 >= homePos.j(context.b()) ? PathType.a : super.a(context, x2, y2, z2);
        }
    }
}

