/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final int cy = 40;
    private static final float cz = 0.3f;
    private static final int cA = 1;
    private static final float cB = 0.6f;
    private static final int cC = 6;
    private static final float cD = 0.5f;
    private static final boolean cE = false;
    private static final int cF = 0;
    private static final boolean cG = false;
    public static final int ct = 300;
    private int cH;
    public int cI = 0;
    public boolean cJ = false;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> cu = ImmutableList.of(SensorType.c, SensorType.d, SensorType.o, SensorType.n);
    protected static final ImmutableList<? extends MemoryModuleType<?>> cv = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.au, (Object[])new MemoryModuleType[]{MemoryModuleType.A, MemoryModuleType.aw, MemoryModuleType.ax, MemoryModuleType.at, MemoryModuleType.L, MemoryModuleType.aA, MemoryModuleType.aB, MemoryModuleType.aa});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cl = 5;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.hoglinRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.hoglinRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.hoglinControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.hoglinMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.hoglinScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.an().purpurConfig.hoglinBreedingTicks;
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.hoglinTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.hoglinAlwaysDropExp;
    }

    @VisibleForTesting
    public void s(int timeInOverworld) {
        this.cI = timeInOverworld;
    }

    @Override
    public boolean v() {
        return true;
    }

    public static AttributeProvider.Builder m() {
        return EntityMonster.gN().a(GenericAttributes.t, 40.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.q, 0.6f).a(GenericAttributes.d, 1.0).a(GenericAttributes.c, 6.0);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        if (target instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)target;
            this.cH = 10;
            this.an().a((Entity)this, (byte)4);
            this.b(SoundEffects.nS);
            HoglinAI.a(this, livingEntity);
            return IOglin.a(level, this, livingEntity);
        }
        return false;
    }

    @Override
    protected void d(EntityLiving entity) {
        if (this.n()) {
            IOglin.a(this, entity);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            HoglinAI.a(level, this, livingEntity);
        }
        return flag;
    }

    protected BehaviorController.b<EntityHoglin> er() {
        return BehaviorController.a(cv, cu);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.er().a(dynamic));
    }

    public BehaviorController<EntityHoglin> eq() {
        return super.eq();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("hoglinBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        HoglinAI.a(this);
        if (this.gI()) {
            ++this.cI;
            if (this.cI > 300) {
                this.b(SoundEffects.nT);
                this.gK();
            }
        } else {
            this.cI = 0;
        }
    }

    @Override
    public void e_() {
        if (this.cH > 0) {
            --this.cH;
        }
        super.e_();
    }

    @Override
    protected void h() {
        if (this.g_()) {
            this.cl = 3;
            this.h(GenericAttributes.c).a(0.5);
        } else {
            this.cl = 5;
            this.h(GenericAttributes.c).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (EntityMonster.canSpawnInBlueAndPackedIce(level, pos)) {
            return false;
        }
        return !level.a_(pos.e()).a(Blocks.lG);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (level.I_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.gr();
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (HoglinAI.a(this, pos)) {
            return -1.0f;
        }
        return level.a_(pos.e()).a(Blocks.pu) ? 10.0f : 0.0f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            this.gq();
        }
        return interactionResult;
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.cH = 10;
            this.b(SoundEffects.nS);
        } else {
            super.b(id);
        }
    }

    @Override
    public int s() {
        return this.cH;
    }

    @Override
    public boolean eD() {
        return true;
    }

    @Override
    protected int f(WorldServer level) {
        return this.cl;
    }

    private void gK() {
        EntityZoglin converted = this.convertTo(EntityTypes.bS, ConversionParams.a(this, true, false), (T mob) -> mob.a(new MobEffect(MobEffects.i, 200, 0)), EntityTransformEvent.TransformReason.PIGLIN_ZOMBIFIED, CreatureSpawnEvent.SpawnReason.PIGLIN_ZOMBIFIED);
        if (converted == null) {
            this.cI = 0;
        }
    }

    @Override
    public boolean i(ItemStack stack) {
        return stack.a(TagsItem.aS);
    }

    public boolean n() {
        return !this.g_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cx, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsImmuneToZombification", this.gL());
        output.a("TimeInOverworld", this.cI);
        output.a("CannotBeHunted", this.cJ);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("IsImmuneToZombification", false));
        this.cI = input.a("TimeInOverworld", 0);
        this.y(input.a("CannotBeHunted", false));
    }

    public void x(boolean immuneToZombification) {
        this.aC().a(cx, immuneToZombification);
    }

    public boolean gL() {
        return this.aC().a(cx);
    }

    public boolean gI() {
        return !this.an().H_().b() && !this.gL() && !this.gx();
    }

    private void y(boolean cannotBeHunted) {
        this.cJ = cannotBeHunted;
    }

    public boolean gJ() {
        return this.n() && !this.cJ;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        EntityHoglin hoglin = EntityTypes.an.a(level, EntitySpawnReason.e);
        if (hoglin != null) {
            hoglin.gq();
        }
        return hoglin;
    }

    @Override
    public boolean gP() {
        return !HoglinAI.c(this) && super.gP();
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    public SoundEffect p() {
        return this.an().D_() ? null : (SoundEffect)HoglinAI.b(this).orElse(null);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.nV;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.nU;
    }

    @Override
    public SoundEffect bg() {
        return SoundEffects.oB;
    }

    @Override
    public SoundEffect bh() {
        return SoundEffects.oA;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.nX, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.U();
    }
}

