/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> ct = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cu = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cv = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey cw = MinecraftKey.b("baby");
    private static final AttributeModifier cx = new AttributeModifier(cw, 0.2f, AttributeModifier.Operation.b);
    private static final int cy = 16;
    private static final float cz = 0.35f;
    private static final int cA = 5;
    private static final float cB = 0.1f;
    private static final int cC = 3;
    private static final float cD = 0.2f;
    private static final EntitySize cE = EntityTypes.aW.n().a(0.5f).b(0.97f);
    private static final double cF = 0.5;
    private static final boolean cG = false;
    private static final boolean cH = false;
    public final InventorySubcontainer cI = new InventorySubcontainer(8);
    public boolean cJ = false;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> d = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> e = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.w, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.as, MemoryModuleType.ar, MemoryModuleType.M, MemoryModuleType.aT, MemoryModuleType.y, MemoryModuleType.z, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.u, MemoryModuleType.af, MemoryModuleType.ag, MemoryModuleType.A, MemoryModuleType.ah, MemoryModuleType.ai, MemoryModuleType.ak, MemoryModuleType.aj, MemoryModuleType.am, MemoryModuleType.an, MemoryModuleType.al, MemoryModuleType.ap, MemoryModuleType.N, MemoryModuleType.av, MemoryModuleType.t, MemoryModuleType.aw, MemoryModuleType.ax, MemoryModuleType.ao, MemoryModuleType.aq, MemoryModuleType.ay, MemoryModuleType.az, MemoryModuleType.aA});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();
    private static final Codec<Set<Item>> ITEM_SET_CODEC = BuiltInRegistries.h.q().listOf().xmap(HashSet::new, List::copyOf);

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> type, World level) {
        super(type, level);
        this.cl = 5;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.piglinRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.piglinRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.piglinControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.piglinMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.piglinScale);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.piglinTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.piglinAlwaysDropExp;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsBaby", this.g_());
        output.a("CannotHunt", this.cJ);
        this.b_(output);
        output.a("Bukkit.BarterList", ITEM_SET_CODEC, this.allowedBarterItems);
        output.a("Bukkit.InterestList", ITEM_SET_CODEC, this.interestItems);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("IsBaby", false));
        this.z(input.a("CannotHunt", false));
        this.a_(input);
        this.allowedBarterItems = input.a("Bukkit.BarterList", ITEM_SET_CODEC).orElseGet(HashSet::new);
        this.interestItems = input.a("Bukkit.InterestList", ITEM_SET_CODEC).orElseGet(HashSet::new);
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer n() {
        return this.cI;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        this.cI.g().forEach(itemStack -> this.a(level, (ItemStack)itemStack));
    }

    protected ItemStack i(ItemStack stack) {
        return this.cI.b(stack);
    }

    protected boolean j(ItemStack stack) {
        return this.cI.c(stack);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ct, false);
        builder.a(cu, false);
        builder.a(cv, false);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (ct.equals(key)) {
            this.l_();
        }
    }

    public static AttributeProvider.Builder gO() {
        return EntityMonster.gN().a(GenericAttributes.t, 16.0).a(GenericAttributes.w, 0.35f).a(GenericAttributes.c, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        if (EntityPiglin.canSpawnInBlueAndPackedIce(level, pos)) {
            return false;
        }
        return !level.a_(pos.e()).a(Blocks.lG);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.I_();
        if (spawnReason != EntitySpawnReason.d) {
            if (random.i() < 0.2f) {
                this.a(true);
            } else if (this.gI()) {
                this.a(EnumItemSlot.a, this.gQ());
            }
        }
        PiglinAI.a(this, level.I_());
        this.a(random, difficulty);
        this.a(level, random, difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.gr();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (this.gI()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.ry), random);
            this.a(EnumItemSlot.e, new ItemStack(Items.rz), random);
            this.a(EnumItemSlot.d, new ItemStack(Items.rA), random);
            this.a(EnumItemSlot.c, new ItemStack(Items.rB), random);
        }
    }

    private void a(EnumItemSlot slot, ItemStack stack, RandomSource random) {
        if (random.i() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> er() {
        return BehaviorController.a(e, d);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.er().a(dynamic));
    }

    public BehaviorController<EntityPiglin> eq() {
        return super.eq();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            return interactionResult;
        }
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            return PiglinAI.a(serverLevel, this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.gJ() != EntityPiglinArmPose.d;
        return (EnumInteractionResult)((Object)(flag ? EnumInteractionResult.a : EnumInteractionResult.e));
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.g_() ? cE : super.b(pose);
    }

    @Override
    public void a(boolean childZombie) {
        this.aC().a(ct, childZombie);
        if (!this.an().D_()) {
            AttributeModifiable attribute = this.h(GenericAttributes.w);
            attribute.c(cx.a());
            if (childZombie) {
                attribute.b(cx);
            }
        }
    }

    @Override
    public boolean g_() {
        return this.aC().a(ct);
    }

    private void z(boolean cannotHunt) {
        this.cJ = cannotHunt;
    }

    @Override
    protected boolean k() {
        return !this.cJ;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("piglinBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        PiglinAI.a(this);
        super.a(level);
    }

    @Override
    protected int f(WorldServer level) {
        return this.cl;
    }

    @Override
    protected void h(WorldServer level) {
        PiglinAI.a(level, this);
        this.forceDrops = true;
        this.cI.g().forEach(itemStack -> this.a(level, (ItemStack)itemStack));
        this.forceDrops = false;
        super.h(level);
    }

    private ItemStack gQ() {
        return (double)this.as.i() < 0.5 ? new ItemStack(Items.yi) : new ItemStack(Items.qC);
    }

    @Override
    @Nullable
    public TagKey<Item> ac() {
        return this.g_() ? null : TagsItem.cj;
    }

    public boolean gR() {
        return this.az.a(cu);
    }

    @Override
    public void b(boolean isCharging) {
        this.az.a(cu, isCharging);
    }

    @Override
    public void a() {
        this.bJ = 0;
    }

    @Override
    public EntityPiglinArmPose gJ() {
        if (this.gP()) {
            return EntityPiglinArmPose.e;
        }
        if (PiglinAI.a(this.fr())) {
            return EntityPiglinArmPose.d;
        }
        if (this.gz() && this.gK()) {
            return EntityPiglinArmPose.a;
        }
        if (this.gR()) {
            return EntityPiglinArmPose.c;
        }
        return this.b(Items.yi) && ItemCrossbow.g(this.el()) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f;
    }

    public boolean gP() {
        return this.az.a(cv);
    }

    public void y(boolean dancing) {
        this.az.a(cv, dancing);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag = super.a(level, damageSource, amount);
        if (flag && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            PiglinAI.a(level, this, livingEntity);
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon projectileWeapon) {
        return projectileWeapon == Items.yi;
    }

    protected void k(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void l(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.h())) {
            this.a(EnumItemSlot.b, stack);
            this.g(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        return level.S().getBoolean(GameRules.d, level.purpurConfig.piglinMobGriefingOverride) && this.gc() && PiglinAI.a(this, stack);
    }

    protected boolean m(ItemStack candidate) {
        EnumItemSlot equipmentSlotForItem = this.f(candidate);
        ItemStack itemBySlot = this.a(equipmentSlotForItem);
        return this.a(candidate, itemBySlot, equipmentSlotForItem);
    }

    @Override
    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (EnchantmentManager.a(currentItem, EnchantmentEffectComponents.E)) {
            return false;
        }
        TagKey<Item> preferredWeaponType = this.ac();
        boolean flag = PiglinAI.isLovedItem(newItem, this) || preferredWeaponType != null && newItem.a(preferredWeaponType);
        boolean flag1 = PiglinAI.isLovedItem(currentItem, this) || preferredWeaponType != null && currentItem.a(preferredWeaponType);
        return flag && !flag1 || (flag || !flag1) && super.a(newItem, currentItem, slot);
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        PiglinAI.a(level, this, entity);
    }

    @Override
    public boolean a(Entity entity, boolean force, boolean triggerEvents) {
        if (this.g_() && entity.ax() == EntityTypes.an) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, force, triggerEvents);
    }

    private Entity b(Entity vehicle, int maxPosition) {
        List<Entity> passengers = vehicle.di();
        return maxPosition != 1 && !passengers.isEmpty() ? this.b(passengers.getFirst(), maxPosition - 1) : vehicle;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return this.an().D_() ? null : (SoundEffect)PiglinAI.b(this).orElse(null);
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.vE;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.vC;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.vG, 0.15f, 1.0f);
    }

    @Override
    protected void gL() {
        this.b(SoundEffects.vH);
    }
}

