/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final int ct = 40;
    private static final int cu = 200;
    private static final int cv = 500;
    private static final float cw = 0.3f;
    private static final float cx = 1.0f;
    private static final float cy = 1.5f;
    private static final int cz = 30;
    private static final int cA = 24;
    private static final DataWatcherObject<Integer> cB = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int cC = 200;
    private static final int cD = 260;
    private static final int cE = 20;
    private static final int cF = 120;
    private static final int cG = 20;
    private static final int cH = 35;
    private static final int cI = 10;
    private static final int cJ = 20;
    private static final int cK = 100;
    private static final int cL = 20;
    private static final int cM = 30;
    private static final float cN = 4.5f;
    private static final float cO = 0.7f;
    private static final int cP = 30;
    private int cS;
    private int cT;
    private int cU;
    private int cV;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState f = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cW;
    private final VibrationSystem.d cX;
    private VibrationSystem.a cY;
    AngerManagement cZ = new AngerManagement(this::G, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> type, World level) {
        super(type, level);
        this.cX = new a();
        this.cY = new VibrationSystem.a();
        this.cW = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
        this.cl = 5;
        this.S().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
        this.cn = new MoveControllerWASD(this, 0.5);
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.wardenRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.wardenRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.wardenControllable;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        this.cr.a(0, new HasRider(this));
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        return new PacketPlayOutSpawnEntity((Entity)this, entity, this.d(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (packet.n() == 1) {
            this.c(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader level) {
        return super.a(level) && level.a((Entity)this, this.ax().n().a(this.dD()));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.gL() && !damageSource.a(DamageTypeTags.d) || super.a(level, damageSource);
    }

    boolean gL() {
        return this.d(EntityPose.o) || this.d(EntityPose.n);
    }

    @Override
    protected boolean p(Entity vehicle) {
        return false;
    }

    @Override
    public float gj() {
        return 5.0f;
    }

    @Override
    protected float bf() {
        return this.al + 0.55f;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gN().a(GenericAttributes.t, 500.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.q, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0).a(GenericAttributes.n, 24.0);
    }

    @Override
    public boolean bs() {
        return true;
    }

    @Override
    public float ft() {
        return 4.0f;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return !this.d(EntityPose.l) && !this.gL() ? this.n().b() : null;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.Eh;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.Ed;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.Er, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        level.a((Entity)this, (byte)4);
        this.a(SoundEffects.Ec, 10.0f, this.fu());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(level, target);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cB, 0);
    }

    public int m() {
        return this.az.a(cB);
    }

    private void gO() {
        this.az.a(cB, this.gR());
    }

    @Override
    public void g() {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            VibrationSystem.c.a((World)serverLevel, this.cY, this.cX);
            if (this.gr() || this.ae()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.g();
        if (this.an().D_()) {
            if (this.at % this.gP() == 0) {
                this.cU = 10;
                if (!this.bm()) {
                    this.an().a(this.dK(), this.dM(), this.dQ(), SoundEffects.Eg, this.dw(), 5.0f, this.fu(), false);
                }
            }
            this.cT = this.cS;
            if (this.cS > 0) {
                --this.cS;
            }
            this.cV = this.cU;
            if (this.cU > 0) {
                --this.cU;
            }
            switch (this.aE()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("wardenBrain");
        if (this.getRider() == null || !this.isControllable()) {
            this.eq().a(level, this);
        }
        profilerFiller.c();
        super.a(level);
        if ((this.at + this.az()) % 120 == 0) {
            Warden.a(level, this.dD(), this, 20);
        }
        if (this.at % 20 == 0) {
            this.cZ.a(level, this::G);
            this.gO();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.a.a();
            this.e.a(this.at);
        } else if (id == 61) {
            this.cS = 10;
        } else if (id == 62) {
            this.f.a(this.at);
        } else {
            super.b(id);
        }
    }

    private int gP() {
        float f2 = (float)this.m() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float J(float partialTick) {
        return MathHelper.h(partialTick, this.cT, this.cS) / 10.0f;
    }

    public float K(float partialTick) {
        return MathHelper.h(partialTick, this.cV, this.cU) / 10.0f;
    }

    private void a(AnimationState animationState) {
        if ((float)animationState.a((float)this.at) < 4500.0f) {
            RandomSource random = this.ek();
            IBlockData blockStateOn = this.bG();
            if (blockStateOn.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d2 = this.dK() + (double)MathHelper.b(random, -0.7f, 0.7f);
                    double y2 = this.dM();
                    double d1 = this.dQ() + (double)MathHelper.b(random, -0.7f, 0.7f);
                    this.an().a(new ParticleParamBlock(Particles.b, blockStateOn), d2, y2, d1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (Entity.aE.equals(key)) {
            switch (this.aE()) {
                case n: {
                    this.c.a(this.at);
                    break;
                }
                case o: {
                    this.d.a(this.at);
                    break;
                }
                case l: {
                    this.a.a(this.at);
                    break;
                }
                case m: {
                    this.b.a(this.at);
                }
            }
        }
        super.a(key);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gL();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> eq() {
        return super.eq();
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            listenerConsumer.accept(this.cW, serverLevel);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean G(@Nullable Entity entity) {
        if (this.getRider() != null && this.isControllable()) {
            return false;
        }
        if (!(entity instanceof EntityLiving)) return false;
        EntityLiving livingEntity = (EntityLiving)entity;
        if (this.an() != entity.an()) return false;
        if (!IEntitySelector.e.test(entity)) return false;
        if (this.t(entity)) return false;
        if (livingEntity.ax() == EntityTypes.h) return false;
        if (livingEntity.ax() == EntityTypes.bL) return false;
        if (livingEntity.cP()) return false;
        if (livingEntity.eV()) return false;
        if (!this.an().u().a(livingEntity.de())) return false;
        return true;
    }

    public static void a(WorldServer level, Vec3D pos, @Nullable Entity source, int radius) {
        MobEffect mobEffectInstance = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(level, source, pos, radius, mobEffectInstance, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("anger", AngerManagement.a(this::G), this.cZ);
        output.a("listener", VibrationSystem.a.a, this.cY);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cZ = input.a("anger", AngerManagement.a(this::G)).orElseGet(() -> new AngerManagement(this::G, Collections.emptyList()));
        this.gO();
        this.cY = input.a("listener", VibrationSystem.a.a).orElseGet(VibrationSystem.a::new);
    }

    private void gQ() {
        if (!this.d(EntityPose.l)) {
            this.a(this.n().c(), 10.0f, this.fu());
        }
    }

    public AngerLevel n() {
        return AngerLevel.a(this.gR());
    }

    private int gR() {
        return this.cZ.b(this.e());
    }

    public void H(Entity entity) {
        this.cZ.a(entity);
    }

    public void I(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int offset, boolean playListeningSound) {
        if (!this.gx() && this.G(entity)) {
            int activeAnger = this.cZ.b(entity);
            WardenAngerChangeEvent event = new WardenAngerChangeEvent((org.bukkit.entity.Warden)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), activeAnger, Math.min(150, activeAnger + offset));
            this.an().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            offset = event.getNewAnger() - activeAnger;
            WardenAi.a((EntityLiving)this);
            boolean flag = !(this.e() instanceof EntityHuman);
            int i2 = this.cZ.a(entity, offset);
            if (entity instanceof EntityHuman && flag && AngerLevel.a(i2).d()) {
                this.eq().b(MemoryModuleType.p);
            }
            if (playListeningSound) {
                this.gQ();
            }
        }
    }

    public Optional<EntityLiving> s() {
        return this.n().d() ? this.cZ.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.U();
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.eq().a(MemoryModuleType.aI, Unit.a, 1200L);
        if (spawnReason == EntitySpawnReason.k) {
            this.c(EntityPose.n);
            this.eq().a(MemoryModuleType.aG, Unit.a, WardenAi.a);
            this.a(SoundEffects.DZ, 5.0f, 1.0f);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (!this.gx() && !this.gL()) {
            Entity entity = damageSource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bY.c(MemoryModuleType.p).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                if (damageSource.b() || this.a((Entity)livingEntity, 5.0)) {
                    this.i(livingEntity);
                }
            }
        }
        return flag;
    }

    public void i(EntityLiving attackTarget) {
        this.eq().b(MemoryModuleType.aC);
        this.eq().a(MemoryModuleType.p, attackTarget);
        this.eq().b(MemoryModuleType.F);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        EntitySize entityDimensions = super.b(pose);
        return this.gL() ? EntitySize.c(entityDimensions.a(), 1.0f) : entityDimensions;
    }

    @Override
    public boolean bU() {
        return !this.gL() && super.bU();
    }

    @Override
    protected void E(Entity entity) {
        if (!this.gx() && !this.eq().a(MemoryModuleType.aL)) {
            this.eq().a(MemoryModuleType.aL, Unit.a, 20L);
            this.I(entity);
            WardenAi.a(this, entity.dF());
        }
        super.E(entity);
    }

    @VisibleForTesting
    public AngerManagement gI() {
        return this.cZ;
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new Navigation(this, this, level){

            @Override
            protected Pathfinder a(int maxVisitedNodes) {
                this.o = new PathfinderNormal();
                return new Pathfinder(this, this.o, maxVisitedNodes){

                    @Override
                    protected float a(PathPoint first, PathPoint second) {
                        return first.b(second);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gJ() {
        return this.cY;
    }

    @Override
    public VibrationSystem.d gK() {
        return this.cX;
    }

    class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.df());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, GameEvent.a context) {
            EntityLiving livingEntity;
            Entity entity;
            return !Warden.this.gx() && !Warden.this.eV() && !Warden.this.eq().a(MemoryModuleType.aM) && !Warden.this.gL() && level.u().a(pos) && (!((entity = context.a()) instanceof EntityLiving) || Warden.this.G(livingEntity = (EntityLiving)entity));
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            if (!Warden.this.eV()) {
                Warden.this.bY.a(MemoryModuleType.aM, Unit.a, 40L);
                level.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.Es, 5.0f, Warden.this.fu());
                BlockPosition blockPos = pos;
                if (playerEntity != null) {
                    if (Warden.this.a(playerEntity, 30.0)) {
                        if (Warden.this.eq().a(MemoryModuleType.aE)) {
                            if (Warden.this.G(playerEntity)) {
                                blockPos = playerEntity.dF();
                            }
                            Warden.this.I(playerEntity);
                        } else {
                            Warden.this.a(playerEntity, 10, true);
                        }
                    }
                    Warden.this.eq().a(MemoryModuleType.aE, Unit.a, 100L);
                } else {
                    Warden.this.I(entity);
                }
                if (!Warden.this.n().d()) {
                    Optional<EntityLiving> activeEntity = Warden.this.cZ.a();
                    if (playerEntity != null || activeEntity.isEmpty() || activeEntity.get() == entity) {
                        WardenAi.a(Warden.this, blockPos);
                    }
                }
            }
        }
    }
}

