/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class WardenSpawnTracker {
    public static final Codec<WardenSpawnTracker> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.o.fieldOf("ticks_since_last_warning").orElse((Object)0).forGetter(wardenSpawnTracker -> wardenSpawnTracker.g), (App)ExtraCodecs.o.fieldOf("warning_level").orElse((Object)0).forGetter(wardenSpawnTracker -> wardenSpawnTracker.h), (App)ExtraCodecs.o.fieldOf("cooldown_ticks").orElse((Object)0).forGetter(wardenSpawnTracker -> wardenSpawnTracker.i)).apply((Applicative)instance, WardenSpawnTracker::new));
    public static final int b = 4;
    private static final double c = 16.0;
    private static final int d = 48;
    private static final int e = 12000;
    private static final int f = 200;
    public int g;
    private int h;
    public int i;

    public WardenSpawnTracker(int ticksSinceLastWarning, int warningLevel, int cooldownTicks) {
        this.g = ticksSinceLastWarning;
        this.h = warningLevel;
        this.i = cooldownTicks;
    }

    public WardenSpawnTracker() {
        this(0, 0, 0);
    }

    public void a() {
        if (this.g >= 12000) {
            this.f();
            this.g = 0;
        } else {
            ++this.g;
        }
        if (this.i > 0) {
            --this.i;
        }
    }

    public void b() {
        this.g = 0;
        this.h = 0;
        this.i = 0;
    }

    public static OptionalInt a(WorldServer level, BlockPosition pos, EntityPlayer player) {
        if (WardenSpawnTracker.a(level, pos)) {
            return OptionalInt.empty();
        }
        List<EntityPlayer> nearbyPlayers = WardenSpawnTracker.b(level, pos);
        if (!nearbyPlayers.contains(player)) {
            nearbyPlayers.add(player);
        }
        if (nearbyPlayers.stream().anyMatch(serverPlayer -> serverPlayer.ab().map(WardenSpawnTracker::d).orElse(false))) {
            return OptionalInt.empty();
        }
        Optional<WardenSpawnTracker> optional = nearbyPlayers.stream().flatMap(serverPlayer -> serverPlayer.ab().stream()).max(Comparator.comparingInt(WardenSpawnTracker::c));
        if (optional.isPresent()) {
            WardenSpawnTracker wardenSpawnTracker = optional.get();
            wardenSpawnTracker.e();
            nearbyPlayers.forEach(serverPlayer -> serverPlayer.ab().ifPresent(wardenSpawnTracker1 -> wardenSpawnTracker1.a(wardenSpawnTracker)));
            return OptionalInt.of(wardenSpawnTracker.h);
        }
        return OptionalInt.empty();
    }

    private boolean d() {
        return this.i > 0;
    }

    private static boolean a(WorldServer level, BlockPosition pos) {
        AxisAlignedBB aabb = AxisAlignedBB.a(Vec3D.b(pos), 48.0, 48.0, 48.0);
        return !level.a(Warden.class, aabb).isEmpty();
    }

    private static List<EntityPlayer> b(WorldServer level, BlockPosition pos) {
        Vec3D vec3 = Vec3D.b(pos);
        return level.a((? super EntityPlayer serverPlayer) -> !serverPlayer.at() && serverPlayer.dD().a((IPosition)vec3, 16.0) && serverPlayer.bX());
    }

    public void e() {
        if (!this.d()) {
            this.g = 0;
            this.i = 200;
            this.a(this.c() + 1);
        }
    }

    private void f() {
        this.a(this.c() - 1);
    }

    public void a(int warningLevel) {
        this.h = MathHelper.a(warningLevel, 0, 4);
    }

    public int c() {
        return this.h;
    }

    private void a(WardenSpawnTracker other) {
        this.h = other.h;
        this.i = other.i;
        this.g = other.g;
    }
}

