/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockCobbleWall;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.purpurmc.purpur.entity.ai.HasRider;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger cz = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> cA = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.t);
    public static final int cv = 12;
    public static final Map<Item, Integer> cw = ImmutableMap.of((Object)Items.rd, (Object)4, (Object)Items.wo, (Object)1, (Object)Items.wn, (Object)1, (Object)Items.xu, (Object)1);
    private static final int cB = 2;
    private static final int cC = 10;
    private static final int cD = 1200;
    private static final int cE = 24000;
    private static final int cF = 10;
    private static final int cG = 5;
    private static final long cH = 24000L;
    @VisibleForTesting
    public static final float cx = 0.5f;
    private static final int cI = 0;
    private static final byte cJ = 0;
    private static final int cK = 0;
    private static final int cL = 0;
    private static final int cM = 0;
    private static final boolean cN = false;
    private int cO;
    private boolean cP;
    @Nullable
    private EntityHuman cS;
    private boolean cT;
    private int cU = 0;
    private final Reputation cV = new Reputation();
    private long cW;
    private long cX = 0L;
    private int cY = 0;
    private long cZ = 0L;
    public int da = 0;
    private long db;
    private boolean dc = false;
    private static final ImmutableList<MemoryModuleType<?>> dd = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.M, MemoryModuleType.aT, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.o, MemoryModuleType.r, MemoryModuleType.s, MemoryModuleType.u, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.B, MemoryModuleType.f, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.F, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.K, MemoryModuleType.G});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> de = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> cy = ImmutableMap.of(MemoryModuleType.b, (villager, poiType) -> poiType.a(PoiTypes.n), MemoryModuleType.c, (villager, poiType) -> villager.gR().b().a().b().test((Holder<VillagePlaceType>)poiType), MemoryModuleType.d, (villager, poiType) -> VillagerProfession.a.test((Holder<VillagePlaceType>)poiType), MemoryModuleType.e, (villager, poiType) -> poiType.a(PoiTypes.o));
    private boolean isLobotomized = false;
    private int notLobotomizedCount = 0;

    public boolean isLobotomized() {
        return this.isLobotomized;
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> type, World level) {
        this(type, level, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> type, World level, ResourceKey<VillagerType> villagerType) {
        this(type, level, level.L_().d(villagerType));
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> type, World level, Holder<VillagerType> villagerType) {
        super((EntityTypes<? extends EntityVillagerAbstract>)type, level);
        this.S().e(true);
        this.S().a(true);
        this.S().a(48.0f);
        this.a_(true);
        this.a(this.gR().a(villagerType).b(level.L_(), VillagerProfession.b));
    }

    @Override
    public boolean v() {
        return this.an().purpurConfig.villagerCanBeLeashed;
    }

    private boolean checkLobotomized() {
        int interval = this.an().purpurConfig.villagerLobotomizeCheckInterval;
        boolean shouldCheckForTradeLocked = this.an().purpurConfig.villagerLobotomizeWaitUntilTradeLocked;
        if (this.notLobotomizedCount > 3) {
            interval *= 2;
        }
        if (this.an().ag() % (long)interval == 0L) {
            boolean bl = this.isLobotomized = (!shouldCheckForTradeLocked || this.s() != 0) && !this.canTravelFrom(BlockPosition.a(this.dD().g, this.de().b + 0.0625, this.dD().i));
            this.notLobotomizedCount = this.isLobotomized ? 0 : ++this.notLobotomizedCount;
        }
        return this.isLobotomized;
    }

    private boolean canTravelFrom(BlockPosition pos) {
        return this.canTravelTo(pos.i()) || this.canTravelTo(pos.h()) || this.canTravelTo(pos.f()) || this.canTravelTo(pos.g());
    }

    private boolean canTravelTo(BlockPosition pos) {
        IBlockData state = this.an().getBlockStateIfLoaded(pos);
        if (state == null) {
            return false;
        }
        Block bottom = state.b();
        if (bottom instanceof BlockFence || bottom instanceof BlockFenceGate || bottom instanceof BlockCobbleWall) {
            return false;
        }
        Block top = this.an().a_(pos.d()).b();
        return !bottom.F && !top.F;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.villagerRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.villagerRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.villagerControllable;
    }

    @Override
    protected void H() {
        this.cq.a(0, new HasRider(this));
        if (this.an().purpurConfig.villagerFollowEmeraldBlock) {
            this.cq.a(3, new PathfinderGoalTempt(this, 1.0, EntityVillagerAbstract.TEMPT_ITEMS, false));
        }
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.villagerMaxHealth);
        this.h(GenericAttributes.z).a(this.an().purpurConfig.villagerScale);
        this.h(GenericAttributes.F).a(this.an().purpurConfig.villagerTemptRange);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.villagerTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.villagerAlwaysDropExp;
    }

    public BehaviorController<EntityVillager> eq() {
        return super.eq();
    }

    protected BehaviorController.b<EntityVillager> er() {
        return BehaviorController.a(dd, de);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> brain = this.er().a(dynamic);
        this.a(brain);
        return brain;
    }

    public void h(WorldServer level) {
        BehaviorController<EntityVillager> brain = this.eq();
        brain.b(level, this);
        this.bY = brain.i();
        this.a(this.eq());
    }

    private void a(BehaviorController<EntityVillager> villagerBrain) {
        Holder<VillagerProfession> holder = this.gR().b();
        if (this.g_()) {
            villagerBrain.a(Schedule.e);
            villagerBrain.a(Activity.d, Behaviors.a(0.5f));
        } else {
            villagerBrain.a(Schedule.f);
            villagerBrain.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.getWorkPackage(holder, 0.5f, this.an().purpurConfig.villagerClericsFarmWarts), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        villagerBrain.a(Activity.a, Behaviors.a(holder, 0.5f));
        villagerBrain.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        villagerBrain.a(Activity.e, Behaviors.c(holder, 0.5f));
        villagerBrain.a(Activity.b, Behaviors.e(holder, 0.5f));
        villagerBrain.a(Activity.g, Behaviors.f(holder, 0.5f));
        villagerBrain.a(Activity.i, Behaviors.g(holder, 0.5f));
        villagerBrain.a(Activity.h, Behaviors.h(holder, 0.5f));
        villagerBrain.a(Activity.j, Behaviors.i(holder, 0.5f));
        villagerBrain.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        villagerBrain.b(Activity.b);
        villagerBrain.a(Activity.b);
        villagerBrain.a(this.an().ah(), this.an().ag());
    }

    @Override
    protected void h() {
        super.h();
        if (this.an() instanceof WorldServer) {
            this.h((WorldServer)this.an());
        }
    }

    public static AttributeProvider.Builder gS() {
        return EntityInsentient.I().a(GenericAttributes.w, 0.5).a(GenericAttributes.F, 10.0);
    }

    public boolean gT() {
        return this.dc;
    }

    @Override
    public void inactiveTick() {
        if (this.m() > 0) {
            this.r(this.m() - 1);
        }
        if (this.dt()) {
            if (this.an().spigotConfig.tickInactiveVillagers) {
                this.a(this.an().getMinecraftWorld());
            } else {
                this.customServerAiStep(this.an().getMinecraftWorld(), true);
            }
        }
        this.hr();
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer level) {
        this.customServerAiStep(level, false);
    }

    protected void customServerAiStep(WorldServer level, boolean inactive) {
        Raid raidAt;
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("villagerBrain");
        if (this.an().purpurConfig.villagerLobotomizeEnabled) {
            inactive = inactive || this.checkLobotomized();
        } else {
            this.isLobotomized = false;
        }
        if (!(inactive || this.getRider() != null && this.isControllable())) {
            this.eq().a(level, this);
        } else if (this.isLobotomized && this.gW()) {
            this.gV();
        }
        profilerFiller.c();
        if (this.dc) {
            this.dc = false;
        }
        if (!this.gJ() && this.cO > 0) {
            --this.cO;
            if (this.cO <= 0) {
                if (this.cP) {
                    this.hp();
                    this.cP = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cS != null) {
            level.a(ReputationEvent.e, (Entity)this.cS, this);
            level.a((Entity)this, (byte)14);
            this.cS = null;
        }
        if (!inactive && !this.gx() && this.as.a(100) == 0 && (raidAt = level.d(this.dF())) != null && raidAt.r() && !raidAt.a()) {
            level.a((Entity)this, (byte)42);
        }
        if (this.gR().b().a(VillagerProfession.b) && this.gJ()) {
            this.gO();
        }
        if (inactive) {
            return;
        }
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (this.m() > 0) {
            this.r(this.m() - 1);
        }
        this.hr();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.vP) || !this.bX() || this.gJ() || this.gg()) {
            return super.b(player, hand);
        }
        if (this.g_()) {
            this.he();
            return this.tryRide(player, hand, EnumInteractionResult.a);
        }
        if (!this.an().D_()) {
            boolean isEmpty = this.gK().isEmpty();
            if (hand == EnumHand.a) {
                if (isEmpty) {
                    this.he();
                }
                player.a(StatisticList.T);
            }
            if (isEmpty) {
                return this.tryRide(player, hand, EnumInteractionResult.c);
            }
            if (this.an().purpurConfig.villagerRidable && itemInHand.f()) {
                return this.tryRide(player, hand);
            }
            if (this.an().purpurConfig.villagerAllowTrading) {
                this.j(player);
            }
        }
        return EnumInteractionResult.a;
    }

    public void he() {
        this.r(40);
        if (!this.an().D_()) {
            this.b(SoundEffects.Dp);
        }
    }

    private void j(EntityHuman player) {
        this.k(player);
        this.g(player);
        this.a(player, this.S_(), this.gR().c());
    }

    @Override
    public void g(@Nullable EntityHuman player) {
        boolean flag = this.gI() != null && player == null;
        super.g(player);
        if (flag) {
            this.gO();
        }
    }

    @Override
    protected void gO() {
        super.gO();
        this.hf();
    }

    private void hf() {
        if (!this.an().D_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gK()) {
                merchantOffer.n();
            }
        }
    }

    @Override
    public boolean gU() {
        return true;
    }

    public void gV() {
        this.hk();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gK()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantOffer.asBukkit());
            if (!event.callEvent()) continue;
            merchantOffer.j();
        }
        this.hg();
        this.cZ = this.an().ag();
        ++this.da;
    }

    private void hg() {
        MerchantRecipeList offers = this.gK();
        EntityHuman tradingPlayer = this.gI();
        if (tradingPlayer != null && !offers.isEmpty()) {
            tradingPlayer.a(tradingPlayer.cl.l, offers, this.gR().c(), this.s(), this.gL(), this.gU());
        }
    }

    private boolean hh() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gK()) {
            if (!merchantOffer.t()) continue;
            return true;
        }
        return false;
    }

    private boolean hi() {
        return this.da == 0 || this.da < 2 && this.an().ag() > this.cZ + 2400L;
    }

    public boolean gW() {
        long l2 = this.cZ + 12000L;
        long gameTime = this.an().ag();
        boolean flag = gameTime > l2;
        long dayTime = this.an().ah();
        if (this.db > 0L) {
            long l22 = dayTime / 24000L;
            long l1 = this.db / 24000L;
            flag |= l22 > l1;
        }
        this.db = dayTime;
        if (flag) {
            this.cZ = gameTime;
            this.hs();
        }
        return this.hi() && this.hh();
    }

    private void hj() {
        int i2 = 2 - this.da;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gK()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantOffer.asBukkit());
                if (!event.callEvent()) continue;
                merchantOffer.j();
            }
        }
        for (int i1 = 0; i1 < i2; ++i1) {
            this.hk();
        }
        this.hg();
    }

    public void hk() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gK()) {
            merchantOffer.updateDemand(this.an().purpurConfig.villagerMinimumDemand);
        }
    }

    private void k(EntityHuman player) {
        int playerReputation = this.i(player);
        if (playerReputation != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer : this.gK()) {
                if (merchantOffer.ignoreDiscounts) continue;
                merchantOffer.a(-MathHelper.d((float)playerReputation * merchantOffer.p()));
            }
        }
        if (player.d(MobEffects.F)) {
            MobEffect effect = player.e(MobEffects.F);
            int amplifier = effect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantOffer1 : this.gK()) {
                if (merchantOffer1.ignoreDiscounts) continue;
                double d2 = 0.3 + 0.0625 * (double)amplifier;
                int i2 = (int)Math.floor(d2 * (double)merchantOffer1.a().M());
                merchantOffer1.a(-Math.max(i2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cA, EntityVillager.gX());
    }

    public static VillagerData gX() {
        return new VillagerData(BuiltInRegistries.x.b(VillagerType.c), BuiltInRegistries.y.b(VillagerProfession.b), 1);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("VillagerData", VillagerData.c, this.gR());
        output.a("FoodLevel", (byte)this.cU);
        output.a("Gossips", Reputation.a, this.cV);
        output.a("Xp", this.cY);
        output.a("LastRestock", this.cZ);
        output.a("LastGossipDecay", this.cX);
        output.a("RestocksToday", this.da);
        if (this.dc) {
            output.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.az.a(cA, input.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gX));
        this.cU = input.a("FoodLevel", (byte)0);
        this.cV.c();
        input.a("Gossips", Reputation.a).ifPresent(this.cV::a);
        this.cY = input.a("Xp", 0);
        this.cZ = input.a("LastRestock", 0L);
        this.cX = input.a("LastGossipDecay", 0L);
        if (this.an() instanceof WorldServer) {
            this.h((WorldServer)this.an());
        }
        this.da = input.a("RestocksToday", 0);
        this.dc = input.a("AssignProfessionWhenSpawned", false);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        if (this.gg()) {
            return null;
        }
        return this.gJ() ? SoundEffects.Dq : SoundEffects.Dl;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.Do;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.Dn;
    }

    public void gY() {
        this.b(this.gR().b().a().f());
    }

    @Override
    public void a(VillagerData data) {
        VillagerData villagerData = this.gR();
        if (!villagerData.b().equals(data.b())) {
            this.cu = null;
        }
        this.az.a(cA, data);
    }

    @Override
    public VillagerData gR() {
        return this.az.a(cA);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe offer) {
        int i2 = 3 + this.as.a(4);
        this.cY += offer.q();
        this.cS = this.gI();
        if (this.ho()) {
            this.cO = 40;
            this.cP = true;
            i2 += 5;
        }
        if (offer.u()) {
            this.an().b(new EntityExperienceOrb(this.an(), this.dK(), this.dM() + 0.5, this.dQ(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.gI(), this));
        }
    }

    @Override
    public void a(@Nullable EntityLiving livingEntity) {
        if (livingEntity != null && this.an() instanceof WorldServer) {
            ((WorldServer)this.an()).a(ReputationEvent.c, (Entity)livingEntity, this);
            if (this.bX() && livingEntity instanceof EntityHuman) {
                this.an().a((Entity)this, (byte)13);
            }
        }
        super.a(livingEntity);
    }

    @Override
    public void a(DamageSource damageSource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            cz.info("Villager {} died, message: '{}'", (Object)this, (Object)damageSource.a(this).getString());
        }
        if ((entity = damageSource.d()) != null) {
            this.G(entity);
        }
        this.hl();
        super.a(damageSource);
    }

    public void hl() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void G(Entity murderer) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> memory = this.bY.c(MemoryModuleType.h);
            if (!memory.isEmpty()) {
                memory.get().b(ReputationHandler.class::isInstance).forEach(entity -> serverLevel.a(ReputationEvent.d, murderer, (ReputationHandler)((Object)entity)));
            }
        }
    }

    public void a(MemoryModuleType<GlobalPos> moduleType) {
        if (this.an() instanceof WorldServer) {
            MinecraftServer server = ((WorldServer)this.an()).q();
            this.bY.c(moduleType).ifPresent(pos -> {
                WorldServer level = server.a(pos.a());
                if (level != null) {
                    VillagePlace poiManager = level.D();
                    Optional<Holder<VillagePlaceType>> type = poiManager.c(pos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> biPredicate = cy.get(moduleType);
                    if (type.isPresent() && biPredicate.test(this, type.get())) {
                        poiManager.b(pos.b());
                        level.U().b(pos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean Z_() {
        return this.an().purpurConfig.villagerCanBreed && this.cU + this.hq() >= 12 && !this.gg() && this.aa_() == 0;
    }

    private boolean hm() {
        return this.cU < 12;
    }

    private void hn() {
        if (this.hm() && this.hq() != 0) {
            for (int i2 = 0; i2 < this.n().b(); ++i2) {
                int count;
                Integer integer;
                ItemStack item = this.n().a(i2);
                if (item.f() || (integer = cw.get(item.h())) == null) continue;
                for (int i1 = count = item.M(); i1 > 0; --i1) {
                    this.cU += integer.intValue();
                    this.n().a(i2, 1);
                    if (this.hm()) continue;
                    return;
                }
            }
        }
    }

    public int i(EntityHuman player) {
        return this.cV.a(player.cT(), (ReputationType type) -> true);
    }

    private void u(int level) {
        this.cU -= level;
    }

    public void gZ() {
        this.hn();
        this.u(12);
    }

    public void b(MerchantRecipeList offers) {
        this.cu = offers;
    }

    private boolean ho() {
        int level = this.gR().c();
        return VillagerData.d(level) && this.cY >= VillagerData.c(level);
    }

    public void hp() {
        this.a(this.gR().a(this.gR().c() + 1));
        this.gP();
    }

    @Override
    protected IChatBaseComponent cM() {
        return this.gR().b().a().a();
    }

    @Override
    public void b(byte id) {
        if (id == 12) {
            this.a(Particles.T);
        } else if (id == 13) {
            this.a(Particles.a);
        } else if (id == 14) {
            this.a(Particles.R);
        } else if (id == 42) {
            this.a(Particles.aq);
        } else {
            super.b(id);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnReason == EntitySpawnReason.e) {
            this.a(this.gR().b(level.L_(), VillagerProfession.b));
        }
        if (spawnReason == EntitySpawnReason.n || spawnReason == EntitySpawnReason.m || EntitySpawnReason.a(spawnReason) || spawnReason == EntitySpawnReason.o) {
            this.a(this.gR().a(level.L_(), VillagerType.a(level.v(this.dF()))));
        }
        if (spawnReason == EntitySpawnReason.d) {
            this.dc = true;
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Nullable
    public EntityVillager b(WorldServer level, EntityAgeable partner) {
        double randomDouble = this.as.j();
        Holder<VillagerType> orThrow = randomDouble < 0.5 ? level.L_().d(VillagerType.a(level.v(this.dF()))) : (randomDouble < 0.75 ? this.gR().a() : ((EntityVillager)partner).gR().a());
        EntityVillager villager = new EntityVillager(EntityTypes.bI, (World)level, orThrow);
        villager.a((WorldAccess)level, level.d_(villager.dF()), EntitySpawnReason.e, null);
        return villager;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        if (level.aq() != EnumDifficulty.a) {
            EntityWitch witch = this.convertTo(EntityTypes.bN, ConversionParams.a(this, false, false), (T witch1) -> {
                if (CraftEventFactory.callEntityZapEvent(this, lightning, witch1).isCancelled()) {
                    return false;
                }
                if (SpigotConfig.logVillagerDeaths) {
                    cz.info("Villager {} was struck by lightning {}.", (Object)this, (Object)lightning);
                }
                witch1.a((WorldAccess)level, level.d_(witch1.dF()), EntitySpawnReason.i, null);
                witch1.gq();
                this.hl();
                return true;
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (witch == null) {
                super.a(level, lightning);
            }
        } else {
            super.a(level, lightning);
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        InventoryCarrier.a(level, this, this, entity);
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        Item item = stack.h();
        return (stack.a(TagsItem.cc) || this.gR().b().a().d().contains((Object)item)) && this.n().c(stack);
    }

    public boolean ha() {
        return this.hq() >= 24;
    }

    public boolean hb() {
        return this.hq() < 12;
    }

    private int hq() {
        InventorySubcontainer inventory = this.n();
        return cw.entrySet().stream().mapToInt(entry -> inventory.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean hc() {
        return this.n().a_((ItemStack stack) -> this.an().purpurConfig.villagerClericsFarmWarts && this.gR().b().a(VillagerProfession.f) ? stack.a(Items.un) : stack.a(TagsItem.cb));
    }

    @Override
    protected void gP() {
        this.updateTrades(2);
    }

    public boolean updateTrades(int amount) {
        VillagerTrades.IMerchantRecipeOption[] itemListings;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> map;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> map1;
        VillagerData villagerData = this.gR();
        ResourceKey resourceKey = villagerData.b().e().orElse(null);
        if (resourceKey != null && (map1 = this.an().O().b(FeatureFlags.b) ? ((map = VillagerTrades.c.get(resourceKey)) != null ? map : VillagerTrades.a.get(resourceKey)) : VillagerTrades.a.get(resourceKey)) != null && !map1.isEmpty() && (itemListings = (VillagerTrades.IMerchantRecipeOption[])map1.get(villagerData.c())) != null) {
            MerchantRecipeList offers = this.gK();
            this.a(offers, itemListings, amount);
            if (SharedConstants.an && villagerData.c() < map1.size()) {
                this.hp();
            }
            return true;
        }
        return false;
    }

    public void a(WorldServer level, EntityVillager target, long gameTime) {
        if (!(gameTime >= this.cW && gameTime < this.cW + 1200L || gameTime >= target.cW && gameTime < target.cW + 1200L)) {
            this.cV.a(target.cV, this.as, 10);
            this.cW = gameTime;
            target.cW = gameTime;
            this.a(level, gameTime, 5);
        }
    }

    private void hr() {
        long gameTime = this.an().ag();
        if (this.cX == 0L) {
            this.cX = gameTime;
        } else if (gameTime >= this.cX + 24000L) {
            this.cV.b();
            this.cX = gameTime;
        }
    }

    public void a(WorldServer level, long gameTime, int minVillagerAmount) {
        AxisAlignedBB aabb;
        List<EntityVillager> entitiesOfClass;
        List<EntityVillager> list;
        if (level.purpurConfig.villagerSpawnIronGolemRadius > 0 && level.a(EntityIronGolem.class, this.de().g(level.purpurConfig.villagerSpawnIronGolemRadius)).size() > level.purpurConfig.villagerSpawnIronGolemLimit) {
            return;
        }
        if (this.a(gameTime) && (list = (entitiesOfClass = level.a(EntityVillager.class, aabb = this.de().c(10.0, 10.0, 10.0))).stream().filter(villager -> villager.a(gameTime)).limit(5L).toList()).size() >= minVillagerAmount && SpawnUtil.trySpawnMob(EntityTypes.at, EntitySpawnReason.f, level, this.dF(), 10, 8, 6, SpawnUtil.a.a, false, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE, () -> SensorGolemLastSeen.b(this)).isPresent()) {
            entitiesOfClass.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long gameTime) {
        return this.b(this.an().ag()) && !this.bY.a(MemoryModuleType.G);
    }

    @Override
    public void a(ReputationEvent type, Entity target) {
        if (type == ReputationEvent.a) {
            this.cV.a(target.cT(), ReputationType.d, 20);
            this.cV.a(target.cT(), ReputationType.c, 25);
        } else if (type == ReputationEvent.e) {
            this.cV.a(target.cT(), ReputationType.e, 2);
        } else if (type == ReputationEvent.c) {
            this.cV.a(target.cT(), ReputationType.b, 25);
        } else if (type == ReputationEvent.d) {
            this.cV.a(target.cT(), ReputationType.a, 25);
        }
    }

    @Override
    public int s() {
        return this.cY;
    }

    public void t(int villagerXp) {
        this.cY = villagerXp;
    }

    private void hs() {
        this.hj();
        this.da = 0;
    }

    public Reputation hd() {
        return this.cV;
    }

    public void a(Reputation gossips) {
        this.cV.a(gossips);
    }

    @Override
    public void b(BlockPosition pos) {
        if (this.an().purpurConfig.bedExplodeOnVillagerSleep && this.an().a_(pos).b() instanceof BlockBed) {
            this.an().a(null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, (float)this.an().purpurConfig.bedExplosionPower, this.an().purpurConfig.bedExplosionFire, this.an().purpurConfig.bedExplosionEffect);
            return;
        }
        super.b(pos);
        this.bY.a(MemoryModuleType.I, Long.valueOf(this.an().ag()));
        this.bY.b(MemoryModuleType.n);
        this.bY.b(MemoryModuleType.F);
    }

    @Override
    public void gh() {
        super.gh();
        this.bY.a(MemoryModuleType.J, Long.valueOf(this.an().ag()));
    }

    private boolean b(long gameTime) {
        Optional<Long> memory = this.bY.c(MemoryModuleType.I);
        return memory.filter(lastSlept -> gameTime - lastSlept < 24000L).isPresent();
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> component) {
        return component == DataComponents.av ? EntityVillager.c(component, this.gR().a()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.av);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.av) {
            Holder<VillagerType> holder = EntityVillager.c(DataComponents.av, value);
            this.a(this.gR().a(holder));
            return true;
        }
        return super.b(component, value);
    }
}

