/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    static final RecipeItemStack TEMPT_ITEMS = RecipeItemStack.a((IMaterial)Blocks.gy.h());
    private static final DataWatcherObject<Integer> cv = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int ct = 300;
    private static final int cw = 8;
    @Nullable
    private EntityHuman cx;
    @Nullable
    protected MerchantRecipeList cu;
    private final InventorySubcontainer cy = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> type, World level) {
        super((EntityTypes<? extends EntityAgeable>)type, level);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public int m() {
        return this.az.a(cv);
    }

    public void r(int unhappyCounter) {
        this.az.a(cv, unhappyCounter);
    }

    @Override
    public int s() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cv, 0);
    }

    @Override
    public void g(@Nullable EntityHuman player) {
        this.cx = player;
    }

    @Override
    @Nullable
    public EntityHuman gI() {
        return this.cx;
    }

    public boolean gJ() {
        return this.cx != null;
    }

    @Override
    public CraftMerchant getCraftMerchant() {
        return (CraftAbstractVillager)this.getBukkitEntity();
    }

    public void resetOffers() {
        this.cu = new MerchantRecipeList();
        this.gP();
    }

    @Override
    public MerchantRecipeList gK() {
        if (this.an().D_()) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.cu == null) {
            this.cu = new MerchantRecipeList();
            this.gP();
        }
        return this.cu;
    }

    @Override
    public void a(@Nullable MerchantRecipeList offers) {
    }

    @Override
    public void s(int xp) {
    }

    @Override
    public void processTrade(MerchantRecipe offer, @Nullable PlayerPurchaseEvent event) {
        if (event == null || event.willIncreaseTradeUses()) {
            offer.l();
        }
        if (event == null || event.isRewardingExp()) {
            this.b(offer);
        }
        this.a(offer);
    }

    @Override
    public void a(MerchantRecipe offer) {
        this.ck = -this.W();
        if (this.cx instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.cx, this, offer.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gL() {
        return true;
    }

    @Override
    public void i(ItemStack stack) {
        if (!this.an().D_() && this.ck > -this.W() + 20) {
            this.ck = -this.W();
            this.b(this.x(!stack.f()));
        }
    }

    @Override
    public SoundEffect gM() {
        return SoundEffects.Dr;
    }

    protected SoundEffect x(boolean isYesSound) {
        return isYesSound ? SoundEffects.Dr : SoundEffects.Dp;
    }

    public void gN() {
        this.b(SoundEffects.Dm);
    }

    @Override
    protected void a(ValueOutput output) {
        MerchantRecipeList offers;
        super.a(output);
        if (!this.an().D_() && !(offers = this.gK()).isEmpty()) {
            output.a("Offers", MerchantRecipeList.a, offers);
        }
        this.b_(output);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cu = input.a("Offers", MerchantRecipeList.a).orElse(null);
        this.a_(input);
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleportTransition) {
        this.gO();
        return super.b(teleportTransition);
    }

    protected void gO() {
        this.g((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.gO();
    }

    protected void a(ParticleParam options) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d2 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d22 = this.as.k() * 0.02;
            this.an().a(options, this.e(1.0), this.dN() + 1.0, this.h(1.0), d2, d1, d22);
        }
    }

    @Override
    public boolean v() {
        return false;
    }

    @Override
    public InventorySubcontainer n() {
        return this.cy;
    }

    @Override
    public SlotAccess a_(int slot) {
        int i2 = slot - 300;
        return i2 >= 0 && i2 < this.cy.b() ? SlotAccess.a(this.cy, i2) : super.a_(slot);
    }

    protected abstract void gP();

    protected void a(MerchantRecipeList givenMerchantOffers, VillagerTrades.IMerchantRecipeOption[] newTrades, int maxNumbers) {
        ArrayList list = Lists.newArrayList((Object[])newTrades);
        int i2 = 0;
        while (i2 < maxNumbers && !list.isEmpty()) {
            MerchantRecipe offer = ((VillagerTrades.IMerchantRecipeOption)list.remove(this.as.a(list.size()))).a(this, this.as);
            if (offer == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)offer.asBukkit());
            if (this.valid) {
                event.callEvent();
            }
            if (!event.isCancelled()) {
                CraftMerchantRecipe craftMerchantRecipe = CraftMerchantRecipe.fromBukkit(event.getRecipe());
                if (craftMerchantRecipe.getIngredients().isEmpty()) {
                    return;
                }
                givenMerchantOffers.add(craftMerchantRecipe.toMinecraft());
            }
            ++i2;
        }
    }

    @Override
    public Vec3D u(float partialTick) {
        float f2 = MathHelper.h(partialTick, this.bC, this.bB) * ((float)Math.PI / 180);
        Vec3D vec3 = new Vec3D(0.0, this.de().c() - 1.0, 0.2);
        return this.p(partialTick).e(vec3.b(-f2));
    }

    @Override
    public boolean gQ() {
        return this.an().D_();
    }

    @Override
    public boolean h(EntityHuman player) {
        return this.gI() == player && this.bX() && player.b((Entity)this, 4.0);
    }
}

