/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalInteract;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtTradingPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTradeWithPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalUseItem;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityVillagerTrader
extends EntityVillagerAbstract
implements Consumable.b {
    private static final int cv = 0;
    @Nullable
    private BlockPosition cw;
    private int cx = 0;
    public boolean canDrinkPotion = true;
    public boolean canDrinkMilk = true;

    public EntityVillagerTrader(EntityTypes<? extends EntityVillagerTrader> type, World level) {
        super((EntityTypes<? extends EntityVillagerAbstract>)type, level);
    }

    @Override
    public boolean v() {
        return this.an().purpurConfig.wanderingTraderCanBeLeashed;
    }

    @Override
    public boolean isRidable() {
        return this.an().purpurConfig.wanderingTraderRidable;
    }

    @Override
    public boolean cn() {
        return this.an().purpurConfig.useDismountsUnderwaterTag ? super.cn() : !this.an().purpurConfig.wanderingTraderRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.an().purpurConfig.wanderingTraderControllable;
    }

    @Override
    public void initAttributes() {
        this.h(GenericAttributes.t).a(this.an().purpurConfig.wanderingTraderMaxHealth);
        this.h(GenericAttributes.F).a(this.an().purpurConfig.wanderingTraderTemptRange);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.I().a(GenericAttributes.F, 10.0);
    }

    @Override
    public boolean fG() {
        return this.an().purpurConfig.wanderingTraderTakeDamageFromWater;
    }

    @Override
    protected boolean eE() {
        return this.an().purpurConfig.wanderingTraderAlwaysDropExp;
    }

    @Override
    protected void H() {
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, PotionContents.a(Items.up, Potions.g), SoundEffects.DR, wanderingTrader -> this.canDrinkPotion && this.an().ab() && !wanderingTrader.cB()));
        this.cq.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, new ItemStack(Items.sq), SoundEffects.DW, wanderingTrader -> this.an().purpurConfig.milkClearsBeneficialEffects && this.canDrinkMilk && this.an().aa() && wanderingTrader.cB()));
        this.cq.a(1, new PathfinderGoalTradeWithPlayer(this));
        this.cq.a(1, new PathfinderGoalAvoidTarget<EntityZombie>(this, EntityZombie.class, 8.0f, 0.5, 0.5));
        this.cq.a(1, new PathfinderGoalAvoidTarget<EntityEvoker>(this, EntityEvoker.class, 12.0f, 0.5, 0.5));
        this.cq.a(1, new PathfinderGoalAvoidTarget<EntityVindicator>(this, EntityVindicator.class, 8.0f, 0.5, 0.5));
        this.cq.a(1, new PathfinderGoalAvoidTarget<EntityVex>(this, EntityVex.class, 8.0f, 0.5, 0.5));
        this.cq.a(1, new PathfinderGoalAvoidTarget<EntityPillager>(this, EntityPillager.class, 15.0f, 0.5, 0.5));
        this.cq.a(1, new PathfinderGoalAvoidTarget<EntityIllagerIllusioner>(this, EntityIllagerIllusioner.class, 12.0f, 0.5, 0.5));
        this.cq.a(1, new PathfinderGoalAvoidTarget<EntityZoglin>(this, EntityZoglin.class, 10.0f, 0.5, 0.5));
        this.cq.a(1, new PathfinderGoalPanic(this, 0.5));
        this.cq.a(1, new PathfinderGoalLookAtTradingPlayer(this));
        this.cq.a(2, new a(this, 2.0, 0.35));
        if (this.an().purpurConfig.wanderingTraderFollowEmeraldBlock) {
            this.cq.a(3, new PathfinderGoalTempt(this, 1.0, EntityVillagerAbstract.TEMPT_ITEMS, false));
        }
        this.cq.a(4, new PathfinderGoalMoveTowardsRestriction(this, 0.35));
        this.cq.a(8, new PathfinderGoalRandomStrollLand(this, 0.35));
        this.cq.a(9, new PathfinderGoalInteract(this, EntityHuman.class, 3.0f, 1.0f));
        this.cq.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return null;
    }

    @Override
    public boolean gL() {
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.a(Items.vP) && this.bX() && !this.gJ() && !this.g_()) {
            if (hand == EnumHand.a) {
                player.a(StatisticList.T);
            }
            if (!this.an().D_()) {
                if (this.gK().isEmpty()) {
                    return this.tryRide(player, hand, EnumInteractionResult.c);
                }
                if (this.an().purpurConfig.wanderingTraderRidable && itemInHand.f()) {
                    return this.tryRide(player, hand);
                }
                if (this.an().purpurConfig.wanderingTraderAllowTrading) {
                    this.g(player);
                    this.a(player, this.S_(), 1);
                }
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    protected void gP() {
        MerchantRecipeList offers = this.gK();
        for (Pair<VillagerTrades.IMerchantRecipeOption[], Integer> pair : VillagerTrades.b) {
            VillagerTrades.IMerchantRecipeOption[] itemListings = (VillagerTrades.IMerchantRecipeOption[])pair.getLeft();
            this.a(offers, itemListings, (int)((Integer)pair.getRight()));
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("DespawnDelay", this.cx);
        output.b("wander_target", BlockPosition.a, this.cw);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cx = input.a("DespawnDelay", 0);
        this.cw = input.a("wander_target", BlockPosition.a).orElse(null);
        this.c_(Math.max(0, this.aa_()));
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void b(MerchantRecipe offer) {
        if (offer.u()) {
            int i2 = 3 + this.as.a(4);
            this.an().b(new EntityExperienceOrb(this.an(), this.dK(), this.dM() + 0.5, this.dQ(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.gI(), this));
        }
    }

    @Override
    public SoundEffect p() {
        return this.gJ() ? SoundEffects.DX : SoundEffects.DP;
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return SoundEffects.DU;
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.DQ;
    }

    @Override
    public SoundEffect j(ItemStack stack) {
        return stack.a(Items.sq) ? SoundEffects.DS : SoundEffects.DT;
    }

    @Override
    protected SoundEffect x(boolean getYesSound) {
        return getYesSound ? SoundEffects.DY : SoundEffects.DV;
    }

    @Override
    public SoundEffect gM() {
        return SoundEffects.DY;
    }

    public void t(int despawnDelay) {
        this.cx = despawnDelay;
    }

    public int gR() {
        return this.cx;
    }

    @Override
    public void e_() {
        super.e_();
        if (!this.an().D_()) {
            this.gS();
        }
    }

    private void gS() {
        if (this.cx > 0 && !this.gJ() && --this.cx == 0) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    public void h(@Nullable BlockPosition wanderTarget) {
        this.cw = wanderTarget;
    }

    @Nullable
    public BlockPosition gT() {
        return this.cw;
    }

    class a
    extends PathfinderGoal {
        final EntityVillagerTrader a;
        final double b;
        final double c;

        a(EntityVillagerTrader trader, double stopDistance, double speedModifier) {
            this.a = trader;
            this.b = stopDistance;
            this.c = speedModifier;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public void e() {
            this.a.h((BlockPosition)null);
            EntityVillagerTrader.this.cp.n();
        }

        @Override
        public boolean b() {
            BlockPosition wanderTarget = this.a.gT();
            return wanderTarget != null && this.a(wanderTarget, this.b);
        }

        @Override
        public void a() {
            BlockPosition wanderTarget = this.a.gT();
            if (wanderTarget != null && EntityVillagerTrader.this.cp.l()) {
                if (this.a(wanderTarget, 10.0)) {
                    Vec3D vec3 = new Vec3D((double)wanderTarget.u() - this.a.dK(), (double)wanderTarget.v() - this.a.dM(), (double)wanderTarget.w() - this.a.dQ()).d();
                    Vec3D vec31 = vec3.c(10.0).b(this.a.dK(), this.a.dM(), this.a.dQ());
                    EntityVillagerTrader.this.cp.a(vec31.g, vec31.h, vec31.i, this.c);
                } else {
                    EntityVillagerTrader.this.cp.a((double)wanderTarget.u(), (double)wanderTarget.v(), (double)wanderTarget.w(), this.c);
                }
            }
        }

        private boolean a(BlockPosition pos, double distance) {
            return !pos.a(this.a.dD(), distance);
        }
    }
}

