/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerClientLoadedWorldEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public abstract class EntityHuman
extends Avatar
implements ContainerUser {
    public static final int ca = 20;
    public static final int cb = 100;
    public static final int cc = 10;
    public static final int cd = 200;
    public static final int ce = 499;
    public static final int cf = 500;
    public static final float cg = 4.5f;
    public static final float ch = 3.0f;
    private static final int a = 40;
    private static final DataWatcherObject<Float> b = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<OptionalInt> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.u);
    private static final DataWatcherObject<OptionalInt> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.u);
    public static final int ci = 60;
    private static final short f = 0;
    private static final float g = 0.0f;
    private static final int h = 0;
    private static final int i = 0;
    private static final int j = 0;
    private static final int k = 0;
    private static final int cA = 0;
    private static final boolean cB = false;
    private static final int cC = 0;
    final PlayerInventory cD;
    protected InventoryEnderChest cj = new InventoryEnderChest(this);
    public final ContainerPlayer ck;
    public Container cl;
    protected FoodMetaData cm = new FoodMetaData();
    protected int cn;
    private boolean cE = false;
    protected int co = 60;
    public int cp;
    public int cF = 0;
    protected boolean cq;
    private final PlayerAbilities cG = new PlayerAbilities();
    public int cr = 0;
    public int cs = 0;
    public float ct = 0.0f;
    public int cu = 0;
    protected final float cv = 0.02f;
    private int cH;
    public GameProfile cI;
    private boolean cJ;
    private net.minecraft.world.item.ItemStack cK = net.minecraft.world.item.ItemStack.l;
    private final ItemCooldown cL = this.f();
    private Optional<GlobalPos> cM = Optional.empty();
    @Nullable
    public EntityFishingHook cw;
    public float cx;
    @Nullable
    public Vec3D cy;
    @Nullable
    public Entity cz;
    private boolean cN = false;
    private int cO = 0;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public int burpDelay = 0;
    public boolean canPortalInstant = false;
    public int sixRowEnderchestSlotCount = -1;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    public abstract void setAfk(boolean var1);

    public boolean isAfk() {
        return false;
    }

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public abstract void J();

    @Override
    public boolean processClick(EnumHand hand) {
        Entity vehicle = this.dp();
        if (vehicle != null && vehicle.getRider() == this) {
            return vehicle.onClick(hand);
        }
        return false;
    }

    public EntityHuman(World level, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bX, level);
        this.a_(gameProfile.id());
        this.cI = gameProfile;
        this.cD = new PlayerInventory(this, this.bZ);
        this.ck = new ContainerPlayer(this.cD, !level.D_(), this);
        this.cl = this.ck;
    }

    @Override
    protected EntityEquipment ep() {
        return new PlayerEquipment(this);
    }

    public boolean a(World level, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.gO()) {
            return false;
        }
        net.minecraft.world.item.ItemStack mainHandItem = this.fq();
        return mainHandItem.f() || !mainHandItem.b(new ShapeDetectorBlock(level, pos, false));
    }

    public static AttributeProvider.Builder go() {
        return EntityLiving.es().a(GenericAttributes.c, 1.0).a(GenericAttributes.w, 0.1f).a(GenericAttributes.e).a(GenericAttributes.r).a(GenericAttributes.g, 4.5).a(GenericAttributes.k, 3.0).a(GenericAttributes.f).a(GenericAttributes.D).a(GenericAttributes.A).a(GenericAttributes.u).a(GenericAttributes.E).a(GenericAttributes.H, 6.0E7).a(GenericAttributes.I, 6.0E7);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(b, Float.valueOf(0.0f));
        builder.a(c, 0);
        builder.a(d, OptionalInt.empty());
        builder.a(e, OptionalInt.empty());
    }

    @Override
    public void g() {
        if (this.burpDelay > 0 && --this.burpDelay == 0) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.wc, SoundCategory.h, 1.0f, this.an().z.i() * 0.1f + 0.9f);
        }
        this.ar = this.at();
        if (this.at() || this.cl()) {
            this.e(false);
        }
        if (this.cp > 0) {
            --this.cp;
        }
        if (this.gg()) {
            ++this.cF;
            if (this.cF == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.cF = Integer.MIN_VALUE;
            }
            if (this.cF > 100) {
                this.cF = 100;
            }
            if (!this.an().D_() && this.an().aa()) {
                this.a(false, true);
            }
        } else if (this.cF > 0) {
            ++this.cF;
            if (this.cF >= 110) {
                this.cF = 0;
            }
        }
        this.gs();
        super.g();
        int i2 = 29999999;
        double d2 = MathHelper.a(this.dK(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dQ(), -2.9999999E7, 2.9999999E7);
        if (d2 != this.dK() || d1 != this.dQ()) {
            this.a_(d2, this.dM(), d1);
        }
        ++this.by;
        net.minecraft.world.item.ItemStack mainHandItem = this.fq();
        if (!net.minecraft.world.item.ItemStack.a(this.cK, mainHandItem)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cK, mainHandItem)) {
                this.gV();
            }
            this.cK = mainHandItem.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.pP)) {
            this.m();
        }
        if (this.an().purpurConfig.playerNetheriteFireResistanceDuration > 0 && this.an().ag() % 20L == 0L && this.a(EnumItemSlot.f).a(Items.rC) && this.a(EnumItemSlot.e).a(Items.rD) && this.a(EnumItemSlot.d).a(Items.rE) && this.a(EnumItemSlot.c).a(Items.rF)) {
            this.addEffect(new MobEffect(MobEffects.l, this.an().purpurConfig.playerNetheriteFireResistanceDuration, this.an().purpurConfig.playerNetheriteFireResistanceAmplifier, this.an().purpurConfig.playerNetheriteFireResistanceAmbient, this.an().purpurConfig.playerNetheriteFireResistanceShowParticles, this.an().purpurConfig.playerNetheriteFireResistanceShowIcon), EntityPotionEffectEvent.Cause.NETHERITE_ARMOR);
        }
        this.cL.a();
        this.gt();
        if (this.cO > 0) {
            --this.cO;
        }
    }

    @Override
    protected float fE() {
        return this.fV() ? 15.0f : super.fE();
    }

    public boolean gp() {
        return this.cp();
    }

    protected boolean gq() {
        return this.cp();
    }

    protected boolean gr() {
        return this.cp();
    }

    protected boolean gs() {
        this.cq = ((Entity)this).a(TagsFluid.a);
        return this.cq;
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (!this.gC().b) {
            super.a(downwards, pos);
        }
    }

    @Override
    public void m(boolean downwards) {
        if (!this.gC().b) {
            super.m(downwards);
        }
    }

    private void m() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            net.minecraft.world.item.ItemStack itemBySlot = this.a(equipmentSlot);
            Equippable equippable = itemBySlot.a(DataComponents.D);
            if (!itemBySlot.a(item) || equippable == null || equippable.b() != equipmentSlot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown f() {
        return new ItemCooldown();
    }

    protected void gt() {
        if (this.h(EntityPose.d)) {
            EntityPose desiredPose = this.n();
            EntityPose pose = this.at() || this.cl() || this.h(desiredPose) ? desiredPose : (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d);
            this.c(pose);
        }
    }

    private EntityPose n() {
        if (this.gg()) {
            return EntityPose.c;
        }
        if (this.cw()) {
            return EntityPose.d;
        }
        if (this.fY()) {
            return EntityPose.b;
        }
        if (this.fL()) {
            return EntityPose.e;
        }
        return this.cp() && !this.cG.b ? EntityPose.f : EntityPose.a;
    }

    protected boolean h(EntityPose pose) {
        return this.an().a((Entity)this, this.a(pose).a(this.dD()).h(1.0E-7));
    }

    @Override
    public SoundEffect bg() {
        return SoundEffects.wn;
    }

    @Override
    public SoundEffect bh() {
        return SoundEffects.wl;
    }

    @Override
    public SoundEffect bi() {
        return SoundEffects.wm;
    }

    @Override
    public int cj() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.an().a((Entity)this, this.dK(), this.dM(), this.dQ(), sound, this.dw(), volume, pitch);
    }

    public void a(SoundEffect sound, SoundCategory source, float volume, float pitch) {
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.h;
    }

    @Override
    public int dx() {
        return 20;
    }

    @Override
    public void b(byte id) {
        if (id == 9) {
            this.R_();
        } else if (id == 23) {
            this.v(false);
        } else if (id == 22) {
            this.v(true);
        } else {
            super.b(id);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.r();
        this.cl = this.ck;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.cl = this.ck;
    }

    public void r() {
        this.cl = this.ck;
    }

    protected void s() {
    }

    @Override
    public void t() {
        if (!this.an().D_() && this.gq() && this.cl()) {
            this.cb();
            if (!this.cl()) {
                this.h(false);
                return;
            }
        }
        super.t();
    }

    @Override
    public void e_() {
        if (this.cn > 0) {
            --this.cn;
        }
        this.i();
        this.cD.m();
        if (this.cG.b && !this.cl()) {
            this.l();
        }
        super.e_();
        this.fo();
        this.bD = this.dX();
        this.B((float)this.i(GenericAttributes.w));
        if (this.eU() > 0.0f && !this.at()) {
            AxisAlignedBB aabb = this.cl() && !this.du().ec() ? this.de().b(this.du().de()).c(1.0, 0.0, 1.0) : this.de().c(1.0, 0.5, 1.0);
            List<Entity> entities = this.an().a_(this, aabb);
            ArrayList list = Lists.newArrayList();
            for (Entity entity : entities) {
                if (entity.ax() == EntityTypes.Y && entity.an().purpurConfig.playerExpPickupDelay >= 0) {
                    list.add(entity);
                    continue;
                }
                if (entity.ec()) continue;
                this.d(entity);
            }
            if (!list.isEmpty()) {
                this.d((Entity)SystemUtils.a(list, this.as));
            }
        }
        this.j();
    }

    protected void i() {
    }

    public void j() {
    }

    public void k() {
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gu() {
        return this.az.a(c);
    }

    public void q(int score) {
        this.az.a(c, score);
    }

    public void r(int score) {
        int score1 = this.gu();
        this.az.a(c, score1 + score);
    }

    public void a(int ticks, float damageAmount, net.minecraft.world.item.ItemStack stack) {
        this.bV = ticks;
        this.bW = damageAmount;
        this.bX = stack;
        if (!this.an().D_()) {
            this.k();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public net.minecraft.world.item.ItemStack el() {
        return this.fL() && this.bX != null ? this.bX : super.el();
    }

    @Override
    public void a(DamageSource damageSource) {
        World world;
        super.a(damageSource);
        this.aG();
        if (!this.at() && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.dropAllDeathLoot(serverLevel, damageSource);
        }
        if (damageSource != null) {
            this.m(-MathHelper.b((this.fa() + this.dX()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.fa() + this.dX()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.m(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.O);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aQ();
        this.d(false);
        this.d(Optional.of(GlobalPos.a(this.an().al(), this.dF())));
    }

    @Override
    protected void g(WorldServer level) {
        super.g(level);
        if (!level.S().c(GameRules.e)) {
            this.gv();
            this.cD.n();
        }
    }

    protected void gv() {
        for (int i2 = 0; i2 < this.cD.b(); ++i2) {
            net.minecraft.world.item.ItemStack item = this.cD.a(i2);
            if (item.f() || !EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
            this.cD.b(i2);
        }
    }

    @Override
    public SoundEffect e(DamageSource damageSource) {
        return damageSource.k().d().a();
    }

    @Override
    public SoundEffect f_() {
        return SoundEffects.wd;
    }

    public void g(net.minecraft.world.item.ItemStack stack) {
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean includeThrowerName) {
        return this.a(stack, false, includeThrowerName);
    }

    public float c(IBlockData state) {
        float destroySpeed = this.cD.h().a(state);
        if (destroySpeed > 1.0f) {
            destroySpeed += (float)this.i(GenericAttributes.u);
        }
        if (MobEffectUtil.a(this)) {
            destroySpeed *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.d(MobEffects.d)) {
            float f2 = switch (this.e(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            destroySpeed *= f2;
        }
        destroySpeed *= (float)this.i(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            destroySpeed *= (float)this.h(GenericAttributes.D).g();
        }
        if (!this.aS()) {
            destroySpeed /= 5.0f;
        }
        return destroySpeed;
    }

    public boolean d(IBlockData state) {
        return !state.C() || this.cD.h().b(state);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a_(this.cI.id());
        this.cD.a(input.c("Inventory", ItemStackWithSlot.a));
        this.cD.c(input.a("SelectedItemSlot", 0));
        this.cF = input.a("SleepTimer", (short)0);
        this.ct = input.a("XpP", 0.0f);
        this.cr = input.a("XpLevel", 0);
        this.cs = input.a("XpTotal", 0);
        this.cu = input.a("XpSeed", 0);
        if (this.cu == 0) {
            this.cu = this.as.f();
        }
        this.q(input.a("Score", 0));
        this.cm.a(input);
        input.a("abilities", PlayerAbilities.a.a).ifPresent(this.cG::a);
        this.h(GenericAttributes.w).a(this.cG.b());
        this.cj.b(input.c("EnderItems", ItemStackWithSlot.a));
        this.d(input.a("LastDeathLocation", GlobalPos.b));
        this.cy = input.a("current_explosion_impact_pos", Vec3D.a).orElse(null);
        this.cN = input.a("ignore_fall_damage_from_current_explosion", false);
        this.cO = input.a("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        GameProfileSerializer.a(output);
        this.cD.a(output.a("Inventory", ItemStackWithSlot.a));
        output.a("SelectedItemSlot", this.cD.g());
        output.a("SleepTimer", (short)this.cF);
        output.a("XpP", this.ct);
        output.a("XpLevel", this.cr);
        output.a("XpTotal", this.cs);
        output.a("XpSeed", this.cu);
        output.a("Score", this.gu());
        this.cm.a(output);
        output.a("abilities", PlayerAbilities.a.a, this.cG.c());
        this.cj.b(output.a("EnderItems", ItemStackWithSlot.a));
        this.cM.ifPresent(globalPos -> output.a("LastDeathLocation", GlobalPos.b, globalPos));
        output.b("current_explosion_impact_pos", Vec3D.a, this.cy);
        output.a("ignore_fall_damage_from_current_explosion", this.cN);
        output.a("current_impulse_context_reset_grace_time", this.cO);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource) {
        if (super.a(level, damageSource)) {
            return true;
        }
        if (damageSource.a(DamageTypeTags.n)) {
            return !level.S().c(GameRules.I);
        }
        if (damageSource.a(DamageTypeTags.m)) {
            return !level.S().c(GameRules.J);
        }
        return damageSource.a(DamageTypeTags.i) ? !level.S().c(GameRules.K) : damageSource.a(DamageTypeTags.o) && !level.S().c(GameRules.L);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean damaged;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.cG.a && !damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bJ = 0;
        if (this.eV()) {
            return false;
        }
        if (damageSource.g()) {
            if (level.aq() == EnumDifficulty.a) {
                return false;
            }
            if (level.aq() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (level.aq() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(level, damageSource, amount)) {
            this.k();
        }
        return damaged;
    }

    @Override
    protected void a(WorldServer level, EntityLiving entity) {
        super.a(level, entity);
        net.minecraft.world.item.ItemStack itemBlockingWith = this.fW();
        BlocksAttacks blocksAttacks = itemBlockingWith != null ? itemBlockingWith.a(DataComponents.I) : null;
        float secondsToDisableBlocking = entity.gj();
        if (secondsToDisableBlocking > 0.0f && blocksAttacks != null) {
            blocksAttacks.disable(level, this, secondsToDisableBlocking, itemBlockingWith, entity);
        }
    }

    @Override
    public boolean eN() {
        return !this.gC().a && super.eN();
    }

    public boolean a(EntityHuman other) {
        Team team;
        if (other instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)other;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = other.an().getCraftServer().getOfflinePlayer(other.cV());
            team = other.an().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.an().getCraftServer().getOfflinePlayer(this.cV()));
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.f);
    }

    @Override
    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        return super.actuallyHurt(level, damageSource, amount, event);
    }

    public boolean Z() {
        return false;
    }

    public void a(TileEntitySign signEntity, boolean isFrontText) {
    }

    public void a(CommandBlockListenerAbstract commandEntity) {
    }

    public void a(TileEntityCommand commandBlockEntity) {
    }

    public void a(TileEntityStructure structureEntity) {
    }

    public void a(TestBlockEntity testBlockEntity) {
    }

    public void a(TestInstanceBlockEntity testInstanceBlockEntity) {
    }

    public void a(TileEntityJigsaw jigsawBlockEntity) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory menu) {
        return OptionalInt.empty();
    }

    public void b(Holder<Dialog> dialog) {
    }

    public void a(int containerId, MerchantRecipeList offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
    }

    public void a(net.minecraft.world.item.ItemStack stack, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entityToInteractOn, EnumHand hand) {
        if (this.at()) {
            if (entityToInteractOn instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entityToInteractOn));
            }
            return EnumInteractionResult.e;
        }
        net.minecraft.world.item.ItemStack itemInHand = this.b(hand);
        net.minecraft.world.item.ItemStack itemStack = itemInHand.v();
        EnumInteractionResult interactionResult = entityToInteractOn.a(this, hand);
        if (interactionResult.a()) {
            if (this.gk() && itemInHand == this.b(hand) && itemInHand.M() < itemStack.M()) {
                itemInHand.e(itemStack.M());
            }
            return interactionResult;
        }
        if (!itemInHand.f() && entityToInteractOn instanceof EntityLiving) {
            EnumInteractionResult interactionResult1;
            if (this.gk()) {
                itemInHand = itemStack;
            }
            if ((interactionResult1 = itemInHand.a(this, (EntityLiving)entityToInteractOn, hand)).a()) {
                this.an().a(GameEvent.r, entityToInteractOn.dD(), GameEvent.a.a(this));
                if (itemInHand.f() && !this.gk()) {
                    this.a(hand, net.minecraft.world.item.ItemStack.l);
                }
                return interactionResult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        super.removeVehicle(suppressCancellation);
        this.X = 0;
    }

    @Override
    protected boolean fv() {
        return super.fv() || this.gg() || this.ec() || !this.valid;
    }

    @Override
    public boolean eB() {
        return !this.cG.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        float f2 = this.eb();
        if (!this.cG.b && !(movement.h > 0.0) && (type == EnumMoveType.a || type == EnumMoveType.b) && this.gr() && this.H(f2)) {
            double d2;
            double d1 = movement.i;
            double d22 = 0.05;
            double d3 = Math.signum(d2) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d2 = movement.g; d2 != 0.0 && this.p(d2, 0.0, f2); d2 -= d3) {
                if (!(Math.abs(d2) <= 0.05)) continue;
                d2 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.p(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d2 != 0.0 && d1 != 0.0 && this.p(d2, d1, f2)) {
                d2 = Math.abs(d2) <= 0.05 ? 0.0 : (d2 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d2, movement.h, d1);
        }
        return movement;
    }

    private boolean H(float maxUpStep) {
        return this.aS() || this.an < (double)maxUpStep && !this.p(0.0, 0.0, (double)maxUpStep - this.an);
    }

    private boolean p(double x2, double z2, double distance) {
        AxisAlignedBB boundingBox = this.de();
        return this.an().a((Entity)this, new AxisAlignedBB(boundingBox.a + 1.0E-7 + x2, boundingBox.b - distance - 1.0E-7, boundingBox.c + 1.0E-7 + z2, boundingBox.d - 1.0E-7 + x2, boundingBox.b, boundingBox.f - 1.0E-7 + z2));
    }

    public void e(Entity target) {
        boolean willAttack = target.cO() && !target.w(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = this.fL() ? this.bW : (float)this.i(GenericAttributes.c);
            net.minecraft.world.item.ItemStack weaponItem = this.el();
            DamageSource damageSource = Optional.ofNullable(weaponItem.h().a(this)).orElse(this.ei().a(this));
            float f1 = this.a(target, f2, damageSource) - f2;
            float attackStrengthScale = this.G(0.5f);
            f2 *= 0.2f + attackStrengthScale * attackStrengthScale * 0.8f;
            f1 *= attackStrengthScale;
            if (target.ax().a(TagsEntity.H) && target instanceof IProjectile) {
                IProjectile projectile = (IProjectile)target;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(target, damageSource, f1, false)) {
                    return;
                }
                if (projectile.a(ProjectileDeflection.c, this, EntityReference.a(this), true)) {
                    this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.vW, this.dw());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                double d1;
                double d2;
                boolean flag1;
                boolean flag;
                boolean bl = flag = attackStrengthScale > 0.9f;
                if (this.cv() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dK(), this.dM(), this.dQ(), SoundEffects.vV, this.dw(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += weaponItem.h().a(target, f2, damageSource);
                boolean flag2 = flag && this.an > 0.0 && !this.aS() && !this.fe() && !this.bu() && !this.ha() && !this.cl() && target instanceof EntityLiving && !this.cv();
                boolean bl2 = flag2 = flag2 && !this.an().paperConfig().entities.behavior.disablePlayerCrits;
                if (flag2) {
                    damageSource = damageSource.critical();
                    f2 *= (float)this.an().purpurConfig.playerCriticalDamageMultiplier;
                }
                float f22 = f2 + f1;
                boolean flag3 = false;
                if (flag && !flag2 && !flag1 && this.aS() && (d2 = this.ag().j()) < MathHelper.l(d1 = (double)this.fD() * 2.5) && this.b(EnumHand.a).a(TagsItem.bV)) {
                    flag3 = true;
                }
                float f3 = 0.0f;
                if (target instanceof EntityLiving) {
                    EntityLiving livingEntity = (EntityLiving)target;
                    f3 = livingEntity.eU();
                }
                Vec3D deltaMovement = target.dI();
                boolean flag4 = target.b(damageSource, f22);
                if (flag4) {
                    Object event;
                    float f4 = this.b(target, damageSource) + (flag1 ? 1.0f : 0.0f);
                    if (f4 > 0.0f) {
                        if (target instanceof EntityLiving) {
                            EntityLiving livingEntity1 = (EntityLiving)target;
                            livingEntity1.knockback(f4 * 0.5f, MathHelper.a(this.dX() * ((float)Math.PI / 180)), -MathHelper.b(this.dX() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                        } else {
                            target.push(-MathHelper.a(this.dX() * ((float)Math.PI / 180)) * f4 * 0.5f, 0.1, MathHelper.b(this.dX() * ((float)Math.PI / 180)) * f4 * 0.5f, this);
                        }
                        this.k(this.dI().d(0.6, 1.0, 0.6));
                        if (!this.an().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.i(false);
                        }
                    }
                    if (flag3) {
                        float f5 = 1.0f + (float)this.i(GenericAttributes.E) * f2;
                        for (EntityLiving livingEntity2 : this.an().a(EntityLiving.class, target.de().c(1.0, 0.25, 1.0))) {
                            WorldServer serverLevel;
                            EntityArmorStand armorStand;
                            if (livingEntity2 == this || livingEntity2 == target || this.t(livingEntity2) || livingEntity2 instanceof EntityArmorStand && (armorStand = (EntityArmorStand)livingEntity2).s() || !(this.g(livingEntity2) < 9.0)) continue;
                            float f6 = this.a((Entity)livingEntity2, f5, damageSource) * attackStrengthScale;
                            livingEntity2.lastDamageCancelled = false;
                            World world = this.an();
                            if (!(world instanceof WorldServer) || !livingEntity2.a(serverLevel = (WorldServer)world, damageSource.knownCause(EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK), f6) || livingEntity2.lastDamageCancelled) continue;
                            livingEntity2.knockback(0.4f, MathHelper.a(this.dX() * ((float)Math.PI / 180)), -MathHelper.b(this.dX() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.SWEEP_ATTACK);
                            EnchantmentManager.a(serverLevel, (Entity)livingEntity2, damageSource);
                        }
                        EntityHuman.sendSoundEffect(this, this.dK(), this.dM(), this.dQ(), SoundEffects.vY, this.dw(), 1.0f, 1.0f);
                        this.gw();
                    }
                    if (target instanceof EntityPlayer && target.ah) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(deltaMovement);
                        event = new PlayerVelocityEvent(player, velocity.clone());
                        this.an().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).g.b(new PacketPlayOutEntityVelocity(target));
                            target.ah = false;
                            target.k(deltaMovement);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dK(), this.dM(), this.dQ(), SoundEffects.vU, this.dw(), 1.0f, 1.0f);
                        this.b(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dK(), this.dM(), this.dQ(), SoundEffects.vX, this.dw(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dK(), this.dM(), this.dQ(), SoundEffects.vZ, this.dw(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(target);
                    }
                    this.C(target);
                    Entity entity = target;
                    if (target instanceof EntityComplexPart) {
                        entity = ((EntityComplexPart)target).a;
                    }
                    boolean flag5 = false;
                    event = this.an();
                    if (event instanceof WorldServer) {
                        WorldServer serverLevel1 = (WorldServer)event;
                        if (entity instanceof EntityLiving) {
                            EntityLiving livingEntity2x = (EntityLiving)entity;
                            flag5 = weaponItem.a(livingEntity2x, (EntityLiving)this);
                        }
                        EnchantmentManager.a(serverLevel1, target, damageSource);
                    }
                    if (!this.an().D_() && !weaponItem.f() && entity instanceof EntityLiving) {
                        if (flag5) {
                            weaponItem.b((EntityLiving)entity, (EntityLiving)this);
                        }
                        if (weaponItem.f()) {
                            if (weaponItem == this.fq()) {
                                this.a(EnumHand.a, net.minecraft.world.item.ItemStack.l);
                            } else {
                                this.a(EnumHand.b, net.minecraft.world.item.ItemStack.l);
                            }
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f7 = f3 - ((EntityLiving)target).eU();
                        this.a(StatisticList.H, Math.round(f7 * 10.0f));
                        if (this.an() instanceof WorldServer && f7 > 2.0f) {
                            int i2 = (int)((double)f7 * 0.5);
                            ((WorldServer)this.an()).a(Particles.h, target.dK(), target.f(0.5), target.dQ(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.an().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dK(), this.dM(), this.dQ(), SoundEffects.vW, this.dw(), 1.0f, 1.0f);
                }
            }
        }
    }

    protected float a(Entity entity, float damage, DamageSource damageSource) {
        return damage;
    }

    @Override
    protected void f(EntityLiving target) {
        this.e((Entity)target);
    }

    public void b(Entity target) {
    }

    public void c(Entity target) {
    }

    public void gw() {
        double d2 = -MathHelper.a(this.dX() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dX() * ((float)Math.PI / 180));
        if (this.an() instanceof WorldServer) {
            ((WorldServer)this.an()).a(Particles.an, this.dK() + d2, this.f(0.5), this.dQ() + d1, 0, d2, 0.0, d1, 0.0);
        }
    }

    public void gx() {
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        super.remove(reason, eventCause);
        this.ck.a(this);
        if (this.gE()) {
            this.s();
        }
    }

    @Override
    public boolean ab_() {
        return true;
    }

    @Override
    protected boolean dr() {
        return this.gy();
    }

    public boolean gy() {
        return false;
    }

    @Override
    public boolean ds() {
        return !this.an().D_() || this.gy();
    }

    @Override
    public boolean dt() {
        return !this.an().D_() || this.gy();
    }

    public GameProfile gz() {
        return this.cI;
    }

    public NameAndId gA() {
        return new NameAndId(this.cI);
    }

    public PlayerInventory gB() {
        return this.cD;
    }

    public PlayerAbilities gC() {
        return this.cG;
    }

    @Override
    public boolean gk() {
        return this.cG.d;
    }

    public boolean gD() {
        return this.cG.d;
    }

    public void a(net.minecraft.world.item.ItemStack carried, net.minecraft.world.item.ItemStack clicked, ClickAction action) {
    }

    public boolean gE() {
        return this.cl != this.ck;
    }

    public boolean gF() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition bedPos) {
        return this.startSleepInBed(bedPos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition bedPos, boolean force) {
        this.b(bedPos);
        this.cF = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        super.gh();
        if (this.an() instanceof WorldServer && updateLevelForSleepingPlayers) {
            ((WorldServer)this.an()).f();
        }
        this.cF = wakeImmediately ? 0 : 100;
    }

    @Override
    public void gh() {
        this.a(true, true);
    }

    public boolean gG() {
        return this.gg() && this.cF >= 100;
    }

    public int gH() {
        return this.cF;
    }

    public void a(IChatBaseComponent message, boolean overlay) {
    }

    public void a(MinecraftKey statKey) {
        this.b(StatisticList.i.b(statKey));
    }

    public void a(MinecraftKey stat, int increment) {
        this.a(StatisticList.i.b(stat), increment);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int increment) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void a(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> items) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
    }

    public int b(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.cl()) {
            super.m(travelVector);
        } else {
            double d2;
            if (this.cw()) {
                double d1;
                d2 = this.cf().h;
                double d3 = d1 = d2 < -0.2 ? 0.085 : 0.06;
                if (d2 <= 0.0 || this.bL || !this.an().b_(BlockPosition.a(this.dK(), this.dM() + 1.0 - 0.1, this.dQ())).c()) {
                    Vec3D deltaMovement = this.dI();
                    this.k(deltaMovement.b(0.0, (d2 - deltaMovement.h) * d1, 0.0));
                }
            }
            if (this.gC().b) {
                d2 = this.dI().h;
                super.m(travelVector);
                this.k(this.dI().a(EnumDirection.EnumAxis.b, d2 * 0.6));
            } else {
                super.m(travelVector);
            }
        }
    }

    @Override
    public boolean fJ() {
        return !this.cG.b && super.fJ();
    }

    @Override
    public void bB() {
        if (this.cG.b) {
            this.j(false);
        } else {
            super.bB();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.an().a_(pos).j(this.an(), pos);
    }

    @Override
    public float fD() {
        return (float)this.i(GenericAttributes.w);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        double min;
        boolean flag;
        if (this.cG.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0) {
            this.a(StatisticList.t, (int)Math.round(fallDistance * 100.0));
        }
        boolean bl = flag = this.cy != null && this.cN;
        if (flag) {
            boolean flag1;
            min = Math.min(fallDistance, this.cy.h - this.dM());
            boolean bl2 = flag1 = min <= 0.0;
            if (flag1) {
                this.hh();
            } else {
                this.hg();
            }
        } else {
            min = fallDistance;
        }
        if (min > 0.0 && super.a(min, damageMultiplier, damageSource)) {
            this.hh();
            return true;
        }
        this.b(fallDistance, damageMultiplier, damageSource);
        return false;
    }

    public boolean gI() {
        if (!this.fY() && this.fJ() && !this.bu()) {
            this.gJ();
            return true;
        }
        return false;
    }

    public void gJ() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bE() {
        if (!this.at()) {
            super.bE();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.bu()) {
            this.bj();
            this.b(state);
        } else {
            BlockPosition primaryStepSoundBlockPos = this.e(pos);
            if (!pos.equals(primaryStepSoundBlockPos)) {
                IBlockData blockState = this.an().a_(primaryStepSoundBlockPos);
                if (blockState.a(TagsBlock.bA)) {
                    this.a(blockState, state);
                } else {
                    super.b(primaryStepSoundBlockPos, blockState);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a fc() {
        return new EntityLiving.a(SoundEffects.wk, SoundEffects.wa);
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity, DamageSource damageSource) {
        this.b(StatisticList.g.b(entity.ax()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D motionMultiplier) {
        if (!this.cG.b) {
            super.a(state, motionMultiplier);
        }
        this.hg();
    }

    public void d(int xpPoints) {
        this.r(xpPoints);
        this.ct += (float)xpPoints / (float)this.gL();
        this.cs = MathHelper.a(this.cs + xpPoints, 0, Integer.MAX_VALUE);
        while (this.ct < 0.0f) {
            float f2 = this.ct * (float)this.gL();
            if (this.cr > 0) {
                this.c(-1);
                this.ct = 1.0f + f2 / (float)this.gL();
                continue;
            }
            this.c(-1);
            this.ct = 0.0f;
        }
        while (this.ct >= 1.0f) {
            this.ct = (this.ct - 1.0f) * (float)this.gL();
            this.c(1);
            this.ct /= (float)this.gL();
        }
    }

    public int gK() {
        return this.cu;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int levelCost) {
        this.cr -= levelCost;
        if (this.cr < 0) {
            this.cr = 0;
            this.ct = 0.0f;
            this.cs = 0;
        }
        this.cu = this.as.f();
    }

    public void c(int levels) {
        this.cr = IntMath.saturatedAdd((int)this.cr, (int)levels);
        if (this.cr < 0) {
            this.cr = 0;
            this.ct = 0.0f;
            this.cs = 0;
        }
        if (levels > 0 && this.cr % 5 == 0 && (float)this.cH < (float)this.at - 100.0f) {
            float f2 = this.cr > 30 ? 1.0f : (float)this.cr / 30.0f;
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.wj, this.dw(), f2 * 0.75f, 1.0f);
            this.cH = this.at;
        }
    }

    public int gL() {
        if (this.cr >= 30) {
            return 112 + (this.cr - 30) * 9;
        }
        return this.cr >= 15 ? 37 + (this.cr - 15) * 5 : 7 + this.cr * 2;
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.an().a((Entity)fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)fromEntity;
            serverPlayer.g.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.as.g()));
        }
    }

    public void a(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float exhaustion, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cG.a || this.an().D_() || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, exhaustion)).isCancelled())) {
            this.cm.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> ab() {
        return Optional.empty();
    }

    public FoodMetaData gM() {
        return this.cm;
    }

    public boolean u(boolean canAlwaysEat) {
        return this.cG.a || canAlwaysEat || this.cm.b();
    }

    public boolean gN() {
        return this.eU() > 0.0f && this.eU() < this.fj();
    }

    public boolean gO() {
        return this.cG.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.cG.e) {
            return true;
        }
        BlockPosition blockPos = pos.a(facing.g());
        ShapeDetectorBlock blockInWorld = new ShapeDetectorBlock(this.an(), blockPos, false);
        return stack.a(blockInWorld);
    }

    @Override
    protected int f(WorldServer level) {
        if (!level.S().c(GameRules.e) && !this.at()) {
            int toDrop;
            try {
                toDrop = Math.round(((Number)Entity.scriptEngine.eval("let expLevel = " + this.cr + "; let expTotal = " + this.cs + "; let exp = " + this.ct + "; " + this.an().purpurConfig.playerDeathExpDropEquation)).floatValue());
            }
            catch (ScriptException e2) {
                e2.printStackTrace();
                toDrop = this.cr * 7;
            }
            return Math.min(toDrop, this.an().purpurConfig.playerDeathExpDropMax);
        }
        return 0;
    }

    @Override
    protected boolean eE() {
        return true;
    }

    @Override
    public boolean cZ() {
        return true;
    }

    @Override
    protected Entity.MovementEmission br() {
        return this.cG.b || this.aS() && this.cs() ? Entity.MovementEmission.a : Entity.MovementEmission.d;
    }

    public void z() {
    }

    @Override
    public IChatBaseComponent ao() {
        return IChatBaseComponent.b(this.cI.name());
    }

    @Override
    public String ap() {
        return this.cI.name();
    }

    public InventoryEnderChest gP() {
        return this.cj;
    }

    @Override
    protected boolean b(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    public boolean h(net.minecraft.world.item.ItemStack stack) {
        return this.cD.g(stack);
    }

    @Override
    public boolean cn() {
        return !this.an().purpurConfig.playerRidableInWater;
    }

    @Nullable
    public abstract EnumGamemode a();

    @Override
    public boolean at() {
        return this.a() == EnumGamemode.d;
    }

    @Override
    public boolean bS() {
        return !this.at() && super.bS();
    }

    @Override
    public boolean cw() {
        return !this.cG.b && !this.at() && super.cw();
    }

    public boolean gQ() {
        return this.a() == EnumGamemode.b;
    }

    @Override
    public boolean cW() {
        return !this.cG.b;
    }

    @Override
    public IChatBaseComponent S_() {
        IChatMutableComponent mutableComponent = ScoreboardTeam.a(this.cD(), this.ao());
        return this.a(mutableComponent);
    }

    private IChatMutableComponent a(IChatMutableComponent displayName) {
        String string = this.gz().name();
        return displayName.a(style -> style.a(new ChatClickable.SuggestCommand("/tell " + string + " ")).a(this.dd()).a(string));
    }

    @Override
    public String cV() {
        return this.gz().name();
    }

    @Override
    protected void F(float absorptionAmount) {
        this.aC().a(b, Float.valueOf(absorptionAmount));
    }

    @Override
    public float fM() {
        return this.aC().a(b).floatValue();
    }

    @Override
    public SlotAccess a_(int slot) {
        if (slot == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cl.g();
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack carried) {
                    EntityHuman.this.cl.a(carried);
                    return true;
                }
            };
        }
        final int i2 = slot - 500;
        if (i2 >= 0 && i2 < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.ck.r().a(i2);
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack carried) {
                    EntityHuman.this.ck.r().a(i2, carried);
                    EntityHuman.this.ck.a(EntityHuman.this.cD);
                    return true;
                }
            };
        }
        if (slot >= 0 && slot < this.cD.j().size()) {
            return SlotAccess.a(this.cD, slot);
        }
        int i1 = slot - 200;
        return i1 >= 0 && i1 < this.cj.b() ? SlotAccess.a(this.cj, i1) : super.a_(slot);
    }

    public boolean gR() {
        return this.cJ;
    }

    public void v(boolean reducedDebugInfo) {
        this.cJ = reducedDebugInfo;
    }

    @Override
    public void h(int ticks) {
        super.h(this.cG.a ? Math.min(ticks, 1) : ticks);
    }

    protected static Optional<EntityParrot.Variant> d(NBTTagCompound tag) {
        EntityTypes entityType;
        if (!tag.j() && (entityType = (EntityTypes)tag.a("id", EntityTypes.a).orElse(null)) == EntityTypes.aT) {
            return tag.a("Variant", EntityParrot.Variant.h);
        }
        return Optional.empty();
    }

    protected static OptionalInt a(Optional<EntityParrot.Variant> variant) {
        return variant.map(variant1 -> OptionalInt.of(variant1.a())).orElse(OptionalInt.empty());
    }

    private static Optional<EntityParrot.Variant> a(OptionalInt variantId) {
        return variantId.isPresent() ? Optional.of(EntityParrot.Variant.a(variantId.getAsInt())) : Optional.empty();
    }

    public void b(Optional<EntityParrot.Variant> variant) {
        this.az.a(d, EntityHuman.a(variant));
    }

    public Optional<EntityParrot.Variant> gS() {
        return EntityHuman.a(this.az.a(d));
    }

    public void c(Optional<EntityParrot.Variant> variant) {
        this.az.a(e, EntityHuman.a(variant));
    }

    public Optional<EntityParrot.Variant> gT() {
        return EntityHuman.a(this.az.a(e));
    }

    public float gU() {
        return (float)(1.0 / this.i(GenericAttributes.e) * 20.0);
    }

    public float G(float adjustTicks) {
        return MathHelper.a(((float)this.by + adjustTicks) / this.gU(), 0.0f, 1.0f);
    }

    public void gV() {
        this.by = 0;
    }

    public ItemCooldown gW() {
        return this.cL;
    }

    @Override
    protected float be() {
        return !this.cG.b && !this.fY() ? super.be() : 1.0f;
    }

    @Override
    public float ew() {
        return (float)this.i(GenericAttributes.r);
    }

    public boolean gX() {
        return this.cG.d && this.I() >= 2;
    }

    public int I() {
        return 0;
    }

    public boolean s(int permissionLevel) {
        return this.I() >= permissionLevel;
    }

    @Override
    public ImmutableList<EntityPose> gd() {
        return ImmutableList.of((Object)EntityPose.a, (Object)EntityPose.f, (Object)EntityPose.d);
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack, MutableBoolean cancelled) {
        EntityHuman entityHuman = this;
        if (!(entityHuman instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
        boolean notCancelled = new PlayerReadyArrowEvent((Player)serverPlayer.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
        if (!notCancelled) {
            cancelled.setValue(true);
        }
        return notCancelled;
    }

    @Override
    public net.minecraft.world.item.ItemStack d(net.minecraft.world.item.ItemStack shootable) {
        EntityHuman entityHuman;
        if (!(shootable.h() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.l;
        }
        MutableBoolean anyEventCancelled = new MutableBoolean();
        Predicate<net.minecraft.world.item.ItemStack> supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).c().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        net.minecraft.world.item.ItemStack heldProjectile = ItemProjectileWeapon.a(this, supportedHeldProjectiles);
        if (!heldProjectile.f()) {
            return heldProjectile;
        }
        supportedHeldProjectiles = ((ItemProjectileWeapon)shootable.h()).a().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        for (int i2 = 0; i2 < this.cD.b(); ++i2) {
            net.minecraft.world.item.ItemStack item2 = this.cD.a(i2);
            if (!supportedHeldProjectiles.test(item2)) continue;
            return item2;
        }
        if (anyEventCancelled.booleanValue() && !this.cG.d && (entityHuman = this) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityHuman;
            this.resyncUsingItem(player);
        }
        return this.gk() ? new net.minecraft.world.item.ItemStack(Items.pX) : net.minecraft.world.item.ItemStack.l;
    }

    @Override
    public Vec3D u(float partialTick) {
        double d2 = 0.22 * (this.as() == EnumMainHand.b ? -1.0 : 1.0);
        float f2 = MathHelper.h(partialTick * 0.5f, this.dZ(), this.ac) * ((float)Math.PI / 180);
        float f1 = MathHelper.h(partialTick, this.bC, this.bB) * ((float)Math.PI / 180);
        if (this.fY() || this.fL()) {
            float f22;
            Vec3D viewVector = this.h(partialTick);
            Vec3D deltaMovement = this.dI();
            double d1 = deltaMovement.j();
            double d22 = viewVector.j();
            if (d1 > 0.0 && d22 > 0.0) {
                double d3 = (deltaMovement.g * viewVector.g + deltaMovement.i * viewVector.i) / Math.sqrt(d1 * d22);
                double d4 = deltaMovement.g * viewVector.i - deltaMovement.i * viewVector.g;
                f22 = (float)(Math.signum(d4) * Math.acos(d3));
            } else {
                f22 = 0.0f;
            }
            return this.p(partialTick).e(new Vec3D(d2, -0.11, 0.85).c(-f22).a(-f2).b(-f1));
        }
        if (this.cx()) {
            return this.p(partialTick).e(new Vec3D(d2, 0.2, -0.15).a(-f2).b(-f1));
        }
        double d5 = this.de().c() - 1.0;
        double d1 = this.cu() ? -0.2 : 0.07;
        return this.p(partialTick).e(new Vec3D(d2, d5, d1).b(-f1));
    }

    @Override
    public boolean eg() {
        return true;
    }

    public boolean gY() {
        return this.fO() && this.fQ().a(Items.tb);
    }

    @Override
    public boolean ef() {
        return false;
    }

    public Optional<GlobalPos> gZ() {
        return this.cM;
    }

    public void d(Optional<GlobalPos> lastDeathLocation) {
        this.cM = lastDeathLocation;
    }

    @Override
    public float fa() {
        return this.cx;
    }

    @Override
    public void q(float yaw) {
        super.q(yaw);
        this.cx = yaw;
    }

    public boolean ha() {
        return this.d(MobEffects.o);
    }

    @Override
    public boolean ea() {
        return true;
    }

    @Override
    protected float fC() {
        if (this.cG.b && !this.cl()) {
            return this.cv() ? this.cG.a() * 2.0f : this.cG.a();
        }
        return this.cv() ? 0.025999999f : 0.02f;
    }

    public boolean hb() {
        return this.cE;
    }

    public void hc() {
        if (!this.cE) {
            --this.co;
            if (this.co <= 0) {
                this.cE = true;
                PlayerClientLoadedWorldEvent event = new PlayerClientLoadedWorldEvent((Player)((CraftPlayer)this.getBukkitEntity()), true);
                event.callEvent();
            }
        }
    }

    public void w(boolean clientLoaded) {
        this.cE = clientLoaded;
        if (!this.cE) {
            this.co = 60;
        }
    }

    @Override
    public boolean a(ContainerOpenersCounter openersCounter, BlockPosition pos) {
        return openersCounter.a(this);
    }

    @Override
    public double aq() {
        return this.hd();
    }

    public double hd() {
        return this.i(GenericAttributes.g);
    }

    public double he() {
        return this.i(GenericAttributes.k);
    }

    public boolean b(Entity entity, double distance) {
        return !entity.ec() && this.a(entity.de(), distance);
    }

    public boolean a(AxisAlignedBB boundingBox, double distance) {
        double d2 = this.he() + distance;
        return boundingBox.e(this.bR()) < d2 * d2;
    }

    public boolean a(BlockPosition pos, double distance) {
        double d2 = this.hd() + distance;
        return new AxisAlignedBB(pos).e(this.bR()) < d2 * d2;
    }

    public void x(boolean ignoreFallDamageFromCurrentImpulse) {
        this.cN = ignoreFallDamageFromCurrentImpulse;
        this.cO = ignoreFallDamageFromCurrentImpulse ? 40 : 0;
    }

    public boolean hf() {
        return this.cN;
    }

    public void hg() {
        if (this.cO == 0) {
            this.hh();
        }
    }

    public void hh() {
        this.cO = 0;
        this.cz = null;
        this.cy = null;
        this.cN = false;
    }

    public boolean hi() {
        return false;
    }

    @Override
    public boolean fe() {
        return !this.cG.b && super.fe();
    }

    public String hj() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.ap()).add("id", this.az()).add("pos", (Object)this.dD()).add("mode", (Object)this.a()).add("permission", this.I()).toString();
    }

    public static final class EnumBedResult
    extends Enum<EnumBedResult> {
        public static final /* enum */ EnumBedResult a = new EnumBedResult();
        public static final /* enum */ EnumBedResult b = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.no_sleep"));
        public static final /* enum */ EnumBedResult c = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.too_far_away"));
        public static final /* enum */ EnumBedResult d = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.obstructed"));
        public static final /* enum */ EnumBedResult e = new EnumBedResult();
        public static final /* enum */ EnumBedResult f = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.not_safe"));
        @Nullable
        private final IChatBaseComponent g;
        private static final /* synthetic */ EnumBedResult[] h;

        public static EnumBedResult[] values() {
            return (EnumBedResult[])h.clone();
        }

        public static EnumBedResult valueOf(String name) {
            return Enum.valueOf(EnumBedResult.class, name);
        }

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent message) {
            this.g = message;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }

        private static /* synthetic */ EnumBedResult[] b() {
            return new EnumBedResult[]{a, b, c, d, e, f};
        }

        static {
            h = EnumBedResult.b();
        }
    }
}

