/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double d = 2.0;
    private static final int f = 7;
    private static final float g = 0.6f;
    private static final float h = 0.99f;
    private static final short i = 0;
    private static final byte j = 0;
    private static final boolean k = false;
    private static final boolean l = false;
    private static final byte m = 0;
    private static final DataWatcherObject<Byte> n = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> o = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Boolean> p = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.k);
    private static final int q = 1;
    private static final int r = 2;
    @Nullable
    private IBlockData s;
    protected int a;
    public PickupStatus b = PickupStatus.a;
    public int c = 0;
    public int t = 0;
    public double u = 2.0;
    private SoundEffect aN = this.i();
    @Nullable
    private IntOpenHashSet aO;
    @Nullable
    private List<Entity> aP;
    public ItemStack aQ = this.n();
    @Nullable
    public ItemStack aR = null;
    public ItemEnchantments actualEnchantments = ItemEnchantments.a;

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, World level) {
        super((EntityTypes<? extends IProjectile>)type, level);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, double x2, double y2, double z2, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        this(type, x2, y2, z2, level, pickupItemStack, firedFromWeapon, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, double x2, double y2, double z2, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, @Nullable EntityLiving ownerEntity) {
        this(type, level);
        this.c(ownerEntity);
        this.aQ = pickupItemStack.v();
        this.c(pickupItemStack);
        Unit unit = pickupItemStack.e(DataComponents.u);
        if (unit != null) {
            this.b = PickupStatus.c;
        }
        this.a_(x2, y2, z2);
        if (firedFromWeapon != null && level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (firedFromWeapon.f()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.aR = firedFromWeapon.v();
            int piercingCount = EnchantmentManager.a(serverLevel, firedFromWeapon, this.aQ);
            if (piercingCount > 0) {
                this.a((byte)piercingCount);
            }
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, EntityLiving owner, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        this(type, owner.dK(), owner.dO() - (double)0.1f, owner.dQ(), level, pickupItemStack, firedFromWeapon, owner);
    }

    public void b(SoundEffect soundEvent) {
        this.aN = soundEvent;
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.de().a() * 10.0;
        if (Double.isNaN(d2)) {
            d2 = 1.0;
        }
        return distance < (d2 *= 64.0 * EntityArrow.cX()) * d2;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(n, (byte)0);
        builder.a(o, (byte)0);
        builder.a(p, false);
    }

    @Override
    public void c(double x2, double y2, double z2, float velocity, float inaccuracy) {
        super.c(x2, y2, z2, velocity, inaccuracy);
        this.t = 0;
    }

    @Override
    public void j(Vec3D movement) {
        super.j(movement);
        this.t = 0;
        if (this.e() && movement.h() > 0.0) {
            this.a(false);
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (!this.ay && this.c <= 0 && key.equals(p) && this.e()) {
            this.c = 7;
        }
    }

    @Override
    public void g() {
        VoxelShape collisionShape;
        boolean flag = !this.v();
        Vec3D deltaMovement = this.dI();
        BlockPosition blockPos = this.dF();
        IBlockData blockState = this.an().a_(blockPos);
        if (!blockState.l() && flag && !(collisionShape = blockState.g(this.an(), blockPos)).c()) {
            Vec3D vec3 = this.dD();
            for (AxisAlignedBB aabb : collisionShape.e()) {
                if (!aabb.a(blockPos).d(vec3)) continue;
                this.k(Vec3D.c);
                this.a(true);
                break;
            }
        }
        if (this.c > 0) {
            --this.c;
        }
        if (this.bw()) {
            this.aQ();
        }
        if (this.e() && flag) {
            if (!this.an().D_()) {
                if (this.s != blockState && this.x()) {
                    this.B();
                } else {
                    this.f();
                }
            }
            ++this.a;
            if (this.bX()) {
                this.aT();
            }
            if (!this.an().D_()) {
                this.d(this.aP() > 0);
            }
        } else {
            if (this.at > 200) {
                this.f();
            }
            this.a = 0;
            Vec3D vec31 = this.dD();
            if (this.bu()) {
                this.b(this.u());
                this.a(vec31);
            }
            if (this.r()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.an().a(Particles.g, vec31.g + deltaMovement.g * (double)i2 / 4.0, vec31.h + deltaMovement.h * (double)i2 / 4.0, vec31.i + deltaMovement.i * (double)i2 / 4.0, -deltaMovement.g, -deltaMovement.h + 0.2, -deltaMovement.i);
                }
            }
            float f2 = !flag ? (float)(MathHelper.d(-deltaMovement.g, -deltaMovement.i) * 180.0 / 3.1415927410125732) : (float)(MathHelper.d(deltaMovement.g, deltaMovement.i) * 180.0 / 3.1415927410125732);
            float f1 = (float)(MathHelper.d(deltaMovement.h, deltaMovement.i()) * 180.0 / 3.1415927410125732);
            this.w(EntityArrow.f(this.dZ(), f1));
            this.v(EntityArrow.f(this.dX(), f2));
            this.z();
            if (flag) {
                MovingObjectPositionBlock blockHitResult = this.an().b(new RayTrace(vec31, vec31.e(deltaMovement), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                this.b(blockHitResult);
            } else {
                this.b(vec31.e(deltaMovement));
                this.aT();
            }
            if (!this.bu()) {
                this.b(0.99f);
            }
            if (flag && !this.e()) {
                this.bq();
            }
            super.g();
        }
    }

    private void b(MovingObjectPositionBlock hitResult) {
        while (this.bX()) {
            Vec3D vec3 = this.dD();
            MovingObjectPositionEntity entityHitResult = this.b(vec3, hitResult.g());
            Vec3D location = ((MovingObjectPosition)Objects.requireNonNullElse(entityHitResult, hitResult)).g();
            this.b(location);
            this.a(vec3, location);
            if (this.aG != null && this.aG.e()) {
                this.ci();
            }
            if (entityHitResult == null) {
                if (!this.bX() || hitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) break;
                this.preHitTargetOrDeflectSelf(hitResult);
                this.aF = true;
                break;
            }
            if (!this.bX() || this.ar) continue;
            ProjectileDeflection projectileDeflection = this.preHitTargetOrDeflectSelf(entityHitResult);
            this.aF = true;
            if (this.s() > 0 && projectileDeflection == ProjectileDeflection.a) continue;
        }
    }

    private void b(float inertia) {
        Vec3D deltaMovement = this.dI();
        this.k(deltaMovement.c((double)inertia));
    }

    private void a(Vec3D pos) {
        Vec3D deltaMovement = this.dI();
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2 = 0.25f;
            this.an().a(Particles.d, pos.g - deltaMovement.g * 0.25, pos.h - deltaMovement.h * 0.25, pos.i - deltaMovement.i * 0.25, deltaMovement.g, deltaMovement.h, deltaMovement.i);
        }
    }

    @Override
    public ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition hitResult) {
        if (hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            if (this.hitCancelled && this.s() > 0) {
                if (this.aO == null) {
                    this.aO = new IntOpenHashSet(5);
                }
                this.aO.add(entityHitResult.a().az());
            }
        }
        return super.preHitTargetOrDeflectSelf(hitResult);
    }

    @Override
    protected double bo() {
        return 0.05;
    }

    private boolean x() {
        return this.e() && this.an().b(new AxisAlignedBB(this.dD(), this.dD()).g(0.06));
    }

    private void B() {
        this.a(false);
        Vec3D deltaMovement = this.dI();
        this.k(deltaMovement.d(this.as.i() * 0.2f, this.as.i() * 0.2f, this.as.i() * 0.2f));
        if (this.an().purpurConfig.arrowMovementResetsDespawnCounter) {
            this.t = 0;
        }
    }

    public boolean e() {
        return this.az.a(p);
    }

    protected void a(boolean inGround) {
        this.az.a(p, inGround);
    }

    @Override
    public boolean cW() {
        return !this.e();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        super.a(type, movement);
        if (type != EnumMoveType.a && this.x()) {
            this.B();
        }
    }

    protected void f() {
        ++this.t;
        if (this.t >= (this.b == PickupStatus.c ? this.an().paperConfig().entities.spawning.creativeArrowDespawnRate.value() : (this.b == PickupStatus.a ? this.an().paperConfig().entities.spawning.nonPlayerArrowDespawnRate.value() : (this instanceof EntityThrownTrident ? this.an().spigotConfig.tridentDespawnRate : this.an().spigotConfig.arrowDespawnRate)))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void C() {
        if (this.aP != null) {
            this.aP.clear();
        }
        if (this.aO != null) {
            this.aO.clear();
        }
    }

    @Override
    protected void b(Item item) {
        this.aR = null;
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (!this.e()) {
            super.a(downwards, pos);
        }
    }

    @Override
    public void m(boolean downwards) {
        if (!this.e()) {
            super.m(downwards);
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (!this.e()) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        EntityCombustByEntityEvent combustEvent;
        World world;
        super.a(result);
        Entity entity = result.a();
        float f2 = (float)this.dI().g();
        double d2 = this.u;
        Entity owner = this.ai_();
        DamageSource damageSource = this.ei().a(this, owner != null ? owner : this);
        if (this.el() != null && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            d2 = EnchantmentManager.a(serverLevel, this.el(), entity, damageSource, (float)d2);
        }
        int ceil = MathHelper.c(MathHelper.a((double)f2 * d2, 0.0, 2.147483647E9));
        if (this.s() > 0) {
            if (this.aO == null) {
                this.aO = new IntOpenHashSet(5);
            }
            if (this.aP == null) {
                this.aP = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.aO.size() >= this.s() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.aO.add(entity.az());
        }
        if (this.r()) {
            long l2 = this.as.a(ceil / 2 + 2);
            ceil = (int)Math.min(l2 + (long)ceil, Integer.MAX_VALUE);
        }
        if (owner instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)owner;
            livingEntity.C(entity);
        }
        if (this.r()) {
            damageSource = damageSource.critical();
        }
        boolean flag = entity.ax() == EntityTypes.Q;
        int remainingFireTicks = entity.aP();
        if (this.ck() && !flag && (combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f)).callEvent()) {
            entity.igniteForSeconds(combustEvent.getDuration(), false);
        }
        if (entity.b(damageSource, (float)ceil)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityPlayer serverPlayer;
                EntityLiving livingEntity1 = (EntityLiving)entity;
                if (!this.an().D_() && this.s() <= 0) {
                    livingEntity1.o(livingEntity1.fl() + 1);
                }
                this.a(livingEntity1, damageSource);
                World world2 = this.an();
                if (world2 instanceof WorldServer) {
                    WorldServer serverLevel1 = (WorldServer)world2;
                    EnchantmentManager.a(serverLevel1, (Entity)livingEntity1, damageSource, this.el());
                }
                this.a(livingEntity1);
                if (livingEntity1 instanceof EntityHuman && owner instanceof EntityPlayer) {
                    serverPlayer = (EntityPlayer)owner;
                    if (!this.bm() && livingEntity1 != serverPlayer) {
                        serverPlayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f));
                    }
                }
                if (!entity.bX() && this.aP != null) {
                    this.aP.add(livingEntity1);
                }
                if (!this.an().D_() && owner instanceof EntityPlayer) {
                    serverPlayer = (EntityPlayer)owner;
                    if (this.aP != null) {
                        CriterionTriggers.H.a(serverPlayer, this.aP, this.aR);
                    } else if (!entity.bX()) {
                        CriterionTriggers.H.a(serverPlayer, List.of(entity), this.aR);
                    }
                }
            }
            this.a(this.aN, 1.0f, 1.2f / (this.as.i() * 0.2f + 0.9f));
            if (this.s() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.h(remainingFireTicks);
            this.a(ProjectileDeflection.b, entity, this.e, false);
            this.k(this.dI().c(0.2));
            World world3 = this.an();
            if (world3 instanceof WorldServer) {
                WorldServer serverLevel2 = (WorldServer)world3;
                if (this.dI().h() < 1.0E-7) {
                    if (this.b == PickupStatus.b) {
                        this.a(serverLevel2, this.m(), 0.1f);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    protected void a(EntityLiving entity, DamageSource damageSource) {
        float f2;
        World world;
        if (this.aR != null && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            f2 = EnchantmentManager.d(serverLevel, this.aR, entity, damageSource, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d2 = f2;
        if (d2 > 0.0) {
            double max = Math.max(0.0, 1.0 - entity.i(GenericAttributes.q));
            Vec3D vec3 = this.dI().d(1.0, 0.0, 1.0).d().c(d2 * 0.6 * max);
            if (vec3.h() > 0.0) {
                entity.push(vec3.g, 0.1, vec3.i, this);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        this.s = this.an().a_(result.b());
        super.a(result);
        ItemStack weaponItem = this.el();
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (weaponItem != null) {
                this.a(serverLevel, result, weaponItem);
            }
        }
        Vec3D deltaMovement = this.dI();
        Vec3D vec3 = new Vec3D(Math.signum(deltaMovement.g), Math.signum(deltaMovement.h), Math.signum(deltaMovement.i));
        Vec3D vec31 = vec3.c((double)0.05f);
        this.b(this.dD().d(vec31));
        this.k(Vec3D.c);
        this.a(this.k(), 1.0f, 1.2f / (this.as.i() * 0.2f + 0.9f));
        this.a(true);
        this.c = 7;
        this.b(false);
        this.a((byte)0);
        this.b(SoundEffects.aF);
        this.C();
    }

    protected void a(WorldServer level, MovingObjectPositionBlock hitResult, ItemStack stack) {
        EntityLiving livingEntity;
        Vec3D vec3 = hitResult.b().a(hitResult.g());
        Entity entity = this.ai_();
        EnchantmentManager.a(level, stack, entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null, this, null, vec3, level.a_(hitResult.b()), item -> {
            this.aR = null;
        });
    }

    @Override
    @Nullable
    public ItemStack el() {
        return this.aR;
    }

    public void setActualEnchantments(ItemEnchantments actualEnchantments) {
        this.actualEnchantments = actualEnchantments;
    }

    protected SoundEffect i() {
        return SoundEffects.aF;
    }

    public final SoundEffect k() {
        return this.aN;
    }

    protected void a(EntityLiving target) {
    }

    @Nullable
    protected MovingObjectPositionEntity b(Vec3D startVec, Vec3D endVec) {
        return ProjectileHelper.a(this.an(), this, startVec, endVec, this.de().b(this.dI()).g(1.0), this::b);
    }

    @Override
    protected boolean b(Entity target) {
        EntityHuman player;
        Entity entity;
        return !(target instanceof EntityHuman && (entity = this.ai_()) instanceof EntityHuman && !(player = (EntityHuman)entity).a((EntityHuman)target) || !super.b(target) || this.aO != null && this.aO.contains(target.az()));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("life", (short)this.t);
        output.b("inBlockState", IBlockData.a, this.s);
        output.a("shake", (byte)this.c);
        output.a("inGround", this.e());
        output.a("pickup", PickupStatus.d, this.b);
        output.a("damage", this.u);
        output.a("crit", this.r());
        output.a("PierceLevel", this.s());
        output.a("SoundEvent", BuiltInRegistries.b.q(), this.aN);
        output.a("item", ItemStack.b, this.aQ);
        output.b("weapon", ItemStack.b, this.aR);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.t = input.a("life", (short)0);
        this.s = input.a("inBlockState", IBlockData.a).orElse(null);
        this.c = input.a("shake", (byte)0) & 0xFF;
        this.a(input.a("inGround", false));
        this.u = input.a("damage", 2.0);
        this.b = input.a("pickup", PickupStatus.d).orElse(PickupStatus.a);
        this.b(input.a("crit", false));
        this.a(input.a("PierceLevel", (byte)0));
        this.aN = input.a("SoundEvent", BuiltInRegistries.b.q()).orElse(this.i());
        this.a(input.a("item", ItemStack.b).orElse(this.n()));
        this.aR = input.a("weapon", ItemStack.b).orElse(null);
    }

    @Override
    public void c(@Nullable Entity entity) {
        this.setOwner(entity, true);
    }

    public void setOwner(@Nullable Entity entity, boolean resetPickup) {
        PickupStatus pickupStatus;
        super.c(entity);
        if (!resetPickup) {
            return;
        }
        Entity entity2 = entity;
        int n2 = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
                case 0: {
                    EntityHuman player = (EntityHuman)entity2;
                    if (this.b != PickupStatus.a) {
                        n2 = 1;
                        continue block4;
                    }
                    pickupStatus = PickupStatus.b;
                    break block4;
                }
                case 1: {
                    OminousItemSpawner ominousItemSpawner = (OminousItemSpawner)entity2;
                    pickupStatus = PickupStatus.a;
                    break block4;
                }
                default: {
                    pickupStatus = this.b;
                    break block4;
                }
            }
            break;
        }
        this.b = pickupStatus;
    }

    @Override
    public void a_(EntityHuman entity) {
        if (!this.an().D_() && (this.e() || this.v()) && this.c <= 0) {
            ItemStack itemstack = this.m();
            if (this.b == PickupStatus.b && !itemstack.f() && entity.gB().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.an(), this.dK(), this.dM(), this.dQ(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)item.getBukkitEntity(), (AbstractArrow)this.getBukkitEntity());
                if (!event.callEvent()) {
                    return;
                }
                itemstack = item.e();
            }
            if (this.b == PickupStatus.b && entity.gB().g(itemstack) || this.b == PickupStatus.c && entity.gC().d) {
                entity.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman player) {
        return switch (this.b.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> player.gB().g(this.m());
            case 2 -> player.gk();
        };
    }

    public ItemStack m() {
        return this.aQ.v();
    }

    protected abstract ItemStack n();

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.a;
    }

    public ItemStack q() {
        return this.aQ;
    }

    public void i(double baseDamage) {
        this.u = baseDamage;
    }

    @Override
    public boolean cO() {
        return this.ax().a(TagsEntity.H);
    }

    public void b(boolean critArrow) {
        this.a(1, critArrow);
    }

    public void a(byte pierceLevel) {
        this.az.a(o, pierceLevel);
    }

    private void a(int id, boolean value) {
        byte b2 = this.az.a(n);
        if (value) {
            this.az.a(n, (byte)(b2 | id));
        } else {
            this.az.a(n, (byte)(b2 & ~id));
        }
    }

    public void a(ItemStack pickupItemStack) {
        this.aQ = !pickupItemStack.f() ? pickupItemStack : this.n();
    }

    public boolean r() {
        byte b2 = this.az.a(n);
        return (b2 & 1) != 0;
    }

    public byte s() {
        return this.az.a(o);
    }

    public void a(float velocity) {
        this.i((double)(velocity * 2.0f) + this.as.a((double)this.an().aq().a() * 0.11, 0.57425));
    }

    protected float u() {
        return 0.6f;
    }

    public void r(boolean noPhysics) {
        this.ar = noPhysics;
        this.a(2, noPhysics);
    }

    public boolean v() {
        return !this.an().D_() ? this.ar : (this.az.a(n) & 2) != 0;
    }

    @Override
    public boolean bT() {
        return super.bT() && !this.e();
    }

    @Override
    public SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::q, this::a) : super.a_(slot);
    }

    @Override
    protected boolean w() {
        return true;
    }

    public static final class PickupStatus
    extends Enum<PickupStatus> {
        public static final /* enum */ PickupStatus a = new PickupStatus();
        public static final /* enum */ PickupStatus b = new PickupStatus();
        public static final /* enum */ PickupStatus c = new PickupStatus();
        public static final Codec<PickupStatus> d;
        private static final /* synthetic */ PickupStatus[] e;

        public static PickupStatus[] values() {
            return (PickupStatus[])e.clone();
        }

        public static PickupStatus valueOf(String name) {
            return Enum.valueOf(PickupStatus.class, name);
        }

        public static PickupStatus a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }

        private static /* synthetic */ PickupStatus[] a() {
            return new PickupStatus[]{a, b, c};
        }

        static {
            e = PickupStatus.a();
            d = Codec.BYTE.xmap(PickupStatus::a, pickup -> (byte)pickup.ordinal());
        }
    }
}

