/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityEnderSignal
extends Entity
implements ItemSupplier {
    private static final float a = 12.25f;
    private static final float b = 8.0f;
    private static final float c = 12.0f;
    private static final DataWatcherObject<ItemStack> d = DataWatcher.a(EntityEnderSignal.class, DataWatcherRegistry.h);
    @Nullable
    public Vec3D e;
    public int f;
    public boolean g;

    public EntityEnderSignal(EntityTypes<? extends EntityEnderSignal> type, World level) {
        super(type, level);
    }

    public EntityEnderSignal(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderSignal>)EntityTypes.Z, level);
        this.a_(x2, y2, z2);
    }

    public void a(ItemStack stack) {
        if (stack.f()) {
            this.aC().a(d, this.f());
        } else {
            this.aC().a(d, stack.c(1));
        }
    }

    @Override
    public ItemStack e() {
        return this.aC().a(d);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(d, this.f());
    }

    @Override
    public boolean a(double distance) {
        if (this.at < 2 && distance < 12.25) {
            return false;
        }
        double d2 = this.de().a() * 4.0;
        if (Double.isNaN(d2)) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    public void a(Vec3D pos) {
        this.signalTo(pos, true);
    }

    public void signalTo(Vec3D pos, boolean update) {
        Vec3D vec3 = pos.d(this.dD());
        double d2 = vec3.i();
        this.e = d2 > 12.0 ? this.dD().b(vec3.g / d2 * 12.0, 8.0, vec3.i / d2 * 12.0) : pos;
        if (update) {
            this.f = 0;
            this.g = this.as.a(5) > 0;
        }
    }

    @Override
    public void g() {
        super.g();
        Vec3D vec3 = this.dD().e(this.dI());
        if (!this.an().D_() && this.e != null) {
            this.k(EntityEnderSignal.a(this.dI(), vec3, this.e));
        }
        if (this.an().D_()) {
            Vec3D vec31 = vec3.d(this.dI().c(0.25));
            this.b(vec31, this.dI());
        }
        this.b(vec3);
        if (!this.an().D_()) {
            ++this.f;
            if (this.f > 80 && !this.an().D_()) {
                this.a(SoundEffects.jt, 1.0f, 1.0f);
                this.discard(this.g ? EntityRemoveEvent.Cause.DROP : EntityRemoveEvent.Cause.DESPAWN);
                if (this.g) {
                    this.an().b(new EntityItem(this.an(), this.dK(), this.dM(), this.dQ(), this.e()));
                } else {
                    this.an().c(2003, this.dF(), 0);
                }
            }
        }
    }

    private void b(Vec3D pos, Vec3D deltaMovement) {
        if (this.bu()) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.an().a(Particles.d, pos.g, pos.h, pos.i, deltaMovement.g, deltaMovement.h, deltaMovement.i);
            }
        } else {
            this.an().a(Particles.ag, pos.g + this.as.j() * 0.6 - 0.3, pos.h - 0.5, pos.i + this.as.j() * 0.6 - 0.3, deltaMovement.g, deltaMovement.h, deltaMovement.i);
        }
    }

    private static Vec3D a(Vec3D deltaMovement, Vec3D pos, Vec3D target) {
        Vec3D vec3 = new Vec3D(target.g - pos.g, 0.0, target.i - pos.i);
        double len = vec3.g();
        double d2 = MathHelper.d(0.0025, deltaMovement.i(), len);
        double d1 = deltaMovement.h;
        if (len < 1.0) {
            d2 *= 0.8;
            d1 *= 0.8;
        }
        double d22 = pos.h - deltaMovement.h < target.h ? 1.0 : -1.0;
        return vec3.c(d2 / len).b(0.0, d1 + (d22 - d1) * 0.015, 0.0);
    }

    @Override
    protected void a(ValueOutput output) {
        output.a("Item", ItemStack.b, this.e());
    }

    @Override
    protected void a(ValueInput input) {
        this.a(input.a("Item", ItemStack.b).orElse(this.f()));
    }

    private ItemStack f() {
        return new ItemStack(Items.uw);
    }

    @Override
    public float bK() {
        return 1.0f;
    }

    @Override
    public boolean cO() {
        return false;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }
}

