/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class EntityFireball
extends IProjectile {
    public static final double a = 0.1;
    public static final double b = 0.5;
    public double c = 0.1;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, World level) {
        super((EntityTypes<? extends IProjectile>)type, level);
    }

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, World level) {
        this(type, level);
        this.a_(x2, y2, z2);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, Vec3D movement, World level) {
        this(type, level);
        this.b(x2, y2, z2, this.dX(), this.dZ());
        this.aG();
        this.a(movement, this.c);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, EntityLiving owner, Vec3D movement, World level) {
        this(type, owner.dK(), owner.dM(), owner.dQ(), movement, level);
        this.c(owner);
        this.a(owner.dX(), owner.dZ());
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.de().a() * 4.0;
        if (Double.isNaN(d2)) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    protected RayTrace.BlockCollisionOption aj_() {
        return RayTrace.BlockCollisionOption.a;
    }

    @Override
    public void g() {
        Entity owner = this.ai_();
        this.n();
        if (this.an().D_() || (owner == null || !owner.ec()) && this.an().D(this.dF())) {
            MovingObjectPosition hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b, this.aj_());
            Vec3D location = hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a ? hitResultOnMoveVector.g() : this.dD().e(this.dI());
            ProjectileHelper.a((Entity)this, 0.2f);
            this.b(location);
            this.aT();
            super.g();
            if (this.f()) {
                this.e(1.0f);
            }
            if (hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a && this.bX()) {
                this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
            }
            this.q();
        } else {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void n() {
        float liquidInertia;
        Vec3D deltaMovement = this.dI();
        Vec3D vec3 = this.dD();
        if (this.bu()) {
            for (int i2 = 0; i2 < 4; ++i2) {
                float f2 = 0.25f;
                this.an().a(Particles.d, vec3.g - deltaMovement.g * 0.25, vec3.h - deltaMovement.h * 0.25, vec3.i - deltaMovement.i * 0.25, deltaMovement.g, deltaMovement.h, deltaMovement.i);
            }
            liquidInertia = this.m();
        } else {
            liquidInertia = this.k();
        }
        this.k(deltaMovement.e(deltaMovement.d().c(this.c)).c((double)liquidInertia));
    }

    private void q() {
        ParticleParam trailParticle = this.i();
        Vec3D vec3 = this.dD();
        if (trailParticle != null) {
            this.an().a(trailParticle, vec3.g, vec3.h + 0.5, vec3.i, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }

    @Override
    protected boolean b(Entity target) {
        return super.b(target) && !target.ar;
    }

    protected boolean f() {
        return true;
    }

    @Nullable
    protected ParticleParam i() {
        return Particles.ai;
    }

    protected float k() {
        return 0.95f;
    }

    protected float m() {
        return 0.8f;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("acceleration_power", this.c);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.c = input.a("acceleration_power", 0.1);
    }

    @Override
    public float bK() {
        return 1.0f;
    }

    public void a(Vec3D movement, double accelerationPower) {
        this.k(movement.d().c(accelerationPower));
        this.aF = true;
    }

    @Override
    protected void b_(boolean deflectedByPlayer) {
        super.b_(deflectedByPlayer);
        this.c = deflectedByPlayer ? 0.1 : (this.c *= 0.5);
    }
}

