/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> a = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<OptionalInt> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.u);
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    private static final int d = 0;
    private static final int f = 0;
    private static final boolean g = false;
    public int h = 0;
    public int i = 0;
    @Nullable
    public EntityLiving j;
    @Nullable
    public UUID spawningEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> type, World level) {
        super((EntityTypes<? extends IProjectile>)type, level);
    }

    public EntityFireworks(World level, double x2, double y2, double z2, ItemStack stack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.ac, level);
        this.h = 0;
        this.a_(x2, y2, z2);
        this.az.a(a, stack.v());
        int i2 = 1;
        Fireworks fireworks = stack.a(DataComponents.aj);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.m(this.as.a(0.0, 0.002297), 0.05, this.as.a(0.0, 0.002297));
        this.i = 10 * i2 + this.as.a(6) + this.as.a(7);
    }

    public EntityFireworks(World level, @Nullable Entity shooter, double x2, double y2, double z2, ItemStack stack) {
        this(level, x2, y2, z2, stack);
        this.c(shooter);
    }

    public EntityFireworks(World level, ItemStack stack, EntityLiving shooter) {
        this(level, shooter, shooter.dK(), shooter.dM(), shooter.dQ(), stack);
        this.az.a(b, OptionalInt.of(shooter.az()));
        this.j = shooter;
    }

    public EntityFireworks(World level, ItemStack stack, double x2, double y2, double z2, boolean shotAtAngle) {
        this(level, x2, y2, z2, stack);
        this.az.a(c, shotAtAngle);
    }

    public EntityFireworks(World level, ItemStack stack, Entity shooter, double x2, double y2, double z2, boolean shotAtAngle) {
        this(level, stack, x2, y2, z2, shotAtAngle);
        this.c(shooter);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(a, EntityFireworks.n());
        builder.a(b, OptionalInt.empty());
        builder.a(c, false);
    }

    @Override
    public boolean a(double distance) {
        return distance < 4096.0 && !this.k();
    }

    @Override
    public boolean j(double x2, double y2, double z2) {
        return super.j(x2, y2, z2) && !this.k();
    }

    @Override
    public void inactiveTick() {
        World world;
        ++this.h;
        if (this.h > this.i && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (CraftEventFactory.callFireworkExplodeEvent(this)) {
                this.b(serverLevel);
            }
        }
        super.inactiveTick();
    }

    @Override
    public void g() {
        World world;
        MovingObjectPosition hitResultOnMoveVector;
        super.g();
        if (this.k()) {
            if (this.j == null) {
                this.az.a(b).ifPresent(target -> {
                    Entity entity = this.an().a(target);
                    if (entity instanceof EntityLiving) {
                        this.j = (EntityLiving)entity;
                    }
                });
            }
            if (this.j != null) {
                if (this.j.fY()) {
                    Vec3D lookAngle = this.j.cf();
                    double d2 = 1.5;
                    double d1 = 0.1;
                    Vec3D deltaMovement = this.j.dI();
                    this.j.k(deltaMovement.b(lookAngle.g * 0.1 + (lookAngle.g * 1.5 - deltaMovement.g) * 0.5, lookAngle.h * 0.1 + (lookAngle.h * 1.5 - deltaMovement.h) * 0.5, lookAngle.i * 0.1 + (lookAngle.i * 1.5 - deltaMovement.i) * 0.5));
                    handHoldingItemAngle = this.j.a(Items.wC);
                } else {
                    handHoldingItemAngle = Vec3D.c;
                }
                this.a_(this.j.dK() + handHoldingItemAngle.g, this.j.dM() + handHoldingItemAngle.h, this.j.dQ() + handHoldingItemAngle.i);
                this.k(this.j.dI());
            }
            hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
        } else {
            if (!this.f()) {
                double d2 = this.ad ? 1.0 : 1.15;
                this.k(this.dI().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            handHoldingItemAngle = this.dI();
            hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
            this.a(EnumMoveType.a, handHoldingItemAngle);
            this.aT();
            this.k(handHoldingItemAngle);
        }
        if (!this.ar && this.bX() && hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
            this.aF = true;
        }
        this.A();
        if (this.h == 0 && !this.bm()) {
            this.an().a(null, this.dK(), this.dM(), this.dQ(), SoundEffects.kh, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.h;
        if (this.an().D_() && this.h % 2 < 2) {
            this.an().a(Particles.E, this.dK(), this.dM(), this.dQ(), this.as.k() * 0.05, -this.dI().h * 0.5, this.as.k() * 0.05);
        }
        if (this.h > this.i && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (CraftEventFactory.callFireworkExplodeEvent(this)) {
                this.b(serverLevel);
            }
        }
    }

    private void b(WorldServer level) {
        level.a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.ai_());
        this.e(level);
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (CraftEventFactory.callFireworkExplodeEvent(this)) {
                this.b(serverLevel);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        BlockPosition blockPos = new BlockPosition(result.b());
        this.an().a_(blockPos).a(this.an(), blockPos, this, InsideBlockEffectApplier.a, true);
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.i() && CraftEventFactory.callFireworkExplodeEvent(this)) {
                this.b(serverLevel);
            }
        }
        super.a(result);
    }

    private boolean i() {
        return !this.m().isEmpty();
    }

    private void e(WorldServer level) {
        float f2 = 0.0f;
        List<FireworkExplosion> explosions = this.m();
        if (!explosions.isEmpty()) {
            f2 = 5.0f + (float)(explosions.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.j != null) {
                this.j.a(level, this.ei().a(this, this.ai_()), 5.0f + (float)(explosions.size() * 2));
            }
            double d2 = 5.0;
            Vec3D vec3 = this.dD();
            for (EntityLiving livingEntity : this.an().a(EntityLiving.class, this.de().g(5.0))) {
                if (livingEntity == this.j || this.g(livingEntity) > 25.0) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec31 = new Vec3D(livingEntity.dK(), livingEntity.f(0.5 * (double)i2), livingEntity.dQ());
                    MovingObjectPositionBlock hitResult = this.an().a(new RayTrace(vec3, vec31, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (((MovingObjectPosition)hitResult).d() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(livingEntity)) / 5.0);
                livingEntity.a(level, this.ei().a(this, this.ai_()), f1);
            }
        }
    }

    private boolean k() {
        return this.az.a(b).isPresent();
    }

    public boolean f() {
        return this.az.a(c);
    }

    @Override
    public void b(byte id) {
        if (id == 17 && this.an().D_()) {
            Vec3D deltaMovement = this.dI();
            this.an().a(this.dK(), this.dM(), this.dQ(), deltaMovement.g, deltaMovement.h, deltaMovement.i, this.m());
        }
        super.b(id);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Life", this.h);
        output.a("LifeTime", this.i);
        output.a("FireworksItem", ItemStack.b, this.e());
        output.a("ShotAtAngle", this.az.a(c));
        output.b("SpawningEntity", UUIDUtil.a, this.spawningEntity);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.h = input.a("Life", 0);
        this.i = input.a("LifeTime", 0);
        this.az.a(a, input.a("FireworksItem", ItemStack.b).orElse(EntityFireworks.n()));
        this.az.a(c, input.a("ShotAtAngle", false));
        this.spawningEntity = input.a("SpawningEntity", UUIDUtil.a).orElse(null);
    }

    private List<FireworkExplosion> m() {
        ItemStack itemStack = this.az.a(a);
        Fireworks fireworks = itemStack.a(DataComponents.aj);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack e() {
        return this.az.a(a);
    }

    @Override
    public boolean cO() {
        return false;
    }

    public static ItemStack n() {
        return new ItemStack(Items.wC);
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entity, DamageSource damageSource) {
        double d2 = entity.dD().g - this.dD().g;
        double d1 = entity.dD().i - this.dD().i;
        return DoubleDoubleImmutablePair.of((double)d2, (double)d1);
    }
}

