/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.FishHookStateChangeEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger a = LogUtils.getLogger();
    private final RandomSource b = RandomSource.a();
    private boolean c;
    public int d;
    private static final int f = 10;
    public static final DataWatcherObject<Integer> g = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.k);
    private int i;
    private int j;
    public int k;
    public int l;
    public float m;
    private boolean n = true;
    @Nullable
    public Entity o;
    public HookState p = HookState.a;
    private final int q;
    private final int r;
    private final InterpolationHandler s = new InterpolationHandler(this);
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World level, int luck, int lureSpeed) {
        super((EntityTypes<? extends IProjectile>)type, level);
        this.q = Math.max(0, luck);
        this.r = Math.max(0, lureSpeed);
        this.minWaitTime = level.paperConfig().fishingTimeRange.minimum;
        this.maxWaitTime = level.paperConfig().fishingTimeRange.maximum;
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World level) {
        this(type, level, 0, 0);
    }

    public EntityFishingHook(EntityHuman owner, World level, int luck, int lureSpeed) {
        this(EntityTypes.bY, level, luck, lureSpeed);
        this.c((Entity)owner);
        float xRot = owner.dZ();
        float yRot = owner.dX();
        float cos = MathHelper.b(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float sin = MathHelper.a(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = -MathHelper.b(-xRot * ((float)Math.PI / 180));
        float sin1 = MathHelper.a(-xRot * ((float)Math.PI / 180));
        double d2 = owner.dK() - (double)sin * 0.3;
        double eyeY = owner.dO();
        double d1 = owner.dQ() - (double)cos * 0.3;
        this.b(d2, eyeY, d1, yRot, xRot);
        Vec3D vec3 = new Vec3D(-sin, MathHelper.a(-(sin1 / f2), -5.0f, 5.0f), -cos);
        double len = vec3.g();
        vec3 = vec3.d(0.6 / len + this.as.a(0.5, 0.0103365), 0.6 / len + this.as.a(0.5, 0.0103365), 0.6 / len + this.as.a(0.5, 0.0103365));
        this.k(vec3);
        this.v((float)(MathHelper.d(vec3.g, vec3.i) * 180.0 / 3.1415927410125732));
        this.w((float)(MathHelper.d(vec3.h, vec3.i()) * 180.0 / 3.1415927410125732));
        this.ab = this.dX();
        this.ac = this.dZ();
    }

    @Override
    @Nonnull
    public InterpolationHandler n_() {
        return this.s;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(g, 0);
        builder.a(h, false);
    }

    @Override
    protected boolean w() {
        return true;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (g.equals(key)) {
            int i2 = this.aC().a(g);
            Entity entity = this.o = i2 > 0 ? this.an().a(i2 - 1) : null;
        }
        if (h.equals(key)) {
            this.c = this.aC().a(h);
            if (this.c) {
                this.m(this.dI().g, -0.4f * MathHelper.a(this.b, 0.6f, 1.0f), this.dI().i);
            }
        }
        super.a(key);
    }

    @Override
    public boolean a(double distance) {
        double d2 = 64.0;
        return distance < 4096.0;
    }

    @Override
    public void g() {
        this.b.b(this.cT().getLeastSignificantBits() ^ this.an().ag());
        this.n_().e();
        super.g();
        EntityHuman playerOwner = this.f();
        if (playerOwner == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.an().D_() || !this.a(playerOwner)) {
            boolean flag;
            if (this.aS()) {
                ++this.i;
                if (this.i >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.i = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockPos = this.dF();
            Fluid fluidState = this.an().b_(blockPos);
            if (fluidState.a(TagsFluid.a)) {
                f2 = fluidState.a(this.an(), blockPos);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.p == HookState.a) {
                if (this.o != null) {
                    this.k(Vec3D.c);
                    new FishHookStateChangeEvent((FishHook)this.getBukkitEntity(), FishHook.HookState.HOOKED_ENTITY).callEvent();
                    this.p = HookState.b;
                    return;
                }
                if (flag) {
                    this.k(this.dI().d(0.3, 0.2, 0.3));
                    new FishHookStateChangeEvent((FishHook)this.getBukkitEntity(), FishHook.HookState.BOBBING).callEvent();
                    this.p = HookState.c;
                    return;
                }
                this.k();
            } else {
                if (this.p == HookState.b) {
                    if (this.o != null) {
                        if (!this.o.ec() && this.o.au() && this.o.an().al() == this.an().al()) {
                            this.a_(this.o.dK(), this.o.f(0.8), this.o.dQ());
                        } else {
                            this.C(null);
                            new FishHookStateChangeEvent((FishHook)this.getBukkitEntity(), FishHook.HookState.UNHOOKED).callEvent();
                            this.p = HookState.a;
                        }
                    }
                    return;
                }
                if (this.p == HookState.c) {
                    Vec3D deltaMovement = this.dI();
                    double d2 = this.dM() + deltaMovement.h - (double)blockPos.v() - (double)f2;
                    if (Math.abs(d2) < 0.01) {
                        d2 += Math.signum(d2) * 0.1;
                    }
                    this.m(deltaMovement.g * 0.9, deltaMovement.h - d2 * (double)this.as.i() * 0.2, deltaMovement.i * 0.9);
                    if (this.j <= 0 && this.l <= 0) {
                        this.n = true;
                    } else {
                        boolean bl2 = this.n = this.n && this.d < 10 && this.b(blockPos);
                    }
                    if (flag) {
                        this.d = Math.max(0, this.d - 1);
                        if (this.c) {
                            this.k(this.dI().b(0.0, -0.1 * (double)this.b.i() * (double)this.b.i(), 0.0));
                        }
                        if (!this.an().D_()) {
                            this.a(blockPos);
                        }
                    } else {
                        this.d = Math.min(10, this.d + 1);
                    }
                }
            }
            if (!fluidState.a(TagsFluid.a) && !this.aS() && this.o == null) {
                this.k(this.dI().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.dI());
            this.aT();
            this.A();
            if (this.p == HookState.a && (this.aS() || this.ad)) {
                this.k(Vec3D.c);
            }
            double d1 = 0.92;
            this.k(this.dI().c(0.92));
            this.aG();
        }
    }

    private boolean a(EntityHuman player) {
        if (player.au()) {
            ItemStack mainHandItem = player.fq();
            ItemStack offhandItem = player.fr();
            boolean isFishingRod = mainHandItem.a(Items.sZ);
            boolean isFishingRod1 = offhandItem.a(Items.sZ);
            if ((isFishingRod || isFishingRod1) && this.g(player) <= 1024.0) {
                return false;
            }
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void k() {
        MovingObjectPosition hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
    }

    @Override
    protected boolean b(Entity target) {
        return super.b(target) || target.bX() && target instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        if (!this.an().D_()) {
            this.C(result.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        this.k(this.dI().d().c(result.a(this)));
    }

    public void C(@Nullable Entity hookedEntity) {
        this.o = hookedEntity;
        this.aC().a(g, hookedEntity == null ? 0 : hookedEntity.az() + 1);
    }

    private void a(BlockPosition pos) {
        WorldServer serverLevel = (WorldServer)this.an();
        int i2 = 1;
        BlockPosition blockPos = pos.d();
        if (this.rainInfluenced && this.as.i() < 0.25f && this.an().r(blockPos)) {
            ++i2;
        }
        if (this.skyInfluenced && this.as.i() < 0.5f && !this.an().h(blockPos)) {
            --i2;
        }
        if (this.j > 0) {
            --this.j;
            if (this.j <= 0) {
                this.k = 0;
                this.l = 0;
                this.aC().a(h, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                playerFishEvent.callEvent();
            }
        } else if (this.l > 0) {
            this.l -= i2;
            if (this.l > 0) {
                double d2;
                double d1;
                this.m += (float)this.as.a(0.0, 9.188);
                float f2 = this.m * ((float)Math.PI / 180);
                float sin = MathHelper.a(f2);
                float cos = MathHelper.b(f2);
                double d3 = this.dK() + (double)(sin * (float)this.l * 0.1f);
                IBlockData blockState = serverLevel.a_(BlockPosition.a(d3, (d1 = (double)((float)MathHelper.a(this.dM()) + 1.0f)) - 1.0, d2 = this.dQ() + (double)(cos * (float)this.l * 0.1f)));
                if (blockState.a(Blocks.J)) {
                    if (this.as.i() < 0.15f) {
                        serverLevel.a(Particles.d, d3, d1 - (double)0.1f, d2, 1, (double)sin, 0.1, (double)cos, 0.0);
                    }
                    float f1 = sin * 0.04f;
                    float f22 = cos * 0.04f;
                    serverLevel.a(Particles.F, d3, d1, d2, 0, (double)f22, 0.01, (double)(-f1), 1.0);
                    serverLevel.a(Particles.F, d3, d1, d2, 0, (double)(-f22), 0.01, (double)f1, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                if (!playerFishEvent.callEvent()) {
                    return;
                }
                this.a(SoundEffects.kp, 0.25f, 1.0f + (this.as.i() - this.as.i()) * 0.4f);
                double d3 = this.dM() + 0.5;
                serverLevel.a(Particles.d, this.dK(), d3, this.dQ(), (int)(1.0f + this.dA() * 20.0f), (double)this.dA(), 0.0, (double)this.dA(), (double)0.2f);
                serverLevel.a(Particles.F, this.dK(), d3, this.dQ(), (int)(1.0f + this.dA() * 20.0f), (double)this.dA(), 0.0, (double)this.dA(), (double)0.2f);
                this.j = MathHelper.a(this.as, 20, 40);
                this.aC().a(h, true);
            }
        } else if (this.k > 0) {
            this.k -= i2;
            float f3 = 0.15f;
            if (this.k < 20) {
                f3 += (float)(20 - this.k) * 0.05f;
            } else if (this.k < 40) {
                f3 += (float)(40 - this.k) * 0.02f;
            } else if (this.k < 60) {
                f3 += (float)(60 - this.k) * 0.01f;
            }
            if (this.as.i() < f3) {
                double d2;
                double d1;
                float sin = MathHelper.a(this.as, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float cos = MathHelper.a(this.as, 25.0f, 60.0f);
                double d4 = this.dK() + (double)(MathHelper.a(sin) * cos) * 0.1;
                IBlockData blockState = serverLevel.a_(BlockPosition.a(d4, (d1 = (double)((float)MathHelper.a(this.dM()) + 1.0f)) - 1.0, d2 = this.dQ() + (double)(MathHelper.b(sin) * cos) * 0.1));
                if (blockState.a(Blocks.J)) {
                    serverLevel.a(Particles.aq, d4, d1, d2, 2 + this.as.a(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.k <= 0) {
                PlayerFishEvent playerFishEvent;
                this.m = MathHelper.a(this.as, this.minLureAngle, this.maxLureAngle);
                this.l = MathHelper.a(this.as, this.minLureTime, this.maxLureTime);
                if (this.f() != null && !(playerFishEvent = new PlayerFishEvent((Player)this.f().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.LURED)).callEvent()) {
                    this.l = 0;
                    return;
                }
            }
        } else {
            this.resetTimeUntilLured();
        }
    }

    public void resetTimeUntilLured() {
        this.k = MathHelper.a(this.as, this.minWaitTime, this.maxWaitTime);
        this.k -= this.applyLure ? (this.r >= this.maxWaitTime ? this.k - 1 : this.r) : 0;
    }

    public boolean b(BlockPosition pos) {
        WaterPosition openWaterType = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition openWaterTypeForArea = this.a(pos.b(-2, i2, -2), pos.b(2, i2, 2));
            switch (openWaterTypeForArea.ordinal()) {
                case 0: {
                    if (openWaterType != WaterPosition.c) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != WaterPosition.a) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            openWaterType = openWaterTypeForArea;
        }
        return true;
    }

    private WaterPosition a(BlockPosition pos1, BlockPosition pos2) {
        return BlockPosition.d(pos1, pos2).map(this::c).reduce((type1, type2) -> type1 == type2 ? type1 : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition pos) {
        IBlockData blockState = this.an().a_(pos);
        if (!blockState.l() && !blockState.a(Blocks.fV)) {
            Fluid fluidState = blockState.y();
            return fluidState.a(TagsFluid.a) && fluidState.b() && blockState.g(this.an(), pos).c() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean e() {
        return this.n;
    }

    @Override
    protected void a(ValueOutput output) {
    }

    @Override
    protected void a(ValueInput input) {
    }

    @Deprecated
    @DoNotUse
    public int a(ItemStack stack) {
        return this.retrieve(stack, EnumHand.a);
    }

    public int retrieve(ItemStack stack, EnumHand hand) {
        EntityHuman playerOwner = this.f();
        if (!this.an().D_() && playerOwner != null && !this.a(playerOwner)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.o != null) {
                playerFishEvent = new PlayerFishEvent((Player)playerOwner.getBukkitEntity(), (org.bukkit.entity.Entity)this.o.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_ENTITY);
                if (!playerFishEvent.callEvent()) {
                    return 0;
                }
                if (this.o != null) {
                    this.d(this.o);
                    CriterionTriggers.E.a((EntityPlayer)playerOwner, stack, this, Collections.emptyList());
                    this.an().a((Entity)this, (byte)31);
                    i2 = this.o instanceof EntityItem ? 3 : 5;
                }
            } else if (this.j > 0) {
                LootParams lootParams = new LootParams.a((WorldServer)this.an()).a(LootContextParameters.h, this.dD()).a(LootContextParameters.k, stack).a(LootContextParameters.a, this).a((float)this.q + playerOwner.ew()).a(LootContextParameterSets.f);
                LootTable lootTable = this.an().q().bi().a(LootTables.am);
                ObjectArrayList<ItemStack> randomItems = lootTable.a(lootParams);
                CriterionTriggers.E.a((EntityPlayer)playerOwner, stack, this, (Collection<ItemStack>)randomItems);
                for (ItemStack itemStack : randomItems) {
                    EntityItem itemEntity = new EntityItem(this.an(), this.dK(), this.dM(), this.dQ(), itemStack);
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)playerOwner.getBukkitEntity(), (org.bukkit.entity.Entity)itemEntity.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.as.a(6) + 1);
                    if (!playerFishEvent2.callEvent()) {
                        return 0;
                    }
                    double d2 = playerOwner.dK() - this.dK();
                    double d1 = playerOwner.dM() - this.dM();
                    double d22 = playerOwner.dQ() - this.dQ();
                    double d3 = 0.1;
                    itemEntity.m(d2 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d2 * d2 + d1 * d1 + d22 * d22)) * 0.08, d22 * 0.1);
                    this.an().b(itemEntity);
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        playerOwner.an().b(new EntityExperienceOrb(playerOwner.an(), new Vec3D(playerOwner.dK(), playerOwner.dM() + 0.5, playerOwner.dQ() + 0.5), Vec3D.c, playerFishEvent2.getExpToDrop(), ExperienceOrb.SpawnReason.FISHING, this.f(), this));
                    }
                    if (!itemStack.a(TagsItem.bj)) continue;
                    playerOwner.a(StatisticList.S, 1);
                }
                i2 = 1;
            }
            if (this.aS()) {
                playerFishEvent = new PlayerFishEvent((Player)playerOwner.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.IN_GROUND);
                if (!playerFishEvent.callEvent()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0 && !(playerFishEvent = new PlayerFishEvent((Player)playerOwner.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.REEL_IN)).callEvent()) {
                return 0;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void b(byte id) {
        EntityHuman player;
        Entity entity;
        if (id == 31 && this.an().D_() && (entity = this.o) instanceof EntityHuman && (player = (EntityHuman)entity).gy()) {
            this.d(this.o);
        }
        super.b(id);
    }

    public void d(Entity entity) {
        Entity owner = this.ai_();
        if (owner != null) {
            Vec3D vec3 = new Vec3D(owner.dK() - this.dK(), owner.dM() - this.dM(), owner.dQ() - this.dQ()).c(0.1);
            entity.k(entity.dI().e(vec3));
        }
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause cause) {
        this.a((EntityFishingHook)null);
        super.remove(reason, cause);
    }

    @Override
    public void aD() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void c(@Nullable Entity owner) {
        super.c(owner);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook fishingHook) {
        EntityHuman playerOwner = this.f();
        if (playerOwner != null) {
            playerOwner.cw = fishingHook;
        }
    }

    @Nullable
    public EntityHuman f() {
        EntityHuman player;
        Entity entity = this.ai_();
        return entity instanceof EntityHuman ? (player = (EntityHuman)entity) : null;
    }

    @Nullable
    public Entity i() {
        return this.o;
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        Entity owner = this.ai_();
        return new PacketPlayOutSpawnEntity((Entity)this, entity, owner == null ? this.az() : owner.az());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (this.f() == null) {
            int data = packet.n();
            a.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.an().a(data), (Object)data);
            this.discard(null);
        }
    }

    public static final class HookState
    extends Enum<HookState> {
        public static final /* enum */ HookState a = new HookState();
        public static final /* enum */ HookState b = new HookState();
        public static final /* enum */ HookState c = new HookState();
        private static final /* synthetic */ HookState[] d;

        public static HookState[] values() {
            return (HookState[])d.clone();
        }

        public static HookState valueOf(String name) {
            return Enum.valueOf(HookState.class, name);
        }

        private static /* synthetic */ HookState[] a() {
            return new HookState[]{a, b, c};
        }

        static {
            d = HookState.a();
        }
    }

    static final class WaterPosition
    extends Enum<WaterPosition> {
        public static final /* enum */ WaterPosition a = new WaterPosition();
        public static final /* enum */ WaterPosition b = new WaterPosition();
        public static final /* enum */ WaterPosition c = new WaterPosition();
        private static final /* synthetic */ WaterPosition[] d;

        public static WaterPosition[] values() {
            return (WaterPosition[])d.clone();
        }

        public static WaterPosition valueOf(String name) {
            return Enum.valueOf(WaterPosition.class, name);
        }

        private static /* synthetic */ WaterPosition[] a() {
            return new WaterPosition[]{a, b, c};
        }

        static {
            d = WaterPosition.a();
        }
    }
}

