/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityShulkerBullet
extends IProjectile {
    private static final double a = 0.15;
    @Nullable
    private EntityReference<Entity> b;
    @Nullable
    public EnumDirection c;
    public int d;
    public double f;
    public double g;
    public double h;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> type, World level) {
        super((EntityTypes<? extends IProjectile>)type, level);
        this.ar = true;
    }

    public EntityShulkerBullet(World level, EntityLiving shooter, Entity finalTarget, EnumDirection.EnumAxis axis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.bi, level);
        this.c(shooter);
        Vec3D center = shooter.de().f();
        this.b(center.g, center.h, center.i, this.dX(), this.dZ());
        this.b = EntityReference.a(finalTarget);
        this.c = EnumDirection.b;
        this.a(axis, finalTarget);
        this.projectileSource = shooter.getBukkitLivingEntity();
    }

    @Nullable
    public Entity getTarget() {
        return EntityReference.a(this.b, this.an(), Entity.class);
    }

    public void setTarget(@Nullable Entity finalTarget) {
        this.b = finalTarget == null ? null : EntityReference.a(finalTarget);
        this.c = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a, finalTarget);
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.f;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        if (this.b != null) {
            output.a("Target", UUIDUtil.a, this.b.c());
        }
        output.b("Dir", EnumDirection.k, this.c);
        output.a("Steps", this.d);
        output.a("TXD", this.f);
        output.a("TYD", this.g);
        output.a("TZD", this.h);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.d = input.a("Steps", 0);
        this.f = input.a("TXD", 0.0);
        this.g = input.a("TYD", 0.0);
        this.h = input.a("TZD", 0.0);
        this.c = input.a("Dir", EnumDirection.k).orElse(null);
        this.b = EntityReference.a(input, "Target");
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Nullable
    private EnumDirection e() {
        return this.c;
    }

    private void a(@Nullable EnumDirection direction) {
        this.c = direction;
    }

    private void a(@Nullable EnumDirection.EnumAxis axis, @Nullable Entity target) {
        BlockPosition blockPos;
        double d2 = 0.5;
        if (target == null) {
            blockPos = this.dF().e();
        } else {
            d2 = (double)target.dB() * 0.5;
            blockPos = BlockPosition.a(target.dK(), target.dM() + d2, target.dQ());
        }
        double d1 = (double)blockPos.u() + 0.5;
        double d22 = (double)blockPos.v() + d2;
        double d3 = (double)blockPos.w() + 0.5;
        EnumDirection direction = null;
        if (!blockPos.a(this.dD(), 2.0)) {
            BlockPosition blockPos1 = this.dF();
            ArrayList list = Lists.newArrayList();
            if (axis != EnumDirection.EnumAxis.a) {
                if (blockPos1.u() < blockPos.u() && this.an().w(blockPos1.i())) {
                    list.add(EnumDirection.f);
                } else if (blockPos1.u() > blockPos.u() && this.an().w(blockPos1.h())) {
                    list.add(EnumDirection.e);
                }
            }
            if (axis != EnumDirection.EnumAxis.b) {
                if (blockPos1.v() < blockPos.v() && this.an().w(blockPos1.d())) {
                    list.add(EnumDirection.b);
                } else if (blockPos1.v() > blockPos.v() && this.an().w(blockPos1.e())) {
                    list.add(EnumDirection.a);
                }
            }
            if (axis != EnumDirection.EnumAxis.c) {
                if (blockPos1.w() < blockPos.w() && this.an().w(blockPos1.g())) {
                    list.add(EnumDirection.d);
                } else if (blockPos1.w() > blockPos.w() && this.an().w(blockPos1.f())) {
                    list.add(EnumDirection.c);
                }
            }
            direction = EnumDirection.b(this.as);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.an().w(blockPos1.a(direction)) && i2 > 0; --i2) {
                    direction = EnumDirection.b(this.as);
                }
            } else {
                direction = (EnumDirection)list.get(this.as.a(list.size()));
            }
            d1 = this.dK() + (double)direction.j();
            d22 = this.dM() + (double)direction.k();
            d3 = this.dQ() + (double)direction.l();
        }
        this.a(direction);
        double d4 = d1 - this.dK();
        double d5 = d22 - this.dM();
        double d6 = d3 - this.dQ();
        double squareRoot = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (squareRoot == 0.0) {
            this.f = 0.0;
            this.g = 0.0;
            this.h = 0.0;
        } else {
            this.f = d4 / squareRoot * 0.15;
            this.g = d5 / squareRoot * 0.15;
            this.h = d6 / squareRoot * 0.15;
        }
        this.aF = true;
        this.d = 10 + this.as.a(5) * 10;
    }

    @Override
    public void dR() {
        if (this.an().aq() == EnumDifficulty.a) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected double bo() {
        return 0.04;
    }

    @Override
    public void g() {
        Vec3D deltaMovement;
        super.g();
        Entity entity = !this.an().D_() ? EntityReference.a(this.b, this.an()) : null;
        MovingObjectPosition hitResult = null;
        if (!this.an().D_()) {
            if (entity == null) {
                this.b = null;
            }
            if (entity == null || !entity.bX() || entity instanceof EntityHuman && entity.at()) {
                this.bq();
            } else {
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.g = MathHelper.a(this.g * 1.025, -1.0, 1.0);
                this.h = MathHelper.a(this.h * 1.025, -1.0, 1.0);
                deltaMovement = this.dI();
                this.k(deltaMovement.b((this.f - deltaMovement.g) * 0.2, (this.g - deltaMovement.h) * 0.2, (this.h - deltaMovement.i) * 0.2));
            }
            hitResult = ProjectileHelper.a((Entity)this, this::b);
        }
        deltaMovement = this.dI();
        this.b(this.dD().e(deltaMovement));
        this.aT();
        if (this.aG != null && this.aG.e()) {
            this.ci();
        }
        if (hitResult != null && this.bX() && hitResult.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(hitResult);
        }
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.an().D_()) {
            this.an().a(Particles.u, this.dK() - deltaMovement.g, this.dM() - deltaMovement.h + 0.15, this.dQ() - deltaMovement.i, 0.0, 0.0, 0.0);
        } else if (entity != null) {
            if (this.d > 0) {
                --this.d;
                if (this.d == 0) {
                    this.a(this.c == null ? null : this.c.o(), entity);
                }
            }
            if (this.c != null) {
                BlockPosition blockPos = this.dF();
                EnumDirection.EnumAxis axis = this.c.o();
                if (this.an().a(blockPos.a(this.c), this)) {
                    this.a(axis, entity);
                } else {
                    BlockPosition blockPos1 = entity.dF();
                    if (axis == EnumDirection.EnumAxis.a && blockPos.u() == blockPos1.u() || axis == EnumDirection.EnumAxis.c && blockPos.w() == blockPos1.w() || axis == EnumDirection.EnumAxis.b && blockPos.v() == blockPos1.v()) {
                        this.a(axis, entity);
                    }
                }
            }
        }
    }

    @Override
    public boolean aW() {
        return !this.ec();
    }

    @Override
    protected boolean b(Entity target) {
        return super.b(target) && !target.ar;
    }

    @Override
    public boolean ck() {
        return false;
    }

    @Override
    public boolean a(double distance) {
        return distance < 16384.0;
    }

    @Override
    public float bK() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        Entity entity = result.a();
        Entity owner = this.ai_();
        EntityLiving livingEntity = owner instanceof EntityLiving ? (EntityLiving)owner : null;
        DamageSource damageSource = this.ei().a((Entity)this, livingEntity);
        boolean flag = entity.b(damageSource, 4.0f);
        if (flag) {
            World world = this.an();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                EnchantmentManager.a(serverLevel, entity, damageSource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity1 = (EntityLiving)entity;
                livingEntity1.addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)owner, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        ((WorldServer)this.an()).a(Particles.x, this.dK(), this.dM(), this.dQ(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.yT, 1.0f, 1.0f);
    }

    private void f() {
        this.destroy(null);
    }

    private void destroy(@Nullable EntityRemoveEvent.Cause cause) {
        this.discard(cause);
        this.an().a(GameEvent.o, this.dD(), GameEvent.a.a(this));
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        this.destroy(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public boolean bT() {
        return true;
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, false)) {
            return false;
        }
        this.a(SoundEffects.yU, 1.0f, 1.0f);
        level.a(Particles.g, this.dK(), this.dM(), this.dQ(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy(EntityRemoveEvent.Cause.DEATH);
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.k(packet.j());
    }
}

