/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntitySmallFireball
extends EntityFireballFireball {
    public EntitySmallFireball(EntityTypes<? extends EntitySmallFireball> type, World level) {
        super((EntityTypes<? extends EntityFireballFireball>)type, level);
    }

    public EntitySmallFireball(World level, EntityLiving owner, Vec3D movement) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.bn, owner, movement, level);
        if (this.ai_() != null && this.ai_() instanceof EntityInsentient) {
            WorldServer serverLevel;
            this.isIncendiary = level instanceof WorldServer && (serverLevel = (WorldServer)level).S().getBoolean(GameRules.d, serverLevel.purpurConfig.fireballsMobGriefingOverride);
        }
    }

    public EntitySmallFireball(World level, double x2, double y2, double z2, Vec3D movement) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.bn, x2, y2, z2, movement, level);
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        World world = this.an();
        if (world instanceof WorldServer) {
            DamageSource damageSource;
            WorldServer serverLevel = (WorldServer)world;
            Entity var7 = result.a();
            Entity owner = this.ai_();
            int remainingFireTicks = var7.aP();
            EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)var7.getBukkitEntity(), 5.0f);
            var7.an().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                var7.igniteForSeconds(event.getDuration(), false);
            }
            if (!var7.a(serverLevel, damageSource = this.ei().a(this, owner), 5.0f)) {
                var7.h(remainingFireTicks);
            } else {
                EnchantmentManager.a(serverLevel, var7, damageSource);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Entity owner = this.ai_();
            if (this.isIncendiary) {
                BlockPosition blockPos = result.b().a(result.c());
                if (this.an().w(blockPos) && !CraftEventFactory.callBlockIgniteEvent(this.an(), blockPos, this).isCancelled()) {
                    this.an().c(blockPos, BlockFireAbstract.a(this.an(), blockPos));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition result) {
        super.a(result);
        if (!this.an().D_()) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

