/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class ThrownSplashPotion
extends EntityPotion {
    public ThrownSplashPotion(EntityTypes<? extends ThrownSplashPotion> type, World level) {
        super((EntityTypes<? extends EntityPotion>)type, level);
    }

    public ThrownSplashPotion(World level, EntityLiving owner, ItemStack item) {
        super(EntityTypes.ba, level, owner, item);
    }

    public ThrownSplashPotion(World level, double x2, double y2, double z2, ItemStack stack) {
        super(EntityTypes.ba, level, x2, y2, z2, stack);
    }

    @Override
    public Item f() {
        return Items.xy;
    }

    @Override
    public boolean onHitAsPotion(WorldServer level, ItemStack stack, MovingObjectPosition hitResult) {
        PotionSplashEvent event;
        PotionContents potionContents = stack.a(DataComponents.R, PotionContents.a);
        float orDefault = stack.a(DataComponents.S, Float.valueOf(1.0f)).floatValue();
        Iterable<MobEffect> allEffects = potionContents.a();
        AxisAlignedBB aabb = this.de().c(hitResult.g().d(this.dD()));
        AxisAlignedBB aabb1 = aabb.c(4.0, 2.0, 4.0);
        List<EntityLiving> entitiesOfClass = this.an().a(EntityLiving.class, aabb1);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        float f2 = ProjectileHelper.a(this);
        if (!entitiesOfClass.isEmpty()) {
            Entity effectSource = this.y();
            for (EntityLiving livingEntity : entitiesOfClass) {
                double d2;
                if (!livingEntity.ga() || !((d2 = aabb.d(livingEntity.de().g(f2))) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d2) / 4.0;
                affected.put(livingEntity.getBukkitLivingEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, hitResult, affected)).isCancelled() && !entitiesOfClass.isEmpty()) {
            Entity effectSource = this.y();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                CraftLivingEntity craftLivingEntity = (CraftLivingEntity)victim;
                EntityLiving livingEntity = craftLivingEntity.getHandle();
                double d1 = event.getIntensity(victim);
                for (MobEffect mobEffectInstance : allEffects) {
                    Holder<MobEffectList> effect = mobEffectInstance.c();
                    if (effect.a().a()) {
                        effect.a().a(level, this, this.ai_(), livingEntity, mobEffectInstance.e(), d1);
                        continue;
                    }
                    int i2 = mobEffectInstance.a(i1 -> (int)(d1 * (double)i1 * (double)orDefault + 0.5));
                    MobEffect mobEffectInstance1 = new MobEffect(effect, i2, mobEffectInstance.e(), mobEffectInstance.f(), mobEffectInstance.g());
                    if (mobEffectInstance1.a(20)) continue;
                    livingEntity.addEffect(mobEffectInstance1, effectSource, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
        return !event.isCancelled();
    }
}

