/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRaid;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public abstract class EntityRaider
extends EntityMonsterPatrolling {
    protected static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityRaider.class, DataWatcherRegistry.k);
    static final Predicate<EntityItem> a = item -> !item.n() && item.bX() && ItemStack.a(item.e(), Raid.a(item.ej().f(Registries.aM)));
    private static final int b = 0;
    private static final boolean e = false;
    @Nullable
    protected Raid d;
    private int f = 0;
    private boolean ct = false;
    private int cu;

    protected EntityRaider(EntityTypes<? extends EntityRaider> type, World level) {
        super((EntityTypes<? extends EntityMonsterPatrolling>)type, level);
    }

    @Override
    protected void H() {
        super.H();
        this.cq.a(1, new b(this, this));
        this.cq.a(3, new PathfinderGoalRaid<EntityRaider>(this));
        this.cq.a(4, new d(this, 1.05f, 1));
        this.cq.a(5, new c(this));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, false);
    }

    public abstract void a(WorldServer var1, int var2, boolean var3);

    public boolean gU() {
        return this.ct;
    }

    public void A(boolean canJoinRaid) {
        this.ct = canJoinRaid;
    }

    @Override
    public void e_() {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.bX()) {
                Raid currentRaid = this.gV();
                if (this.gU()) {
                    if (currentRaid == null) {
                        Raid raidAt;
                        if (this.an().ag() % 20L == 0L && (raidAt = serverLevel.d(this.dF())) != null && PersistentRaid.a(this)) {
                            raidAt.a(serverLevel, raidAt.j(), this, null, true);
                        }
                    } else {
                        EntityLiving target = this.e();
                        if (target != null && (target.ax() == EntityTypes.bX || target.ax() == EntityTypes.at)) {
                            this.bJ = 0;
                        }
                    }
                }
            }
        }
        super.e_();
    }

    @Override
    protected void gM() {
        this.bJ += 2;
    }

    @Override
    public void a(DamageSource damageSource) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Entity entity = damageSource.d();
            Raid currentRaid = this.gV();
            if (currentRaid != null) {
                if (this.gL()) {
                    currentRaid.c(this.gZ());
                }
                if (entity != null && entity.ax() == EntityTypes.bX) {
                    currentRaid.a(entity);
                }
                currentRaid.a(serverLevel, this, false);
            }
        }
        super.a(damageSource);
    }

    @Override
    public boolean gO() {
        return !this.gY();
    }

    public void a(@Nullable Raid raid) {
        this.d = raid;
    }

    @Nullable
    public Raid gV() {
        return this.d;
    }

    public boolean gW() {
        ItemStack itemBySlot = this.a(EnumItemSlot.f);
        boolean flag = !itemBySlot.f() && ItemStack.a(itemBySlot, Raid.a(this.ej().f(Registries.aM)));
        boolean isPatrolLeader = this.gL();
        return flag && isPatrolLeader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean gX() {
        World world = this.an();
        if (!(world instanceof WorldServer)) return false;
        WorldServer serverLevel = (WorldServer)world;
        if (this.gV() != null) return true;
        if (serverLevel.d(this.dF()) == null) return false;
        return true;
    }

    public boolean gY() {
        return this.gV() != null && this.gV().r();
    }

    public void b(int wave) {
        this.f = wave;
    }

    public int gZ() {
        return this.f;
    }

    public boolean ha() {
        return this.az.a(c);
    }

    public void B(boolean celebrating) {
        this.az.a(c, celebrating);
    }

    @Override
    protected void a(ValueOutput output) {
        World world;
        super.a(output);
        output.a("Wave", this.f);
        output.a("CanJoinRaid", this.ct);
        if (this.d != null && (world = this.an()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.E().a(this.d).ifPresent(i2 -> output.a("RaidId", i2));
        }
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.f = input.a("Wave", 0);
        this.ct = input.a("CanJoinRaid", false);
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            input.e("RaidId").ifPresent(integer -> {
                this.d = serverLevel.E().a((int)integer);
                if (this.d != null) {
                    this.d.a(serverLevel, this.f, this, false);
                    if (this.gL()) {
                        this.d.a(this.f, this);
                    }
                }
            });
        }
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        boolean flag;
        ItemStack item = entity.e();
        boolean bl = flag = this.gY() && this.gV().b(this.gZ()) != null;
        if (this.gY() && !flag && ItemStack.a(item, Raid.a(this.ej().f(Registries.aM)))) {
            if (CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, false).isCancelled()) {
                return;
            }
            EnumItemSlot equipmentSlot = EnumItemSlot.f;
            ItemStack itemBySlot = this.a(equipmentSlot);
            double d2 = this.gp().b(equipmentSlot);
            if (!itemBySlot.f() && (double)Math.max(this.as.i() - 0.1f, 0.0f) < d2) {
                this.forceDrops = true;
                this.a(level, itemBySlot);
                this.forceDrops = false;
            }
            this.a(entity);
            this.a(equipmentSlot, item);
            this.a((Entity)entity, item.M());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
            this.gV().a(this.gZ(), this);
            this.x(true);
        } else {
            super.a(level, entity);
        }
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return this.gV() == null && super.i(distanceToClosestPlayer);
    }

    @Override
    public boolean ae() {
        return super.ae() || this.gV() != null;
    }

    public int hb() {
        return this.cu;
    }

    public void c(int ticksOutsideRaid) {
        this.cu = ticksOutsideRaid;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.gY()) {
            this.gV().n();
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.A(this.ax() != EntityTypes.bN || spawnReason != EntitySpawnReason.a);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public abstract SoundEffect ah_();

    public static class b<T extends EntityRaider>
    extends PathfinderGoal {
        private final T b;
        private Int2LongOpenHashMap c = new Int2LongOpenHashMap();
        @Nullable
        private PathEntity d;
        @Nullable
        private EntityItem e;
        final /* synthetic */ EntityRaider a;

        public b(T mob) {
            this.a = this$0;
            this.b = mob;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (this.h()) {
                return false;
            }
            Int2LongOpenHashMap map = new Int2LongOpenHashMap();
            double attributeValue = this.a.i(GenericAttributes.n);
            for (EntityItem itemEntity : ((Entity)this.b).an().a(EntityItem.class, ((Entity)this.b).de().c(attributeValue, 8.0, attributeValue), a)) {
                long orDefault = this.c.getOrDefault(itemEntity.az(), Long.MIN_VALUE);
                if (this.a.an().ag() < orDefault) {
                    map.put(itemEntity.az(), orDefault);
                    continue;
                }
                PathEntity path = ((EntityInsentient)this.b).S().a((Entity)itemEntity, 1);
                if (path != null && path.j()) {
                    this.d = path;
                    this.e = itemEntity;
                    return true;
                }
                map.put(itemEntity.az(), this.a.an().ag() + 600L);
            }
            this.c = map;
            return false;
        }

        @Override
        public boolean c() {
            return this.e != null && this.d != null && !this.e.ec() && !this.d.c() && !this.h();
        }

        private boolean h() {
            if (!net.minecraft.world.entity.raid.EntityRaider$b.a(this.b).S().getBoolean(GameRules.d, ((Entity)this.b).an().purpurConfig.pillagerMobGriefingOverride)) {
                return true;
            }
            if (!((EntityRaider)this.b).gY()) {
                return true;
            }
            if (((EntityRaider)this.b).gV().a()) {
                return true;
            }
            if (!((EntityMonsterPatrolling)this.b).gI()) {
                return true;
            }
            if (ItemStack.a(((EntityLiving)this.b).a(EnumItemSlot.f), Raid.a(((Entity)this.b).ej().f(Registries.aM)))) {
                return true;
            }
            EntityRaider leader = this.a.d.b(((EntityRaider)this.b).gZ());
            return leader != null && leader.bX();
        }

        @Override
        public void d() {
            ((EntityInsentient)this.b).S().a(this.d, (double)1.15f);
        }

        @Override
        public void e() {
            this.d = null;
            this.e = null;
        }

        @Override
        public void a() {
            if (this.e != null && this.e.a((Entity)this.b, 1.414)) {
                ((EntityRaider)this.b).a(net.minecraft.world.entity.raid.EntityRaider$b.a(this.a.an()), this.e);
            }
        }
    }

    static class d
    extends PathfinderGoal {
        private final EntityRaider a;
        private final double b;
        private BlockPosition c;
        private final List<BlockPosition> d = Lists.newArrayList();
        private final int e;
        private boolean f;

        public d(EntityRaider raider, double speedModifier, int distanceToPoi) {
            this.a = raider;
            this.b = speedModifier;
            this.e = distanceToPoi;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.k();
            return this.h() && this.i() && this.a.e() == null;
        }

        private boolean h() {
            return this.a.gY() && !this.a.gV().a();
        }

        private boolean i() {
            WorldServer serverLevel = (WorldServer)this.a.an();
            BlockPosition blockPos = this.a.dF();
            Optional<BlockPosition> random = serverLevel.D().a(poi -> poi.a(PoiTypes.n), this::a, VillagePlace.Occupancy.c, blockPos, 48, this.a.as);
            if (random.isEmpty()) {
                return false;
            }
            this.c = random.get().j();
            return true;
        }

        @Override
        public boolean c() {
            return !this.a.S().l() && this.a.e() == null && !this.c.a(this.a.dD(), (double)(this.a.dA() + (float)this.e)) && !this.f;
        }

        @Override
        public void e() {
            if (this.c.a(this.a.dD(), (double)this.e)) {
                this.d.add(this.c);
            }
        }

        @Override
        public void d() {
            super.d();
            this.a.n(0);
            this.a.S().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), this.b);
            this.f = false;
        }

        @Override
        public void a() {
            if (this.a.S().l()) {
                Vec3D vec3 = Vec3D.c(this.c);
                Vec3D posTowards = DefaultRandomPos.a((EntityCreature)this.a, 16, 7, vec3, 0.3141592741012573);
                if (posTowards == null) {
                    posTowards = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3, 1.5707963705062866);
                }
                if (posTowards == null) {
                    this.f = true;
                    return;
                }
                this.a.S().a(posTowards.g, posTowards.h, posTowards.i, this.b);
            }
        }

        private boolean a(BlockPosition pos) {
            for (BlockPosition blockPos : this.d) {
                if (!Objects.equals(pos, blockPos)) continue;
                return false;
            }
            return true;
        }

        private void k() {
            if (this.d.size() > 2) {
                this.d.remove(0);
            }
        }
    }

    public class c
    extends PathfinderGoal {
        private final EntityRaider b;

        c(EntityRaider mob) {
            this.b = mob;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            Raid currentRaid = this.b.gV();
            return this.b.bX() && this.b.e() == null && currentRaid != null && currentRaid.f();
        }

        @Override
        public void d() {
            this.b.B(true);
            super.d();
        }

        @Override
        public void e() {
            this.b.B(false);
            super.e();
        }

        @Override
        public void a() {
            if (!this.b.bm() && this.b.as.a(this.a(100)) == 0) {
                EntityRaider.this.b(EntityRaider.this.ah_());
            }
            if (!this.b.cl() && this.b.as.a(this.a(50)) == 0) {
                this.b.R().a();
            }
            super.a();
        }
    }

    public static class a
    extends PathfinderGoal {
        private final EntityRaider b;
        private final float c;
        public final PathfinderTargetCondition a = PathfinderTargetCondition.b().a(8.0).d().e();

        public a(EntityIllagerAbstract mob, float radius) {
            this.b = mob;
            this.c = radius * radius;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving lastHurtByMob = this.b.eF();
            return this.b.gV() == null && this.b.gQ() && this.b.e() != null && !this.b.gz() && (lastHurtByMob == null || lastHurtByMob.ax() != EntityTypes.bX);
        }

        @Override
        public void d() {
            super.d();
            this.b.S().n();
            for (EntityRaider raider : net.minecraft.world.entity.raid.EntityRaider$a.a(this.b).a(EntityRaider.class, this.a, this.b, this.b.de().c(8.0, 8.0, 8.0))) {
                raider.setTarget(this.b.e(), EntityTargetEvent.TargetReason.FOLLOW_LEADER);
            }
        }

        @Override
        public void e() {
            super.e();
            EntityLiving target = this.b.e();
            if (target != null) {
                for (EntityRaider raider : net.minecraft.world.entity.raid.EntityRaider$a.a(this.b).a(EntityRaider.class, this.a, this.b, this.b.de().c(8.0, 8.0, 8.0))) {
                    raider.setTarget(target, EntityTargetEvent.TargetReason.FOLLOW_LEADER);
                    raider.w(true);
                }
                this.b.w(true);
            }
        }

        @Override
        public boolean Y_() {
            return true;
        }

        @Override
        public void a() {
            EntityLiving target = this.b.e();
            if (target != null) {
                if (this.b.g((Entity)target) > (double)this.c) {
                    this.b.P().a(target, 30.0f, 30.0f);
                    if (this.b.as.a(50) == 0) {
                        this.b.X();
                    }
                } else {
                    this.b.w(true);
                }
                super.a();
            }
        }
    }
}

