/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class PersistentRaid
extends PersistentBase {
    private static final String d = "raids";
    public final Map<UUID, Integer> playerCooldowns = Maps.newHashMap();
    public static final Codec<PersistentRaid> a = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.entity.raid.PersistentRaid$a.a.listOf().optionalFieldOf(d, List.of()).forGetter(raids -> raids.e.int2ObjectEntrySet().stream().map(a::a).toList()), (App)Codec.INT.fieldOf("next_id").forGetter(raids -> raids.f), (App)Codec.INT.fieldOf("tick").forGetter(raids -> raids.g)).apply((Applicative)instance, PersistentRaid::new));
    public static final SavedDataType<PersistentRaid> b = new SavedDataType<PersistentRaid>("raids", PersistentRaid::new, a, DataFixTypes.m);
    public static final SavedDataType<PersistentRaid> c = new SavedDataType<PersistentRaid>("raids_end", PersistentRaid::new, a, DataFixTypes.m);
    public final Int2ObjectMap<Raid> e = new Int2ObjectOpenHashMap();
    private int f = 1;
    private int g;

    public static SavedDataType<PersistentRaid> a(Holder<DimensionManager> dimension) {
        return dimension.a(BuiltinDimensionTypes.c) ? c : b;
    }

    public PersistentRaid() {
        this.t();
    }

    private PersistentRaid(List<a> raids, int nextId, int tick) {
        for (a raidWithId : raids) {
            this.e.put(raidWithId.b, (Object)raidWithId.c);
            raidWithId.c.idOrNegativeOne = raidWithId.b;
        }
        this.f = nextId;
        this.g = tick;
    }

    @Nullable
    public Raid a(int id) {
        return (Raid)this.e.get(id);
    }

    public OptionalInt a(Raid raid) {
        for (Int2ObjectMap.Entry entry : this.e.int2ObjectEntrySet()) {
            if (entry.getValue() != raid) continue;
            return OptionalInt.of(entry.getIntKey());
        }
        return OptionalInt.empty();
    }

    public void a(WorldServer level) {
        ++this.g;
        if (level.purpurConfig.raidCooldownSeconds != 0 && this.g % 20 == 0) {
            ImmutableMap.copyOf(this.playerCooldowns).forEach((uuid, i2) -> {
                if (i2 < 1) {
                    this.playerCooldowns.remove(uuid);
                } else {
                    this.playerCooldowns.put((UUID)uuid, i2 - 1);
                }
            });
        }
        ObjectIterator iterator = this.e.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = (Raid)iterator.next();
            if (level.S().c(GameRules.D)) {
                raid.m();
            }
            if (raid.d()) {
                iterator.remove();
                this.t();
                continue;
            }
            raid.a(level);
        }
        if (this.g % 200 == 0) {
            this.t();
        }
    }

    public static boolean a(EntityRaider raider) {
        return raider.bX() && raider.gU() && raider.eK() <= 2400;
    }

    @Nullable
    public Raid a(EntityPlayer player, BlockPosition pos) {
        BlockPosition blockPos;
        if (player.at()) {
            return null;
        }
        WorldServer serverLevel = player.A();
        if (serverLevel.S().c(GameRules.D)) {
            return null;
        }
        DimensionManager dimensionType = serverLevel.H_();
        if (!dimensionType.c()) {
            return null;
        }
        List<VillagePlaceRecord> list = serverLevel.D().c(holder -> holder.a(PoiTypeTags.b), pos, 64, VillagePlace.Occupancy.b).toList();
        int i2 = 0;
        Vec3D vec3 = Vec3D.c;
        for (VillagePlaceRecord poiRecord : list) {
            BlockPosition pos1 = poiRecord.g();
            vec3 = vec3.b(pos1.u(), pos1.v(), pos1.w());
            ++i2;
        }
        if (i2 > 0) {
            vec3 = vec3.c(1.0 / (double)i2);
            blockPos = BlockPosition.a(vec3);
        } else {
            blockPos = pos;
        }
        Raid raid = this.a(serverLevel, blockPos);
        if (!raid.i() || raid.isInProgress() && raid.l() < raid.k()) {
            if (serverLevel.purpurConfig.raidCooldownSeconds != 0 && this.playerCooldowns.containsKey(player.cT())) {
                return null;
            }
            if (!CraftEventFactory.callRaidTriggerEvent(serverLevel, raid, player)) {
                player.g(MobEffects.I);
                return null;
            }
            if (serverLevel.purpurConfig.raidCooldownSeconds != 0) {
                this.playerCooldowns.put(player.cT(), serverLevel.purpurConfig.raidCooldownSeconds);
            }
            if (!raid.i() && !this.e.containsValue((Object)raid)) {
                this.e.put(this.a(), (Object)raid);
                raid.idOrNegativeOne = this.f;
            }
            raid.a(player);
        }
        this.t();
        return raid;
    }

    private Raid a(WorldServer level, BlockPosition pos) {
        Raid raidAt = level.d(pos);
        return raidAt != null ? raidAt : new Raid(pos, level.aq());
    }

    public static PersistentRaid a(NBTTagCompound tag) {
        return a.parse((DynamicOps)DynamicOpsNBT.a, (Object)tag).resultOrPartial().orElseGet(PersistentRaid::new);
    }

    private int a() {
        return ++this.f;
    }

    @Nullable
    public Raid a(BlockPosition pos, int distance) {
        Raid raid = null;
        double d2 = distance;
        for (Raid raid1 : this.e.values()) {
            double d1 = raid1.q().j(pos);
            if (!raid1.r() || !(d1 < d2)) continue;
            raid = raid1;
            d2 = d1;
        }
        return raid;
    }

    @VisibleForDebug
    public List<BlockPosition> a(ChunkCoordIntPair chunkPos) {
        return this.e.values().stream().map(Raid::q).filter(chunkPos::b).toList();
    }

    static final class a
    extends Record {
        private final int b;
        private final Raid c;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(a::a), (App)Raid.b.forGetter(a::b)).apply((Applicative)instance, a::new));

        a(int id, Raid raid) {
            this.b = id;
            this.c = raid;
        }

        public static a a(Int2ObjectMap.Entry<Raid> entry) {
            return new a(entry.getIntKey(), (Raid)entry.getValue());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;raid", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;raid", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;raid", "b", "c"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public Raid b() {
            return this.c;
        }
    }
}

