/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public abstract class AbstractBoat
extends VehicleEntity
implements Leashable {
    private static final DataWatcherObject<Boolean> r = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> s = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> t = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.b);
    public static final int a = 0;
    public static final int b = 1;
    private static final int u = 60;
    private static final float aN = 0.3926991f;
    public static final double c = 0.7853981852531433;
    public static final int d = 60;
    private final float[] aO = new float[2];
    private float aP;
    private float aQ;
    private final InterpolationHandler aR = new InterpolationHandler((Entity)this, 3);
    private boolean aS;
    private boolean aT;
    private boolean aU;
    private boolean aV;
    private double aW;
    private float aX;
    public EnumStatus aY;
    private EnumStatus aZ;
    private double ba;
    private boolean bb;
    private boolean bc;
    private float bd;
    private float be;
    private float bf;
    @Nullable
    private Leashable.a bg;
    private final Supplier<Item> bh;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public AbstractBoat(EntityTypes<? extends AbstractBoat> type, World level, Supplier<Item> dropItem) {
        super(type, level);
        this.bh = dropItem;
        this.W = true;
    }

    public void o(double x2, double y2, double z2) {
        this.a_(x2, y2, z2);
        this.Y = x2;
        this.Z = y2;
        this.aa = z2;
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(r, false);
        builder.a(s, false);
        builder.a(t, 0);
    }

    @Override
    public boolean i(Entity entity) {
        return AbstractBoat.a((Entity)this, entity);
    }

    public static boolean a(Entity first, Entity second) {
        return (second.j(first) || second.bU()) && !first.A(second);
    }

    @Override
    public boolean j(@Nullable Entity entity) {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.n(super.a(axis, portal));
    }

    protected abstract double b(EntitySize var1);

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        float singlePassengerXOffset = this.m();
        if (this.di().size() > 1) {
            int index = this.di().indexOf(entity);
            singlePassengerXOffset = index == 0 ? 0.2f : -0.6f;
            if (entity instanceof EntityAnimal) {
                singlePassengerXOffset += 0.2f;
            }
        }
        return new Vec3D(0.0, this.b(dimensions), singlePassengerXOffset).b(-this.dX() * ((float)Math.PI / 180));
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (this.an() instanceof WorldServer) {
            this.bb = true;
            this.bc = downwards;
            if (this.Q() == 0) {
                this.m(60);
            }
        }
        if (!this.by() && this.as.a(100) == 0) {
            this.an().a(this.dK(), this.dM(), this.dQ(), this.bh(), this.dw(), 1.0f, 0.8f + 0.4f * this.as.i(), false);
            this.an().a(Particles.aq, this.dK() + (double)this.as.i(), this.dM() + 0.7, this.dQ() + (double)this.as.i(), 0.0, 0.0, 0.0);
            this.a(GameEvent.O, this.dg());
        }
    }

    @Override
    public void h(Entity entity) {
        if (!this.an().paperConfig().collisions.allowVehicleCollisions && this.an().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof AbstractBoat) {
            if (entity.de().b < this.de().e) {
                VehicleEntityCollisionEvent event;
                if (!this.A(entity) && !(event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) {
                    return;
                }
                super.h(entity);
            }
        } else if (entity.de().b <= this.de().b) {
            VehicleEntityCollisionEvent event;
            if (!this.A(entity) && !(event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) {
                return;
            }
            super.h(entity);
        }
    }

    @Override
    public void q(float yaw) {
        this.l(-this.I());
        this.d(10);
        this.a(this.G() * 11.0f);
    }

    @Override
    public boolean bT() {
        return !this.ec();
    }

    @Override
    public InterpolationHandler n_() {
        return this.aR;
    }

    @Override
    public EnumDirection dc() {
        return this.db().h();
    }

    @Override
    public void g() {
        this.aZ = this.aY;
        this.aY = this.K();
        this.aP = this.aY != EnumStatus.b && this.aY != EnumStatus.c ? 0.0f : (this.aP += 1.0f);
        if (!this.an().D_() && this.aP >= 60.0f) {
            this.ca();
        }
        if (this.H() > 0) {
            this.d(this.H() - 1);
        }
        if (this.G() > 0.0f) {
            this.a(this.G() - 1.0f);
        }
        super.g();
        this.aR.e();
        if (this.dq()) {
            if (!(this.dj() instanceof EntityHuman)) {
                this.a(false, false);
            }
            this.N();
            if (this.an().D_()) {
                this.P();
                this.an().a(new PacketPlayInBoatMove(this.c(0), this.c(1)));
            }
            this.a(EnumMoveType.a, this.dI());
        } else {
            this.k(Vec3D.c);
        }
        Location to = CraftLocation.toBukkit(this.dD(), this.an(), this.dX(), this.dZ());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        new VehicleUpdateEvent(vehicle).callEvent();
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            event.callEvent();
        }
        this.lastLocation = vehicle.getLocation();
        this.aT();
        this.aT();
        this.J();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.c(i2)) {
                SoundEffect paddleSound;
                if (!this.bm() && this.aO[i2] % ((float)Math.PI * 2) <= 0.7853982f && (this.aO[i2] + 0.3926991f) % ((float)Math.PI * 2) >= 0.7853982f && (paddleSound = this.f()) != null) {
                    Vec3D viewVector = this.h(1.0f);
                    double d2 = i2 == 1 ? -viewVector.i : viewVector.i;
                    double d1 = i2 == 1 ? viewVector.g : -viewVector.g;
                    this.an().a(null, this.dK() + d2, this.dM(), this.dQ() + d1, paddleSound, this.dw(), 1.0f, 0.8f + 0.4f * this.as.i());
                }
                this.aO[i2] = this.aO[i2] + 0.3926991f;
                continue;
            }
            this.aO[i2] = 0.0f;
        }
        List<Entity> entities = this.an().a((Entity)this, this.de().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!entities.isEmpty()) {
            boolean flag = !this.an().D_() && !(this.dg() instanceof EntityHuman);
            for (Entity entity : entities) {
                if (entity.z(this)) continue;
                if (flag && this.di().size() < this.n() && !entity.cl() && this.C(entity) && entity instanceof EntityLiving && !entity.ax().a(TagsEntity.N)) {
                    entity.o(this);
                    continue;
                }
                this.h(entity);
            }
        }
    }

    private void J() {
        if (this.an().D_()) {
            int bubbleTime = this.Q();
            this.bd = bubbleTime > 0 ? (this.bd += 0.05f) : (this.bd -= 0.1f);
            this.bd = MathHelper.a(this.bd, 0.0f, 1.0f);
            this.bf = this.be;
            this.be = 10.0f * (float)Math.sin(0.5 * (double)this.at) * this.bd;
        } else {
            int bubbleTime;
            if (!this.bb) {
                this.m(0);
            }
            if ((bubbleTime = this.Q()) > 0) {
                this.m(--bubbleTime);
                int i2 = 60 - bubbleTime - 1;
                if (i2 > 0 && bubbleTime == 0) {
                    this.m(0);
                    Vec3D deltaMovement = this.dI();
                    if (this.bc) {
                        this.k(deltaMovement.b(0.0, -0.7, 0.0));
                        this.ca();
                    } else {
                        this.m(deltaMovement.g, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, deltaMovement.i);
                    }
                }
                this.bb = false;
            }
        }
    }

    @Nullable
    protected SoundEffect f() {
        return switch (this.K().ordinal()) {
            case 0, 1, 2 -> SoundEffects.cn;
            case 3 -> SoundEffects.cm;
            default -> null;
        };
    }

    public void a(boolean left, boolean right) {
        this.az.a(r, left);
        this.az.a(s, right);
    }

    public float a(int side, float partialTick) {
        return this.c(side) ? MathHelper.b(this.aO[side] - 0.3926991f, this.aO[side], partialTick) : 0.0f;
    }

    @Override
    @Nullable
    public Leashable.a U_() {
        return this.bg;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.bg = leashData;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.88f * this.dB(), 0.64f * this.dA());
    }

    @Override
    public boolean D() {
        return true;
    }

    @Override
    public Vec3D[] E() {
        return Leashable.a(this, 0.0, 0.64, 0.382, 0.88);
    }

    public EnumStatus K() {
        EnumStatus status = this.M();
        if (status != null) {
            this.aW = this.de().e;
            return status;
        }
        if (this.L()) {
            return EnumStatus.a;
        }
        float groundFriction = this.k();
        if (groundFriction > 0.0f) {
            this.aX = groundFriction;
            if (this.an().purpurConfig.boatEjectPlayersOnLand) {
                this.ca();
            }
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float i() {
        AxisAlignedBB boundingBox = this.de();
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.e);
        int ceil1 = MathHelper.c(boundingBox.e - this.ba);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        block0: for (int i2 = floor1; i2 < ceil1; ++i2) {
            float f2 = 0.0f;
            for (int i1 = floor; i1 < ceil; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i1, i2, i22);
                    Fluid fluidState = this.an().b_(mutableBlockPos);
                    if (fluidState.a(TagsFluid.a)) {
                        f2 = Math.max(f2, fluidState.a(this.an(), mutableBlockPos));
                    }
                    if (f2 >= 1.0f) continue block0;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)mutableBlockPos.v() + f2;
        }
        return ceil1 + 1;
    }

    public float k() {
        AxisAlignedBB boundingBox = this.de();
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a, boundingBox.b - 0.001, boundingBox.c, boundingBox.d, boundingBox.b, boundingBox.f);
        int i2 = MathHelper.a(aabb.a) - 1;
        int i1 = MathHelper.c(aabb.d) + 1;
        int i22 = MathHelper.a(aabb.b) - 1;
        int i3 = MathHelper.c(aabb.e) + 1;
        int i4 = MathHelper.a(aabb.c) - 1;
        int i5 = MathHelper.c(aabb.f) + 1;
        VoxelShape voxelShape = VoxelShapes.a(aabb);
        float f2 = 0.0f;
        int i6 = 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i7 = i2; i7 < i1; ++i7) {
            for (int i8 = i4; i8 < i5; ++i8) {
                int i9 = (i7 != i2 && i7 != i1 - 1 ? 0 : 1) + (i8 != i4 && i8 != i5 - 1 ? 0 : 1);
                if (i9 == 2) continue;
                for (int i10 = i22; i10 < i3; ++i10) {
                    if (i9 > 0 && (i10 == i22 || i10 == i3 - 1)) continue;
                    mutableBlockPos.d(i7, i10, i8);
                    IBlockData blockState = this.an().a_(mutableBlockPos);
                    if (blockState.b() instanceof BlockWaterLily || !VoxelShapes.c(blockState.g(this.an(), mutableBlockPos).a(mutableBlockPos), voxelShape, OperatorBoolean.i)) continue;
                    f2 += blockState.b().g();
                    ++i6;
                }
            }
        }
        return f2 / (float)i6;
    }

    private boolean L() {
        AxisAlignedBB boundingBox = this.de();
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.b);
        int ceil1 = MathHelper.c(boundingBox.b + 0.001);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        boolean flag = false;
        this.aW = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i2, i1, i22);
                    Fluid fluidState = this.an().b_(mutableBlockPos);
                    if (!fluidState.a(TagsFluid.a)) continue;
                    float f2 = (float)i1 + fluidState.a(this.an(), mutableBlockPos);
                    this.aW = Math.max((double)f2, this.aW);
                    flag |= boundingBox.b < (double)f2;
                }
            }
        }
        return flag;
    }

    @Nullable
    private EnumStatus M() {
        AxisAlignedBB boundingBox = this.de();
        double d2 = boundingBox.e + 0.001;
        int floor = MathHelper.a(boundingBox.a);
        int ceil = MathHelper.c(boundingBox.d);
        int floor1 = MathHelper.a(boundingBox.e);
        int ceil1 = MathHelper.c(d2);
        int floor2 = MathHelper.a(boundingBox.c);
        int ceil2 = MathHelper.c(boundingBox.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i2, i1, i22);
                    Fluid fluidState = this.an().b_(mutableBlockPos);
                    if (!fluidState.a(TagsFluid.a) || !(d2 < (double)((float)mutableBlockPos.v() + fluidState.a(this.an(), mutableBlockPos)))) continue;
                    if (!fluidState.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    @Override
    protected double bo() {
        return 0.04;
    }

    private void N() {
        double d2 = -this.bp();
        double d1 = 0.0;
        float f2 = 0.05f;
        if (this.aZ == EnumStatus.e && this.aY != EnumStatus.e && this.aY != EnumStatus.d) {
            this.aW = this.f(1.0);
            double d22 = (double)(this.i() - this.dB()) + 0.101;
            if (this.an().a((Entity)this, this.de().d(0.0, d22 - this.dM(), 0.0))) {
                this.a(EnumMoveType.a, new Vec3D(0.0, d22 - this.dM(), 0.0));
                this.k(this.dI().d(1.0, 0.0, 1.0));
                this.ba = 0.0;
            }
            this.aY = EnumStatus.a;
        } else {
            if (this.aY == EnumStatus.a) {
                d1 = (this.aW - this.dM()) / (double)this.dB();
                f2 = 0.9f;
            } else if (this.aY == EnumStatus.c) {
                d2 = -7.0E-4;
                f2 = 0.9f;
            } else if (this.aY == EnumStatus.b) {
                d1 = 0.01f;
                f2 = 0.45f;
            } else if (this.aY == EnumStatus.e) {
                f2 = 0.9f;
            } else if (this.aY == EnumStatus.d) {
                f2 = this.aX;
                if (this.dg() instanceof EntityHuman) {
                    this.aX /= 2.0f;
                }
            }
            Vec3D deltaMovement = this.dI();
            this.m(deltaMovement.g * (double)f2, deltaMovement.h + d2, deltaMovement.i * (double)f2);
            this.aQ *= f2;
            if (d1 > 0.0) {
                Vec3D deltaMovement1 = this.dI();
                this.m(deltaMovement1.g, (deltaMovement1.h + d1 * (this.bo() / 0.65)) * 0.75, deltaMovement1.i);
            }
        }
    }

    private void P() {
        if (this.cm()) {
            float f2 = 0.0f;
            if (this.aS) {
                this.aQ -= 1.0f;
            }
            if (this.aT) {
                this.aQ += 1.0f;
            }
            if (this.aT != this.aS && !this.aU && !this.aV) {
                f2 += 0.005f;
            }
            this.v(this.dX() + this.aQ);
            if (this.aU) {
                f2 += 0.04f;
            }
            if (this.aV) {
                f2 -= 0.005f;
            }
            this.k(this.dI().b(MathHelper.a(-this.dX() * ((float)Math.PI / 180)) * f2, 0.0, MathHelper.b(this.dX() * ((float)Math.PI / 180)) * f2));
            this.a(this.aT && !this.aS || this.aU, this.aS && !this.aT || this.aU);
        }
    }

    protected float m() {
        return 0.0f;
    }

    public boolean C(Entity entity) {
        return entity.dA() < this.dA();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (!passenger.ax().a(TagsEntity.s)) {
            passenger.v(passenger.dX() + this.aQ);
            passenger.r(passenger.cN() + this.aQ);
            this.D(passenger);
            if (passenger instanceof EntityAnimal && this.di().size() == this.n()) {
                int i2 = passenger.az() % 2 == 0 ? 90 : 270;
                passenger.s(((EntityAnimal)passenger).bB + (float)i2);
                passenger.r(passenger.cN() + (float)i2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D collisionHorizontalEscapeVector = AbstractBoat.a(this.dA() * MathHelper.g, (double)passenger.dA(), passenger.dX());
        double d2 = this.dK() + collisionHorizontalEscapeVector.g;
        double d1 = this.dQ() + collisionHorizontalEscapeVector.i;
        BlockPosition blockPos = BlockPosition.a(d2, this.de().e, d1);
        BlockPosition blockPos1 = blockPos.e();
        if (!this.an().B(blockPos1)) {
            double blockFloorHeight1;
            ArrayList list = Lists.newArrayList();
            double blockFloorHeight = this.an().j(blockPos);
            if (DismountUtil.a(blockFloorHeight)) {
                list.add(new Vec3D(d2, (double)blockPos.v() + blockFloorHeight, d1));
            }
            if (DismountUtil.a(blockFloorHeight1 = this.an().j(blockPos1))) {
                list.add(new Vec3D(d2, (double)blockPos1.v() + blockFloorHeight1, d1));
            }
            for (EntityPose pose : passenger.gd()) {
                for (Vec3D vec3 : list) {
                    if (!DismountUtil.a(this.an(), vec3, passenger, pose)) continue;
                    passenger.c(pose);
                    return vec3;
                }
            }
        }
        return super.b(passenger);
    }

    protected void D(Entity entity) {
        entity.s(this.dX());
        float f2 = MathHelper.h(entity.dX() - this.dX());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        entity.ab += f1 - f2;
        entity.v(entity.dX() + f1 - f2);
        entity.r(entity.dX());
    }

    @Override
    public void l(Entity entityToUpdate) {
        this.D(entityToUpdate);
    }

    @Override
    protected void a(ValueOutput output) {
        this.a(output, this.bg);
    }

    @Override
    protected void a(ValueInput input) {
        this.b(input);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.a(player, hand);
        if (interactionResult != EnumInteractionResult.e) {
            return interactionResult;
        }
        return (EnumInteractionResult)((Object)(player.gp() || !(this.aP < 60.0f) || !this.an().D_() && !player.o(this) ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause eventCause) {
        if (!this.an().D_() && reason.a() && this.T_()) {
            this.w();
        }
        super.remove(reason, eventCause);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        this.ba = this.dI().h;
        if (!this.cl()) {
            if (onGround) {
                this.l();
            } else if (!this.an().b_(this.dF().e()).a(TagsFluid.a) && y2 < 0.0) {
                this.an -= (double)((float)y2);
            }
        }
    }

    public boolean c(int side) {
        return this.az.a(side == 0 ? r : s) != false && this.dg() != null;
    }

    private void m(int bubbleTime) {
        this.az.a(t, bubbleTime);
    }

    private int Q() {
        return this.az.a(t);
    }

    public float b(float partialTick) {
        return MathHelper.h(partialTick, this.bf, this.be);
    }

    @Override
    protected boolean s(Entity passenger) {
        return this.di().size() < this.n() && !this.a(TagsFluid.a);
    }

    protected int n() {
        return 2;
    }

    @Override
    @Nullable
    public EntityLiving dg() {
        EntityLiving livingEntity;
        Entity entity = this.dj();
        return entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : super.dg();
    }

    public void a(boolean left, boolean right, boolean up, boolean down) {
        this.aS = left;
        this.aT = right;
        this.aU = up;
        this.aV = down;
    }

    @Override
    public boolean by() {
        return this.aY == EnumStatus.b || this.aY == EnumStatus.c;
    }

    @Override
    public final Item p() {
        return this.bh.get();
    }

    @Override
    public final ItemStack dU() {
        ItemStack boat = new ItemStack(this.bh.get());
        if (!this.an().purpurConfig.persistentDroppableEntityDisplayNames) {
            boat.b(DataComponents.g, null);
        }
        return boat;
    }

    public static final class EnumStatus
    extends Enum<EnumStatus> {
        public static final /* enum */ EnumStatus a = new EnumStatus();
        public static final /* enum */ EnumStatus b = new EnumStatus();
        public static final /* enum */ EnumStatus c = new EnumStatus();
        public static final /* enum */ EnumStatus d = new EnumStatus();
        public static final /* enum */ EnumStatus e = new EnumStatus();
        private static final /* synthetic */ EnumStatus[] f;

        public static EnumStatus[] values() {
            return (EnumStatus[])f.clone();
        }

        public static EnumStatus valueOf(String name) {
            return Enum.valueOf(EnumStatus.class, name);
        }

        private static /* synthetic */ EnumStatus[] a() {
            return new EnumStatus[]{a, b, c, d, e};
        }

        static {
            f = EnumStatus.a();
        }
    }
}

