/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.destroystokyo.paper.loottable.PaperLootableInventory;
import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public interface ContainerEntity
extends IInventory,
ITileInventory {
    public Vec3D dD();

    public AxisAlignedBB de();

    @Nullable
    public ResourceKey<LootTable> q();

    public void a(@Nullable ResourceKey<LootTable> var1);

    public long r();

    public void a(long var1);

    public NonNullList<ItemStack> s();

    public void u();

    public World an();

    public boolean ec();

    @Override
    default public boolean c() {
        return this.al_();
    }

    default public void c_(ValueOutput output) {
        if (this.q() != null) {
            output.a("LootTable", this.q().a().toString());
            this.lootableData().saveNbt(output);
            if (this.r() != 0L) {
                output.a("LootTableSeed", this.r());
            }
        }
        ContainerUtil.a(output, this.s());
    }

    default public void b_(ValueInput input) {
        this.u();
        ResourceKey resourceKey = input.a("LootTable", LootTable.a).orElse(null);
        this.a(resourceKey);
        this.a(input.a("LootTableSeed", 0L));
        if (this.q() != null) {
            this.lootableData().loadNbt(input);
        }
        ContainerUtil.a(input, this.s());
    }

    default public void a(DamageSource damageSource, WorldServer level, Entity entity) {
        if (level.S().c(GameRules.j)) {
            InventoryUtils.a((World)level, entity, (IInventory)this);
            Entity directEntity = damageSource.c();
            if (directEntity != null && directEntity.ax() == EntityTypes.bX) {
                PiglinAI.a(level, (EntityHuman)directEntity, true);
            }
        }
    }

    default public EnumInteractionResult b_(EntityHuman player) {
        if (player.a(this).isEmpty()) {
            return EnumInteractionResult.e;
        }
        return EnumInteractionResult.a;
    }

    default public void c_(@Nullable EntityHuman player) {
        MinecraftServer server = this.an().q();
        if (server != null && this.lootableData().shouldReplenish(this, PaperLootableInventoryData.ENTITY, player)) {
            LootTable lootTable = server.bi().a(this.q());
            if (player != null) {
                CriterionTriggers.Q.a((EntityPlayer)player, this.q());
            }
            if (this.lootableData().shouldClearLootTable(this, PaperLootableInventoryData.ENTITY, player)) {
                this.a((ResourceKey<LootTable>)null);
            }
            LootParams.a builder = new LootParams.a((WorldServer)this.an()).a(LootContextParameters.h, this.dD());
            if (player != null) {
                builder.a(player.ew()).a(LootContextParameters.a, player);
            }
            lootTable.a(this, builder.a(LootContextParameterSets.c), this.r());
        }
    }

    default public void h() {
        this.c_((EntityHuman)null);
        this.s().clear();
    }

    default public boolean al_() {
        for (ItemStack itemStack : this.s()) {
            if (itemStack.f()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack f_(int slot) {
        this.c_((EntityHuman)null);
        ItemStack itemStack = this.s().get(slot);
        if (itemStack.f()) {
            return ItemStack.l;
        }
        this.s().set(slot, ItemStack.l);
        return itemStack;
    }

    default public ItemStack g_(int slot) {
        this.c_((EntityHuman)null);
        return this.s().get(slot);
    }

    default public ItemStack b(int slot, int amount) {
        this.c_((EntityHuman)null);
        return ContainerUtil.a(this.s(), slot, amount);
    }

    default public void c(int slot, ItemStack stack) {
        this.c_((EntityHuman)null);
        this.s().set(slot, stack);
        stack.f(this.f_(stack));
    }

    default public SlotAccess h_(final int slot) {
        return slot >= 0 && slot < this.b() ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return ContainerEntity.this.g_(slot);
            }

            @Override
            public boolean a(ItemStack carried) {
                ContainerEntity.this.c(slot, carried);
                return true;
            }
        } : SlotAccess.a;
    }

    default public boolean d_(EntityHuman player) {
        return !this.ec() && player.a(this.de(), 4.0);
    }

    default public PaperLootableInventoryData lootableData() {
        throw new UnsupportedOperationException("Implement this method");
    }

    default public PaperLootableInventory getLootableInventory() {
        return (PaperLootableInventory)((Object)((Entity)((Object)this)).getBukkitEntity());
    }
}

