/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class EntityMinecartAbstract
extends VehicleEntity {
    private static final Vec3D b = new Vec3D(0.0, 0.0, 0.0);
    private static final DataWatcherObject<Optional<IBlockData>> c = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> h = ImmutableMap.of((Object)EntityPose.a, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)EntityPose.f, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)EntityPose.d, (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float a = 0.95f;
    private static final boolean i = false;
    private boolean j;
    private boolean k = false;
    private final MinecartBehavior l;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> m = Maps.newEnumMap((Map)((Map)SystemUtils.a(() -> {
        BaseBlockPosition unitVec3i = EnumDirection.e.q();
        BaseBlockPosition unitVec3i1 = EnumDirection.f.q();
        BaseBlockPosition unitVec3i2 = EnumDirection.c.q();
        BaseBlockPosition unitVec3i3 = EnumDirection.d.q();
        BaseBlockPosition vec3i = unitVec3i.p();
        BaseBlockPosition vec3i1 = unitVec3i1.p();
        BaseBlockPosition vec3i2 = unitVec3i2.p();
        BaseBlockPosition vec3i3 = unitVec3i3.p();
        return ImmutableMap.of((Object)BlockPropertyTrackPosition.a, (Object)Pair.of((Object)unitVec3i2, (Object)unitVec3i3), (Object)BlockPropertyTrackPosition.b, (Object)Pair.of((Object)unitVec3i, (Object)unitVec3i1), (Object)BlockPropertyTrackPosition.c, (Object)Pair.of((Object)vec3i, (Object)unitVec3i1), (Object)BlockPropertyTrackPosition.d, (Object)Pair.of((Object)unitVec3i, (Object)vec3i1), (Object)BlockPropertyTrackPosition.e, (Object)Pair.of((Object)unitVec3i2, (Object)vec3i3), (Object)BlockPropertyTrackPosition.f, (Object)Pair.of((Object)vec3i2, (Object)unitVec3i3), (Object)BlockPropertyTrackPosition.g, (Object)Pair.of((Object)unitVec3i3, (Object)unitVec3i1), (Object)BlockPropertyTrackPosition.h, (Object)Pair.of((Object)unitVec3i3, (Object)unitVec3i), (Object)BlockPropertyTrackPosition.i, (Object)Pair.of((Object)unitVec3i2, (Object)unitVec3i), (Object)BlockPropertyTrackPosition.j, (Object)Pair.of((Object)unitVec3i2, (Object)unitVec3i1));
    })));
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    @Nullable
    public Double maxSpeed;
    public double storedMaxSpeed;
    public boolean isNewBehavior;
    public TriState frictionState = TriState.NOT_SET;
    private Double lastSpeed;

    protected EntityMinecartAbstract(EntityTypes<?> type, World level) {
        super(type, level);
        this.W = true;
        if (EntityMinecartAbstract.b(level)) {
            this.l = new NewMinecartBehavior(this);
            this.isNewBehavior = true;
        } else {
            this.l = new OldMinecartBehavior(this);
            this.isNewBehavior = false;
            this.storedMaxSpeed = level.purpurConfig.minecartMaxSpeed;
            this.maxSpeed = this.storedMaxSpeed;
        }
    }

    protected EntityMinecartAbstract(EntityTypes<?> type, World level, double x2, double y2, double z2) {
        this(type, level);
        this.o(x2, y2, z2);
    }

    public void o(double x2, double y2, double z2) {
        this.a_(x2, y2, z2);
        this.Y = x2;
        this.Z = y2;
        this.aa = z2;
    }

    @Nullable
    public static <T extends EntityMinecartAbstract> T a(World level, double x2, double y2, double z2, EntityTypes<T> type, EntitySpawnReason spawnReason, ItemStack spawnedFrom, @Nullable EntityHuman player) {
        EntityMinecartAbstract abstractMinecart = (EntityMinecartAbstract)type.a(level, spawnReason);
        if (abstractMinecart != null) {
            abstractMinecart.o(x2, y2, z2);
            EntityTypes.a(level, spawnedFrom, player).accept(abstractMinecart);
            MinecartBehavior minecartBehavior = abstractMinecart.f();
            if (minecartBehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior newMinecartBehavior = (NewMinecartBehavior)minecartBehavior;
                BlockPosition currentBlockPosOrRailBelow = abstractMinecart.k();
                IBlockData blockState = level.a_(currentBlockPosOrRailBelow);
                newMinecartBehavior.a(currentBlockPosOrRailBelow, blockState, true);
            }
        }
        return (T)abstractMinecart;
    }

    public MinecartBehavior f() {
        return this.l;
    }

    @Override
    protected Entity.MovementEmission br() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(c, Optional.empty());
        builder.a(d, this.x());
    }

    @Override
    public boolean i(Entity entity) {
        boolean collides = AbstractBoat.a((Entity)this, entity);
        if (!collides) {
            return false;
        }
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
        return collisionEvent.callEvent();
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.n(super.a(axis, portal));
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        boolean flag = entity instanceof EntityVillager || entity instanceof EntityVillagerTrader;
        return flag ? b : super.a(entity, dimensions, partialTick);
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        EnumDirection motionDirection = this.dc();
        if (motionDirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(livingEntity);
        }
        int[][] ints = DismountUtil.a(motionDirection);
        BlockPosition blockPos = this.dF();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> dismountPoses = livingEntity.gd();
        for (EntityPose pose : dismountPoses) {
            EntitySize dimensions = livingEntity.a(pose);
            float f2 = Math.min(dimensions.a(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)h.get((Object)pose)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int i2 = (Integer)unmodifiableIterator.next();
                for (int[] ints1 : ints) {
                    mutableBlockPos.d(blockPos.u() + ints1[0], blockPos.v() + i2, blockPos.w() + ints1[1]);
                    double blockFloorHeight = this.an().a(DismountUtil.a((IBlockAccess)this.an(), (BlockPosition)mutableBlockPos), () -> DismountUtil.a((IBlockAccess)this.an(), mutableBlockPos.e()));
                    if (!DismountUtil.a(blockFloorHeight)) continue;
                    AxisAlignedBB aabb = new AxisAlignedBB(-f2, 0.0, -f2, f2, dimensions.b(), f2);
                    Vec3D vec3 = Vec3D.a(mutableBlockPos, blockFloorHeight);
                    if (!DismountUtil.a(this.an(), livingEntity, aabb.c(vec3))) continue;
                    livingEntity.c(pose);
                    return vec3;
                }
            }
        }
        double d2 = this.de().e;
        mutableBlockPos.b((double)blockPos.u(), d2, (double)blockPos.w());
        for (EntityPose pose1 : dismountPoses) {
            int ceil;
            double d22;
            double d1 = livingEntity.a(pose1).b();
            if (!(d2 + d1 <= (d22 = DismountUtil.a(mutableBlockPos, ceil = MathHelper.c(d2 - (double)mutableBlockPos.v() + d1), (BlockPosition pos) -> this.an().a_((BlockPosition)pos).g(this.an(), (BlockPosition)pos))))) continue;
            livingEntity.c(pose1);
            break;
        }
        return super.b(livingEntity);
    }

    @Override
    protected float be() {
        IBlockData blockState = this.an().a_(this.dF());
        return blockState.a(TagsBlock.L) ? 1.0f : super.be();
    }

    @Override
    public void q(float yaw) {
        this.l(-this.I());
        this.d(10);
        this.a(this.G() + this.G() * 10.0f);
    }

    @Override
    public boolean bT() {
        return !this.ec();
    }

    public static Pair<BaseBlockPosition, BaseBlockPosition> a(BlockPropertyTrackPosition shape) {
        return m.get(shape);
    }

    @Override
    public EnumDirection dc() {
        return this.l.l();
    }

    @Override
    protected double bo() {
        return this.bu() ? 0.005 : 0.04;
    }

    @Override
    public void g() {
        if (!this.isNewBehavior && this.storedMaxSpeed != this.an().purpurConfig.minecartMaxSpeed) {
            this.storedMaxSpeed = this.an().purpurConfig.minecartMaxSpeed;
            this.maxSpeed = this.storedMaxSpeed;
        }
        double prevX = this.dK();
        double prevY = this.dM();
        double prevZ = this.dQ();
        float prevYaw = this.dX();
        float prevPitch = this.dZ();
        if (this.H() > 0) {
            this.d(this.H() - 1);
        }
        if (this.G() > 0.0f) {
            this.a(this.G() - 1.0f);
        }
        this.aI();
        this.l.b();
        CraftWorld bworld = this.an().getWorld();
        Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
        Location to = CraftLocation.toBukkit(this.dD(), this.an(), this.dX(), this.dZ());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        new VehicleUpdateEvent(vehicle).callEvent();
        if (!from.equals((Object)to)) {
            new VehicleMoveEvent(vehicle, from, to).callEvent();
        }
        this.bC();
        if (this.bJ()) {
            this.aM();
            this.aN();
            this.an *= 0.5;
        }
        this.ay = false;
    }

    public boolean i() {
        return this.ay;
    }

    public BlockPosition k() {
        int floor = MathHelper.a(this.dK());
        int floor1 = MathHelper.a(this.dM());
        int floor2 = MathHelper.a(this.dQ());
        if (EntityMinecartAbstract.b(this.an())) {
            double d2 = this.dM() - 0.1 - (double)1.0E-5f;
            if (this.an().a_(BlockPosition.a((double)floor, d2, (double)floor2)).a(TagsBlock.L)) {
                floor1 = MathHelper.a(d2);
            }
        } else if (this.an().a_(new BlockPosition(floor, floor1 - 1, floor2)).a(TagsBlock.L)) {
            --floor1;
        }
        return new BlockPosition(floor, floor1, floor2);
    }

    protected double a(WorldServer level) {
        return this.l.b(level);
    }

    public void a(int x2, int y2, int z2, boolean powered) {
    }

    @Override
    public void a(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
        super.a(steps, targetX, targetY, targetZ, targetYRot, targetXRot);
    }

    @Override
    public void bq() {
        super.bq();
    }

    @Override
    public void aG() {
        super.aG();
    }

    @Override
    public boolean bC() {
        return super.bC();
    }

    @Override
    public Vec3D ag() {
        return this.l.d(super.ag());
    }

    @Override
    public InterpolationHandler n_() {
        return this.l.a();
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.l.a(this.dI());
    }

    @Override
    public void j(Vec3D movement) {
        this.l.a(movement);
    }

    protected void b(WorldServer level) {
        this.l.a(level);
    }

    public double getControllableSpeed() {
        IBlockData blockState = this.an().a_(this.dF());
        if (!blockState.e()) {
            blockState = this.an().a_(this.dF().a(EnumDirection.a));
        }
        Double speed = this.an().purpurConfig.minecartControllableBlockSpeeds.get(blockState.b());
        if (!blockState.e()) {
            speed = this.lastSpeed;
        }
        if (speed == null) {
            speed = this.an().purpurConfig.minecartControllableBaseSpeed;
        }
        this.lastSpeed = speed;
        return this.lastSpeed;
    }

    protected void e(WorldServer level) {
        double maxSpeed = this.a(level);
        Vec3D deltaMovement = this.dI();
        this.m(MathHelper.a(deltaMovement.g, -maxSpeed, maxSpeed), deltaMovement.h, MathHelper.a(deltaMovement.i, -maxSpeed, maxSpeed));
        if (this.an().purpurConfig.minecartControllable && !this.bu() && !this.bJ() && !this.aS.isEmpty()) {
            Entity passenger = (Entity)this.aS.get(0);
            if (passenger instanceof EntityPlayer) {
                float forward;
                EntityPlayer player = (EntityPlayer)passenger;
                Input lastClientInput = player.ah();
                float f2 = lastClientInput.a() == lastClientInput.b() ? 0.0f : (forward = lastClientInput.a() ? 1.0f : -1.0f);
                if (lastClientInput.e() && this.bc) {
                    this.k(new Vec3D(this.dI().g, this.an().purpurConfig.minecartControllableHopBoost, this.dI().i));
                }
                if (forward != 0.0f) {
                    Vector velocity = player.getBukkitEntity().getEyeLocation().getDirection().normalize().multiply(this.getControllableSpeed());
                    if ((double)forward < 0.0) {
                        velocity.multiply(-0.5);
                    }
                    this.k(new Vec3D(velocity.getX(), this.dI().h, velocity.getZ()));
                }
                this.v(passenger.dX() - 90.0f);
                this.maxUpStep = this.an().purpurConfig.minecartControllableStepHeight;
            } else {
                this.maxUpStep = 0.0f;
            }
        } else {
            this.maxUpStep = 0.0f;
        }
        if (this.aS()) {
            this.k(new Vec3D(this.dI().g * this.derailedX, this.dI().h * this.derailedY, this.dI().i * this.derailedZ));
        } else if (this.an().purpurConfig.minecartControllable) {
            this.k(new Vec3D(this.dI().g * this.derailedX, this.dI().h, this.dI().i * this.derailedZ));
        }
        this.a(EnumMoveType.a, this.dI());
        if (!this.aS()) {
            this.k(new Vec3D(this.dI().g * this.flyingX, this.dI().h * this.flyingY, this.dI().i * this.flyingZ));
        }
    }

    protected double a(BlockPosition pos, BlockPropertyTrackPosition railShape, double speed) {
        return this.l.a(pos, railShape, speed);
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (EntityMinecartAbstract.b(this.an())) {
            Vec3D vec3 = this.dD().e(movement);
            super.a(type, movement);
            boolean flag = this.l.d();
            if (flag) {
                super.a(type, vec3.d(this.dD()));
            }
            if (type.equals((Object)EnumMoveType.c)) {
                this.j = false;
            }
        } else {
            super.a(type, movement);
            this.aT();
        }
    }

    @Override
    public void aT() {
        if (EntityMinecartAbstract.b(this.an())) {
            super.aT();
        } else {
            this.a(this.dD(), this.dD());
            this.aV();
        }
    }

    @Override
    public boolean cC() {
        return this.j;
    }

    public void a(boolean onRails) {
        this.j = onRails;
    }

    public boolean m() {
        return this.k;
    }

    public void b(boolean flipped) {
        this.k = flipped;
    }

    public Vec3D a(BlockPosition pos) {
        IBlockData blockState = this.an().a_(pos);
        if (blockState.a(Blocks.bw) && blockState.c(BlockPoweredRail.d).booleanValue()) {
            BlockPropertyTrackPosition railShape = blockState.c(((BlockMinecartTrackAbstract)blockState.b()).c());
            if (railShape == BlockPropertyTrackPosition.b) {
                if (this.b(pos.h())) {
                    return new Vec3D(1.0, 0.0, 0.0);
                }
                if (this.b(pos.i())) {
                    return new Vec3D(-1.0, 0.0, 0.0);
                }
            } else if (railShape == BlockPropertyTrackPosition.a) {
                if (this.b(pos.f())) {
                    return new Vec3D(0.0, 0.0, 1.0);
                }
                if (this.b(pos.g())) {
                    return new Vec3D(0.0, 0.0, -1.0);
                }
            }
            return Vec3D.c;
        }
        return Vec3D.c;
    }

    public boolean b(BlockPosition pos) {
        return this.an().a_(pos).d(this.an(), pos);
    }

    protected Vec3D a(Vec3D speed) {
        double slowdownFactor = this.l.m();
        Vec3D vec3 = speed.d(slowdownFactor, 0.0, slowdownFactor);
        if (this.bu()) {
            vec3 = vec3.c((double)0.95f);
        }
        return vec3;
    }

    @Override
    protected void a(ValueInput input) {
        this.a(input.a("DisplayState", IBlockData.a));
        this.c(input.a("DisplayOffset", this.x()));
        this.k = input.a("FlippedRotation", false);
        this.ay = input.a("HasTicked", false);
        input.g("Paper.FrictionState").ifPresent(frictionState -> {
            try {
                this.frictionState = TriState.valueOf((String)frictionState);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state {} for {}", frictionState, (Object)this);
            }
        });
    }

    @Override
    protected void a(ValueOutput output) {
        this.A().ifPresent(blockState -> output.a("DisplayState", IBlockData.a, blockState));
        int displayOffset = this.w();
        if (displayOffset != this.x()) {
            output.a("DisplayOffset", displayOffset);
        }
        output.a("FlippedRotation", this.k);
        output.a("HasTicked", this.ay);
        if (this.frictionState != TriState.NOT_SET) {
            output.a("Paper.FrictionState", this.frictionState.toString());
        }
    }

    @Override
    public void h(Entity entity) {
        if (!(this.an().D_() || entity.ar || this.ar)) {
            if (!this.an().paperConfig().collisions.allowVehicleCollisions && this.an().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
                return;
            }
            if (!this.z(entity)) {
                double d1;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                if (!collisionEvent.callEvent()) {
                    return;
                }
                double d2 = entity.dK() - this.dK();
                double d22 = d2 * d2 + (d1 = entity.dQ() - this.dQ()) * d1;
                if (d22 >= (double)1.0E-4f) {
                    d22 = Math.sqrt(d22);
                    d2 /= d22;
                    d1 /= d22;
                    double d3 = 1.0 / d22;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d2 *= d3;
                    d1 *= d3;
                    d2 *= (double)0.1f;
                    d1 *= (double)0.1f;
                    d2 *= 0.5;
                    d1 *= 0.5;
                    if (entity instanceof EntityMinecartAbstract) {
                        EntityMinecartAbstract abstractMinecart = (EntityMinecartAbstract)entity;
                        this.a(abstractMinecart, d2, d1);
                    } else {
                        this.i(-d2, 0.0, -d1);
                        entity.i(d2 / 4.0, 0.0, d1 / 4.0);
                    }
                }
            }
        }
    }

    private void a(EntityMinecartAbstract otherMinecart, double deltaX, double deltaZ) {
        double d1;
        double d2;
        if (EntityMinecartAbstract.b(this.an())) {
            d2 = this.dI().g;
            d1 = this.dI().i;
        } else {
            d2 = otherMinecart.dK() - this.dK();
            d1 = otherMinecart.dQ() - this.dQ();
        }
        Vec3D vec3 = new Vec3D(d2, 0.0, d1).d();
        Vec3D vec31 = new Vec3D(MathHelper.b(this.dX() * ((float)Math.PI / 180)), 0.0, MathHelper.a(this.dX() * ((float)Math.PI / 180))).d();
        double abs = Math.abs(vec3.b(vec31));
        if (!(abs < (double)0.8f) || EntityMinecartAbstract.b(this.an())) {
            Vec3D deltaMovement = this.dI();
            Vec3D deltaMovement1 = otherMinecart.dI();
            if (otherMinecart.z() && !this.z()) {
                this.k(deltaMovement.d(0.2, 1.0, 0.2));
                this.i(deltaMovement1.g - deltaX, 0.0, deltaMovement1.i - deltaZ);
                otherMinecart.k(deltaMovement1.d(0.95, 1.0, 0.95));
            } else if (!otherMinecart.z() && this.z()) {
                otherMinecart.k(deltaMovement1.d(0.2, 1.0, 0.2));
                otherMinecart.i(deltaMovement.g + deltaX, 0.0, deltaMovement.i + deltaZ);
                this.k(deltaMovement.d(0.95, 1.0, 0.95));
            } else {
                double d22 = (deltaMovement1.g + deltaMovement.g) / 2.0;
                double d3 = (deltaMovement1.i + deltaMovement.i) / 2.0;
                this.k(deltaMovement.d(0.2, 1.0, 0.2));
                this.i(d22 - deltaX, 0.0, d3 - deltaZ);
                otherMinecart.k(deltaMovement1.d(0.2, 1.0, 0.2));
                otherMinecart.i(d22 + deltaX, 0.0, d3 + deltaZ);
            }
        }
    }

    public IBlockData n() {
        return this.A().orElseGet(this::v);
    }

    private Optional<IBlockData> A() {
        return this.aC().a(c);
    }

    public IBlockData v() {
        return Blocks.a.m();
    }

    public int w() {
        return this.aC().a(d);
    }

    public int x() {
        return 6;
    }

    public void a(Optional<IBlockData> customDisplayBlockState) {
        this.aC().a(c, customDisplayBlockState);
    }

    public void c(int displayOffset) {
        this.aC().a(d, displayOffset);
    }

    public static boolean b(World level) {
        return level.O().b(FeatureFlags.d);
    }

    @Override
    public abstract ItemStack dU();

    public boolean y() {
        return false;
    }

    public boolean z() {
        return false;
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }
}

