/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlagUniverse;
import org.slf4j.Logger;

public class FeatureFlagRegistry {
    private static final Logger a = LogUtils.getLogger();
    private final FeatureFlagUniverse b;
    public final Map<MinecraftKey, FeatureFlag> c;
    private final FeatureFlagSet d;

    FeatureFlagRegistry(FeatureFlagUniverse universe, FeatureFlagSet allFlags, Map<MinecraftKey, FeatureFlag> names) {
        this.b = universe;
        this.c = names;
        this.d = allFlags;
    }

    public boolean a(FeatureFlagSet set) {
        return set.a(this.d);
    }

    public FeatureFlagSet a() {
        return this.d;
    }

    public FeatureFlagSet a(Iterable<MinecraftKey> names) {
        return this.a(names, (MinecraftKey errorName) -> a.warn("Unknown feature flag: {}", errorName));
    }

    public FeatureFlagSet a(FeatureFlag ... flags) {
        return FeatureFlagSet.a(this.b, Arrays.asList(flags));
    }

    public FeatureFlagSet a(Iterable<MinecraftKey> names, Consumer<MinecraftKey> onError) {
        Set set = Sets.newIdentityHashSet();
        for (MinecraftKey resourceLocation : names) {
            FeatureFlag featureFlag = this.c.get(resourceLocation);
            if (featureFlag == null) {
                onError.accept(resourceLocation);
                continue;
            }
            set.add(featureFlag);
        }
        return FeatureFlagSet.a(this.b, set);
    }

    public Set<MinecraftKey> b(FeatureFlagSet set) {
        HashSet<MinecraftKey> set1 = new HashSet<MinecraftKey>();
        this.c.forEach((name, flag) -> {
            if (set.b((FeatureFlag)flag)) {
                set1.add((MinecraftKey)name);
            }
        });
        return set1;
    }

    public Codec<FeatureFlagSet> b() {
        return MinecraftKey.a.listOf().comapFlatMap(list -> {
            HashSet set = new HashSet();
            FeatureFlagSet featureFlagSet = this.a((Iterable<MinecraftKey>)list, set::add);
            return !set.isEmpty() ? DataResult.error(() -> "Unknown feature ids: " + String.valueOf(set), (Object)featureFlagSet) : DataResult.success((Object)featureFlagSet);
        }, featureFlagSet -> List.copyOf(this.b((FeatureFlagSet)featureFlagSet)));
    }

    public static class a {
        private final FeatureFlagUniverse a;
        private int b;
        private final Map<MinecraftKey, FeatureFlag> c = new LinkedHashMap<MinecraftKey, FeatureFlag>();

        public a(String id) {
            this.a = new FeatureFlagUniverse(id);
        }

        public FeatureFlag a(String id) {
            return this.a(MinecraftKey.b(id));
        }

        public FeatureFlag a(MinecraftKey location) {
            FeatureFlag featureFlag;
            FeatureFlag featureFlag1;
            if (this.b >= 64) {
                throw new IllegalStateException("Too many feature flags");
            }
            if ((featureFlag1 = this.c.put(location, featureFlag = new FeatureFlag(this.a, this.b++))) != null) {
                throw new IllegalStateException("Duplicate feature flag " + String.valueOf(location));
            }
            return featureFlag;
        }

        public FeatureFlagRegistry a() {
            FeatureFlagSet featureFlagSet = FeatureFlagSet.a(this.a, this.c.values());
            return new FeatureFlagRegistry(this.a, featureFlagSet, Map.copyOf(this.c));
        }
    }
}

