/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
IMaterial {
    public static final Codec<Holder<Item>> e = BuiltInRegistries.h.r().validate(holder -> holder.a(Items.a.e()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)holder));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> f = ByteBufCodecs.b(Registries.O);
    private static final Logger a = LogUtils.getLogger();
    public static final Map<Block, Item> g = Maps.newHashMap();
    public static final MinecraftKey h = MinecraftKey.b("base_attack_damage");
    public static final MinecraftKey i = MinecraftKey.b("base_attack_speed");
    public static final int j = 64;
    public static final int k = 99;
    public static final int l = 13;
    protected static final int m = 72000;
    private final Holder.c<Item> b = BuiltInRegistries.h.f(this);
    private final DataComponentMap c;
    @Nullable
    private final Item d;
    protected final String n;
    private final FeatureFlagSet o;

    public static int a(Item item) {
        return item == null ? 0 : BuiltInRegistries.h.a(item);
    }

    public static Item b(int id) {
        return BuiltInRegistries.h.a(id);
    }

    @Deprecated
    public static Item a(Block block) {
        return g.getOrDefault(block, Items.a);
    }

    public Item(Info properties) {
        String simpleName;
        this.n = properties.d();
        this.c = properties.a(IChatBaseComponent.c(this.n), properties.e());
        this.d = properties.d;
        this.o = properties.e;
        if (SharedConstants.be && !(simpleName = this.getClass().getSimpleName()).endsWith("Item")) {
            a.error("Item classes should end with Item and {} doesn't.", (Object)simpleName);
        }
    }

    @Deprecated
    public Holder.c<Item> e() {
        return this.b;
    }

    public DataComponentMap f() {
        return this.c;
    }

    public int g() {
        return this.c.a(DataComponents.c, 1);
    }

    public void a(World level, EntityLiving livingEntity, ItemStack stack, int remainingUseDuration) {
    }

    public void a(EntityItem itemEntity) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityLiving entity) {
        Tool tool = stack.a(DataComponents.A);
        if (tool == null) return true;
        if (tool.d()) return true;
        if (!(entity instanceof EntityHuman)) return true;
        EntityHuman player = (EntityHuman)entity;
        if (player.gC().d) return false;
        return true;
    }

    @Override
    public Item h() {
        return this;
    }

    public EnumInteractionResult a(ItemActionContext context) {
        return EnumInteractionResult.e;
    }

    public float a(ItemStack stack, IBlockData state) {
        Tool tool = stack.a(DataComponents.A);
        return tool != null ? tool.a(state) : 1.0f;
    }

    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        Consumable consumable = itemInHand.a(DataComponents.w);
        if (consumable != null) {
            return consumable.a(player, itemInHand, hand);
        }
        Equippable equippable = itemInHand.a(DataComponents.D);
        if (equippable != null && equippable.h()) {
            return equippable.a(itemInHand, player);
        }
        BlocksAttacks blocksAttacks = itemInHand.a(DataComponents.I);
        if (blocksAttacks != null) {
            player.c(hand);
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.e;
    }

    public ItemStack a(ItemStack stack, World level, EntityLiving livingEntity) {
        Consumable consumable = stack.a(DataComponents.w);
        return consumable != null ? consumable.a(level, livingEntity, stack) : stack;
    }

    public boolean d(ItemStack stack) {
        return stack.n();
    }

    public int e(ItemStack stack) {
        return MathHelper.a(Math.round(13.0f - (float)stack.o() * 13.0f / (float)stack.p()), 0, 13);
    }

    public int f(ItemStack stack) {
        int maxDamage = stack.p();
        float max = Math.max(0.0f, ((float)maxDamage - (float)stack.o()) / (float)maxDamage);
        return MathHelper.g(max / 3.0f, 1.0f, 1.0f);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction action, EntityHuman player) {
        return false;
    }

    public boolean a(ItemStack stack, ItemStack other, Slot slot, ClickAction action, EntityHuman player, SlotAccess access) {
        return false;
    }

    public float a(Entity target, float damageAmount, DamageSource damageSource) {
        return 0.0f;
    }

    @Nullable
    public DamageSource a(EntityLiving entity) {
        return null;
    }

    public void a(ItemStack stack, EntityLiving target, EntityLiving attacker) {
    }

    public void b(ItemStack stack, EntityLiving target, EntityLiving attacker) {
    }

    public boolean a(ItemStack stack, World level, IBlockData state, BlockPosition pos, EntityLiving miningEntity) {
        Tool tool = stack.a(DataComponents.A);
        if (tool == null) {
            return false;
        }
        if (!level.D_() && state.e(level, pos) != 0.0f && tool.c() > 0) {
            stack.a(tool.c(), miningEntity, EnumItemSlot.a);
        }
        return true;
    }

    public boolean b(ItemStack stack, IBlockData state) {
        Tool tool = stack.a(DataComponents.A);
        return tool != null && tool.b(state);
    }

    public EnumInteractionResult a(ItemStack stack, EntityHuman player, EntityLiving interactionTarget, EnumHand usedHand) {
        return EnumInteractionResult.e;
    }

    public String toString() {
        return BuiltInRegistries.h.e(this).g();
    }

    public final ItemStack i() {
        return this.d == null ? ItemStack.l : new ItemStack(this.d);
    }

    public void a(ItemStack stack, WorldServer level, Entity entity, @Nullable EnumItemSlot slot) {
    }

    public void c(ItemStack stack, EntityHuman player) {
        this.a(stack, player.an());
    }

    public void a(ItemStack stack, World level) {
    }

    public ItemUseAnimation b(ItemStack stack) {
        Consumable consumable = stack.a(DataComponents.w);
        if (consumable != null) {
            return consumable.d();
        }
        BlocksAttacks blocksAttacks = stack.a(DataComponents.I);
        return blocksAttacks != null ? ItemUseAnimation.d : ItemUseAnimation.a;
    }

    public int a(ItemStack stack, EntityLiving entity) {
        Consumable consumable = stack.a(DataComponents.w);
        if (consumable != null) {
            return consumable.a();
        }
        BlocksAttacks blocksAttacks = stack.a(DataComponents.I);
        return blocksAttacks != null ? 72000 : 0;
    }

    public boolean a(ItemStack stack, World level, EntityLiving entity, int timeLeft) {
        return false;
    }

    @Deprecated
    public void a(ItemStack stack, b context, TooltipDisplay tooltipDisplay, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag) {
    }

    public Optional<TooltipComponent> k(ItemStack stack) {
        return Optional.empty();
    }

    @VisibleForTesting
    public final String j() {
        return this.n;
    }

    public final IChatBaseComponent l() {
        return this.c.a(DataComponents.h, CommonComponents.a);
    }

    public IChatBaseComponent a(ItemStack stack) {
        return stack.a().a(DataComponents.h, CommonComponents.a);
    }

    public boolean d_(ItemStack stack) {
        return stack.F();
    }

    protected static MovingObjectPositionBlock a(World level, EntityHuman player, RayTrace.FluidCollisionOption fluidMode) {
        Vec3D eyePosition = player.bR();
        Vec3D vec3 = eyePosition.e(player.c(player.dZ(), player.dX()).c(player.hd()));
        return level.a(new RayTrace(eyePosition, vec3, RayTrace.BlockCollisionOption.b, fluidMode, player));
    }

    public boolean e_(ItemStack stack) {
        return false;
    }

    public ItemStack m() {
        return new ItemStack(this);
    }

    public boolean d() {
        return true;
    }

    @Override
    public FeatureFlagSet k() {
        return this.o;
    }

    public boolean a(ItemStack stack, @Nullable EntityHuman player) {
        return false;
    }

    public static class Info {
        private static final DependantName<Item, String> a = key -> SystemUtils.a("block", key.a());
        private static final DependantName<Item, String> b = key -> SystemUtils.a("item", key.a());
        private final DataComponentMap.a c = DataComponentMap.a().a(DataComponents.aT);
        @Nullable
        Item d;
        FeatureFlagSet e = FeatureFlags.g;
        @Nullable
        private ResourceKey<Item> f;
        private DependantName<Item, String> g = b;
        private DependantName<Item, MinecraftKey> h = ResourceKey::a;

        public Info a(FoodInfo food) {
            return this.a(food, Consumables.a);
        }

        public Info a(FoodInfo food, Consumable consumable) {
            return this.a(DataComponents.v, food).a(DataComponents.w, consumable);
        }

        public Info a(Item usingConvertsTo) {
            return this.a(DataComponents.x, new UseRemainder(new ItemStack(usingConvertsTo)));
        }

        public Info a(float useCooldown) {
            return this.a(DataComponents.y, new UseCooldown(useCooldown));
        }

        public Info a(int maxStackSize) {
            return this.a(DataComponents.c, maxStackSize);
        }

        public Info b(int maxDamage) {
            this.a(DataComponents.d, maxDamage);
            this.a(DataComponents.c, 1);
            this.a(DataComponents.e, 0);
            return this;
        }

        public Info b(Item craftingRemainingItem) {
            this.d = craftingRemainingItem;
            return this;
        }

        public Info a(EnumItemRarity rarity) {
            return this.a(DataComponents.k, rarity);
        }

        public Info a() {
            return this.a(DataComponents.z, new DamageResistant(DamageTypeTags.i));
        }

        public Info a(ResourceKey<JukeboxSong> song) {
            return this.a(DataComponents.ae, new JukeboxPlayable(new EitherHolder<JukeboxSong>(song)));
        }

        public Info c(int enchantmentValue) {
            return this.a(DataComponents.C, new Enchantable(enchantmentValue));
        }

        public Info c(Item repairItem) {
            return this.a(DataComponents.E, new Repairable(HolderSet.a(repairItem.e())));
        }

        public Info a(TagKey<Item> repairItems) {
            HolderGetter<Item> holderGetter = BuiltInRegistries.a(BuiltInRegistries.h);
            return this.a(DataComponents.E, new Repairable(holderGetter.b(repairItems)));
        }

        public Info a(EnumItemSlot slot) {
            return this.a(DataComponents.D, Equippable.a(slot).a());
        }

        public Info b(EnumItemSlot slot) {
            return this.a(DataComponents.D, Equippable.a(slot).b(false).a());
        }

        public Info a(ToolMaterial material, TagKey<Block> mineableBlocks, float attackDamage, float attackSpeed, float disableBlockingForSeconds) {
            return material.a(this, mineableBlocks, attackDamage, attackSpeed, disableBlockingForSeconds);
        }

        public Info a(ToolMaterial material, float attackDamage, float attackSpeed) {
            return this.a(material, TagsBlock.bO, attackDamage, attackSpeed, 0.0f);
        }

        public Info b(ToolMaterial material, float attackDamage, float attackSpeed) {
            return this.a(material, TagsBlock.bM, attackDamage, attackSpeed, 5.0f);
        }

        public Info c(ToolMaterial material, float attackDamage, float attackSpeed) {
            return this.a(material, TagsBlock.bN, attackDamage, attackSpeed, 0.0f);
        }

        public Info d(ToolMaterial material, float attackDamage, float attackSpeed) {
            return this.a(material, TagsBlock.bP, attackDamage, attackSpeed, 0.0f);
        }

        public Info e(ToolMaterial material, float attackDamage, float attackSpeed) {
            return material.a(this, attackDamage, attackSpeed);
        }

        public Info a(EntityTypes<?> type) {
            return this.a(DataComponents.Y, TypedEntityData.a(type, new NBTTagCompound()));
        }

        public Info a(ArmorMaterial material, ArmorType type) {
            return this.b(type.a(material.a())).a(material.a(type)).c(material.c()).a(DataComponents.D, Equippable.a(type.a()).a(material.d()).a(material.h()).a()).a(material.g());
        }

        public Info a(ArmorMaterial material) {
            return this.b(ArmorType.e.a(material.a())).a(material.a(ArmorType.e)).a(material.g()).a(DataComponents.D, Equippable.a(EnumItemSlot.g).a(material.d()).a(material.h()).a(HolderSet.a(EntityTypes.bR.r())).e(true).b(BuiltInRegistries.b.e(SoundEffects.aA)).a()).a(DataComponents.au, SoundEffects.Fc).a(1);
        }

        public Info b(ArmorMaterial material) {
            HolderGetter<EntityTypes<?>> holderGetter = BuiltInRegistries.a(BuiltInRegistries.g);
            return this.a(material.a(ArmorType.e)).a(DataComponents.D, Equippable.a(EnumItemSlot.g).a(SoundEffects.ok).a(material.h()).a(holderGetter.b(TagsEntity.L)).c(false).e(true).b(SoundEffects.ol).a()).a(1);
        }

        public Info b(ResourceKey<TrimMaterial> trimMaterial) {
            return this.a(DataComponents.ac, new ProvidesTrimMaterial(trimMaterial));
        }

        public Info a(FeatureFlag ... requiredFeatures) {
            this.e = FeatureFlags.e.a(requiredFeatures);
            return this;
        }

        public Info c(ResourceKey<Item> id) {
            this.f = id;
            return this;
        }

        public Info a(String description) {
            this.g = DependantName.fixed(description);
            return this;
        }

        public Info b() {
            this.g = a;
            return this;
        }

        public Info c() {
            this.g = b;
            return this;
        }

        protected String d() {
            return this.g.get(Objects.requireNonNull(this.f, "Item id not set"));
        }

        public MinecraftKey e() {
            return this.h.get(Objects.requireNonNull(this.f, "Item id not set"));
        }

        public <T> Info a(DataComponentType<T> component, T value) {
            this.c.a(component, value);
            return this;
        }

        public Info a(ItemAttributeModifiers attributes) {
            return this.a(DataComponents.o, attributes);
        }

        DataComponentMap a(IChatBaseComponent itemName, MinecraftKey itemModel) {
            DataComponentMap dataComponentMap = this.c.a(DataComponents.h, itemName).a(DataComponents.i, itemModel).a();
            if (dataComponentMap.c(DataComponents.e) && dataComponentMap.a(DataComponents.c, 1) > 1) {
                throw new IllegalStateException("Item cannot have both durability and be stackable");
            }
            return dataComponentMap;
        }
    }

    public static interface b {
        public static final b a = new b(){

            @Override
            @Nullable
            public HolderLookup.a a() {
                return null;
            }

            @Override
            public float b() {
                return 20.0f;
            }

            @Override
            @Nullable
            public WorldMap a(MapId mapId) {
                return null;
            }

            @Override
            public boolean c() {
                return false;
            }
        };

        @Nullable
        public HolderLookup.a a();

        public float b();

        @Nullable
        public WorldMap a(MapId var1);

        public boolean c();

        public static b a(final @Nullable World level) {
            return level == null ? a : new b(){

                @Override
                public HolderLookup.a a() {
                    return level.L_();
                }

                @Override
                public float b() {
                    return level.w().f();
                }

                @Override
                public WorldMap a(MapId mapId) {
                    return level.a(mapId);
                }

                @Override
                public boolean c() {
                    return level.aq() == EnumDifficulty.a;
                }
            };
        }

        public static b a(final HolderLookup.a registries) {
            return new b(){

                @Override
                public HolderLookup.a a() {
                    return registries;
                }

                @Override
                public float b() {
                    return 20.0f;
                }

                @Override
                @Nullable
                public WorldMap a(MapId mapId) {
                    return null;
                }

                @Override
                public boolean c() {
                    return false;
                }
            };
        }
    }
}

